
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bsesong.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bsemathsignal.h>
#include <bse/bsesong.h>
#include <bse/bsebus.h>
#include <bse/bsepart.h>
#include <bse/bsetrack.h>
#include "bsemidireceiver.h"
#include "bseundostack.h"
#include "bseproject.h"
#include "gslcommon.h"
#include "bseengine.h"
#include <string.h>

#line 33 "bsesong.proc"

/* --- create-bus --- */
static void
create_bus_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 34 "bsesong.proc"
 {
#line 36 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", NULL, NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("bus", NULL, NULL,
				 BSE_TYPE_BUS, SFI_PARAM_STANDARD);
#line 40 "bsesong.proc"
}  }
static BseErrorType
#line 40 "bsesong.proc"
create_bus_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 43 "bsesong.proc"
{
#line 44 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  BseUndoStack *ustack;
  BseItem *child = NULL;

#line 50 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 54 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      ustack = bse_item_undo_open (self, "create-bus");
      child = bse_container_new_child (BSE_CONTAINER (self), BSE_TYPE_BUS, NULL);
      bse_item_push_undo_proc (self, "remove-bus", child);
      bse_item_undo_close (ustack);
    }

#line 65 "bsesong.proc"
  
  bse_value_set_object (out_values++, child);
  
  return error;
}

/* --- remove-bus --- */
static void
remove_bus_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 71 "bsesong.proc"
 {
#line 73 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", NULL, NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("bus", NULL, NULL,
				 BSE_TYPE_BUS, SFI_PARAM_STANDARD);
#line 77 "bsesong.proc"
}  }
static BseErrorType
#line 77 "bsesong.proc"
remove_bus_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 80 "bsesong.proc"
{
#line 81 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseItem *child = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 86 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_BUS (child) || BSE_ITEM (child)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 90 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "remove-child %s", bse_object_debug_name (child));
#line 96 "bsesong.proc"
      
      bse_item_set (child, "master-output", FALSE, NULL);
#line 98 "bsesong.proc"
      
#line 99 "bsesong.proc"
      bse_container_uncross_undoable (BSE_CONTAINER (self), child);     
#line 100 "bsesong.proc"
      
      bse_item_push_redo_proc (self, "remove-bus", child);
#line 102 "bsesong.proc"
      
      bse_container_remove_backedup (BSE_CONTAINER (self), child, ustack);
#line 104 "bsesong.proc"
      
      bse_item_undo_close (ustack);
    }

  return error;
}

/* --- ensure-master-bus --- */
static void
ensure_master_bus_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 111 "bsesong.proc"
 {
#line 113 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", NULL, NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("bus", NULL, NULL,
				 BSE_TYPE_BUS, SFI_PARAM_STANDARD);
#line 117 "bsesong.proc"
}  }
static BseErrorType
#line 117 "bsesong.proc"
ensure_master_bus_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 120 "bsesong.proc"
{
#line 121 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseSource *child;

#line 125 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 129 "bsesong.proc"
  
  child = bse_song_ensure_master (self);

#line 132 "bsesong.proc"
  
  bse_value_set_object (out_values++, child);
  
  return BSE_ERROR_NONE;
}

/* --- get-master-bus --- */
static void
get_master_bus_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 138 "bsesong.proc"
 {
#line 140 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", NULL, NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("bus", NULL, NULL,
				 BSE_TYPE_BUS, SFI_PARAM_STANDARD);
#line 144 "bsesong.proc"
}  }
static BseErrorType
#line 144 "bsesong.proc"
get_master_bus_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 147 "bsesong.proc"
{
#line 148 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);

#line 151 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 155 "bsesong.proc"
  
  BseBus *bus = bse_song_find_master (self);

#line 158 "bsesong.proc"
  
  bse_value_set_object (out_values++, bus);
  
  return BSE_ERROR_NONE;
}

static const gchar*
orphans_track_name (void)
{
#line 167 "bsesong.proc"
  
  return _("Orphan Parts");
}

static BseTrack*
bse_song_ensure_orphans_track_noundo (BseSong *self)
{
  SfiRing *ring;
  for (ring = self->tracks_SL; ring; ring = sfi_ring_walk (ring, self->tracks_SL))
    {
      BseTrack *track = ring->data;
      gboolean muted = FALSE;
      g_object_get (track, "muted", &muted, NULL);
#line 182 "bsesong.proc"
      if (muted && g_object_get_data (track, "BseSong-orphan-track") == bse_song_ensure_orphans_track_noundo) 
        return track;
    }
  gpointer child = bse_container_new_child_bname (BSE_CONTAINER (self), BSE_TYPE_TRACK, orphans_track_name(), NULL);
#line 186 "bsesong.proc"
  g_object_set (child, "muted", TRUE, NULL); 
#line 187 "bsesong.proc"
  g_object_set_data (child, "BseSong-orphan-track", bse_song_ensure_orphans_track_noundo); 
  return child;
}

static BseTrack*
bse_song_find_first_track (BseSong *self,
                           BsePart *part)
{
  SfiRing *ring;
#line 196 "bsesong.proc"
  
  for (ring = self->tracks_SL; ring; ring = sfi_ring_walk (ring, self->tracks_SL))
    {
      BseTrack *track = ring->data;
      guint start;
      if (bse_track_find_part (track, part, &start))
        return track;
    }
  return NULL;
}

/* --- ensure-track-links --- */
static void
ensure_track_links_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 207 "bsesong.proc"
 {
#line 209 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", NULL, NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
#line 211 "bsesong.proc"
}  }
static BseErrorType
#line 211 "bsesong.proc"
ensure_track_links_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 214 "bsesong.proc"
{
#line 215 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);

#line 218 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 222 "bsesong.proc"
  
  gboolean clear_undo = FALSE;
  SfiRing *ring;
  for (ring = self->parts; ring; ring = sfi_ring_walk (ring, self->parts))
    if (!bse_song_find_first_track (self, ring->data))
      {
        BseTrack *track = bse_song_ensure_orphans_track_noundo (self);
        bse_item_exec_void (track, "insert-part", bse_track_get_last_tick (track), ring->data);
        clear_undo = TRUE;
      }
  if (clear_undo)
    {
      BseProject *project = bse_item_get_project (BSE_ITEM (self));
      if (project)
        bse_project_clear_undo (project);
    }
  
  return BSE_ERROR_NONE;
}

/* --- create-part --- */
static void
create_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 242 "bsesong.proc"
 {
#line 244 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", NULL, NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("part", NULL, NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
#line 248 "bsesong.proc"
}  }
static BseErrorType
#line 248 "bsesong.proc"
create_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 251 "bsesong.proc"
{
#line 252 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseUndoStack *ustack;
  BseItem *child;

#line 257 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 261 "bsesong.proc"
  
  ustack = bse_item_undo_open (self, "create-part");
  child = bse_container_new_child (BSE_CONTAINER (self), BSE_TYPE_PART, NULL);
  bse_item_push_undo_proc (self, "remove-part", child);
  bse_item_undo_close (ustack);
  
#line 267 "bsesong.proc"
  
  bse_value_set_object (out_values++, child);
  
  return BSE_ERROR_NONE;
}

/* --- remove-part --- */
static void
remove_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 273 "bsesong.proc"
 {
#line 275 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
#line 279 "bsesong.proc"
}  }
static BseErrorType
#line 279 "bsesong.proc"
remove_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 282 "bsesong.proc"
{
#line 283 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseItem *child = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 288 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_PART (child) || BSE_ITEM (child)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 292 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "remove-child %s", bse_object_debug_name (child));
#line 298 "bsesong.proc"
      
      bse_container_uncross_undoable (BSE_CONTAINER (self), child);
#line 300 "bsesong.proc"
      
      bse_item_push_redo_proc (self, "remove-part", child);
#line 302 "bsesong.proc"
      
      bse_container_remove_backedup (BSE_CONTAINER (self), child, ustack);
#line 304 "bsesong.proc"
      
      bse_item_undo_close (ustack);
    }

  return error;
}

/* --- create-track --- */
static void
create_track_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 311 "bsesong.proc"
 {
#line 313 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
#line 317 "bsesong.proc"
}  }
static BseErrorType
#line 317 "bsesong.proc"
create_track_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 320 "bsesong.proc"
{
#line 321 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  BseItem *child = NULL;

#line 326 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 330 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "create-track");
      child = bse_container_new_child (BSE_CONTAINER (self), BSE_TYPE_TRACK, NULL);
      bse_item_push_undo_proc (self, "remove-track", child);
      bse_item_undo_close (ustack);
    }

#line 341 "bsesong.proc"
  
  bse_value_set_object (out_values++, child);
  
  return error;
}

/* --- remove-track --- */
static void
remove_track_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 347 "bsesong.proc"
 {
#line 349 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
#line 353 "bsesong.proc"
}  }
static BseErrorType
#line 353 "bsesong.proc"
remove_track_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 356 "bsesong.proc"
{
#line 357 "bsesong.proc"
  
  BseSong *self  = bse_value_get_object (in_values++);
  BseItem *child = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 362 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_TRACK (child) ||
      BSE_ITEM (child)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 367 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "remove-child %s", bse_object_debug_name (child));
#line 373 "bsesong.proc"
      
      bse_container_uncross_undoable (BSE_CONTAINER (self), child);
#line 375 "bsesong.proc"
      
      bse_item_push_redo_proc (self, "remove-track", child);
#line 377 "bsesong.proc"
      
      bse_container_remove_backedup (BSE_CONTAINER (self), child, ustack);
#line 379 "bsesong.proc"
      
      bse_item_undo_close (ustack);
    }

  return error;
}

/* --- find-track-for-part --- */
static void
find_track_for_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 386 "bsesong.proc"
 {
#line 388 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
#line 394 "bsesong.proc"
}  }
static BseErrorType
#line 394 "bsesong.proc"
find_track_for_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 397 "bsesong.proc"
{
#line 398 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BsePart *part = bse_value_get_object (in_values++);
  BseTrack *track = NULL;
  guint tick = 0;
  SfiRing *ring;

#line 405 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_PART (part) ||
      BSE_ITEM (part)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 410 "bsesong.proc"
  
  for (ring = self->tracks_SL; ring; ring = sfi_ring_walk (ring, self->tracks_SL))
    {
      BseTrack *test_track = ring->data;
      guint start;
      if (bse_track_find_part (test_track, part, &start) &&
	  (!track || start < tick))
	{
	  track = test_track;
	  tick = start;
	}
    }

#line 423 "bsesong.proc"
  
  bse_value_set_object (out_values++, track);
  
  return BSE_ERROR_NONE;
}

/* --- find-any-track-for-part --- */
static void
find_any_track_for_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 429 "bsesong.proc"
 {
#line 431 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
#line 437 "bsesong.proc"
}  }
static BseErrorType
#line 437 "bsesong.proc"
find_any_track_for_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 440 "bsesong.proc"
{
#line 441 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BsePart *part = bse_value_get_object (in_values++);

#line 445 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_PART (part) ||
      BSE_ITEM (part)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 450 "bsesong.proc"
  
  bse_value_set_object (out_values++, bse_song_find_first_track (self, part));
  
  return BSE_ERROR_NONE;
}

/* --- synthesize-note --- */
static void
synthesize_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 456 "bsesong.proc"
 {
#line 458 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", "Fine tune in cents per semitone");
  *(in_pspecs++)    = sfi_pspec_real ("velocity", "Velocity", NULL,
			  1.0, 0, 1.0, 0.01,
			  SFI_PARAM_STANDARD ":scale");
#line 470 "bsesong.proc"
}  }
static BseErrorType
#line 470 "bsesong.proc"
synthesize_note_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 473 "bsesong.proc"
{
#line 474 "bsesong.proc"
  
  BseSong *self      = bse_value_get_object (in_values++);
  BseTrack *track    = bse_value_get_object (in_values++);
  guint    duration  = sfi_value_get_int (in_values++);
  gint     note      = sfi_value_get_note (in_values++);
  gint     fine_tune = sfi_value_get_int (in_values++);
  gfloat   velocity  = sfi_value_get_real (in_values++);
  
#line 482 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_TRACK (track) ||
      BSE_ITEM (track)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 487 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self) && self->midi_receiver_SL)
    {
      double semitone_factor = bse_transpose_factor (self->musical_tuning, CLAMP (note, SFI_MIN_NOTE, SFI_MAX_NOTE) - SFI_KAMMER_NOTE);
      double freq = BSE_KAMMER_FREQUENCY * semitone_factor * bse_cent_tune_fast (fine_tune);
      SfiTime tstamp = gsl_tick_stamp () + bse_engine_block_size () * 2;
      BseMidiEvent *eon, *eoff;
      eon  = bse_midi_event_note_on (track->midi_channel_SL, tstamp, freq, velocity);
      eoff = bse_midi_event_note_off (track->midi_channel_SL, tstamp + duration, freq);
      bse_midi_receiver_push_event (self->midi_receiver_SL, eon);
      bse_midi_receiver_push_event (self->midi_receiver_SL, eoff);
      bse_midi_receiver_process_events (self->midi_receiver_SL, tstamp + duration);
      bse_project_keep_activated (BSE_PROJECT (BSE_ITEM (self)->parent), tstamp + duration);
    }
  
  return BSE_ERROR_NONE;
}

/* --- get-timing --- */
static void
get_timing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 505 "bsesong.proc"
 {
#line 507 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL, BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", "Tick to retrieve timing info about", 0, 0, G_MAXINT, 384, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("timing", "Timing", "Song Timing", BSE_TYPE_SONG_TIMING, SFI_PARAM_STANDARD);
#line 510 "bsesong.proc"
}  }
static BseErrorType
#line 510 "bsesong.proc"
get_timing_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 513 "bsesong.proc"
{
#line 514 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  SfiInt   tick = sfi_value_get_int (in_values++);
  BseSongTiming timing = { 0, };

#line 519 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 523 "bsesong.proc"
  
  bse_song_get_timing (self, tick, &timing);

#line 526 "bsesong.proc"
  
  bse_value_set_boxed (out_values++, &timing);
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_create_bus__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Create a new mixer bus for a Song.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 35;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_create_bus = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseSong+create-bus", 
    NULL,
    "/Methods/BseSong/General/Create Bus",
    NULL,
    __enode_create_bus__fill_strings,
  },
  0, create_bus_setup, create_bus_exec, 
};
static void
__enode_remove_bus__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Delete a mixer bus from a Song.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 72;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_remove_bus = {
  { (BseExportNode*) &__enode_create_bus, BSE_EXPORT_NODE_PROC,
    "BseSong+remove-bus", 
    NULL,
    "/Methods/BseSong/General/Remove Bus",
    NULL,
    __enode_remove_bus__fill_strings,
  },
  0, remove_bus_setup, remove_bus_exec, 
};
static void
__enode_ensure_master_bus__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Retrieve master output bus of a song, will create one if it doesn't exist.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 112;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ensure_master_bus = {
  { (BseExportNode*) &__enode_remove_bus, BSE_EXPORT_NODE_PROC,
    "BseSong+ensure-master-bus", 
    NULL,
    "/Methods/BseSong/General/Ensure Master Bus",
    NULL,
    __enode_ensure_master_bus__fill_strings,
  },
  0, ensure_master_bus_setup, ensure_master_bus_exec, 
};
static void
__enode_get_master_bus__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Retrieve master output bus of a song if it exists.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 139;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_master_bus = {
  { (BseExportNode*) &__enode_ensure_master_bus, BSE_EXPORT_NODE_PROC,
    "BseSong+get-master-bus", 
    NULL,
    "/Methods/BseSong/General/Get Master Bus",
    NULL,
    __enode_get_master_bus__fill_strings,
  },
  0, get_master_bus_setup, get_master_bus_exec, 
};
static void
__enode_ensure_track_links__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Ensure that each part in a song is inserted into at least one track.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 208;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ensure_track_links = {
  { (BseExportNode*) &__enode_get_master_bus, BSE_EXPORT_NODE_PROC,
    "BseSong+ensure-track-links", 
    NULL,
    "/Methods/BseSong/General/Ensure Track Links",
    NULL,
    __enode_ensure_track_links__fill_strings,
  },
  0, ensure_track_links_setup, ensure_track_links_exec, 
};
static void
__enode_create_part__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Create a new Part in a Song.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 243;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_create_part = {
  { (BseExportNode*) &__enode_ensure_track_links, BSE_EXPORT_NODE_PROC,
    "BseSong+create-part", 
    NULL,
    "/Methods/BseSong/General/Create Part",
    NULL,
    __enode_create_part__fill_strings,
  },
  0, create_part_setup, create_part_exec, 
};
static void
__enode_remove_part__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Delete a Part from a Song.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 274;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_remove_part = {
  { (BseExportNode*) &__enode_create_part, BSE_EXPORT_NODE_PROC,
    "BseSong+remove-part", 
    NULL,
    "/Methods/BseSong/General/Remove Part",
    NULL,
    __enode_remove_part__fill_strings,
  },
  0, remove_part_setup, remove_part_exec, 
};
static void
__enode_create_track__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Create a new Track for a Song.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 312;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_create_track = {
  { (BseExportNode*) &__enode_remove_part, BSE_EXPORT_NODE_PROC,
    "BseSong+create-track", 
    NULL,
    "/Methods/BseSong/General/Create Track",
    NULL,
    __enode_create_track__fill_strings,
  },
  0, create_track_setup, create_track_exec, 
};
static void
__enode_remove_track__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Delete a Track from a Song.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 348;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_remove_track = {
  { (BseExportNode*) &__enode_create_track, BSE_EXPORT_NODE_PROC,
    "BseSong+remove-track", 
    NULL,
    "/Methods/BseSong/General/Remove Track",
    NULL,
    __enode_remove_track__fill_strings,
  },
  0, remove_track_setup, remove_track_exec, 
};
static void
__enode_find_track_for_part__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Find a track suitable for playing notes of a given part.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 387;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_find_track_for_part = {
  { (BseExportNode*) &__enode_remove_track, BSE_EXPORT_NODE_PROC,
    "BseSong+find-track-for-part", 
    NULL,
    "/Methods/BseSong/General/Find Track For Part",
    NULL,
    __enode_find_track_for_part__fill_strings,
  },
  0, find_track_for_part_setup, find_track_for_part_exec, 
};
static void
__enode_find_any_track_for_part__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Find the first track that contains part, suitable to check for orphan parts.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 430;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_find_any_track_for_part = {
  { (BseExportNode*) &__enode_find_track_for_part, BSE_EXPORT_NODE_PROC,
    "BseSong+find-any-track-for-part", 
    NULL,
    "/Methods/BseSong/General/Find Any Track For Part",
    NULL,
    __enode_find_any_track_for_part__fill_strings,
  },
  0, find_any_track_for_part_setup, find_any_track_for_part_exec, 
};
static void
__enode_synthesize_note__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Synthesize a note on a song of an active project.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 457;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_synthesize_note = {
  { (BseExportNode*) &__enode_find_any_track_for_part, BSE_EXPORT_NODE_PROC,
    "BseSong+synthesize-note", 
    NULL,
    "/Methods/BseSong/General/Synthesize Note",
    NULL,
    __enode_synthesize_note__fill_strings,
  },
  0, synthesize_note_setup, synthesize_note_exec, 
};
static void
__enode_get_timing__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Retrieve song timing information at a specific tick.");
  es->file = "/opt/src/beast/bse/bsesong.proc";
  es->line = 506;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_timing = {
  { (BseExportNode*) &__enode_synthesize_note, BSE_EXPORT_NODE_PROC,
    "BseSong+get-timing", 
    NULL,
    "/Methods/BseSong/General/Get Timing",
    NULL,
    __enode_get_timing__fill_strings,
  },
  0, get_timing_setup, get_timing_exec, 
};
BseExportNode* bse__builtin_init_bsesong_genprc_c (void);
BseExportNode* bse__builtin_init_bsesong_genprc_c (void)
{
  return (BseExportNode*) &__enode_get_timing;
}

/*
 * Generated data ends here
 */
