/* ****************************************************************************

 * eID Middleware Project.
 * Copyright (C) 2008-2009 FedICT.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version
 * 3.0 as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, see
 * http://www.gnu.org/licenses/.

**************************************************************************** */
#include "UnitTest++/src/UnitTest++.h"
#include "../eidlib/eidlib.h"
#include "../eidlib/eidlibException.h"
#include <iostream>

using namespace eIDMW;

static unsigned char _root[] = {
		0x30,0x82,0x03,0xb4,0x30,0x82,0x02,0x9c,0xa0,0x03,0x02,0x01,0x02,0x02,0x10,0x01,
		0x00,0x00,0x00,0x00,0x00,0xfb,0x7c,0x59,0x0d,0xf3,0x00,0x00,0xce,0xc0,0x00,0x30,
		0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x38,
		0x31,0x0e,0x30,0x0c,0x06,0x03,0x55,0x04,0x06,0x13,0x05,0x42,0x45,0x20,0x20,0x20,
		0x31,0x0e,0x30,0x0c,0x06,0x03,0x55,0x04,0x0a,0x13,0x05,0x5a,0x45,0x54,0x45,0x53,
		0x31,0x16,0x30,0x14,0x06,0x03,0x55,0x04,0x03,0x13,0x0d,0x5a,0x45,0x54,0x45,0x53,
		0x20,0x52,0x6f,0x6f,0x74,0x20,0x43,0x41,0x30,0x1e,0x17,0x0d,0x30,0x34,0x30,0x33,
		0x32,0x33,0x31,0x30,0x31,0x30,0x30,0x32,0x5a,0x17,0x0d,0x30,0x39,0x30,0x33,0x32,
		0x33,0x31,0x30,0x31,0x30,0x30,0x32,0x5a,0x30,0x38,0x31,0x0e,0x30,0x0c,0x06,0x03,
		0x55,0x04,0x06,0x13,0x05,0x42,0x45,0x20,0x20,0x20,0x31,0x0e,0x30,0x0c,0x06,0x03,
		0x55,0x04,0x0a,0x13,0x05,0x5a,0x45,0x54,0x45,0x53,0x31,0x16,0x30,0x14,0x06,0x03,
		0x55,0x04,0x03,0x13,0x0d,0x5a,0x45,0x54,0x45,0x53,0x20,0x52,0x6f,0x6f,0x74,0x20,
		0x43,0x41,0x30,0x82,0x01,0x22,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,
		0x01,0x01,0x01,0x05,0x00,0x03,0x82,0x01,0x0f,0x00,0x30,0x82,0x01,0x0a,0x02,0x82,
		0x01,0x01,0x00,0xb1,0x56,0x7b,0xe1,0xcb,0x9e,0xcc,0xb0,0x8f,0x1d,0x10,0x44,0xf9,
		0x85,0x3e,0xc5,0xcc,0xbd,0x14,0x79,0xaa,0x75,0xe4,0x2e,0xcc,0x3b,0xc6,0x2a,0x8d,
		0xb2,0x31,0x53,0x0f,0x67,0x2a,0x08,0x21,0x5c,0xd3,0x9a,0x46,0xc5,0x40,0x71,0xe6,
		0xa5,0x92,0x55,0xec,0xe4,0xba,0x43,0x02,0x67,0x58,0x56,0x6a,0x71,0x90,0xfb,0x4a,
		0x4e,0x5d,0xe1,0xbb,0x66,0xd8,0xc5,0xeb,0x94,0x3c,0x2a,0x0b,0xf4,0xf0,0x51,0xa0,
		0xaa,0xae,0xd2,0x1d,0x93,0x90,0x9d,0xfd,0x66,0x17,0x35,0xe9,0xaa,0x15,0x0f,0x12,
		0xde,0xd6,0x31,0xc7,0x57,0x10,0x87,0xda,0x37,0xdf,0xb1,0x12,0xf2,0xf3,0x4b,0x59,
		0x45,0x7d,0xdf,0x6f,0x3d,0xda,0x10,0x53,0x2c,0xe5,0xe2,0xd1,0xcf,0xb0,0xf8,0x7f,
		0xe6,0x68,0x47,0xe9,0x44,0x8f,0x7f,0x72,0x63,0x80,0x55,0x2d,0x32,0x13,0x0d,0x57,
		0x07,0x20,0xaf,0x9e,0x85,0xeb,0xe5,0x1b,0x28,0x4b,0x06,0x22,0x55,0xe2,0x1a,0xf3,
		0x9b,0x13,0x96,0x00,0x0d,0x11,0xf4,0x64,0xb3,0x6f,0x9f,0x59,0x7f,0x20,0xb8,0x68,
		0x57,0x7c,0x3e,0x3d,0xe7,0xea,0x9d,0x6e,0x33,0x5d,0xbf,0x30,0xe2,0x89,0x1a,0x9f,
		0xc3,0x8d,0x25,0x5c,0x01,0x2a,0xfb,0xf2,0xc4,0x20,0x40,0x50,0x57,0xc0,0x00,0x37,
		0xb8,0xa0,0x37,0x5f,0x38,0xe2,0xd9,0x54,0xaf,0x41,0xa3,0xea,0xef,0x6e,0xd3,0x1f,
		0x47,0xde,0x93,0xcd,0xf9,0x19,0x74,0x8a,0xb6,0x02,0xec,0x06,0x5b,0x74,0x00,0xdb,
		0x2f,0x48,0x6f,0xfa,0xf5,0xcd,0x99,0xc8,0xac,0x94,0xd0,0x13,0x61,0x36,0x44,0x0e,
		0x74,0x56,0x17,0x02,0x03,0x01,0x00,0x01,0xa3,0x81,0xb9,0x30,0x81,0xb6,0x30,0x0e,
		0x06,0x03,0x55,0x1d,0x0f,0x01,0x01,0xff,0x04,0x04,0x03,0x02,0x01,0x06,0x30,0x0f,
		0x06,0x03,0x55,0x1d,0x13,0x01,0x01,0xff,0x04,0x05,0x30,0x03,0x01,0x01,0xff,0x30,
		0x1d,0x06,0x03,0x55,0x1d,0x0e,0x04,0x16,0x04,0x14,0xc0,0x36,0xc8,0xa1,0x2c,0x09,
		0x80,0x78,0xd1,0xc9,0x47,0x0b,0xad,0xa0,0xad,0x56,0x84,0x51,0x19,0xe6,0x30,0x40,
		0x06,0x03,0x55,0x1d,0x20,0x04,0x39,0x30,0x37,0x30,0x35,0x06,0x05,0x60,0x38,0x01,
		0x01,0x01,0x30,0x2c,0x30,0x2a,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x02,0x01,
		0x16,0x1e,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x72,0x65,0x70,0x6f,0x73,0x69,0x74,
		0x6f,0x72,0x79,0x2e,0x65,0x69,0x64,0x2e,0x7a,0x65,0x74,0x65,0x73,0x2e,0x62,0x65,
		0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,0x01,0x04,0x04,0x03,
		0x02,0x00,0x07,0x30,0x1f,0x06,0x03,0x55,0x1d,0x23,0x04,0x18,0x30,0x16,0x80,0x14,
		0xc0,0x36,0xc8,0xa1,0x2c,0x09,0x80,0x78,0xd1,0xc9,0x47,0x0b,0xad,0xa0,0xad,0x56,
		0x84,0x51,0x19,0xe6,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,
		0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0x4d,0x16,0xa5,0xe5,0x81,0x9f,0xac,0xb4,
		0xf7,0xaf,0x51,0x7e,0xa1,0x73,0x07,0xe6,0xe3,0x7d,0x96,0x3d,0x36,0x3f,0x9f,0xd7,
		0x01,0xed,0x53,0x70,0xb0,0x82,0x58,0x79,0x72,0x64,0x20,0x02,0x85,0xa4,0xb5,0xe6,
		0x7b,0x40,0xad,0x4b,0xe1,0x50,0x00,0x22,0x91,0x88,0xfa,0xbd,0xdc,0x69,0xbe,0xa6,
		0x6f,0x84,0x5c,0xf8,0x9a,0xfa,0x08,0xfa,0x8c,0xd4,0x14,0x35,0x1d,0xc9,0x2b,0x46,
		0xb4,0x94,0x87,0x42,0xf7,0x38,0xc2,0x36,0xc2,0xac,0x30,0x04,0xa9,0xe4,0xe0,0x6d,
		0xb8,0x46,0x54,0xc1,0xcb,0x4f,0x44,0xcf,0x3b,0x36,0x61,0xd7,0x34,0x2f,0x7c,0xef,
		0xe0,0x9c,0xc7,0xdc,0x82,0x5e,0x84,0x12,0xdc,0x17,0x05,0xa5,0x26,0x39,0x45,0x9e,
		0xb9,0xfc,0x0f,0x24,0x66,0xf4,0x9e,0x0a,0x16,0x3c,0x71,0xe0,0x17,0x03,0xdc,0x66,
		0x51,0x57,0x7d,0x8c,0x2b,0x0e,0x3c,0x55,0x8a,0xf6,0xc8,0x7a,0x12,0x4a,0x48,0x76,
		0xa4,0x29,0xad,0xa2,0x88,0xe6,0x2e,0x7c,0xfb,0xe2,0xc1,0xa5,0xfc,0xd1,0xb5,0xea,
		0xad,0x1e,0x8c,0xb2,0x2c,0xd9,0x2a,0xd1,0xf7,0xe6,0xb5,0x8c,0x60,0x44,0xdc,0x54,
		0x14,0x5f,0x65,0xbf,0x4b,0xc7,0xa4,0xc5,0x3f,0x49,0x5d,0xb1,0x9a,0x69,0x93,0xee,
		0x5c,0xa2,0x1a,0x35,0xfd,0xce,0xf4,0xb3,0x5c,0xd7,0x9d,0x72,0xbf,0x33,0xc9,0x17,
		0xaf,0x03,0xa8,0x59,0xe7,0x70,0x7b,0x74,0x15,0xd3,0x15,0x23,0xe9,0xd9,0x5d,0x36,
		0xc7,0xbd,0xda,0x45,0xd7,0x2e,0x21,0xf0,0x25,0xd7,0xd2,0x16,0x9a,0xc1,0xd1,0x09,
		0xb8,0xb3,0x9a,0xe8,0xb8,0xff,0x81,0xbb,
};

static unsigned char _child0[] = {
		0x30,0x82,0x03,0xf6,0x30,0x82,0x02,0xde,0xa0,0x03,0x02,0x01,0x02,0x02,0x10,0x01,
		0x00,0x00,0x00,0x00,0x01,0x15,0xa8,0xd3,0x59,0x66,0x00,0x00,0xce,0xc0,0x03,0x30,
		0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x37,
		0x31,0x1a,0x30,0x18,0x06,0x03,0x55,0x04,0x06,0x13,0x11,0x42,0x45,0x20,0x20,0x20,
		0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x31,0x19,0x30,0x17,
		0x06,0x03,0x55,0x04,0x03,0x13,0x10,0x5a,0x45,0x54,0x45,0x53,0x20,0x43,0x69,0x74,
		0x69,0x7a,0x65,0x6e,0x20,0x43,0x41,0x30,0x1e,0x17,0x0d,0x30,0x37,0x31,0x30,0x31,
		0x35,0x31,0x32,0x33,0x39,0x32,0x34,0x5a,0x17,0x0d,0x31,0x32,0x31,0x30,0x31,0x35,
		0x31,0x32,0x33,0x39,0x32,0x34,0x5a,0x30,0x6c,0x31,0x0b,0x30,0x09,0x06,0x03,0x55,
		0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x26,0x30,0x24,0x06,0x03,0x55,0x04,0x03,0x13,
		0x1d,0x67,0x6e,0x61,0x6d,0x65,0x30,0x20,0x6e,0x61,0x6d,0x65,0x30,0x20,0x28,0x41,
		0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x29,0x31,0x0e,
		0x30,0x0c,0x06,0x03,0x55,0x04,0x04,0x13,0x05,0x6e,0x61,0x6d,0x65,0x30,0x31,0x0f,
		0x30,0x0d,0x06,0x03,0x55,0x04,0x2a,0x13,0x06,0x67,0x6e,0x61,0x6d,0x65,0x30,0x31,
		0x14,0x30,0x12,0x06,0x03,0x55,0x04,0x05,0x13,0x0b,0x30,0x30,0x30,0x30,0x30,0x30,
		0x30,0x30,0x30,0x30,0x30,0x30,0x81,0x9f,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,
		0xf7,0x0d,0x01,0x01,0x01,0x05,0x00,0x03,0x81,0x8d,0x00,0x30,0x81,0x89,0x02,0x81,
		0x81,0x00,0xdd,0x15,0xe4,0xaa,0xd6,0x3b,0xea,0xef,0x8a,0x5c,0x1f,0xd9,0x86,0x29,
		0x04,0xbb,0x10,0xf8,0xce,0x9f,0x86,0x7d,0xaf,0x4f,0xba,0xca,0x24,0xaa,0xc1,0x18,
		0x27,0xae,0xd1,0xf6,0x60,0x3e,0x72,0x8c,0x7f,0x97,0xbc,0xe3,0x22,0xc6,0x47,0x4c,
		0xb4,0x7c,0x03,0x6f,0x4a,0x22,0xb3,0x7f,0x7e,0x13,0xd0,0xb4,0x26,0xc9,0x29,0xe7,
		0x82,0x72,0x55,0xaf,0x73,0x19,0x31,0x52,0xb8,0x49,0xa4,0xbe,0xdb,0x82,0x01,0x13,
		0xfd,0x32,0x87,0xb3,0x5f,0x53,0x2d,0x20,0x7d,0x17,0x9d,0x37,0x48,0xf4,0xcb,0xa8,
		0x1f,0x08,0x5d,0xf3,0x32,0x05,0x6a,0x7f,0xa3,0x2e,0xab,0x39,0x2b,0x5f,0xf1,0x43,
		0xd3,0x7e,0x33,0xb7,0x3c,0x43,0x3d,0xd3,0xec,0xb2,0x50,0x06,0x51,0x8b,0xb5,0x72,
		0xf8,0x9d,0x02,0x03,0x01,0x00,0x01,0xa3,0x82,0x01,0x4b,0x30,0x82,0x01,0x47,0x30,
		0x0e,0x06,0x03,0x55,0x1d,0x0f,0x01,0x01,0xff,0x04,0x04,0x03,0x02,0x07,0x80,0x30,
		0x45,0x06,0x03,0x55,0x1d,0x20,0x04,0x3e,0x30,0x3c,0x30,0x3a,0x06,0x07,0x60,0x38,
		0x01,0x01,0x01,0x02,0x02,0x30,0x2f,0x30,0x2d,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,
		0x07,0x02,0x01,0x16,0x21,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x72,0x65,0x70,0x6f,
		0x73,0x69,0x74,0x6f,0x72,0x79,0x2e,0x65,0x69,0x64,0x2e,0x7a,0x65,0x74,0x65,0x73,
		0x2e,0x62,0x65,0x20,0x20,0x20,0x30,0x3c,0x06,0x03,0x55,0x1d,0x1f,0x04,0x35,0x30,
		0x33,0x30,0x31,0xa0,0x2f,0xa0,0x2d,0x86,0x2b,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,
		0x63,0x72,0x6c,0x2e,0x65,0x69,0x64,0x2e,0x7a,0x65,0x74,0x65,0x73,0x2e,0x62,0x65,
		0x2f,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2f,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,
		0x2e,0x63,0x72,0x6c,0x30,0x7c,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x01,
		0x04,0x70,0x30,0x6e,0x30,0x3f,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x02,
		0x86,0x33,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x5a,0x65,0x74,
		0x65,0x73,0x43,0x61,0x72,0x64,0x73,0x2e,0x62,0x65,0x2f,0x64,0x75,0x6d,0x6d,0x79,
		0x2f,0x63,0x65,0x72,0x74,0x69,0x66,0x63,0x61,0x74,0x65,0x73,0x2f,0x74,0x65,0x73,
		0x74,0x2e,0x63,0x72,0x74,0x30,0x2b,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x30,
		0x01,0x86,0x1f,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x6f,0x63,0x73,0x70,0x2e,0x5a,
		0x65,0x74,0x65,0x73,0x43,0x61,0x72,0x64,0x73,0x2e,0x62,0x65,0x2f,0x64,0x75,0x6d,
		0x6d,0x79,0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,0x01,0x04,
		0x04,0x03,0x02,0x05,0xa0,0x30,0x1f,0x06,0x03,0x55,0x1d,0x23,0x04,0x18,0x30,0x16,
		0x80,0x14,0xed,0x2b,0xa5,0x67,0x16,0xb1,0xed,0x70,0xe1,0x5d,0x55,0x7a,0x11,0x12,
		0x16,0x1c,0x97,0x41,0x56,0x96,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,
		0x01,0x01,0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0x45,0x28,0x20,0xfb,0xa3,0xf1,
		0x04,0x25,0xbb,0x6c,0x4b,0x37,0x08,0xd1,0x54,0x99,0x1c,0x1c,0x28,0x4b,0xde,0x2e,
		0x53,0xf4,0x81,0x11,0xd1,0xb6,0x09,0x56,0xef,0x2c,0x30,0xfa,0x43,0x74,0x89,0xbc,
		0x05,0x06,0xc3,0xff,0x83,0x49,0xc4,0xea,0xc7,0x01,0x3e,0x67,0x75,0x74,0x71,0x59,
		0x0a,0x71,0xfb,0xf3,0xb7,0x10,0xd2,0x79,0x52,0x89,0x5f,0x1b,0xf8,0x58,0x61,0xfb,
		0xb5,0xec,0x09,0xe9,0x29,0x5c,0x1b,0x43,0x29,0x12,0x92,0x88,0xcc,0x70,0x97,0xd9,
		0xe0,0x81,0x61,0xa8,0x42,0xf8,0x88,0x57,0xf4,0x95,0x0a,0x01,0xc2,0xf4,0xa2,0xe7,
		0xfb,0x99,0xee,0xfa,0xbf,0x77,0x03,0xf9,0x6f,0xf4,0xad,0xa2,0xd9,0x01,0xd0,0x3c,
		0xdc,0x67,0xfe,0xa2,0x0b,0x82,0x7e,0x1e,0xcd,0xb2,0x45,0x4a,0x88,0x13,0xd1,0x2c,
		0x3e,0x0b,0xea,0xd0,0x2d,0x66,0xda,0x6b,0xad,0x6b,0x6e,0x5d,0x01,0x54,0x2f,0x56,
		0xdf,0xe4,0x1d,0x49,0x75,0xd5,0x1b,0x75,0xd6,0x84,0xf5,0x90,0xa9,0x68,0xce,0x87,
		0xb8,0xfe,0xb8,0x9f,0x4f,0x17,0xcb,0x62,0xbe,0xce,0x41,0x93,0x7b,0x43,0xcc,0xd5,
		0xff,0x26,0xfd,0xde,0xef,0xda,0xeb,0x0c,0x7f,0x14,0xb4,0xfd,0xe6,0xca,0x3a,0xcb,
		0xbf,0xc1,0xcc,0x71,0x43,0x1b,0x32,0xe8,0x37,0xa1,0x6d,0xe1,0xc3,0xd3,0x00,0xd5,
		0x9a,0xc1,0x38,0x92,0x71,0xb3,0xa5,0xba,0xd8,0xab,0x9f,0xb7,0x75,0xf6,0xd6,0x9a,
		0x95,0x8d,0xbb,0xe5,0x7a,0x15,0x2a,0x91,0x33,0x31,0x05,0x8a,0x4c,0x74,0xd3,0x95,
		0xbe,0x45,0xe6,0xe3,0x0e,0x64,0xc3,0xa4,0x6f,0x45,
};

static unsigned char _child1[] = {
		0x30,0x82,0x04,0x0c,0x30,0x82,0x02,0xf4,0xa0,0x03,0x02,0x01,0x02,0x02,0x10,0x01,
		0x00,0x00,0x00,0x00,0x01,0x15,0xa8,0xd3,0x5a,0x40,0x00,0x00,0xce,0xc0,0x04,0x30,
		0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x37,
		0x31,0x1a,0x30,0x18,0x06,0x03,0x55,0x04,0x06,0x13,0x11,0x42,0x45,0x20,0x20,0x20,
		0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x31,0x19,0x30,0x17,
		0x06,0x03,0x55,0x04,0x03,0x13,0x10,0x5a,0x45,0x54,0x45,0x53,0x20,0x43,0x69,0x74,
		0x69,0x7a,0x65,0x6e,0x20,0x43,0x41,0x30,0x1e,0x17,0x0d,0x30,0x37,0x31,0x30,0x31,
		0x35,0x31,0x32,0x33,0x39,0x32,0x34,0x5a,0x17,0x0d,0x31,0x32,0x31,0x30,0x31,0x35,
		0x31,0x32,0x33,0x39,0x32,0x34,0x5a,0x30,0x67,0x31,0x0b,0x30,0x09,0x06,0x03,0x55,
		0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x21,0x30,0x1f,0x06,0x03,0x55,0x04,0x03,0x13,
		0x18,0x67,0x6e,0x61,0x6d,0x65,0x30,0x20,0x6e,0x61,0x6d,0x65,0x30,0x20,0x28,0x53,
		0x69,0x67,0x6e,0x61,0x74,0x75,0x72,0x65,0x29,0x31,0x0e,0x30,0x0c,0x06,0x03,0x55,
		0x04,0x04,0x13,0x05,0x6e,0x61,0x6d,0x65,0x30,0x31,0x0f,0x30,0x0d,0x06,0x03,0x55,
		0x04,0x2a,0x13,0x06,0x67,0x6e,0x61,0x6d,0x65,0x30,0x31,0x14,0x30,0x12,0x06,0x03,
		0x55,0x04,0x05,0x13,0x0b,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
		0x30,0x81,0x9f,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x01,
		0x05,0x00,0x03,0x81,0x8d,0x00,0x30,0x81,0x89,0x02,0x81,0x81,0x00,0xb9,0x1d,0x49,
		0x9b,0x9e,0x9e,0x3a,0x8c,0x3b,0x8a,0xce,0x79,0x78,0xdb,0x33,0x01,0xb8,0xd1,0x59,
		0x15,0x83,0x7b,0x91,0x91,0xbd,0xa0,0xf4,0x51,0x2b,0xf3,0x9a,0x9e,0xe3,0x56,0x42,
		0x3e,0xaf,0xfb,0x01,0xef,0xbb,0xf4,0x97,0x34,0x0c,0x21,0x12,0x82,0x4a,0x02,0x1d,
		0x90,0xce,0x3e,0x11,0xfc,0x6a,0x53,0xcd,0x8b,0xce,0xbf,0x21,0xb8,0x60,0x0a,0x89,
		0x83,0x7e,0x87,0x24,0x08,0x63,0x28,0x7f,0xb2,0xa2,0x1c,0x2a,0xfe,0x67,0xd4,0x2b,
		0xd9,0x0f,0x23,0x40,0x28,0x71,0x3e,0xd4,0xaf,0x72,0x34,0x7c,0xb5,0x37,0x7b,0x8c,
		0x5e,0x7a,0x0f,0x24,0xa6,0x43,0xa0,0x8b,0xce,0x74,0x39,0x4b,0x4f,0x85,0x30,0x85,
		0xb0,0x36,0x6f,0x45,0x06,0x34,0xee,0x2f,0xed,0x0e,0x8a,0x53,0xa5,0x02,0x03,0x01,
		0x00,0x01,0xa3,0x82,0x01,0x66,0x30,0x82,0x01,0x62,0x30,0x0e,0x06,0x03,0x55,0x1d,
		0x0f,0x01,0x01,0xff,0x04,0x04,0x03,0x02,0x06,0x40,0x30,0x46,0x06,0x03,0x55,0x1d,
		0x20,0x04,0x3f,0x30,0x3d,0x30,0x3b,0x06,0x07,0x60,0x38,0x01,0x01,0x01,0x02,0x01,
		0x30,0x30,0x30,0x2e,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x02,0x01,0x16,0x22,
		0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x72,0x65,0x70,0x6f,0x73,0x69,0x74,0x6f,0x72,
		0x79,0x2e,0x65,0x69,0x64,0x2e,0x7a,0x65,0x74,0x65,0x73,0x2e,0x62,0x65,0x20,0x20,
		0x20,0x20,0x30,0x3c,0x06,0x03,0x55,0x1d,0x1f,0x04,0x35,0x30,0x33,0x30,0x31,0xa0,
		0x2f,0xa0,0x2d,0x86,0x2b,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x63,0x72,0x6c,0x2e,
		0x65,0x69,0x64,0x2e,0x7a,0x65,0x74,0x65,0x73,0x2e,0x62,0x65,0x2f,0x62,0x65,0x6c,
		0x67,0x69,0x75,0x6d,0x2f,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x63,0x72,0x6c,
		0x30,0x18,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x03,0x04,0x0c,0x30,0x0a,
		0x30,0x08,0x06,0x06,0x04,0x00,0x8e,0x46,0x01,0x01,0x30,0x7c,0x06,0x08,0x2b,0x06,
		0x01,0x05,0x05,0x07,0x01,0x01,0x04,0x70,0x30,0x6e,0x30,0x3f,0x06,0x08,0x2b,0x06,
		0x01,0x05,0x05,0x07,0x30,0x02,0x86,0x33,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,
		0x77,0x77,0x2e,0x5a,0x65,0x74,0x65,0x73,0x43,0x61,0x72,0x64,0x73,0x2e,0x62,0x65,
		0x2f,0x64,0x75,0x6d,0x6d,0x79,0x2f,0x63,0x65,0x72,0x74,0x69,0x66,0x63,0x61,0x74,
		0x65,0x73,0x2f,0x74,0x65,0x73,0x74,0x2e,0x63,0x72,0x74,0x30,0x2b,0x06,0x08,0x2b,
		0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x86,0x1f,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,
		0x6f,0x63,0x73,0x70,0x2e,0x5a,0x65,0x74,0x65,0x73,0x43,0x61,0x72,0x64,0x73,0x2e,
		0x62,0x65,0x2f,0x64,0x75,0x6d,0x6d,0x79,0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,
		0x86,0xf8,0x42,0x01,0x01,0x04,0x04,0x03,0x02,0x05,0xa0,0x30,0x1f,0x06,0x03,0x55,
		0x1d,0x23,0x04,0x18,0x30,0x16,0x80,0x14,0xed,0x2b,0xa5,0x67,0x16,0xb1,0xed,0x70,
		0xe1,0x5d,0x55,0x7a,0x11,0x12,0x16,0x1c,0x97,0x41,0x56,0x96,0x30,0x0d,0x06,0x09,
		0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,
		0x22,0xe4,0x89,0x2c,0x7b,0xad,0x30,0xd7,0xf5,0x6c,0xde,0x70,0xe2,0x6c,0x90,0x8b,
		0x33,0xd3,0x20,0xcf,0xc9,0x62,0x71,0x91,0x95,0x8d,0xbd,0x63,0xb0,0x13,0x58,0xf4,
		0x88,0xa9,0xd9,0x36,0x76,0x8e,0x5f,0xae,0x3f,0xc7,0x88,0x5e,0x8b,0x55,0x64,0x54,
		0xc1,0xf5,0x54,0xee,0xde,0x43,0x4a,0xaf,0x3e,0x9d,0x93,0x0a,0x1c,0x18,0x5d,0xba,
		0x3f,0x00,0xfc,0xfd,0x62,0xc8,0x62,0x94,0xca,0x69,0x65,0x1b,0x27,0xde,0x24,0x91,
		0xc9,0xa2,0x6c,0x9c,0xcd,0xee,0xc6,0x91,0x0e,0x1d,0x18,0x7f,0x03,0x1f,0xbf,0xe9,
		0xa5,0x51,0x79,0xb0,0x0a,0x9e,0x81,0x9e,0x70,0x5e,0xb3,0x73,0xa4,0xb8,0x94,0xe8,
		0x91,0xa5,0x02,0xf5,0x6d,0x48,0x0a,0xb1,0xf9,0x9f,0xb1,0x2b,0x49,0xf7,0xd9,0x92,
		0x56,0x75,0x6e,0xd0,0x8d,0x80,0x60,0x2c,0x11,0xd2,0xcd,0x53,0x19,0xf3,0xb6,0xab,
		0xd7,0x2b,0x5d,0xd1,0xdf,0x54,0x3f,0xbb,0xf7,0x7c,0xc3,0xf4,0xe9,0x41,0x5c,0x17,
		0x46,0xf1,0x6e,0x3e,0x89,0xa2,0xfb,0xf2,0x89,0x73,0x3e,0xea,0x13,0x7a,0x74,0xbb,
		0x6e,0xb6,0xd0,0xea,0xf5,0xff,0x6b,0xfa,0x00,0xb2,0x7c,0xe3,0xe8,0x65,0x0f,0xe2,
		0x97,0x3f,0x9d,0x97,0x48,0x7a,0x14,0xf9,0xba,0xbf,0x2d,0x14,0x72,0xc3,0x3f,0x26,
		0xe0,0x19,0xa8,0x6d,0x23,0xcc,0xb4,0x7c,0x3f,0xcb,0x47,0x41,0x07,0xb1,0xe3,0x42,
		0xf1,0x1b,0x6b,0x76,0xa5,0xcf,0xb1,0xdf,0xf8,0xaa,0xd0,0xed,0x48,0x04,0x3e,0xd5,
		0x2b,0xf4,0x38,0x52,0xa1,0x11,0x29,0xc3,0x4e,0xca,0x23,0x02,0xc6,0xa6,0xc7,0xc0,
};

static unsigned char _ca[] = {
		0x30,0x82,0x03,0xf5,0x30,0x82,0x02,0xdd,0xa0,0x03,0x02,0x01,0x02,0x02,0x10,0x01,
		0x00,0x00,0x00,0x00,0x00,0xfb,0x7c,0x59,0x0f,0xa2,0x00,0x00,0xce,0xc0,0x01,0x30,
		0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x38,
		0x31,0x0e,0x30,0x0c,0x06,0x03,0x55,0x04,0x06,0x13,0x05,0x42,0x45,0x20,0x20,0x20,
		0x31,0x0e,0x30,0x0c,0x06,0x03,0x55,0x04,0x0a,0x13,0x05,0x5a,0x45,0x54,0x45,0x53,
		0x31,0x16,0x30,0x14,0x06,0x03,0x55,0x04,0x03,0x13,0x0d,0x5a,0x45,0x54,0x45,0x53,
		0x20,0x52,0x6f,0x6f,0x74,0x20,0x43,0x41,0x30,0x1e,0x17,0x0d,0x30,0x34,0x30,0x33,
		0x32,0x33,0x31,0x30,0x31,0x30,0x30,0x32,0x5a,0x17,0x0d,0x30,0x39,0x30,0x33,0x32,
		0x33,0x31,0x30,0x31,0x30,0x30,0x32,0x5a,0x30,0x37,0x31,0x1a,0x30,0x18,0x06,0x03,
		0x55,0x04,0x06,0x13,0x11,0x42,0x45,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
		0x20,0x20,0x20,0x20,0x20,0x20,0x31,0x19,0x30,0x17,0x06,0x03,0x55,0x04,0x03,0x13,
		0x10,0x5a,0x45,0x54,0x45,0x53,0x20,0x43,0x69,0x74,0x69,0x7a,0x65,0x6e,0x20,0x43,
		0x41,0x30,0x82,0x01,0x22,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,
		0x01,0x01,0x05,0x00,0x03,0x82,0x01,0x0f,0x00,0x30,0x82,0x01,0x0a,0x02,0x82,0x01,
		0x01,0x00,0x9d,0x32,0xe1,0xe3,0xae,0x49,0xb7,0x32,0x4c,0x2c,0xc7,0x84,0xa4,0xf5,
		0xef,0x95,0x5b,0x61,0xf0,0x68,0xc5,0xb0,0x0a,0xeb,0xe0,0x9e,0x05,0x27,0x24,0xd0,
		0xca,0xe1,0x46,0x3a,0x95,0x4b,0x77,0xce,0xc8,0x88,0xb9,0x38,0x30,0xeb,0x15,0x23,
		0xc0,0xa6,0x01,0xe8,0x9c,0xe2,0x2f,0xbd,0x1e,0x2e,0x77,0xab,0x62,0x65,0xff,0xf5,
		0xc3,0x0b,0x0f,0x12,0x51,0x4f,0xaa,0x2a,0x4f,0xf1,0x06,0x8e,0x4a,0x93,0xfb,0x4a,
		0x22,0x5b,0x69,0x12,0xa5,0x81,0x9e,0xc3,0xfb,0xdc,0x50,0x4f,0x62,0xbb,0xc9,0xcb,
		0xdd,0xfd,0x84,0x6b,0xb0,0x6c,0xa1,0xcb,0xca,0xb6,0x20,0x8b,0x1b,0xe4,0xf6,0xac,
		0x21,0xef,0x6c,0x07,0x80,0xa5,0x8f,0x75,0x1f,0xfd,0x99,0x46,0x24,0xae,0xd0,0x54,
		0x28,0xbe,0x4a,0x75,0x91,0x96,0xc6,0xc0,0x21,0xe3,0x81,0x17,0x4f,0xb6,0x86,0x6b,
		0x5e,0x33,0x7a,0x17,0x9d,0x13,0x62,0x1b,0x57,0x19,0x51,0xfe,0x3f,0xdf,0x73,0xdf,
		0xa1,0xd1,0x07,0xfa,0x0c,0xcb,0xef,0x4e,0x82,0xb2,0xc1,0x9c,0x8f,0x77,0x03,0xe4,
		0x34,0xc5,0x55,0xd1,0x3a,0x17,0x86,0x4b,0x51,0x08,0x84,0xf0,0xaf,0x58,0x4c,0x8a,
		0x14,0x59,0x4d,0x3f,0x9f,0x46,0x70,0x3b,0xfb,0x23,0x1f,0x3b,0xec,0x7a,0x50,0xa4,
		0x18,0xe0,0x05,0xe0,0x7d,0xcd,0x01,0xb3,0x15,0x0f,0x3d,0xf5,0xcf,0xbb,0x85,0x2e,
		0x5d,0x83,0x1c,0xd5,0x54,0x12,0x5c,0x8d,0x19,0x92,0xe0,0x1b,0xcb,0x28,0x27,0xea,
		0x62,0xda,0xbe,0xf8,0xb8,0x7b,0xed,0xd7,0xbb,0xbc,0xb6,0xb6,0xc3,0xb9,0xa9,0xc8,
		0x90,0x8d,0x02,0x03,0x01,0x00,0x01,0xa3,0x81,0xfb,0x30,0x81,0xf8,0x30,0x0e,0x06,
		0x03,0x55,0x1d,0x0f,0x01,0x01,0xff,0x04,0x04,0x03,0x02,0x01,0x06,0x30,0x12,0x06,
		0x03,0x55,0x1d,0x13,0x01,0x01,0xff,0x04,0x08,0x30,0x06,0x01,0x01,0xff,0x02,0x01,
		0x00,0x30,0x1d,0x06,0x03,0x55,0x1d,0x0e,0x04,0x16,0x04,0x14,0xed,0x2b,0xa5,0x67,
		0x16,0xb1,0xed,0x70,0xe1,0x5d,0x55,0x7a,0x11,0x12,0x16,0x1c,0x97,0x41,0x56,0x96,
		0x30,0x41,0x06,0x03,0x55,0x1d,0x20,0x04,0x3a,0x30,0x38,0x30,0x36,0x06,0x06,0x60,
		0x38,0x01,0x01,0x01,0x02,0x30,0x2c,0x30,0x2a,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,
		0x07,0x02,0x01,0x16,0x1e,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x72,0x65,0x70,0x6f,
		0x73,0x69,0x74,0x6f,0x72,0x79,0x2e,0x65,0x69,0x64,0x2e,0x7a,0x65,0x74,0x65,0x73,
		0x2e,0x62,0x65,0x30,0x3c,0x06,0x03,0x55,0x1d,0x1f,0x04,0x35,0x30,0x33,0x30,0x31,
		0xa0,0x2f,0xa0,0x2d,0x86,0x2b,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x63,0x72,0x6c,
		0x2e,0x65,0x69,0x64,0x2e,0x7a,0x65,0x74,0x65,0x73,0x2e,0x62,0x65,0x2f,0x62,0x65,
		0x6c,0x67,0x69,0x75,0x6d,0x2f,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x63,0x72,
		0x6c,0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,0x86,0xf8,0x42,0x01,0x01,0x04,0x04,
		0x03,0x02,0x00,0x07,0x30,0x1f,0x06,0x03,0x55,0x1d,0x23,0x04,0x18,0x30,0x16,0x80,
		0x14,0xc0,0x36,0xc8,0xa1,0x2c,0x09,0x80,0x78,0xd1,0xc9,0x47,0x0b,0xad,0xa0,0xad,
		0x56,0x84,0x51,0x19,0xe6,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,
		0x01,0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0xaa,0x58,0xd0,0xa0,0xba,0x1a,0xf8,
		0xe5,0x5e,0xb7,0x39,0x34,0x4c,0x3d,0x54,0x6a,0x54,0x38,0x62,0xe7,0x77,0x2b,0x93,
		0x07,0xfb,0x34,0x5d,0x4e,0xc9,0x09,0xb5,0xc2,0x76,0x62,0x1b,0xd3,0xe0,0xb6,0xff,
		0xc7,0x46,0x1b,0x49,0x45,0x62,0x94,0x55,0xb7,0xa8,0x9c,0xc7,0xa0,0x31,0x5b,0xd8,
		0xbd,0x5a,0x33,0x81,0x5b,0x18,0xbf,0x29,0x7f,0xc1,0x4a,0x14,0xdf,0x18,0x03,0x1e,
		0xd4,0x55,0x21,0x5d,0x09,0x5b,0x11,0xad,0x35,0x74,0x14,0x8c,0x49,0xba,0x6d,0xf9,
		0xa8,0x40,0xa0,0x8c,0xe4,0x26,0x70,0x51,0x80,0x1d,0xfd,0x8f,0x99,0x09,0x49,0x30,
		0x12,0x2f,0xd4,0x02,0x85,0xa4,0x0a,0xfa,0x8d,0xbc,0xdb,0xc5,0xc6,0xee,0x54,0xf8,
		0xf5,0xa7,0x5c,0xe8,0x69,0x40,0x7c,0xc6,0xff,0xc8,0xac,0x56,0xf3,0x6e,0xfa,0xd1,
		0x6e,0x6b,0x1a,0xa6,0x0b,0x92,0x1d,0x8d,0xdf,0x0c,0x57,0xe3,0x33,0x0d,0x7f,0xc4,
		0xe7,0x2a,0x0b,0x51,0x1a,0x78,0x43,0xc9,0x97,0x7c,0x2b,0xeb,0x80,0xda,0xcd,0xe3,
		0x56,0xf7,0xc5,0xfe,0x70,0x8b,0xec,0xcb,0xa3,0xc3,0x11,0xcc,0xd4,0x65,0x56,0x86,
		0xc5,0xf9,0xc1,0x42,0xaf,0x99,0x46,0x94,0x3e,0x70,0x61,0xfc,0x3e,0xec,0x9f,0xb0,
		0xe2,0xca,0xc8,0xe5,0xdc,0x4c,0x8e,0x12,0x45,0x49,0x63,0xd7,0x64,0xde,0x3b,0xbd,
		0x2a,0x05,0xc0,0x18,0x43,0xed,0x01,0xad,0x9e,0xcb,0xb1,0x35,0x25,0x75,0x0f,0xd0,
		0x17,0x67,0xd6,0x08,0x60,0x8c,0xe3,0xde,0xf0,0xc1,0xd7,0x85,0xf0,0x17,0xa1,0x38,
		0x08,0x1d,0x5f,0xd2,0x46,0xa9,0x2f,0xd2,0xa0,
};

TEST(PinCount)
{
	BEID_ReaderContext &reader=ReaderSet.getReaderByNum(0);	

	BEID_EIDCard &card=reader.getEIDCard();				

	CHECK_EQUAL(1,card.pinCount());

	BEID_Pins &pins=card.getPins();

	CHECK_EQUAL(1,pins.count());
}

TEST(VerifyChangePin)
{
	BEID_ReaderContext &reader=ReaderSet.getReaderByNum(0);	

	BEID_EIDCard &card=reader.getEIDCard();				
	BEID_Pin &pin=card.getPins().getPinByNumber(0);

	unsigned long ulRemaining=0;
	CHECK_EQUAL(false,pin.verifyPin("4321",ulRemaining));
	CHECK_EQUAL(2,ulRemaining);
	CHECK_EQUAL(true,pin.verifyPin("1234",ulRemaining));

	CHECK_EQUAL(false,pin.changePin("4321","1234",ulRemaining));
	CHECK_EQUAL(2,ulRemaining);
	CHECK_EQUAL(true,pin.changePin("1234","4321",ulRemaining));

	CHECK_EQUAL(true,pin.verifyPin("4321",ulRemaining));
	CHECK_EQUAL(true,pin.changePin("4321","1234",ulRemaining));

}

TEST(CertifsCount)
{
	BEID_ReaderContext &reader=ReaderSet.getReaderByNum(0);	

	BEID_EIDCard &card=reader.getEIDCard();				

	CHECK_EQUAL(4,card.certificateCount());
}

TEST(CertifsHierarchy)
{
	BEID_ReaderContext &reader=ReaderSet.getReaderByNum(0);	

	BEID_EIDCard &card=reader.getEIDCard();				
	BEID_Certificate &root=card.getCertificates().getRoot();

	try
	{
		BEID_Certificate &issuer=root.getIssuer();
		CHECK(0);
	}
	catch(BEID_ExCertNoIssuer e)
	{
		CHECK(1);
	}
	catch(...)
	{
		CHECK(0);
	}

	CHECK_EQUAL(sizeof(_root),root.getCertData().Size());
	if(root.getCertData().Size()==sizeof(_root))
		CHECK(memcmp(_root,root.getCertData().GetBytes(),sizeof(_root))==0);

	BEID_Certificate &ca=root.getChildren(0);

	CHECK_EQUAL(sizeof(_ca),ca.getCertData().Size());
	if(ca.getCertData().Size()==sizeof(_ca))
		CHECK(memcmp(_ca,ca.getCertData().GetBytes(),sizeof(_ca))==0);

	try
	{
		BEID_Certificate &child2=root.getChildren(1);
		CHECK(0);
	}
	catch(BEID_ExParamRange e)
	{
		CHECK(1);
	}
	catch(...)
	{
		CHECK(0);
	}

	BEID_Certificate &child0=ca.getChildren(0);

	CHECK_EQUAL(sizeof(_child0),child0.getCertData().Size());
	if(child0.getCertData().Size()==sizeof(_child0))
		CHECK(memcmp(_child0,child0.getCertData().GetBytes(),sizeof(_child0))==0);

	BEID_Certificate &child1=ca.getChildren(1);

	CHECK_EQUAL(sizeof(_child1),child1.getCertData().Size());
	if(child1.getCertData().Size()==sizeof(_child1))
		CHECK(memcmp(_child1,child1.getCertData().GetBytes(),sizeof(_child1))==0);

	try
	{
		BEID_Certificate &child2=ca.getChildren(2);
		CHECK(0);
	}
	catch(BEID_ExParamRange e)
	{
		CHECK(1);
	}
	catch(...)
	{
		CHECK(0);
	}
}

TEST(CertifsInfo)
{
	BEID_ReaderContext &reader=ReaderSet.getReaderByNum(0);	

	BEID_EIDCard &card=reader.getEIDCard();				
	BEID_Certificate &root=card.getCertificates().getRoot();
	BEID_Certificate &ca=root.getChildren(0);
	BEID_Certificate &cert0=ca.getChildren(1);

	CHECK_EQUAL("gname0 name0 (Signature)",cert0.getOwnerName());
	CHECK_EQUAL("ZETES Citizen CA",cert0.getIssuerName());
	CHECK_EQUAL("15/10/2007",cert0.getValidityBegin());
	CHECK_EQUAL("15/10/2012",cert0.getValidityEnd());
	CHECK_EQUAL(1024,cert0.getKeyLength());

	CHECK_EQUAL(BEID_CERTIF_STATUS_VALID,cert0.getStatus(BEID_VALIDATION_LEVEL_NONE,BEID_VALIDATION_LEVEL_NONE));
}

TEST(AttributCertificateCRL)
{
	BEID_Crl crl("http://crl.specimen-eid.belgium.be/eidc0001.crl");

	try
	{
		crl.getIssuer();
		CHECK(0);
	}
	catch(BEID_ExBadUsage &e)
	{
		CHECK(&e);
	}
	catch(...)
	{
		CHECK(0);
	}

	CHECK_EQUAL("SPECIMEN Citizen CA",crl.getIssuerName());

	CHECK_EQUAL("http://crl.specimen-eid.belgium.be/eidc0001.crl",crl.getUri());
}

TEST(AttributCertificateOCSP)
{
	unsigned char namehash[]=	{0x48, 0xE8, 0x79, 0xCF, 0x31, 0x52, 0x03, 0xB5, 0xAC, 0x68, 0xA8, 0x9A, 0xAC, 0xAA, 0x9F, 0x09, 0xB2, 0xD4, 0xB3, 0x7C };
	unsigned char keyhash[]=	{0xD6, 0xA5, 0xFE, 0x65, 0x26, 0xBF, 0x28, 0x6C, 0x16, 0x15, 0xD7, 0xFA, 0x7E, 0x3D, 0xDA, 0x9F, 0xA9, 0xEE, 0x7D, 0x1D};
	unsigned char serialnumber[]={0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x15, 0xD1, 0xD2, 0x92, 0xA9};
	
	BEID_ByteArray baNameHash(namehash,sizeof(namehash));
	BEID_ByteArray baKeyHash(keyhash,sizeof(keyhash));
	BEID_ByteArray baSerialNumber(serialnumber,sizeof(serialnumber));

	BEID_OcspResponse ocsp("http://ocsp.specimen-eid.belgium.be",BEID_ALGO_SHA1,baNameHash,baKeyHash,baSerialNumber);

	BEID_ByteArray baResponse;

	CHECK_EQUAL(BEID_CERTIF_STATUS_VALID_OCSP,ocsp.getResponse(baResponse));

	CHECK_EQUAL("http://ocsp.specimen-eid.belgium.be",ocsp.getUri());
}

//void FillCertTree(BEID_Certificate &cert, unsigned long level)
//{
//	std::cout << level << cert.getLabel() << "\n";
//
//	unsigned long ulIndex=0;
//
//	for(unsigned long ulIndex=0;ulIndex<cert.countChildren();ulIndex++)
//	{
//		BEID_Certificate &child=cert.getChildren(ulIndex);
//		FillCertTree(child,level+1);
//	}
//}
//
//TEST(FillCertTree)
//{
//	BEID_ReaderContext &reader=ReaderSet.getReaderByNum(0);	
//
//	BEID_EIDCard &card=reader.getEIDCard();				
//	BEID_Certificate &root=card.getCertificates().getRoot();
//
//	unsigned long level=0;
//	FillCertTree(root,level);
//
//	CHECK(1);
//}
