#include "socketmanager.h"


using namespace std;

namespace rpc {

SocketManager* SocketManager::inst = 0;

SocketManager::SocketManager()
{
}

SocketManager::~SocketManager()
{
}

void SocketManager::addSocket( Socket *s )
{
	sockets.insert(s);
}

void SocketManager::removeSocket( Socket *s )
{
	sockets.erase(s);
}

void SocketManager::select( )
{
	set<Socket*> sl;
	fd_set fds;
	FD_ZERO(&fds);
	int maxfd = -1;
	set<Socket*>::iterator it = sockets.begin();
	while(it!=sockets.end()) {
		int fd = (*it)->getFd();
		FD_SET(fd,&fds);
		if(maxfd < fd) maxfd = fd;
		sl.insert(*it);		
		it++;
	}
	int nEvents = ::select( maxfd+1, &fds,NULL,NULL,NULL );
	if(nEvents>0) {
		
		for(it = sl.begin();it!=sl.end();it++) {
			int fd  = (*it)->getFd();
			if(FD_ISSET(fd,&fds)) (*it)->onRead();
		}

	} else if(nEvents==-1) {
		perror("select():");
	}
}

Socket* SocketManager::findSocket( int socketId )
{
	Socket* ret = NULL;
	
	std::set<Socket*>::const_iterator socketIt = sockets.begin();
	while( socketIt != sockets.end() ) {
		
		if( (*socketIt)->getId() == socketId ) {
			ret = *socketIt;
			break;
		}
		++socketIt;
	}
	return ret;
}

}	// namespace

