/* Copyright (C) 2000 MySQL AB

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; version 2
   of the License.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 51 Franklin Place - Suite 330, Boston,
   MA 02110-1301, USA */

/* UTF8 according RFC 2279 */
/* Written by Alexander Barkov <bar@udm.net> */

#include <config.h>

#include <drizzled/internal/m_string.h>
#include <drizzled/charset_info.h>
#include <errno.h>

#include <algorithm>

#ifndef EILSEQ
#define EILSEQ ENOENT
#endif


#define MY_UTF8MB3_GENERAL_CI MY_UTF8MB3 "_general_ci"
#define MY_UTF8MB3_BIN        MY_UTF8MB3 "_bin"
#define MY_UTF8MB4_GENERAL_CI MY_UTF8MB4 "_general_ci"
#define MY_UTF8MB4_BIN        MY_UTF8MB4 "_bin"


using namespace std;

namespace drizzled
{

void my_hash_sort_utf8mb4(const CHARSET_INFO * const cs,
                          const unsigned char *s, size_t slen,
                          uint32_t *n1, uint32_t *n2);

static MY_UNICASE_INFO plane00[]={
  {0x0000,0x0000,0x0000},  {0x0001,0x0001,0x0001},
  {0x0002,0x0002,0x0002},  {0x0003,0x0003,0x0003},
  {0x0004,0x0004,0x0004},  {0x0005,0x0005,0x0005},
  {0x0006,0x0006,0x0006},  {0x0007,0x0007,0x0007},
  {0x0008,0x0008,0x0008},  {0x0009,0x0009,0x0009},
  {0x000A,0x000A,0x000A},  {0x000B,0x000B,0x000B},
  {0x000C,0x000C,0x000C},  {0x000D,0x000D,0x000D},
  {0x000E,0x000E,0x000E},  {0x000F,0x000F,0x000F},
  {0x0010,0x0010,0x0010},  {0x0011,0x0011,0x0011},
  {0x0012,0x0012,0x0012},  {0x0013,0x0013,0x0013},
  {0x0014,0x0014,0x0014},  {0x0015,0x0015,0x0015},
  {0x0016,0x0016,0x0016},  {0x0017,0x0017,0x0017},
  {0x0018,0x0018,0x0018},  {0x0019,0x0019,0x0019},
  {0x001A,0x001A,0x001A},  {0x001B,0x001B,0x001B},
  {0x001C,0x001C,0x001C},  {0x001D,0x001D,0x001D},
  {0x001E,0x001E,0x001E},  {0x001F,0x001F,0x001F},
  {0x0020,0x0020,0x0020},  {0x0021,0x0021,0x0021},
  {0x0022,0x0022,0x0022},  {0x0023,0x0023,0x0023},
  {0x0024,0x0024,0x0024},  {0x0025,0x0025,0x0025},
  {0x0026,0x0026,0x0026},  {0x0027,0x0027,0x0027},
  {0x0028,0x0028,0x0028},  {0x0029,0x0029,0x0029},
  {0x002A,0x002A,0x002A},  {0x002B,0x002B,0x002B},
  {0x002C,0x002C,0x002C},  {0x002D,0x002D,0x002D},
  {0x002E,0x002E,0x002E},  {0x002F,0x002F,0x002F},
  {0x0030,0x0030,0x0030},  {0x0031,0x0031,0x0031},
  {0x0032,0x0032,0x0032},  {0x0033,0x0033,0x0033},
  {0x0034,0x0034,0x0034},  {0x0035,0x0035,0x0035},
  {0x0036,0x0036,0x0036},  {0x0037,0x0037,0x0037},
  {0x0038,0x0038,0x0038},  {0x0039,0x0039,0x0039},
  {0x003A,0x003A,0x003A},  {0x003B,0x003B,0x003B},
  {0x003C,0x003C,0x003C},  {0x003D,0x003D,0x003D},
  {0x003E,0x003E,0x003E},  {0x003F,0x003F,0x003F},
  {0x0040,0x0040,0x0040},  {0x0041,0x0061,0x0041},
  {0x0042,0x0062,0x0042},  {0x0043,0x0063,0x0043},
  {0x0044,0x0064,0x0044},  {0x0045,0x0065,0x0045},
  {0x0046,0x0066,0x0046},  {0x0047,0x0067,0x0047},
  {0x0048,0x0068,0x0048},  {0x0049,0x0069,0x0049},
  {0x004A,0x006A,0x004A},  {0x004B,0x006B,0x004B},
  {0x004C,0x006C,0x004C},  {0x004D,0x006D,0x004D},
  {0x004E,0x006E,0x004E},  {0x004F,0x006F,0x004F},
  {0x0050,0x0070,0x0050},  {0x0051,0x0071,0x0051},
  {0x0052,0x0072,0x0052},  {0x0053,0x0073,0x0053},
  {0x0054,0x0074,0x0054},  {0x0055,0x0075,0x0055},
  {0x0056,0x0076,0x0056},  {0x0057,0x0077,0x0057},
  {0x0058,0x0078,0x0058},  {0x0059,0x0079,0x0059},
  {0x005A,0x007A,0x005A},  {0x005B,0x005B,0x005B},
  {0x005C,0x005C,0x005C},  {0x005D,0x005D,0x005D},
  {0x005E,0x005E,0x005E},  {0x005F,0x005F,0x005F},
  {0x0060,0x0060,0x0060},  {0x0041,0x0061,0x0041},
  {0x0042,0x0062,0x0042},  {0x0043,0x0063,0x0043},
  {0x0044,0x0064,0x0044},  {0x0045,0x0065,0x0045},
  {0x0046,0x0066,0x0046},  {0x0047,0x0067,0x0047},
  {0x0048,0x0068,0x0048},  {0x0049,0x0069,0x0049},
  {0x004A,0x006A,0x004A},  {0x004B,0x006B,0x004B},
  {0x004C,0x006C,0x004C},  {0x004D,0x006D,0x004D},
  {0x004E,0x006E,0x004E},  {0x004F,0x006F,0x004F},
  {0x0050,0x0070,0x0050},  {0x0051,0x0071,0x0051},
  {0x0052,0x0072,0x0052},  {0x0053,0x0073,0x0053},
  {0x0054,0x0074,0x0054},  {0x0055,0x0075,0x0055},
  {0x0056,0x0076,0x0056},  {0x0057,0x0077,0x0057},
  {0x0058,0x0078,0x0058},  {0x0059,0x0079,0x0059},
  {0x005A,0x007A,0x005A},  {0x007B,0x007B,0x007B},
  {0x007C,0x007C,0x007C},  {0x007D,0x007D,0x007D},
  {0x007E,0x007E,0x007E},  {0x007F,0x007F,0x007F},
  {0x0080,0x0080,0x0080},  {0x0081,0x0081,0x0081},
  {0x0082,0x0082,0x0082},  {0x0083,0x0083,0x0083},
  {0x0084,0x0084,0x0084},  {0x0085,0x0085,0x0085},
  {0x0086,0x0086,0x0086},  {0x0087,0x0087,0x0087},
  {0x0088,0x0088,0x0088},  {0x0089,0x0089,0x0089},
  {0x008A,0x008A,0x008A},  {0x008B,0x008B,0x008B},
  {0x008C,0x008C,0x008C},  {0x008D,0x008D,0x008D},
  {0x008E,0x008E,0x008E},  {0x008F,0x008F,0x008F},
  {0x0090,0x0090,0x0090},  {0x0091,0x0091,0x0091},
  {0x0092,0x0092,0x0092},  {0x0093,0x0093,0x0093},
  {0x0094,0x0094,0x0094},  {0x0095,0x0095,0x0095},
  {0x0096,0x0096,0x0096},  {0x0097,0x0097,0x0097},
  {0x0098,0x0098,0x0098},  {0x0099,0x0099,0x0099},
  {0x009A,0x009A,0x009A},  {0x009B,0x009B,0x009B},
  {0x009C,0x009C,0x009C},  {0x009D,0x009D,0x009D},
  {0x009E,0x009E,0x009E},  {0x009F,0x009F,0x009F},
  {0x00A0,0x00A0,0x00A0},  {0x00A1,0x00A1,0x00A1},
  {0x00A2,0x00A2,0x00A2},  {0x00A3,0x00A3,0x00A3},
  {0x00A4,0x00A4,0x00A4},  {0x00A5,0x00A5,0x00A5},
  {0x00A6,0x00A6,0x00A6},  {0x00A7,0x00A7,0x00A7},
  {0x00A8,0x00A8,0x00A8},  {0x00A9,0x00A9,0x00A9},
  {0x00AA,0x00AA,0x00AA},  {0x00AB,0x00AB,0x00AB},
  {0x00AC,0x00AC,0x00AC},  {0x00AD,0x00AD,0x00AD},
  {0x00AE,0x00AE,0x00AE},  {0x00AF,0x00AF,0x00AF},
  {0x00B0,0x00B0,0x00B0},  {0x00B1,0x00B1,0x00B1},
  {0x00B2,0x00B2,0x00B2},  {0x00B3,0x00B3,0x00B3},
  {0x00B4,0x00B4,0x00B4},  {0x039C,0x00B5,0x039C},
  {0x00B6,0x00B6,0x00B6},  {0x00B7,0x00B7,0x00B7},
  {0x00B8,0x00B8,0x00B8},  {0x00B9,0x00B9,0x00B9},
  {0x00BA,0x00BA,0x00BA},  {0x00BB,0x00BB,0x00BB},
  {0x00BC,0x00BC,0x00BC},  {0x00BD,0x00BD,0x00BD},
  {0x00BE,0x00BE,0x00BE},  {0x00BF,0x00BF,0x00BF},
  {0x00C0,0x00E0,0x0041},  {0x00C1,0x00E1,0x0041},
  {0x00C2,0x00E2,0x0041},  {0x00C3,0x00E3,0x0041},
  {0x00C4,0x00E4,0x0041},  {0x00C5,0x00E5,0x0041},
  {0x00C6,0x00E6,0x00C6},  {0x00C7,0x00E7,0x0043},
  {0x00C8,0x00E8,0x0045},  {0x00C9,0x00E9,0x0045},
  {0x00CA,0x00EA,0x0045},  {0x00CB,0x00EB,0x0045},
  {0x00CC,0x00EC,0x0049},  {0x00CD,0x00ED,0x0049},
  {0x00CE,0x00EE,0x0049},  {0x00CF,0x00EF,0x0049},
  {0x00D0,0x00F0,0x00D0},  {0x00D1,0x00F1,0x004E},
  {0x00D2,0x00F2,0x004F},  {0x00D3,0x00F3,0x004F},
  {0x00D4,0x00F4,0x004F},  {0x00D5,0x00F5,0x004F},
  {0x00D6,0x00F6,0x004F},  {0x00D7,0x00D7,0x00D7},
  {0x00D8,0x00F8,0x00D8},  {0x00D9,0x00F9,0x0055},
  {0x00DA,0x00FA,0x0055},  {0x00DB,0x00FB,0x0055},
  {0x00DC,0x00FC,0x0055},  {0x00DD,0x00FD,0x0059},
  {0x00DE,0x00FE,0x00DE},  {0x00DF,0x00DF,0x0053},
  {0x00C0,0x00E0,0x0041},  {0x00C1,0x00E1,0x0041},
  {0x00C2,0x00E2,0x0041},  {0x00C3,0x00E3,0x0041},
  {0x00C4,0x00E4,0x0041},  {0x00C5,0x00E5,0x0041},
  {0x00C6,0x00E6,0x00C6},  {0x00C7,0x00E7,0x0043},
  {0x00C8,0x00E8,0x0045},  {0x00C9,0x00E9,0x0045},
  {0x00CA,0x00EA,0x0045},  {0x00CB,0x00EB,0x0045},
  {0x00CC,0x00EC,0x0049},  {0x00CD,0x00ED,0x0049},
  {0x00CE,0x00EE,0x0049},  {0x00CF,0x00EF,0x0049},
  {0x00D0,0x00F0,0x00D0},  {0x00D1,0x00F1,0x004E},
  {0x00D2,0x00F2,0x004F},  {0x00D3,0x00F3,0x004F},
  {0x00D4,0x00F4,0x004F},  {0x00D5,0x00F5,0x004F},
  {0x00D6,0x00F6,0x004F},  {0x00F7,0x00F7,0x00F7},
  {0x00D8,0x00F8,0x00D8},  {0x00D9,0x00F9,0x0055},
  {0x00DA,0x00FA,0x0055},  {0x00DB,0x00FB,0x0055},
  {0x00DC,0x00FC,0x0055},  {0x00DD,0x00FD,0x0059},
  {0x00DE,0x00FE,0x00DE},  {0x0178,0x00FF,0x0059}
};



static MY_UNICASE_INFO plane01[]={
  {0x0100,0x0101,0x0041},  {0x0100,0x0101,0x0041},
  {0x0102,0x0103,0x0041},  {0x0102,0x0103,0x0041},
  {0x0104,0x0105,0x0041},  {0x0104,0x0105,0x0041},
  {0x0106,0x0107,0x0043},  {0x0106,0x0107,0x0043},
  {0x0108,0x0109,0x0043},  {0x0108,0x0109,0x0043},
  {0x010A,0x010B,0x0043},  {0x010A,0x010B,0x0043},
  {0x010C,0x010D,0x0043},  {0x010C,0x010D,0x0043},
  {0x010E,0x010F,0x0044},  {0x010E,0x010F,0x0044},
  {0x0110,0x0111,0x0110},  {0x0110,0x0111,0x0110},
  {0x0112,0x0113,0x0045},  {0x0112,0x0113,0x0045},
  {0x0114,0x0115,0x0045},  {0x0114,0x0115,0x0045},
  {0x0116,0x0117,0x0045},  {0x0116,0x0117,0x0045},
  {0x0118,0x0119,0x0045},  {0x0118,0x0119,0x0045},
  {0x011A,0x011B,0x0045},  {0x011A,0x011B,0x0045},
  {0x011C,0x011D,0x0047},  {0x011C,0x011D,0x0047},
  {0x011E,0x011F,0x0047},  {0x011E,0x011F,0x0047},
  {0x0120,0x0121,0x0047},  {0x0120,0x0121,0x0047},
  {0x0122,0x0123,0x0047},  {0x0122,0x0123,0x0047},
  {0x0124,0x0125,0x0048},  {0x0124,0x0125,0x0048},
  {0x0126,0x0127,0x0126},  {0x0126,0x0127,0x0126},
  {0x0128,0x0129,0x0049},  {0x0128,0x0129,0x0049},
  {0x012A,0x012B,0x0049},  {0x012A,0x012B,0x0049},
  {0x012C,0x012D,0x0049},  {0x012C,0x012D,0x0049},
  {0x012E,0x012F,0x0049},  {0x012E,0x012F,0x0049},
  {0x0130,0x0069,0x0049},  {0x0049,0x0131,0x0049},
  {0x0132,0x0133,0x0132},  {0x0132,0x0133,0x0132},
  {0x0134,0x0135,0x004A},  {0x0134,0x0135,0x004A},
  {0x0136,0x0137,0x004B},  {0x0136,0x0137,0x004B},
  {0x0138,0x0138,0x0138},  {0x0139,0x013A,0x004C},
  {0x0139,0x013A,0x004C},  {0x013B,0x013C,0x004C},
  {0x013B,0x013C,0x004C},  {0x013D,0x013E,0x004C},
  {0x013D,0x013E,0x004C},  {0x013F,0x0140,0x013F},
  {0x013F,0x0140,0x013F},  {0x0141,0x0142,0x0141},
  {0x0141,0x0142,0x0141},  {0x0143,0x0144,0x004E},
  {0x0143,0x0144,0x004E},  {0x0145,0x0146,0x004E},
  {0x0145,0x0146,0x004E},  {0x0147,0x0148,0x004E},
  {0x0147,0x0148,0x004E},  {0x0149,0x0149,0x0149},
  {0x014A,0x014B,0x014A},  {0x014A,0x014B,0x014A},
  {0x014C,0x014D,0x004F},  {0x014C,0x014D,0x004F},
  {0x014E,0x014F,0x004F},  {0x014E,0x014F,0x004F},
  {0x0150,0x0151,0x004F},  {0x0150,0x0151,0x004F},
  {0x0152,0x0153,0x0152},  {0x0152,0x0153,0x0152},
  {0x0154,0x0155,0x0052},  {0x0154,0x0155,0x0052},
  {0x0156,0x0157,0x0052},  {0x0156,0x0157,0x0052},
  {0x0158,0x0159,0x0052},  {0x0158,0x0159,0x0052},
  {0x015A,0x015B,0x0053},  {0x015A,0x015B,0x0053},
  {0x015C,0x015D,0x0053},  {0x015C,0x015D,0x0053},
  {0x015E,0x015F,0x0053},  {0x015E,0x015F,0x0053},
  {0x0160,0x0161,0x0053},  {0x0160,0x0161,0x0053},
  {0x0162,0x0163,0x0054},  {0x0162,0x0163,0x0054},
  {0x0164,0x0165,0x0054},  {0x0164,0x0165,0x0054},
  {0x0166,0x0167,0x0166},  {0x0166,0x0167,0x0166},
  {0x0168,0x0169,0x0055},  {0x0168,0x0169,0x0055},
  {0x016A,0x016B,0x0055},  {0x016A,0x016B,0x0055},
  {0x016C,0x016D,0x0055},  {0x016C,0x016D,0x0055},
  {0x016E,0x016F,0x0055},  {0x016E,0x016F,0x0055},
  {0x0170,0x0171,0x0055},  {0x0170,0x0171,0x0055},
  {0x0172,0x0173,0x0055},  {0x0172,0x0173,0x0055},
  {0x0174,0x0175,0x0057},  {0x0174,0x0175,0x0057},
  {0x0176,0x0177,0x0059},  {0x0176,0x0177,0x0059},
  {0x0178,0x00FF,0x0059},  {0x0179,0x017A,0x005A},
  {0x0179,0x017A,0x005A},  {0x017B,0x017C,0x005A},
  {0x017B,0x017C,0x005A},  {0x017D,0x017E,0x005A},
  {0x017D,0x017E,0x005A},  {0x0053,0x017F,0x0053},
  {0x0180,0x0180,0x0180},  {0x0181,0x0253,0x0181},
  {0x0182,0x0183,0x0182},  {0x0182,0x0183,0x0182},
  {0x0184,0x0185,0x0184},  {0x0184,0x0185,0x0184},
  {0x0186,0x0254,0x0186},  {0x0187,0x0188,0x0187},
  {0x0187,0x0188,0x0187},  {0x0189,0x0256,0x0189},
  {0x018A,0x0257,0x018A},  {0x018B,0x018C,0x018B},
  {0x018B,0x018C,0x018B},  {0x018D,0x018D,0x018D},
  {0x018E,0x01DD,0x018E},  {0x018F,0x0259,0x018F},
  {0x0190,0x025B,0x0190},  {0x0191,0x0192,0x0191},
  {0x0191,0x0192,0x0191},  {0x0193,0x0260,0x0193},
  {0x0194,0x0263,0x0194},  {0x01F6,0x0195,0x01F6},
  {0x0196,0x0269,0x0196},  {0x0197,0x0268,0x0197},
  {0x0198,0x0199,0x0198},  {0x0198,0x0199,0x0198},
  {0x019A,0x019A,0x019A},  {0x019B,0x019B,0x019B},
  {0x019C,0x026F,0x019C},  {0x019D,0x0272,0x019D},
  {0x019E,0x019E,0x019E},  {0x019F,0x0275,0x019F},
  {0x01A0,0x01A1,0x004F},  {0x01A0,0x01A1,0x004F},
  {0x01A2,0x01A3,0x01A2},  {0x01A2,0x01A3,0x01A2},
  {0x01A4,0x01A5,0x01A4},  {0x01A4,0x01A5,0x01A4},
  {0x01A6,0x0280,0x01A6},  {0x01A7,0x01A8,0x01A7},
  {0x01A7,0x01A8,0x01A7},  {0x01A9,0x0283,0x01A9},
  {0x01AA,0x01AA,0x01AA},  {0x01AB,0x01AB,0x01AB},
  {0x01AC,0x01AD,0x01AC},  {0x01AC,0x01AD,0x01AC},
  {0x01AE,0x0288,0x01AE},  {0x01AF,0x01B0,0x0055},
  {0x01AF,0x01B0,0x0055},  {0x01B1,0x028A,0x01B1},
  {0x01B2,0x028B,0x01B2},  {0x01B3,0x01B4,0x01B3},
  {0x01B3,0x01B4,0x01B3},  {0x01B5,0x01B6,0x01B5},
  {0x01B5,0x01B6,0x01B5},  {0x01B7,0x0292,0x01B7},
  {0x01B8,0x01B9,0x01B8},  {0x01B8,0x01B9,0x01B8},
  {0x01BA,0x01BA,0x01BA},  {0x01BB,0x01BB,0x01BB},
  {0x01BC,0x01BD,0x01BC},  {0x01BC,0x01BD,0x01BC},
  {0x01BE,0x01BE,0x01BE},  {0x01F7,0x01BF,0x01F7},
  {0x01C0,0x01C0,0x01C0},  {0x01C1,0x01C1,0x01C1},
  {0x01C2,0x01C2,0x01C2},  {0x01C3,0x01C3,0x01C3},
  {0x01C4,0x01C6,0x01C4},  {0x01C4,0x01C6,0x01C4},
  {0x01C4,0x01C6,0x01C4},  {0x01C7,0x01C9,0x01C7},
  {0x01C7,0x01C9,0x01C7},  {0x01C7,0x01C9,0x01C7},
  {0x01CA,0x01CC,0x01CA},  {0x01CA,0x01CC,0x01CA},
  {0x01CA,0x01CC,0x01CA},  {0x01CD,0x01CE,0x0041},
  {0x01CD,0x01CE,0x0041},  {0x01CF,0x01D0,0x0049},
  {0x01CF,0x01D0,0x0049},  {0x01D1,0x01D2,0x004F},
  {0x01D1,0x01D2,0x004F},  {0x01D3,0x01D4,0x0055},
  {0x01D3,0x01D4,0x0055},  {0x01D5,0x01D6,0x0055},
  {0x01D5,0x01D6,0x0055},  {0x01D7,0x01D8,0x0055},
  {0x01D7,0x01D8,0x0055},  {0x01D9,0x01DA,0x0055},
  {0x01D9,0x01DA,0x0055},  {0x01DB,0x01DC,0x0055},
  {0x01DB,0x01DC,0x0055},  {0x018E,0x01DD,0x018E},
  {0x01DE,0x01DF,0x0041},  {0x01DE,0x01DF,0x0041},
  {0x01E0,0x01E1,0x0041},  {0x01E0,0x01E1,0x0041},
  {0x01E2,0x01E3,0x00C6},  {0x01E2,0x01E3,0x00C6},
  {0x01E4,0x01E5,0x01E4},  {0x01E4,0x01E5,0x01E4},
  {0x01E6,0x01E7,0x0047},  {0x01E6,0x01E7,0x0047},
  {0x01E8,0x01E9,0x004B},  {0x01E8,0x01E9,0x004B},
  {0x01EA,0x01EB,0x004F},  {0x01EA,0x01EB,0x004F},
  {0x01EC,0x01ED,0x004F},  {0x01EC,0x01ED,0x004F},
  {0x01EE,0x01EF,0x01B7},  {0x01EE,0x01EF,0x01B7},
  {0x01F0,0x01F0,0x004A},  {0x01F1,0x01F3,0x01F1},
  {0x01F1,0x01F3,0x01F1},  {0x01F1,0x01F3,0x01F1},
  {0x01F4,0x01F5,0x0047},  {0x01F4,0x01F5,0x0047},
  {0x01F6,0x0195,0x01F6},  {0x01F7,0x01BF,0x01F7},
  {0x01F8,0x01F9,0x004E},  {0x01F8,0x01F9,0x004E},
  {0x01FA,0x01FB,0x0041},  {0x01FA,0x01FB,0x0041},
  {0x01FC,0x01FD,0x00C6},  {0x01FC,0x01FD,0x00C6},
  {0x01FE,0x01FF,0x00D8},  {0x01FE,0x01FF,0x00D8}
};

static MY_UNICASE_INFO plane02[]={
  {0x0200,0x0201,0x0041},  {0x0200,0x0201,0x0041},
  {0x0202,0x0203,0x0041},  {0x0202,0x0203,0x0041},
  {0x0204,0x0205,0x0045},  {0x0204,0x0205,0x0045},
  {0x0206,0x0207,0x0045},  {0x0206,0x0207,0x0045},
  {0x0208,0x0209,0x0049},  {0x0208,0x0209,0x0049},
  {0x020A,0x020B,0x0049},  {0x020A,0x020B,0x0049},
  {0x020C,0x020D,0x004F},  {0x020C,0x020D,0x004F},
  {0x020E,0x020F,0x004F},  {0x020E,0x020F,0x004F},
  {0x0210,0x0211,0x0052},  {0x0210,0x0211,0x0052},
  {0x0212,0x0213,0x0052},  {0x0212,0x0213,0x0052},
  {0x0214,0x0215,0x0055},  {0x0214,0x0215,0x0055},
  {0x0216,0x0217,0x0055},  {0x0216,0x0217,0x0055},
  {0x0218,0x0219,0x0053},  {0x0218,0x0219,0x0053},
  {0x021A,0x021B,0x0054},  {0x021A,0x021B,0x0054},
  {0x021C,0x021D,0x021C},  {0x021C,0x021D,0x021C},
  {0x021E,0x021F,0x0048},  {0x021E,0x021F,0x0048},
  {0x0220,0x0220,0x0220},  {0x0221,0x0221,0x0221},
  {0x0222,0x0223,0x0222},  {0x0222,0x0223,0x0222},
  {0x0224,0x0225,0x0224},  {0x0224,0x0225,0x0224},
  {0x0226,0x0227,0x0041},  {0x0226,0x0227,0x0041},
  {0x0228,0x0229,0x0045},  {0x0228,0x0229,0x0045},
  {0x022A,0x022B,0x004F},  {0x022A,0x022B,0x004F},
  {0x022C,0x022D,0x004F},  {0x022C,0x022D,0x004F},
  {0x022E,0x022F,0x004F},  {0x022E,0x022F,0x004F},
  {0x0230,0x0231,0x004F},  {0x0230,0x0231,0x004F},
  {0x0232,0x0233,0x0059},  {0x0232,0x0233,0x0059},
  {0x0234,0x0234,0x0234},  {0x0235,0x0235,0x0235},
  {0x0236,0x0236,0x0236},  {0x0237,0x0237,0x0237},
  {0x0238,0x0238,0x0238},  {0x0239,0x0239,0x0239},
  {0x023A,0x023A,0x023A},  {0x023B,0x023B,0x023B},
  {0x023C,0x023C,0x023C},  {0x023D,0x023D,0x023D},
  {0x023E,0x023E,0x023E},  {0x023F,0x023F,0x023F},
  {0x0240,0x0240,0x0240},  {0x0241,0x0241,0x0241},
  {0x0242,0x0242,0x0242},  {0x0243,0x0243,0x0243},
  {0x0244,0x0244,0x0244},  {0x0245,0x0245,0x0245},
  {0x0246,0x0246,0x0246},  {0x0247,0x0247,0x0247},
  {0x0248,0x0248,0x0248},  {0x0249,0x0249,0x0249},
  {0x024A,0x024A,0x024A},  {0x024B,0x024B,0x024B},
  {0x024C,0x024C,0x024C},  {0x024D,0x024D,0x024D},
  {0x024E,0x024E,0x024E},  {0x024F,0x024F,0x024F},
  {0x0250,0x0250,0x0250},  {0x0251,0x0251,0x0251},
  {0x0252,0x0252,0x0252},  {0x0181,0x0253,0x0181},
  {0x0186,0x0254,0x0186},  {0x0255,0x0255,0x0255},
  {0x0189,0x0256,0x0189},  {0x018A,0x0257,0x018A},
  {0x0258,0x0258,0x0258},  {0x018F,0x0259,0x018F},
  {0x025A,0x025A,0x025A},  {0x0190,0x025B,0x0190},
  {0x025C,0x025C,0x025C},  {0x025D,0x025D,0x025D},
  {0x025E,0x025E,0x025E},  {0x025F,0x025F,0x025F},
  {0x0193,0x0260,0x0193},  {0x0261,0x0261,0x0261},
  {0x0262,0x0262,0x0262},  {0x0194,0x0263,0x0194},
  {0x0264,0x0264,0x0264},  {0x0265,0x0265,0x0265},
  {0x0266,0x0266,0x0266},  {0x0267,0x0267,0x0267},
  {0x0197,0x0268,0x0197},  {0x0196,0x0269,0x0196},
  {0x026A,0x026A,0x026A},  {0x026B,0x026B,0x026B},
  {0x026C,0x026C,0x026C},  {0x026D,0x026D,0x026D},
  {0x026E,0x026E,0x026E},  {0x019C,0x026F,0x019C},
  {0x0270,0x0270,0x0270},  {0x0271,0x0271,0x0271},
  {0x019D,0x0272,0x019D},  {0x0273,0x0273,0x0273},
  {0x0274,0x0274,0x0274},  {0x019F,0x0275,0x019F},
  {0x0276,0x0276,0x0276},  {0x0277,0x0277,0x0277},
  {0x0278,0x0278,0x0278},  {0x0279,0x0279,0x0279},
  {0x027A,0x027A,0x027A},  {0x027B,0x027B,0x027B},
  {0x027C,0x027C,0x027C},  {0x027D,0x027D,0x027D},
  {0x027E,0x027E,0x027E},  {0x027F,0x027F,0x027F},
  {0x01A6,0x0280,0x01A6},  {0x0281,0x0281,0x0281},
  {0x0282,0x0282,0x0282},  {0x01A9,0x0283,0x01A9},
  {0x0284,0x0284,0x0284},  {0x0285,0x0285,0x0285},
  {0x0286,0x0286,0x0286},  {0x0287,0x0287,0x0287},
  {0x01AE,0x0288,0x01AE},  {0x0289,0x0289,0x0289},
  {0x01B1,0x028A,0x01B1},  {0x01B2,0x028B,0x01B2},
  {0x028C,0x028C,0x028C},  {0x028D,0x028D,0x028D},
  {0x028E,0x028E,0x028E},  {0x028F,0x028F,0x028F},
  {0x0290,0x0290,0x0290},  {0x0291,0x0291,0x0291},
  {0x01B7,0x0292,0x01B7},  {0x0293,0x0293,0x0293},
  {0x0294,0x0294,0x0294},  {0x0295,0x0295,0x0295},
  {0x0296,0x0296,0x0296},  {0x0297,0x0297,0x0297},
  {0x0298,0x0298,0x0298},  {0x0299,0x0299,0x0299},
  {0x029A,0x029A,0x029A},  {0x029B,0x029B,0x029B},
  {0x029C,0x029C,0x029C},  {0x029D,0x029D,0x029D},
  {0x029E,0x029E,0x029E},  {0x029F,0x029F,0x029F},
  {0x02A0,0x02A0,0x02A0},  {0x02A1,0x02A1,0x02A1},
  {0x02A2,0x02A2,0x02A2},  {0x02A3,0x02A3,0x02A3},
  {0x02A4,0x02A4,0x02A4},  {0x02A5,0x02A5,0x02A5},
  {0x02A6,0x02A6,0x02A6},  {0x02A7,0x02A7,0x02A7},
  {0x02A8,0x02A8,0x02A8},  {0x02A9,0x02A9,0x02A9},
  {0x02AA,0x02AA,0x02AA},  {0x02AB,0x02AB,0x02AB},
  {0x02AC,0x02AC,0x02AC},  {0x02AD,0x02AD,0x02AD},
  {0x02AE,0x02AE,0x02AE},  {0x02AF,0x02AF,0x02AF},
  {0x02B0,0x02B0,0x02B0},  {0x02B1,0x02B1,0x02B1},
  {0x02B2,0x02B2,0x02B2},  {0x02B3,0x02B3,0x02B3},
  {0x02B4,0x02B4,0x02B4},  {0x02B5,0x02B5,0x02B5},
  {0x02B6,0x02B6,0x02B6},  {0x02B7,0x02B7,0x02B7},
  {0x02B8,0x02B8,0x02B8},  {0x02B9,0x02B9,0x02B9},
  {0x02BA,0x02BA,0x02BA},  {0x02BB,0x02BB,0x02BB},
  {0x02BC,0x02BC,0x02BC},  {0x02BD,0x02BD,0x02BD},
  {0x02BE,0x02BE,0x02BE},  {0x02BF,0x02BF,0x02BF},
  {0x02C0,0x02C0,0x02C0},  {0x02C1,0x02C1,0x02C1},
  {0x02C2,0x02C2,0x02C2},  {0x02C3,0x02C3,0x02C3},
  {0x02C4,0x02C4,0x02C4},  {0x02C5,0x02C5,0x02C5},
  {0x02C6,0x02C6,0x02C6},  {0x02C7,0x02C7,0x02C7},
  {0x02C8,0x02C8,0x02C8},  {0x02C9,0x02C9,0x02C9},
  {0x02CA,0x02CA,0x02CA},  {0x02CB,0x02CB,0x02CB},
  {0x02CC,0x02CC,0x02CC},  {0x02CD,0x02CD,0x02CD},
  {0x02CE,0x02CE,0x02CE},  {0x02CF,0x02CF,0x02CF},
  {0x02D0,0x02D0,0x02D0},  {0x02D1,0x02D1,0x02D1},
  {0x02D2,0x02D2,0x02D2},  {0x02D3,0x02D3,0x02D3},
  {0x02D4,0x02D4,0x02D4},  {0x02D5,0x02D5,0x02D5},
  {0x02D6,0x02D6,0x02D6},  {0x02D7,0x02D7,0x02D7},
  {0x02D8,0x02D8,0x02D8},  {0x02D9,0x02D9,0x02D9},
  {0x02DA,0x02DA,0x02DA},  {0x02DB,0x02DB,0x02DB},
  {0x02DC,0x02DC,0x02DC},  {0x02DD,0x02DD,0x02DD},
  {0x02DE,0x02DE,0x02DE},  {0x02DF,0x02DF,0x02DF},
  {0x02E0,0x02E0,0x02E0},  {0x02E1,0x02E1,0x02E1},
  {0x02E2,0x02E2,0x02E2},  {0x02E3,0x02E3,0x02E3},
  {0x02E4,0x02E4,0x02E4},  {0x02E5,0x02E5,0x02E5},
  {0x02E6,0x02E6,0x02E6},  {0x02E7,0x02E7,0x02E7},
  {0x02E8,0x02E8,0x02E8},  {0x02E9,0x02E9,0x02E9},
  {0x02EA,0x02EA,0x02EA},  {0x02EB,0x02EB,0x02EB},
  {0x02EC,0x02EC,0x02EC},  {0x02ED,0x02ED,0x02ED},
  {0x02EE,0x02EE,0x02EE},  {0x02EF,0x02EF,0x02EF},
  {0x02F0,0x02F0,0x02F0},  {0x02F1,0x02F1,0x02F1},
  {0x02F2,0x02F2,0x02F2},  {0x02F3,0x02F3,0x02F3},
  {0x02F4,0x02F4,0x02F4},  {0x02F5,0x02F5,0x02F5},
  {0x02F6,0x02F6,0x02F6},  {0x02F7,0x02F7,0x02F7},
  {0x02F8,0x02F8,0x02F8},  {0x02F9,0x02F9,0x02F9},
  {0x02FA,0x02FA,0x02FA},  {0x02FB,0x02FB,0x02FB},
  {0x02FC,0x02FC,0x02FC},  {0x02FD,0x02FD,0x02FD},
  {0x02FE,0x02FE,0x02FE},  {0x02FF,0x02FF,0x02FF}
};

static MY_UNICASE_INFO plane03[]={
  {0x0300,0x0300,0x0300},  {0x0301,0x0301,0x0301},
  {0x0302,0x0302,0x0302},  {0x0303,0x0303,0x0303},
  {0x0304,0x0304,0x0304},  {0x0305,0x0305,0x0305},
  {0x0306,0x0306,0x0306},  {0x0307,0x0307,0x0307},
  {0x0308,0x0308,0x0308},  {0x0309,0x0309,0x0309},
  {0x030A,0x030A,0x030A},  {0x030B,0x030B,0x030B},
  {0x030C,0x030C,0x030C},  {0x030D,0x030D,0x030D},
  {0x030E,0x030E,0x030E},  {0x030F,0x030F,0x030F},
  {0x0310,0x0310,0x0310},  {0x0311,0x0311,0x0311},
  {0x0312,0x0312,0x0312},  {0x0313,0x0313,0x0313},
  {0x0314,0x0314,0x0314},  {0x0315,0x0315,0x0315},
  {0x0316,0x0316,0x0316},  {0x0317,0x0317,0x0317},
  {0x0318,0x0318,0x0318},  {0x0319,0x0319,0x0319},
  {0x031A,0x031A,0x031A},  {0x031B,0x031B,0x031B},
  {0x031C,0x031C,0x031C},  {0x031D,0x031D,0x031D},
  {0x031E,0x031E,0x031E},  {0x031F,0x031F,0x031F},
  {0x0320,0x0320,0x0320},  {0x0321,0x0321,0x0321},
  {0x0322,0x0322,0x0322},  {0x0323,0x0323,0x0323},
  {0x0324,0x0324,0x0324},  {0x0325,0x0325,0x0325},
  {0x0326,0x0326,0x0326},  {0x0327,0x0327,0x0327},
  {0x0328,0x0328,0x0328},  {0x0329,0x0329,0x0329},
  {0x032A,0x032A,0x032A},  {0x032B,0x032B,0x032B},
  {0x032C,0x032C,0x032C},  {0x032D,0x032D,0x032D},
  {0x032E,0x032E,0x032E},  {0x032F,0x032F,0x032F},
  {0x0330,0x0330,0x0330},  {0x0331,0x0331,0x0331},
  {0x0332,0x0332,0x0332},  {0x0333,0x0333,0x0333},
  {0x0334,0x0334,0x0334},  {0x0335,0x0335,0x0335},
  {0x0336,0x0336,0x0336},  {0x0337,0x0337,0x0337},
  {0x0338,0x0338,0x0338},  {0x0339,0x0339,0x0339},
  {0x033A,0x033A,0x033A},  {0x033B,0x033B,0x033B},
  {0x033C,0x033C,0x033C},  {0x033D,0x033D,0x033D},
  {0x033E,0x033E,0x033E},  {0x033F,0x033F,0x033F},
  {0x0340,0x0340,0x0340},  {0x0341,0x0341,0x0341},
  {0x0342,0x0342,0x0342},  {0x0343,0x0343,0x0343},
  {0x0344,0x0344,0x0344},  {0x0399,0x0345,0x0399},
  {0x0346,0x0346,0x0346},  {0x0347,0x0347,0x0347},
  {0x0348,0x0348,0x0348},  {0x0349,0x0349,0x0349},
  {0x034A,0x034A,0x034A},  {0x034B,0x034B,0x034B},
  {0x034C,0x034C,0x034C},  {0x034D,0x034D,0x034D},
  {0x034E,0x034E,0x034E},  {0x034F,0x034F,0x034F},
  {0x0350,0x0350,0x0350},  {0x0351,0x0351,0x0351},
  {0x0352,0x0352,0x0352},  {0x0353,0x0353,0x0353},
  {0x0354,0x0354,0x0354},  {0x0355,0x0355,0x0355},
  {0x0356,0x0356,0x0356},  {0x0357,0x0357,0x0357},
  {0x0358,0x0358,0x0358},  {0x0359,0x0359,0x0359},
  {0x035A,0x035A,0x035A},  {0x035B,0x035B,0x035B},
  {0x035C,0x035C,0x035C},  {0x035D,0x035D,0x035D},
  {0x035E,0x035E,0x035E},  {0x035F,0x035F,0x035F},
  {0x0360,0x0360,0x0360},  {0x0361,0x0361,0x0361},
  {0x0362,0x0362,0x0362},  {0x0363,0x0363,0x0363},
  {0x0364,0x0364,0x0364},  {0x0365,0x0365,0x0365},
  {0x0366,0x0366,0x0366},  {0x0367,0x0367,0x0367},
  {0x0368,0x0368,0x0368},  {0x0369,0x0369,0x0369},
  {0x036A,0x036A,0x036A},  {0x036B,0x036B,0x036B},
  {0x036C,0x036C,0x036C},  {0x036D,0x036D,0x036D},
  {0x036E,0x036E,0x036E},  {0x036F,0x036F,0x036F},
  {0x0370,0x0370,0x0370},  {0x0371,0x0371,0x0371},
  {0x0372,0x0372,0x0372},  {0x0373,0x0373,0x0373},
  {0x0374,0x0374,0x0374},  {0x0375,0x0375,0x0375},
  {0x0376,0x0376,0x0376},  {0x0377,0x0377,0x0377},
  {0x0378,0x0378,0x0378},  {0x0379,0x0379,0x0379},
  {0x037A,0x037A,0x037A},  {0x037B,0x037B,0x037B},
  {0x037C,0x037C,0x037C},  {0x037D,0x037D,0x037D},
  {0x037E,0x037E,0x037E},  {0x037F,0x037F,0x037F},
  {0x0380,0x0380,0x0380},  {0x0381,0x0381,0x0381},
  {0x0382,0x0382,0x0382},  {0x0383,0x0383,0x0383},
  {0x0384,0x0384,0x0384},  {0x0385,0x0385,0x0385},
  {0x0386,0x03AC,0x0391},  {0x0387,0x0387,0x0387},
  {0x0388,0x03AD,0x0395},  {0x0389,0x03AE,0x0397},
  {0x038A,0x03AF,0x0399},  {0x038B,0x038B,0x038B},
  {0x038C,0x03CC,0x039F},  {0x038D,0x038D,0x038D},
  {0x038E,0x03CD,0x03A5},  {0x038F,0x03CE,0x03A9},
  {0x0390,0x0390,0x0399},  {0x0391,0x03B1,0x0391},
  {0x0392,0x03B2,0x0392},  {0x0393,0x03B3,0x0393},
  {0x0394,0x03B4,0x0394},  {0x0395,0x03B5,0x0395},
  {0x0396,0x03B6,0x0396},  {0x0397,0x03B7,0x0397},
  {0x0398,0x03B8,0x0398},  {0x0399,0x03B9,0x0399},
  {0x039A,0x03BA,0x039A},  {0x039B,0x03BB,0x039B},
  {0x039C,0x03BC,0x039C},  {0x039D,0x03BD,0x039D},
  {0x039E,0x03BE,0x039E},  {0x039F,0x03BF,0x039F},
  {0x03A0,0x03C0,0x03A0},  {0x03A1,0x03C1,0x03A1},
  {0x03A2,0x03A2,0x03A2},  {0x03A3,0x03C3,0x03A3},
  {0x03A4,0x03C4,0x03A4},  {0x03A5,0x03C5,0x03A5},
  {0x03A6,0x03C6,0x03A6},  {0x03A7,0x03C7,0x03A7},
  {0x03A8,0x03C8,0x03A8},  {0x03A9,0x03C9,0x03A9},
  {0x03AA,0x03CA,0x0399},  {0x03AB,0x03CB,0x03A5},
  {0x0386,0x03AC,0x0391},  {0x0388,0x03AD,0x0395},
  {0x0389,0x03AE,0x0397},  {0x038A,0x03AF,0x0399},
  {0x03B0,0x03B0,0x03A5},  {0x0391,0x03B1,0x0391},
  {0x0392,0x03B2,0x0392},  {0x0393,0x03B3,0x0393},
  {0x0394,0x03B4,0x0394},  {0x0395,0x03B5,0x0395},
  {0x0396,0x03B6,0x0396},  {0x0397,0x03B7,0x0397},
  {0x0398,0x03B8,0x0398},  {0x0399,0x03B9,0x0399},
  {0x039A,0x03BA,0x039A},  {0x039B,0x03BB,0x039B},
  {0x039C,0x03BC,0x039C},  {0x039D,0x03BD,0x039D},
  {0x039E,0x03BE,0x039E},  {0x039F,0x03BF,0x039F},
  {0x03A0,0x03C0,0x03A0},  {0x03A1,0x03C1,0x03A1},
  {0x03A3,0x03C2,0x03A3},  {0x03A3,0x03C3,0x03A3},
  {0x03A4,0x03C4,0x03A4},  {0x03A5,0x03C5,0x03A5},
  {0x03A6,0x03C6,0x03A6},  {0x03A7,0x03C7,0x03A7},
  {0x03A8,0x03C8,0x03A8},  {0x03A9,0x03C9,0x03A9},
  {0x03AA,0x03CA,0x0399},  {0x03AB,0x03CB,0x03A5},
  {0x038C,0x03CC,0x039F},  {0x038E,0x03CD,0x03A5},
  {0x038F,0x03CE,0x03A9},  {0x03CF,0x03CF,0x03CF},
  {0x0392,0x03D0,0x0392},  {0x0398,0x03D1,0x0398},
  {0x03D2,0x03D2,0x03D2},  {0x03D3,0x03D3,0x03D2},
  {0x03D4,0x03D4,0x03D2},  {0x03A6,0x03D5,0x03A6},
  {0x03A0,0x03D6,0x03A0},  {0x03D7,0x03D7,0x03D7},
  {0x03D8,0x03D8,0x03D8},  {0x03D9,0x03D9,0x03D9},
  {0x03DA,0x03DB,0x03DA},  {0x03DA,0x03DB,0x03DA},
  {0x03DC,0x03DD,0x03DC},  {0x03DC,0x03DD,0x03DC},
  {0x03DE,0x03DF,0x03DE},  {0x03DE,0x03DF,0x03DE},
  {0x03E0,0x03E1,0x03E0},  {0x03E0,0x03E1,0x03E0},
  {0x03E2,0x03E3,0x03E2},  {0x03E2,0x03E3,0x03E2},
  {0x03E4,0x03E5,0x03E4},  {0x03E4,0x03E5,0x03E4},
  {0x03E6,0x03E7,0x03E6},  {0x03E6,0x03E7,0x03E6},
  {0x03E8,0x03E9,0x03E8},  {0x03E8,0x03E9,0x03E8},
  {0x03EA,0x03EB,0x03EA},  {0x03EA,0x03EB,0x03EA},
  {0x03EC,0x03ED,0x03EC},  {0x03EC,0x03ED,0x03EC},
  {0x03EE,0x03EF,0x03EE},  {0x03EE,0x03EF,0x03EE},
  {0x039A,0x03F0,0x039A},  {0x03A1,0x03F1,0x03A1},
  {0x03A3,0x03F2,0x03A3},  {0x03F3,0x03F3,0x03F3},
  {0x03F4,0x03F4,0x03F4},  {0x03F5,0x03F5,0x03F5},
  {0x03F6,0x03F6,0x03F6},  {0x03F7,0x03F7,0x03F7},
  {0x03F8,0x03F8,0x03F8},  {0x03F9,0x03F9,0x03F9},
  {0x03FA,0x03FA,0x03FA},  {0x03FB,0x03FB,0x03FB},
  {0x03FC,0x03FC,0x03FC},  {0x03FD,0x03FD,0x03FD},
  {0x03FE,0x03FE,0x03FE},  {0x03FF,0x03FF,0x03FF}
};

static MY_UNICASE_INFO plane04[]={
  {0x0400,0x0450,0x0415},  {0x0401,0x0451,0x0415},
  {0x0402,0x0452,0x0402},  {0x0403,0x0453,0x0413},
  {0x0404,0x0454,0x0404},  {0x0405,0x0455,0x0405},
  {0x0406,0x0456,0x0406},  {0x0407,0x0457,0x0406},
  {0x0408,0x0458,0x0408},  {0x0409,0x0459,0x0409},
  {0x040A,0x045A,0x040A},  {0x040B,0x045B,0x040B},
  {0x040C,0x045C,0x041A},  {0x040D,0x045D,0x0418},
  {0x040E,0x045E,0x0423},  {0x040F,0x045F,0x040F},
  {0x0410,0x0430,0x0410},  {0x0411,0x0431,0x0411},
  {0x0412,0x0432,0x0412},  {0x0413,0x0433,0x0413},
  {0x0414,0x0434,0x0414},  {0x0415,0x0435,0x0415},
  {0x0416,0x0436,0x0416},  {0x0417,0x0437,0x0417},
  {0x0418,0x0438,0x0418},  {0x0419,0x0439,0x0419},
  {0x041A,0x043A,0x041A},  {0x041B,0x043B,0x041B},
  {0x041C,0x043C,0x041C},  {0x041D,0x043D,0x041D},
  {0x041E,0x043E,0x041E},  {0x041F,0x043F,0x041F},
  {0x0420,0x0440,0x0420},  {0x0421,0x0441,0x0421},
  {0x0422,0x0442,0x0422},  {0x0423,0x0443,0x0423},
  {0x0424,0x0444,0x0424},  {0x0425,0x0445,0x0425},
  {0x0426,0x0446,0x0426},  {0x0427,0x0447,0x0427},
  {0x0428,0x0448,0x0428},  {0x0429,0x0449,0x0429},
  {0x042A,0x044A,0x042A},  {0x042B,0x044B,0x042B},
  {0x042C,0x044C,0x042C},  {0x042D,0x044D,0x042D},
  {0x042E,0x044E,0x042E},  {0x042F,0x044F,0x042F},
  {0x0410,0x0430,0x0410},  {0x0411,0x0431,0x0411},
  {0x0412,0x0432,0x0412},  {0x0413,0x0433,0x0413},
  {0x0414,0x0434,0x0414},  {0x0415,0x0435,0x0415},
  {0x0416,0x0436,0x0416},  {0x0417,0x0437,0x0417},
  {0x0418,0x0438,0x0418},  {0x0419,0x0439,0x0419},
  {0x041A,0x043A,0x041A},  {0x041B,0x043B,0x041B},
  {0x041C,0x043C,0x041C},  {0x041D,0x043D,0x041D},
  {0x041E,0x043E,0x041E},  {0x041F,0x043F,0x041F},
  {0x0420,0x0440,0x0420},  {0x0421,0x0441,0x0421},
  {0x0422,0x0442,0x0422},  {0x0423,0x0443,0x0423},
  {0x0424,0x0444,0x0424},  {0x0425,0x0445,0x0425},
  {0x0426,0x0446,0x0426},  {0x0427,0x0447,0x0427},
  {0x0428,0x0448,0x0428},  {0x0429,0x0449,0x0429},
  {0x042A,0x044A,0x042A},  {0x042B,0x044B,0x042B},
  {0x042C,0x044C,0x042C},  {0x042D,0x044D,0x042D},
  {0x042E,0x044E,0x042E},  {0x042F,0x044F,0x042F},
  {0x0400,0x0450,0x0415},  {0x0401,0x0451,0x0415},
  {0x0402,0x0452,0x0402},  {0x0403,0x0453,0x0413},
  {0x0404,0x0454,0x0404},  {0x0405,0x0455,0x0405},
  {0x0406,0x0456,0x0406},  {0x0407,0x0457,0x0406},
  {0x0408,0x0458,0x0408},  {0x0409,0x0459,0x0409},
  {0x040A,0x045A,0x040A},  {0x040B,0x045B,0x040B},
  {0x040C,0x045C,0x041A},  {0x040D,0x045D,0x0418},
  {0x040E,0x045E,0x0423},  {0x040F,0x045F,0x040F},
  {0x0460,0x0461,0x0460},  {0x0460,0x0461,0x0460},
  {0x0462,0x0463,0x0462},  {0x0462,0x0463,0x0462},
  {0x0464,0x0465,0x0464},  {0x0464,0x0465,0x0464},
  {0x0466,0x0467,0x0466},  {0x0466,0x0467,0x0466},
  {0x0468,0x0469,0x0468},  {0x0468,0x0469,0x0468},
  {0x046A,0x046B,0x046A},  {0x046A,0x046B,0x046A},
  {0x046C,0x046D,0x046C},  {0x046C,0x046D,0x046C},
  {0x046E,0x046F,0x046E},  {0x046E,0x046F,0x046E},
  {0x0470,0x0471,0x0470},  {0x0470,0x0471,0x0470},
  {0x0472,0x0473,0x0472},  {0x0472,0x0473,0x0472},
  {0x0474,0x0475,0x0474},  {0x0474,0x0475,0x0474},
  {0x0476,0x0477,0x0474},  {0x0476,0x0477,0x0474},
  {0x0478,0x0479,0x0478},  {0x0478,0x0479,0x0478},
  {0x047A,0x047B,0x047A},  {0x047A,0x047B,0x047A},
  {0x047C,0x047D,0x047C},  {0x047C,0x047D,0x047C},
  {0x047E,0x047F,0x047E},  {0x047E,0x047F,0x047E},
  {0x0480,0x0481,0x0480},  {0x0480,0x0481,0x0480},
  {0x0482,0x0482,0x0482},  {0x0483,0x0483,0x0483},
  {0x0484,0x0484,0x0484},  {0x0485,0x0485,0x0485},
  {0x0486,0x0486,0x0486},  {0x0487,0x0487,0x0487},
  {0x0488,0x0488,0x0488},  {0x0489,0x0489,0x0489},
  {0x048A,0x048A,0x048A},  {0x048B,0x048B,0x048B},
  {0x048C,0x048D,0x048C},  {0x048C,0x048D,0x048C},
  {0x048E,0x048F,0x048E},  {0x048E,0x048F,0x048E},
  {0x0490,0x0491,0x0490},  {0x0490,0x0491,0x0490},
  {0x0492,0x0493,0x0492},  {0x0492,0x0493,0x0492},
  {0x0494,0x0495,0x0494},  {0x0494,0x0495,0x0494},
  {0x0496,0x0497,0x0496},  {0x0496,0x0497,0x0496},
  {0x0498,0x0499,0x0498},  {0x0498,0x0499,0x0498},
  {0x049A,0x049B,0x049A},  {0x049A,0x049B,0x049A},
  {0x049C,0x049D,0x049C},  {0x049C,0x049D,0x049C},
  {0x049E,0x049F,0x049E},  {0x049E,0x049F,0x049E},
  {0x04A0,0x04A1,0x04A0},  {0x04A0,0x04A1,0x04A0},
  {0x04A2,0x04A3,0x04A2},  {0x04A2,0x04A3,0x04A2},
  {0x04A4,0x04A5,0x04A4},  {0x04A4,0x04A5,0x04A4},
  {0x04A6,0x04A7,0x04A6},  {0x04A6,0x04A7,0x04A6},
  {0x04A8,0x04A9,0x04A8},  {0x04A8,0x04A9,0x04A8},
  {0x04AA,0x04AB,0x04AA},  {0x04AA,0x04AB,0x04AA},
  {0x04AC,0x04AD,0x04AC},  {0x04AC,0x04AD,0x04AC},
  {0x04AE,0x04AF,0x04AE},  {0x04AE,0x04AF,0x04AE},
  {0x04B0,0x04B1,0x04B0},  {0x04B0,0x04B1,0x04B0},
  {0x04B2,0x04B3,0x04B2},  {0x04B2,0x04B3,0x04B2},
  {0x04B4,0x04B5,0x04B4},  {0x04B4,0x04B5,0x04B4},
  {0x04B6,0x04B7,0x04B6},  {0x04B6,0x04B7,0x04B6},
  {0x04B8,0x04B9,0x04B8},  {0x04B8,0x04B9,0x04B8},
  {0x04BA,0x04BB,0x04BA},  {0x04BA,0x04BB,0x04BA},
  {0x04BC,0x04BD,0x04BC},  {0x04BC,0x04BD,0x04BC},
  {0x04BE,0x04BF,0x04BE},  {0x04BE,0x04BF,0x04BE},
  {0x04C0,0x04C0,0x04C0},  {0x04C1,0x04C2,0x0416},
  {0x04C1,0x04C2,0x0416},  {0x04C3,0x04C4,0x04C3},
  {0x04C3,0x04C4,0x04C3},  {0x04C5,0x04C5,0x04C5},
  {0x04C6,0x04C6,0x04C6},  {0x04C7,0x04C8,0x04C7},
  {0x04C7,0x04C8,0x04C7},  {0x04C9,0x04C9,0x04C9},
  {0x04CA,0x04CA,0x04CA},  {0x04CB,0x04CC,0x04CB},
  {0x04CB,0x04CC,0x04CB},  {0x04CD,0x04CD,0x04CD},
  {0x04CE,0x04CE,0x04CE},  {0x04CF,0x04CF,0x04CF},
  {0x04D0,0x04D1,0x0410},  {0x04D0,0x04D1,0x0410},
  {0x04D2,0x04D3,0x0410},  {0x04D2,0x04D3,0x0410},
  {0x04D4,0x04D5,0x04D4},  {0x04D4,0x04D5,0x04D4},
  {0x04D6,0x04D7,0x0415},  {0x04D6,0x04D7,0x0415},
  {0x04D8,0x04D9,0x04D8},  {0x04D8,0x04D9,0x04D8},
  {0x04DA,0x04DB,0x04D8},  {0x04DA,0x04DB,0x04D8},
  {0x04DC,0x04DD,0x0416},  {0x04DC,0x04DD,0x0416},
  {0x04DE,0x04DF,0x0417},  {0x04DE,0x04DF,0x0417},
  {0x04E0,0x04E1,0x04E0},  {0x04E0,0x04E1,0x04E0},
  {0x04E2,0x04E3,0x0418},  {0x04E2,0x04E3,0x0418},
  {0x04E4,0x04E5,0x0418},  {0x04E4,0x04E5,0x0418},
  {0x04E6,0x04E7,0x041E},  {0x04E6,0x04E7,0x041E},
  {0x04E8,0x04E9,0x04E8},  {0x04E8,0x04E9,0x04E8},
  {0x04EA,0x04EB,0x04E8},  {0x04EA,0x04EB,0x04E8},
  {0x04EC,0x04ED,0x042D},  {0x04EC,0x04ED,0x042D},
  {0x04EE,0x04EF,0x0423},  {0x04EE,0x04EF,0x0423},
  {0x04F0,0x04F1,0x0423},  {0x04F0,0x04F1,0x0423},
  {0x04F2,0x04F3,0x0423},  {0x04F2,0x04F3,0x0423},
  {0x04F4,0x04F5,0x0427},  {0x04F4,0x04F5,0x0427},
  {0x04F6,0x04F6,0x04F6},  {0x04F7,0x04F7,0x04F7},
  {0x04F8,0x04F9,0x042B},  {0x04F8,0x04F9,0x042B},
  {0x04FA,0x04FA,0x04FA},  {0x04FB,0x04FB,0x04FB},
  {0x04FC,0x04FC,0x04FC},  {0x04FD,0x04FD,0x04FD},
  {0x04FE,0x04FE,0x04FE},  {0x04FF,0x04FF,0x04FF}
};

static MY_UNICASE_INFO plane05[]={
  {0x0500,0x0500,0x0500},  {0x0501,0x0501,0x0501},
  {0x0502,0x0502,0x0502},  {0x0503,0x0503,0x0503},
  {0x0504,0x0504,0x0504},  {0x0505,0x0505,0x0505},
  {0x0506,0x0506,0x0506},  {0x0507,0x0507,0x0507},
  {0x0508,0x0508,0x0508},  {0x0509,0x0509,0x0509},
  {0x050A,0x050A,0x050A},  {0x050B,0x050B,0x050B},
  {0x050C,0x050C,0x050C},  {0x050D,0x050D,0x050D},
  {0x050E,0x050E,0x050E},  {0x050F,0x050F,0x050F},
  {0x0510,0x0510,0x0510},  {0x0511,0x0511,0x0511},
  {0x0512,0x0512,0x0512},  {0x0513,0x0513,0x0513},
  {0x0514,0x0514,0x0514},  {0x0515,0x0515,0x0515},
  {0x0516,0x0516,0x0516},  {0x0517,0x0517,0x0517},
  {0x0518,0x0518,0x0518},  {0x0519,0x0519,0x0519},
  {0x051A,0x051A,0x051A},  {0x051B,0x051B,0x051B},
  {0x051C,0x051C,0x051C},  {0x051D,0x051D,0x051D},
  {0x051E,0x051E,0x051E},  {0x051F,0x051F,0x051F},
  {0x0520,0x0520,0x0520},  {0x0521,0x0521,0x0521},
  {0x0522,0x0522,0x0522},  {0x0523,0x0523,0x0523},
  {0x0524,0x0524,0x0524},  {0x0525,0x0525,0x0525},
  {0x0526,0x0526,0x0526},  {0x0527,0x0527,0x0527},
  {0x0528,0x0528,0x0528},  {0x0529,0x0529,0x0529},
  {0x052A,0x052A,0x052A},  {0x052B,0x052B,0x052B},
  {0x052C,0x052C,0x052C},  {0x052D,0x052D,0x052D},
  {0x052E,0x052E,0x052E},  {0x052F,0x052F,0x052F},
  {0x0530,0x0530,0x0530},  {0x0531,0x0561,0x0531},
  {0x0532,0x0562,0x0532},  {0x0533,0x0563,0x0533},
  {0x0534,0x0564,0x0534},  {0x0535,0x0565,0x0535},
  {0x0536,0x0566,0x0536},  {0x0537,0x0567,0x0537},
  {0x0538,0x0568,0x0538},  {0x0539,0x0569,0x0539},
  {0x053A,0x056A,0x053A},  {0x053B,0x056B,0x053B},
  {0x053C,0x056C,0x053C},  {0x053D,0x056D,0x053D},
  {0x053E,0x056E,0x053E},  {0x053F,0x056F,0x053F},
  {0x0540,0x0570,0x0540},  {0x0541,0x0571,0x0541},
  {0x0542,0x0572,0x0542},  {0x0543,0x0573,0x0543},
  {0x0544,0x0574,0x0544},  {0x0545,0x0575,0x0545},
  {0x0546,0x0576,0x0546},  {0x0547,0x0577,0x0547},
  {0x0548,0x0578,0x0548},  {0x0549,0x0579,0x0549},
  {0x054A,0x057A,0x054A},  {0x054B,0x057B,0x054B},
  {0x054C,0x057C,0x054C},  {0x054D,0x057D,0x054D},
  {0x054E,0x057E,0x054E},  {0x054F,0x057F,0x054F},
  {0x0550,0x0580,0x0550},  {0x0551,0x0581,0x0551},
  {0x0552,0x0582,0x0552},  {0x0553,0x0583,0x0553},
  {0x0554,0x0584,0x0554},  {0x0555,0x0585,0x0555},
  {0x0556,0x0586,0x0556},  {0x0557,0x0557,0x0557},
  {0x0558,0x0558,0x0558},  {0x0559,0x0559,0x0559},
  {0x055A,0x055A,0x055A},  {0x055B,0x055B,0x055B},
  {0x055C,0x055C,0x055C},  {0x055D,0x055D,0x055D},
  {0x055E,0x055E,0x055E},  {0x055F,0x055F,0x055F},
  {0x0560,0x0560,0x0560},  {0x0531,0x0561,0x0531},
  {0x0532,0x0562,0x0532},  {0x0533,0x0563,0x0533},
  {0x0534,0x0564,0x0534},  {0x0535,0x0565,0x0535},
  {0x0536,0x0566,0x0536},  {0x0537,0x0567,0x0537},
  {0x0538,0x0568,0x0538},  {0x0539,0x0569,0x0539},
  {0x053A,0x056A,0x053A},  {0x053B,0x056B,0x053B},
  {0x053C,0x056C,0x053C},  {0x053D,0x056D,0x053D},
  {0x053E,0x056E,0x053E},  {0x053F,0x056F,0x053F},
  {0x0540,0x0570,0x0540},  {0x0541,0x0571,0x0541},
  {0x0542,0x0572,0x0542},  {0x0543,0x0573,0x0543},
  {0x0544,0x0574,0x0544},  {0x0545,0x0575,0x0545},
  {0x0546,0x0576,0x0546},  {0x0547,0x0577,0x0547},
  {0x0548,0x0578,0x0548},  {0x0549,0x0579,0x0549},
  {0x054A,0x057A,0x054A},  {0x054B,0x057B,0x054B},
  {0x054C,0x057C,0x054C},  {0x054D,0x057D,0x054D},
  {0x054E,0x057E,0x054E},  {0x054F,0x057F,0x054F},
  {0x0550,0x0580,0x0550},  {0x0551,0x0581,0x0551},
  {0x0552,0x0582,0x0552},  {0x0553,0x0583,0x0553},
  {0x0554,0x0584,0x0554},  {0x0555,0x0585,0x0555},
  {0x0556,0x0586,0x0556},  {0x0587,0x0587,0x0587},
  {0x0588,0x0588,0x0588},  {0x0589,0x0589,0x0589},
  {0x058A,0x058A,0x058A},  {0x058B,0x058B,0x058B},
  {0x058C,0x058C,0x058C},  {0x058D,0x058D,0x058D},
  {0x058E,0x058E,0x058E},  {0x058F,0x058F,0x058F},
  {0x0590,0x0590,0x0590},  {0x0591,0x0591,0x0591},
  {0x0592,0x0592,0x0592},  {0x0593,0x0593,0x0593},
  {0x0594,0x0594,0x0594},  {0x0595,0x0595,0x0595},
  {0x0596,0x0596,0x0596},  {0x0597,0x0597,0x0597},
  {0x0598,0x0598,0x0598},  {0x0599,0x0599,0x0599},
  {0x059A,0x059A,0x059A},  {0x059B,0x059B,0x059B},
  {0x059C,0x059C,0x059C},  {0x059D,0x059D,0x059D},
  {0x059E,0x059E,0x059E},  {0x059F,0x059F,0x059F},
  {0x05A0,0x05A0,0x05A0},  {0x05A1,0x05A1,0x05A1},
  {0x05A2,0x05A2,0x05A2},  {0x05A3,0x05A3,0x05A3},
  {0x05A4,0x05A4,0x05A4},  {0x05A5,0x05A5,0x05A5},
  {0x05A6,0x05A6,0x05A6},  {0x05A7,0x05A7,0x05A7},
  {0x05A8,0x05A8,0x05A8},  {0x05A9,0x05A9,0x05A9},
  {0x05AA,0x05AA,0x05AA},  {0x05AB,0x05AB,0x05AB},
  {0x05AC,0x05AC,0x05AC},  {0x05AD,0x05AD,0x05AD},
  {0x05AE,0x05AE,0x05AE},  {0x05AF,0x05AF,0x05AF},
  {0x05B0,0x05B0,0x05B0},  {0x05B1,0x05B1,0x05B1},
  {0x05B2,0x05B2,0x05B2},  {0x05B3,0x05B3,0x05B3},
  {0x05B4,0x05B4,0x05B4},  {0x05B5,0x05B5,0x05B5},
  {0x05B6,0x05B6,0x05B6},  {0x05B7,0x05B7,0x05B7},
  {0x05B8,0x05B8,0x05B8},  {0x05B9,0x05B9,0x05B9},
  {0x05BA,0x05BA,0x05BA},  {0x05BB,0x05BB,0x05BB},
  {0x05BC,0x05BC,0x05BC},  {0x05BD,0x05BD,0x05BD},
  {0x05BE,0x05BE,0x05BE},  {0x05BF,0x05BF,0x05BF},
  {0x05C0,0x05C0,0x05C0},  {0x05C1,0x05C1,0x05C1},
  {0x05C2,0x05C2,0x05C2},  {0x05C3,0x05C3,0x05C3},
  {0x05C4,0x05C4,0x05C4},  {0x05C5,0x05C5,0x05C5},
  {0x05C6,0x05C6,0x05C6},  {0x05C7,0x05C7,0x05C7},
  {0x05C8,0x05C8,0x05C8},  {0x05C9,0x05C9,0x05C9},
  {0x05CA,0x05CA,0x05CA},  {0x05CB,0x05CB,0x05CB},
  {0x05CC,0x05CC,0x05CC},  {0x05CD,0x05CD,0x05CD},
  {0x05CE,0x05CE,0x05CE},  {0x05CF,0x05CF,0x05CF},
  {0x05D0,0x05D0,0x05D0},  {0x05D1,0x05D1,0x05D1},
  {0x05D2,0x05D2,0x05D2},  {0x05D3,0x05D3,0x05D3},
  {0x05D4,0x05D4,0x05D4},  {0x05D5,0x05D5,0x05D5},
  {0x05D6,0x05D6,0x05D6},  {0x05D7,0x05D7,0x05D7},
  {0x05D8,0x05D8,0x05D8},  {0x05D9,0x05D9,0x05D9},
  {0x05DA,0x05DA,0x05DA},  {0x05DB,0x05DB,0x05DB},
  {0x05DC,0x05DC,0x05DC},  {0x05DD,0x05DD,0x05DD},
  {0x05DE,0x05DE,0x05DE},  {0x05DF,0x05DF,0x05DF},
  {0x05E0,0x05E0,0x05E0},  {0x05E1,0x05E1,0x05E1},
  {0x05E2,0x05E2,0x05E2},  {0x05E3,0x05E3,0x05E3},
  {0x05E4,0x05E4,0x05E4},  {0x05E5,0x05E5,0x05E5},
  {0x05E6,0x05E6,0x05E6},  {0x05E7,0x05E7,0x05E7},
  {0x05E8,0x05E8,0x05E8},  {0x05E9,0x05E9,0x05E9},
  {0x05EA,0x05EA,0x05EA},  {0x05EB,0x05EB,0x05EB},
  {0x05EC,0x05EC,0x05EC},  {0x05ED,0x05ED,0x05ED},
  {0x05EE,0x05EE,0x05EE},  {0x05EF,0x05EF,0x05EF},
  {0x05F0,0x05F0,0x05F0},  {0x05F1,0x05F1,0x05F1},
  {0x05F2,0x05F2,0x05F2},  {0x05F3,0x05F3,0x05F3},
  {0x05F4,0x05F4,0x05F4},  {0x05F5,0x05F5,0x05F5},
  {0x05F6,0x05F6,0x05F6},  {0x05F7,0x05F7,0x05F7},
  {0x05F8,0x05F8,0x05F8},  {0x05F9,0x05F9,0x05F9},
  {0x05FA,0x05FA,0x05FA},  {0x05FB,0x05FB,0x05FB},
  {0x05FC,0x05FC,0x05FC},  {0x05FD,0x05FD,0x05FD},
  {0x05FE,0x05FE,0x05FE},  {0x05FF,0x05FF,0x05FF}
};

static MY_UNICASE_INFO plane1E[]={
  {0x1E00,0x1E01,0x0041},  {0x1E00,0x1E01,0x0041},
  {0x1E02,0x1E03,0x0042},  {0x1E02,0x1E03,0x0042},
  {0x1E04,0x1E05,0x0042},  {0x1E04,0x1E05,0x0042},
  {0x1E06,0x1E07,0x0042},  {0x1E06,0x1E07,0x0042},
  {0x1E08,0x1E09,0x0043},  {0x1E08,0x1E09,0x0043},
  {0x1E0A,0x1E0B,0x0044},  {0x1E0A,0x1E0B,0x0044},
  {0x1E0C,0x1E0D,0x0044},  {0x1E0C,0x1E0D,0x0044},
  {0x1E0E,0x1E0F,0x0044},  {0x1E0E,0x1E0F,0x0044},
  {0x1E10,0x1E11,0x0044},  {0x1E10,0x1E11,0x0044},
  {0x1E12,0x1E13,0x0044},  {0x1E12,0x1E13,0x0044},
  {0x1E14,0x1E15,0x0045},  {0x1E14,0x1E15,0x0045},
  {0x1E16,0x1E17,0x0045},  {0x1E16,0x1E17,0x0045},
  {0x1E18,0x1E19,0x0045},  {0x1E18,0x1E19,0x0045},
  {0x1E1A,0x1E1B,0x0045},  {0x1E1A,0x1E1B,0x0045},
  {0x1E1C,0x1E1D,0x0045},  {0x1E1C,0x1E1D,0x0045},
  {0x1E1E,0x1E1F,0x0046},  {0x1E1E,0x1E1F,0x0046},
  {0x1E20,0x1E21,0x0047},  {0x1E20,0x1E21,0x0047},
  {0x1E22,0x1E23,0x0048},  {0x1E22,0x1E23,0x0048},
  {0x1E24,0x1E25,0x0048},  {0x1E24,0x1E25,0x0048},
  {0x1E26,0x1E27,0x0048},  {0x1E26,0x1E27,0x0048},
  {0x1E28,0x1E29,0x0048},  {0x1E28,0x1E29,0x0048},
  {0x1E2A,0x1E2B,0x0048},  {0x1E2A,0x1E2B,0x0048},
  {0x1E2C,0x1E2D,0x0049},  {0x1E2C,0x1E2D,0x0049},
  {0x1E2E,0x1E2F,0x0049},  {0x1E2E,0x1E2F,0x0049},
  {0x1E30,0x1E31,0x004B},  {0x1E30,0x1E31,0x004B},
  {0x1E32,0x1E33,0x004B},  {0x1E32,0x1E33,0x004B},
  {0x1E34,0x1E35,0x004B},  {0x1E34,0x1E35,0x004B},
  {0x1E36,0x1E37,0x004C},  {0x1E36,0x1E37,0x004C},
  {0x1E38,0x1E39,0x004C},  {0x1E38,0x1E39,0x004C},
  {0x1E3A,0x1E3B,0x004C},  {0x1E3A,0x1E3B,0x004C},
  {0x1E3C,0x1E3D,0x004C},  {0x1E3C,0x1E3D,0x004C},
  {0x1E3E,0x1E3F,0x004D},  {0x1E3E,0x1E3F,0x004D},
  {0x1E40,0x1E41,0x004D},  {0x1E40,0x1E41,0x004D},
  {0x1E42,0x1E43,0x004D},  {0x1E42,0x1E43,0x004D},
  {0x1E44,0x1E45,0x004E},  {0x1E44,0x1E45,0x004E},
  {0x1E46,0x1E47,0x004E},  {0x1E46,0x1E47,0x004E},
  {0x1E48,0x1E49,0x004E},  {0x1E48,0x1E49,0x004E},
  {0x1E4A,0x1E4B,0x004E},  {0x1E4A,0x1E4B,0x004E},
  {0x1E4C,0x1E4D,0x004F},  {0x1E4C,0x1E4D,0x004F},
  {0x1E4E,0x1E4F,0x004F},  {0x1E4E,0x1E4F,0x004F},
  {0x1E50,0x1E51,0x004F},  {0x1E50,0x1E51,0x004F},
  {0x1E52,0x1E53,0x004F},  {0x1E52,0x1E53,0x004F},
  {0x1E54,0x1E55,0x0050},  {0x1E54,0x1E55,0x0050},
  {0x1E56,0x1E57,0x0050},  {0x1E56,0x1E57,0x0050},
  {0x1E58,0x1E59,0x0052},  {0x1E58,0x1E59,0x0052},
  {0x1E5A,0x1E5B,0x0052},  {0x1E5A,0x1E5B,0x0052},
  {0x1E5C,0x1E5D,0x0052},  {0x1E5C,0x1E5D,0x0052},
  {0x1E5E,0x1E5F,0x0052},  {0x1E5E,0x1E5F,0x0052},
  {0x1E60,0x1E61,0x0053},  {0x1E60,0x1E61,0x0053},
  {0x1E62,0x1E63,0x0053},  {0x1E62,0x1E63,0x0053},
  {0x1E64,0x1E65,0x0053},  {0x1E64,0x1E65,0x0053},
  {0x1E66,0x1E67,0x0053},  {0x1E66,0x1E67,0x0053},
  {0x1E68,0x1E69,0x0053},  {0x1E68,0x1E69,0x0053},
  {0x1E6A,0x1E6B,0x0054},  {0x1E6A,0x1E6B,0x0054},
  {0x1E6C,0x1E6D,0x0054},  {0x1E6C,0x1E6D,0x0054},
  {0x1E6E,0x1E6F,0x0054},  {0x1E6E,0x1E6F,0x0054},
  {0x1E70,0x1E71,0x0054},  {0x1E70,0x1E71,0x0054},
  {0x1E72,0x1E73,0x0055},  {0x1E72,0x1E73,0x0055},
  {0x1E74,0x1E75,0x0055},  {0x1E74,0x1E75,0x0055},
  {0x1E76,0x1E77,0x0055},  {0x1E76,0x1E77,0x0055},
  {0x1E78,0x1E79,0x0055},  {0x1E78,0x1E79,0x0055},
  {0x1E7A,0x1E7B,0x0055},  {0x1E7A,0x1E7B,0x0055},
  {0x1E7C,0x1E7D,0x0056},  {0x1E7C,0x1E7D,0x0056},
  {0x1E7E,0x1E7F,0x0056},  {0x1E7E,0x1E7F,0x0056},
  {0x1E80,0x1E81,0x0057},  {0x1E80,0x1E81,0x0057},
  {0x1E82,0x1E83,0x0057},  {0x1E82,0x1E83,0x0057},
  {0x1E84,0x1E85,0x0057},  {0x1E84,0x1E85,0x0057},
  {0x1E86,0x1E87,0x0057},  {0x1E86,0x1E87,0x0057},
  {0x1E88,0x1E89,0x0057},  {0x1E88,0x1E89,0x0057},
  {0x1E8A,0x1E8B,0x0058},  {0x1E8A,0x1E8B,0x0058},
  {0x1E8C,0x1E8D,0x0058},  {0x1E8C,0x1E8D,0x0058},
  {0x1E8E,0x1E8F,0x0059},  {0x1E8E,0x1E8F,0x0059},
  {0x1E90,0x1E91,0x005A},  {0x1E90,0x1E91,0x005A},
  {0x1E92,0x1E93,0x005A},  {0x1E92,0x1E93,0x005A},
  {0x1E94,0x1E95,0x005A},  {0x1E94,0x1E95,0x005A},
  {0x1E96,0x1E96,0x0048},  {0x1E97,0x1E97,0x0054},
  {0x1E98,0x1E98,0x0057},  {0x1E99,0x1E99,0x0059},
  {0x1E9A,0x1E9A,0x1E9A},  {0x1E60,0x1E9B,0x0053},
  {0x1E9C,0x1E9C,0x1E9C},  {0x1E9D,0x1E9D,0x1E9D},
  {0x1E9E,0x1E9E,0x1E9E},  {0x1E9F,0x1E9F,0x1E9F},
  {0x1EA0,0x1EA1,0x0041},  {0x1EA0,0x1EA1,0x0041},
  {0x1EA2,0x1EA3,0x0041},  {0x1EA2,0x1EA3,0x0041},
  {0x1EA4,0x1EA5,0x0041},  {0x1EA4,0x1EA5,0x0041},
  {0x1EA6,0x1EA7,0x0041},  {0x1EA6,0x1EA7,0x0041},
  {0x1EA8,0x1EA9,0x0041},  {0x1EA8,0x1EA9,0x0041},
  {0x1EAA,0x1EAB,0x0041},  {0x1EAA,0x1EAB,0x0041},
  {0x1EAC,0x1EAD,0x0041},  {0x1EAC,0x1EAD,0x0041},
  {0x1EAE,0x1EAF,0x0041},  {0x1EAE,0x1EAF,0x0041},
  {0x1EB0,0x1EB1,0x0041},  {0x1EB0,0x1EB1,0x0041},
  {0x1EB2,0x1EB3,0x0041},  {0x1EB2,0x1EB3,0x0041},
  {0x1EB4,0x1EB5,0x0041},  {0x1EB4,0x1EB5,0x0041},
  {0x1EB6,0x1EB7,0x0041},  {0x1EB6,0x1EB7,0x0041},
  {0x1EB8,0x1EB9,0x0045},  {0x1EB8,0x1EB9,0x0045},
  {0x1EBA,0x1EBB,0x0045},  {0x1EBA,0x1EBB,0x0045},
  {0x1EBC,0x1EBD,0x0045},  {0x1EBC,0x1EBD,0x0045},
  {0x1EBE,0x1EBF,0x0045},  {0x1EBE,0x1EBF,0x0045},
  {0x1EC0,0x1EC1,0x0045},  {0x1EC0,0x1EC1,0x0045},
  {0x1EC2,0x1EC3,0x0045},  {0x1EC2,0x1EC3,0x0045},
  {0x1EC4,0x1EC5,0x0045},  {0x1EC4,0x1EC5,0x0045},
  {0x1EC6,0x1EC7,0x0045},  {0x1EC6,0x1EC7,0x0045},
  {0x1EC8,0x1EC9,0x0049},  {0x1EC8,0x1EC9,0x0049},
  {0x1ECA,0x1ECB,0x0049},  {0x1ECA,0x1ECB,0x0049},
  {0x1ECC,0x1ECD,0x004F},  {0x1ECC,0x1ECD,0x004F},
  {0x1ECE,0x1ECF,0x004F},  {0x1ECE,0x1ECF,0x004F},
  {0x1ED0,0x1ED1,0x004F},  {0x1ED0,0x1ED1,0x004F},
  {0x1ED2,0x1ED3,0x004F},  {0x1ED2,0x1ED3,0x004F},
  {0x1ED4,0x1ED5,0x004F},  {0x1ED4,0x1ED5,0x004F},
  {0x1ED6,0x1ED7,0x004F},  {0x1ED6,0x1ED7,0x004F},
  {0x1ED8,0x1ED9,0x004F},  {0x1ED8,0x1ED9,0x004F},
  {0x1EDA,0x1EDB,0x004F},  {0x1EDA,0x1EDB,0x004F},
  {0x1EDC,0x1EDD,0x004F},  {0x1EDC,0x1EDD,0x004F},
  {0x1EDE,0x1EDF,0x004F},  {0x1EDE,0x1EDF,0x004F},
  {0x1EE0,0x1EE1,0x004F},  {0x1EE0,0x1EE1,0x004F},
  {0x1EE2,0x1EE3,0x004F},  {0x1EE2,0x1EE3,0x004F},
  {0x1EE4,0x1EE5,0x0055},  {0x1EE4,0x1EE5,0x0055},
  {0x1EE6,0x1EE7,0x0055},  {0x1EE6,0x1EE7,0x0055},
  {0x1EE8,0x1EE9,0x0055},  {0x1EE8,0x1EE9,0x0055},
  {0x1EEA,0x1EEB,0x0055},  {0x1EEA,0x1EEB,0x0055},
  {0x1EEC,0x1EED,0x0055},  {0x1EEC,0x1EED,0x0055},
  {0x1EEE,0x1EEF,0x0055},  {0x1EEE,0x1EEF,0x0055},
  {0x1EF0,0x1EF1,0x0055},  {0x1EF0,0x1EF1,0x0055},
  {0x1EF2,0x1EF3,0x0059},  {0x1EF2,0x1EF3,0x0059},
  {0x1EF4,0x1EF5,0x0059},  {0x1EF4,0x1EF5,0x0059},
  {0x1EF6,0x1EF7,0x0059},  {0x1EF6,0x1EF7,0x0059},
  {0x1EF8,0x1EF9,0x0059},  {0x1EF8,0x1EF9,0x0059},
  {0x1EFA,0x1EFA,0x1EFA},  {0x1EFB,0x1EFB,0x1EFB},
  {0x1EFC,0x1EFC,0x1EFC},  {0x1EFD,0x1EFD,0x1EFD},
  {0x1EFE,0x1EFE,0x1EFE},  {0x1EFF,0x1EFF,0x1EFF}
};

static MY_UNICASE_INFO plane1F[]={
  {0x1F08,0x1F00,0x0391},  {0x1F09,0x1F01,0x0391},
  {0x1F0A,0x1F02,0x0391},  {0x1F0B,0x1F03,0x0391},
  {0x1F0C,0x1F04,0x0391},  {0x1F0D,0x1F05,0x0391},
  {0x1F0E,0x1F06,0x0391},  {0x1F0F,0x1F07,0x0391},
  {0x1F08,0x1F00,0x0391},  {0x1F09,0x1F01,0x0391},
  {0x1F0A,0x1F02,0x0391},  {0x1F0B,0x1F03,0x0391},
  {0x1F0C,0x1F04,0x0391},  {0x1F0D,0x1F05,0x0391},
  {0x1F0E,0x1F06,0x0391},  {0x1F0F,0x1F07,0x0391},
  {0x1F18,0x1F10,0x0395},  {0x1F19,0x1F11,0x0395},
  {0x1F1A,0x1F12,0x0395},  {0x1F1B,0x1F13,0x0395},
  {0x1F1C,0x1F14,0x0395},  {0x1F1D,0x1F15,0x0395},
  {0x1F16,0x1F16,0x1F16},  {0x1F17,0x1F17,0x1F17},
  {0x1F18,0x1F10,0x0395},  {0x1F19,0x1F11,0x0395},
  {0x1F1A,0x1F12,0x0395},  {0x1F1B,0x1F13,0x0395},
  {0x1F1C,0x1F14,0x0395},  {0x1F1D,0x1F15,0x0395},
  {0x1F1E,0x1F1E,0x1F1E},  {0x1F1F,0x1F1F,0x1F1F},
  {0x1F28,0x1F20,0x0397},  {0x1F29,0x1F21,0x0397},
  {0x1F2A,0x1F22,0x0397},  {0x1F2B,0x1F23,0x0397},
  {0x1F2C,0x1F24,0x0397},  {0x1F2D,0x1F25,0x0397},
  {0x1F2E,0x1F26,0x0397},  {0x1F2F,0x1F27,0x0397},
  {0x1F28,0x1F20,0x0397},  {0x1F29,0x1F21,0x0397},
  {0x1F2A,0x1F22,0x0397},  {0x1F2B,0x1F23,0x0397},
  {0x1F2C,0x1F24,0x0397},  {0x1F2D,0x1F25,0x0397},
  {0x1F2E,0x1F26,0x0397},  {0x1F2F,0x1F27,0x0397},
  {0x1F38,0x1F30,0x0399},  {0x1F39,0x1F31,0x0399},
  {0x1F3A,0x1F32,0x0399},  {0x1F3B,0x1F33,0x0399},
  {0x1F3C,0x1F34,0x0399},  {0x1F3D,0x1F35,0x0399},
  {0x1F3E,0x1F36,0x0399},  {0x1F3F,0x1F37,0x0399},
  {0x1F38,0x1F30,0x0399},  {0x1F39,0x1F31,0x0399},
  {0x1F3A,0x1F32,0x0399},  {0x1F3B,0x1F33,0x0399},
  {0x1F3C,0x1F34,0x0399},  {0x1F3D,0x1F35,0x0399},
  {0x1F3E,0x1F36,0x0399},  {0x1F3F,0x1F37,0x0399},
  {0x1F48,0x1F40,0x039F},  {0x1F49,0x1F41,0x039F},
  {0x1F4A,0x1F42,0x039F},  {0x1F4B,0x1F43,0x039F},
  {0x1F4C,0x1F44,0x039F},  {0x1F4D,0x1F45,0x039F},
  {0x1F46,0x1F46,0x1F46},  {0x1F47,0x1F47,0x1F47},
  {0x1F48,0x1F40,0x039F},  {0x1F49,0x1F41,0x039F},
  {0x1F4A,0x1F42,0x039F},  {0x1F4B,0x1F43,0x039F},
  {0x1F4C,0x1F44,0x039F},  {0x1F4D,0x1F45,0x039F},
  {0x1F4E,0x1F4E,0x1F4E},  {0x1F4F,0x1F4F,0x1F4F},
  {0x1F50,0x1F50,0x03A5},  {0x1F59,0x1F51,0x03A5},
  {0x1F52,0x1F52,0x03A5},  {0x1F5B,0x1F53,0x03A5},
  {0x1F54,0x1F54,0x03A5},  {0x1F5D,0x1F55,0x03A5},
  {0x1F56,0x1F56,0x03A5},  {0x1F5F,0x1F57,0x03A5},
  {0x1F58,0x1F58,0x1F58},  {0x1F59,0x1F51,0x03A5},
  {0x1F5A,0x1F5A,0x1F5A},  {0x1F5B,0x1F53,0x03A5},
  {0x1F5C,0x1F5C,0x1F5C},  {0x1F5D,0x1F55,0x03A5},
  {0x1F5E,0x1F5E,0x1F5E},  {0x1F5F,0x1F57,0x03A5},
  {0x1F68,0x1F60,0x03A9},  {0x1F69,0x1F61,0x03A9},
  {0x1F6A,0x1F62,0x03A9},  {0x1F6B,0x1F63,0x03A9},
  {0x1F6C,0x1F64,0x03A9},  {0x1F6D,0x1F65,0x03A9},
  {0x1F6E,0x1F66,0x03A9},  {0x1F6F,0x1F67,0x03A9},
  {0x1F68,0x1F60,0x03A9},  {0x1F69,0x1F61,0x03A9},
  {0x1F6A,0x1F62,0x03A9},  {0x1F6B,0x1F63,0x03A9},
  {0x1F6C,0x1F64,0x03A9},  {0x1F6D,0x1F65,0x03A9},
  {0x1F6E,0x1F66,0x03A9},  {0x1F6F,0x1F67,0x03A9},
  {0x1FBA,0x1F70,0x0391},  {0x1FBB,0x1F71,0x1FBB},
  {0x1FC8,0x1F72,0x0395},  {0x1FC9,0x1F73,0x1FC9},
  {0x1FCA,0x1F74,0x0397},  {0x1FCB,0x1F75,0x1FCB},
  {0x1FDA,0x1F76,0x0399},  {0x1FDB,0x1F77,0x1FDB},
  {0x1FF8,0x1F78,0x039F},  {0x1FF9,0x1F79,0x1FF9},
  {0x1FEA,0x1F7A,0x03A5},  {0x1FEB,0x1F7B,0x1FEB},
  {0x1FFA,0x1F7C,0x03A9},  {0x1FFB,0x1F7D,0x1FFB},
  {0x1F7E,0x1F7E,0x1F7E},  {0x1F7F,0x1F7F,0x1F7F},
  {0x1F88,0x1F80,0x0391},  {0x1F89,0x1F81,0x0391},
  {0x1F8A,0x1F82,0x0391},  {0x1F8B,0x1F83,0x0391},
  {0x1F8C,0x1F84,0x0391},  {0x1F8D,0x1F85,0x0391},
  {0x1F8E,0x1F86,0x0391},  {0x1F8F,0x1F87,0x0391},
  {0x1F88,0x1F80,0x0391},  {0x1F89,0x1F81,0x0391},
  {0x1F8A,0x1F82,0x0391},  {0x1F8B,0x1F83,0x0391},
  {0x1F8C,0x1F84,0x0391},  {0x1F8D,0x1F85,0x0391},
  {0x1F8E,0x1F86,0x0391},  {0x1F8F,0x1F87,0x0391},
  {0x1F98,0x1F90,0x0397},  {0x1F99,0x1F91,0x0397},
  {0x1F9A,0x1F92,0x0397},  {0x1F9B,0x1F93,0x0397},
  {0x1F9C,0x1F94,0x0397},  {0x1F9D,0x1F95,0x0397},
  {0x1F9E,0x1F96,0x0397},  {0x1F9F,0x1F97,0x0397},
  {0x1F98,0x1F90,0x0397},  {0x1F99,0x1F91,0x0397},
  {0x1F9A,0x1F92,0x0397},  {0x1F9B,0x1F93,0x0397},
  {0x1F9C,0x1F94,0x0397},  {0x1F9D,0x1F95,0x0397},
  {0x1F9E,0x1F96,0x0397},  {0x1F9F,0x1F97,0x0397},
  {0x1FA8,0x1FA0,0x03A9},  {0x1FA9,0x1FA1,0x03A9},
  {0x1FAA,0x1FA2,0x03A9},  {0x1FAB,0x1FA3,0x03A9},
  {0x1FAC,0x1FA4,0x03A9},  {0x1FAD,0x1FA5,0x03A9},
  {0x1FAE,0x1FA6,0x03A9},  {0x1FAF,0x1FA7,0x03A9},
  {0x1FA8,0x1FA0,0x03A9},  {0x1FA9,0x1FA1,0x03A9},
  {0x1FAA,0x1FA2,0x03A9},  {0x1FAB,0x1FA3,0x03A9},
  {0x1FAC,0x1FA4,0x03A9},  {0x1FAD,0x1FA5,0x03A9},
  {0x1FAE,0x1FA6,0x03A9},  {0x1FAF,0x1FA7,0x03A9},
  {0x1FB8,0x1FB0,0x0391},  {0x1FB9,0x1FB1,0x0391},
  {0x1FB2,0x1FB2,0x0391},  {0x1FBC,0x1FB3,0x0391},
  {0x1FB4,0x1FB4,0x0391},  {0x1FB5,0x1FB5,0x1FB5},
  {0x1FB6,0x1FB6,0x0391},  {0x1FB7,0x1FB7,0x0391},
  {0x1FB8,0x1FB0,0x0391},  {0x1FB9,0x1FB1,0x0391},
  {0x1FBA,0x1F70,0x0391},  {0x1FBB,0x1F71,0x1FBB},
  {0x1FBC,0x1FB3,0x0391},  {0x1FBD,0x1FBD,0x1FBD},
  {0x0399,0x1FBE,0x0399},  {0x1FBF,0x1FBF,0x1FBF},
  {0x1FC0,0x1FC0,0x1FC0},  {0x1FC1,0x1FC1,0x1FC1},
  {0x1FC2,0x1FC2,0x0397},  {0x1FCC,0x1FC3,0x0397},
  {0x1FC4,0x1FC4,0x0397},  {0x1FC5,0x1FC5,0x1FC5},
  {0x1FC6,0x1FC6,0x0397},  {0x1FC7,0x1FC7,0x0397},
  {0x1FC8,0x1F72,0x0395},  {0x1FC9,0x1F73,0x1FC9},
  {0x1FCA,0x1F74,0x0397},  {0x1FCB,0x1F75,0x1FCB},
  {0x1FCC,0x1FC3,0x0397},  {0x1FCD,0x1FCD,0x1FCD},
  {0x1FCE,0x1FCE,0x1FCE},  {0x1FCF,0x1FCF,0x1FCF},
  {0x1FD8,0x1FD0,0x0399},  {0x1FD9,0x1FD1,0x0399},
  {0x1FD2,0x1FD2,0x0399},  {0x1FD3,0x1FD3,0x1FD3},
  {0x1FD4,0x1FD4,0x1FD4},  {0x1FD5,0x1FD5,0x1FD5},
  {0x1FD6,0x1FD6,0x0399},  {0x1FD7,0x1FD7,0x0399},
  {0x1FD8,0x1FD0,0x0399},  {0x1FD9,0x1FD1,0x0399},
  {0x1FDA,0x1F76,0x0399},  {0x1FDB,0x1F77,0x1FDB},
  {0x1FDC,0x1FDC,0x1FDC},  {0x1FDD,0x1FDD,0x1FDD},
  {0x1FDE,0x1FDE,0x1FDE},  {0x1FDF,0x1FDF,0x1FDF},
  {0x1FE8,0x1FE0,0x03A5},  {0x1FE9,0x1FE1,0x03A5},
  {0x1FE2,0x1FE2,0x03A5},  {0x1FE3,0x1FE3,0x1FE3},
  {0x1FE4,0x1FE4,0x03A1},  {0x1FEC,0x1FE5,0x03A1},
  {0x1FE6,0x1FE6,0x03A5},  {0x1FE7,0x1FE7,0x03A5},
  {0x1FE8,0x1FE0,0x03A5},  {0x1FE9,0x1FE1,0x03A5},
  {0x1FEA,0x1F7A,0x03A5},  {0x1FEB,0x1F7B,0x1FEB},
  {0x1FEC,0x1FE5,0x03A1},  {0x1FED,0x1FED,0x1FED},
  {0x1FEE,0x1FEE,0x1FEE},  {0x1FEF,0x1FEF,0x1FEF},
  {0x1FF0,0x1FF0,0x1FF0},  {0x1FF1,0x1FF1,0x1FF1},
  {0x1FF2,0x1FF2,0x03A9},  {0x1FFC,0x1FF3,0x03A9},
  {0x1FF4,0x1FF4,0x03A9},  {0x1FF5,0x1FF5,0x1FF5},
  {0x1FF6,0x1FF6,0x03A9},  {0x1FF7,0x1FF7,0x03A9},
  {0x1FF8,0x1F78,0x039F},  {0x1FF9,0x1F79,0x1FF9},
  {0x1FFA,0x1F7C,0x03A9},  {0x1FFB,0x1F7D,0x1FFB},
  {0x1FFC,0x1FF3,0x03A9},  {0x1FFD,0x1FFD,0x1FFD},
  {0x1FFE,0x1FFE,0x1FFE},  {0x1FFF,0x1FFF,0x1FFF}
};

static MY_UNICASE_INFO plane21[]={
  {0x2100,0x2100,0x2100},  {0x2101,0x2101,0x2101},
  {0x2102,0x2102,0x2102},  {0x2103,0x2103,0x2103},
  {0x2104,0x2104,0x2104},  {0x2105,0x2105,0x2105},
  {0x2106,0x2106,0x2106},  {0x2107,0x2107,0x2107},
  {0x2108,0x2108,0x2108},  {0x2109,0x2109,0x2109},
  {0x210A,0x210A,0x210A},  {0x210B,0x210B,0x210B},
  {0x210C,0x210C,0x210C},  {0x210D,0x210D,0x210D},
  {0x210E,0x210E,0x210E},  {0x210F,0x210F,0x210F},
  {0x2110,0x2110,0x2110},  {0x2111,0x2111,0x2111},
  {0x2112,0x2112,0x2112},  {0x2113,0x2113,0x2113},
  {0x2114,0x2114,0x2114},  {0x2115,0x2115,0x2115},
  {0x2116,0x2116,0x2116},  {0x2117,0x2117,0x2117},
  {0x2118,0x2118,0x2118},  {0x2119,0x2119,0x2119},
  {0x211A,0x211A,0x211A},  {0x211B,0x211B,0x211B},
  {0x211C,0x211C,0x211C},  {0x211D,0x211D,0x211D},
  {0x211E,0x211E,0x211E},  {0x211F,0x211F,0x211F},
  {0x2120,0x2120,0x2120},  {0x2121,0x2121,0x2121},
  {0x2122,0x2122,0x2122},  {0x2123,0x2123,0x2123},
  {0x2124,0x2124,0x2124},  {0x2125,0x2125,0x2125},
  {0x2126,0x03C9,0x2126},  {0x2127,0x2127,0x2127},
  {0x2128,0x2128,0x2128},  {0x2129,0x2129,0x2129},
  {0x212A,0x006B,0x212A},  {0x212B,0x00E5,0x212B},
  {0x212C,0x212C,0x212C},  {0x212D,0x212D,0x212D},
  {0x212E,0x212E,0x212E},  {0x212F,0x212F,0x212F},
  {0x2130,0x2130,0x2130},  {0x2131,0x2131,0x2131},
  {0x2132,0x2132,0x2132},  {0x2133,0x2133,0x2133},
  {0x2134,0x2134,0x2134},  {0x2135,0x2135,0x2135},
  {0x2136,0x2136,0x2136},  {0x2137,0x2137,0x2137},
  {0x2138,0x2138,0x2138},  {0x2139,0x2139,0x2139},
  {0x213A,0x213A,0x213A},  {0x213B,0x213B,0x213B},
  {0x213C,0x213C,0x213C},  {0x213D,0x213D,0x213D},
  {0x213E,0x213E,0x213E},  {0x213F,0x213F,0x213F},
  {0x2140,0x2140,0x2140},  {0x2141,0x2141,0x2141},
  {0x2142,0x2142,0x2142},  {0x2143,0x2143,0x2143},
  {0x2144,0x2144,0x2144},  {0x2145,0x2145,0x2145},
  {0x2146,0x2146,0x2146},  {0x2147,0x2147,0x2147},
  {0x2148,0x2148,0x2148},  {0x2149,0x2149,0x2149},
  {0x214A,0x214A,0x214A},  {0x214B,0x214B,0x214B},
  {0x214C,0x214C,0x214C},  {0x214D,0x214D,0x214D},
  {0x214E,0x214E,0x214E},  {0x214F,0x214F,0x214F},
  {0x2150,0x2150,0x2150},  {0x2151,0x2151,0x2151},
  {0x2152,0x2152,0x2152},  {0x2153,0x2153,0x2153},
  {0x2154,0x2154,0x2154},  {0x2155,0x2155,0x2155},
  {0x2156,0x2156,0x2156},  {0x2157,0x2157,0x2157},
  {0x2158,0x2158,0x2158},  {0x2159,0x2159,0x2159},
  {0x215A,0x215A,0x215A},  {0x215B,0x215B,0x215B},
  {0x215C,0x215C,0x215C},  {0x215D,0x215D,0x215D},
  {0x215E,0x215E,0x215E},  {0x215F,0x215F,0x215F},
  {0x2160,0x2170,0x2160},  {0x2161,0x2171,0x2161},
  {0x2162,0x2172,0x2162},  {0x2163,0x2173,0x2163},
  {0x2164,0x2174,0x2164},  {0x2165,0x2175,0x2165},
  {0x2166,0x2176,0x2166},  {0x2167,0x2177,0x2167},
  {0x2168,0x2178,0x2168},  {0x2169,0x2179,0x2169},
  {0x216A,0x217A,0x216A},  {0x216B,0x217B,0x216B},
  {0x216C,0x217C,0x216C},  {0x216D,0x217D,0x216D},
  {0x216E,0x217E,0x216E},  {0x216F,0x217F,0x216F},
  {0x2160,0x2170,0x2160},  {0x2161,0x2171,0x2161},
  {0x2162,0x2172,0x2162},  {0x2163,0x2173,0x2163},
  {0x2164,0x2174,0x2164},  {0x2165,0x2175,0x2165},
  {0x2166,0x2176,0x2166},  {0x2167,0x2177,0x2167},
  {0x2168,0x2178,0x2168},  {0x2169,0x2179,0x2169},
  {0x216A,0x217A,0x216A},  {0x216B,0x217B,0x216B},
  {0x216C,0x217C,0x216C},  {0x216D,0x217D,0x216D},
  {0x216E,0x217E,0x216E},  {0x216F,0x217F,0x216F},
  {0x2180,0x2180,0x2180},  {0x2181,0x2181,0x2181},
  {0x2182,0x2182,0x2182},  {0x2183,0x2183,0x2183},
  {0x2184,0x2184,0x2184},  {0x2185,0x2185,0x2185},
  {0x2186,0x2186,0x2186},  {0x2187,0x2187,0x2187},
  {0x2188,0x2188,0x2188},  {0x2189,0x2189,0x2189},
  {0x218A,0x218A,0x218A},  {0x218B,0x218B,0x218B},
  {0x218C,0x218C,0x218C},  {0x218D,0x218D,0x218D},
  {0x218E,0x218E,0x218E},  {0x218F,0x218F,0x218F},
  {0x2190,0x2190,0x2190},  {0x2191,0x2191,0x2191},
  {0x2192,0x2192,0x2192},  {0x2193,0x2193,0x2193},
  {0x2194,0x2194,0x2194},  {0x2195,0x2195,0x2195},
  {0x2196,0x2196,0x2196},  {0x2197,0x2197,0x2197},
  {0x2198,0x2198,0x2198},  {0x2199,0x2199,0x2199},
  {0x219A,0x219A,0x219A},  {0x219B,0x219B,0x219B},
  {0x219C,0x219C,0x219C},  {0x219D,0x219D,0x219D},
  {0x219E,0x219E,0x219E},  {0x219F,0x219F,0x219F},
  {0x21A0,0x21A0,0x21A0},  {0x21A1,0x21A1,0x21A1},
  {0x21A2,0x21A2,0x21A2},  {0x21A3,0x21A3,0x21A3},
  {0x21A4,0x21A4,0x21A4},  {0x21A5,0x21A5,0x21A5},
  {0x21A6,0x21A6,0x21A6},  {0x21A7,0x21A7,0x21A7},
  {0x21A8,0x21A8,0x21A8},  {0x21A9,0x21A9,0x21A9},
  {0x21AA,0x21AA,0x21AA},  {0x21AB,0x21AB,0x21AB},
  {0x21AC,0x21AC,0x21AC},  {0x21AD,0x21AD,0x21AD},
  {0x21AE,0x21AE,0x21AE},  {0x21AF,0x21AF,0x21AF},
  {0x21B0,0x21B0,0x21B0},  {0x21B1,0x21B1,0x21B1},
  {0x21B2,0x21B2,0x21B2},  {0x21B3,0x21B3,0x21B3},
  {0x21B4,0x21B4,0x21B4},  {0x21B5,0x21B5,0x21B5},
  {0x21B6,0x21B6,0x21B6},  {0x21B7,0x21B7,0x21B7},
  {0x21B8,0x21B8,0x21B8},  {0x21B9,0x21B9,0x21B9},
  {0x21BA,0x21BA,0x21BA},  {0x21BB,0x21BB,0x21BB},
  {0x21BC,0x21BC,0x21BC},  {0x21BD,0x21BD,0x21BD},
  {0x21BE,0x21BE,0x21BE},  {0x21BF,0x21BF,0x21BF},
  {0x21C0,0x21C0,0x21C0},  {0x21C1,0x21C1,0x21C1},
  {0x21C2,0x21C2,0x21C2},  {0x21C3,0x21C3,0x21C3},
  {0x21C4,0x21C4,0x21C4},  {0x21C5,0x21C5,0x21C5},
  {0x21C6,0x21C6,0x21C6},  {0x21C7,0x21C7,0x21C7},
  {0x21C8,0x21C8,0x21C8},  {0x21C9,0x21C9,0x21C9},
  {0x21CA,0x21CA,0x21CA},  {0x21CB,0x21CB,0x21CB},
  {0x21CC,0x21CC,0x21CC},  {0x21CD,0x21CD,0x21CD},
  {0x21CE,0x21CE,0x21CE},  {0x21CF,0x21CF,0x21CF},
  {0x21D0,0x21D0,0x21D0},  {0x21D1,0x21D1,0x21D1},
  {0x21D2,0x21D2,0x21D2},  {0x21D3,0x21D3,0x21D3},
  {0x21D4,0x21D4,0x21D4},  {0x21D5,0x21D5,0x21D5},
  {0x21D6,0x21D6,0x21D6},  {0x21D7,0x21D7,0x21D7},
  {0x21D8,0x21D8,0x21D8},  {0x21D9,0x21D9,0x21D9},
  {0x21DA,0x21DA,0x21DA},  {0x21DB,0x21DB,0x21DB},
  {0x21DC,0x21DC,0x21DC},  {0x21DD,0x21DD,0x21DD},
  {0x21DE,0x21DE,0x21DE},  {0x21DF,0x21DF,0x21DF},
  {0x21E0,0x21E0,0x21E0},  {0x21E1,0x21E1,0x21E1},
  {0x21E2,0x21E2,0x21E2},  {0x21E3,0x21E3,0x21E3},
  {0x21E4,0x21E4,0x21E4},  {0x21E5,0x21E5,0x21E5},
  {0x21E6,0x21E6,0x21E6},  {0x21E7,0x21E7,0x21E7},
  {0x21E8,0x21E8,0x21E8},  {0x21E9,0x21E9,0x21E9},
  {0x21EA,0x21EA,0x21EA},  {0x21EB,0x21EB,0x21EB},
  {0x21EC,0x21EC,0x21EC},  {0x21ED,0x21ED,0x21ED},
  {0x21EE,0x21EE,0x21EE},  {0x21EF,0x21EF,0x21EF},
  {0x21F0,0x21F0,0x21F0},  {0x21F1,0x21F1,0x21F1},
  {0x21F2,0x21F2,0x21F2},  {0x21F3,0x21F3,0x21F3},
  {0x21F4,0x21F4,0x21F4},  {0x21F5,0x21F5,0x21F5},
  {0x21F6,0x21F6,0x21F6},  {0x21F7,0x21F7,0x21F7},
  {0x21F8,0x21F8,0x21F8},  {0x21F9,0x21F9,0x21F9},
  {0x21FA,0x21FA,0x21FA},  {0x21FB,0x21FB,0x21FB},
  {0x21FC,0x21FC,0x21FC},  {0x21FD,0x21FD,0x21FD},
  {0x21FE,0x21FE,0x21FE},  {0x21FF,0x21FF,0x21FF}
};

static MY_UNICASE_INFO plane24[]={
  {0x2400,0x2400,0x2400},  {0x2401,0x2401,0x2401},
  {0x2402,0x2402,0x2402},  {0x2403,0x2403,0x2403},
  {0x2404,0x2404,0x2404},  {0x2405,0x2405,0x2405},
  {0x2406,0x2406,0x2406},  {0x2407,0x2407,0x2407},
  {0x2408,0x2408,0x2408},  {0x2409,0x2409,0x2409},
  {0x240A,0x240A,0x240A},  {0x240B,0x240B,0x240B},
  {0x240C,0x240C,0x240C},  {0x240D,0x240D,0x240D},
  {0x240E,0x240E,0x240E},  {0x240F,0x240F,0x240F},
  {0x2410,0x2410,0x2410},  {0x2411,0x2411,0x2411},
  {0x2412,0x2412,0x2412},  {0x2413,0x2413,0x2413},
  {0x2414,0x2414,0x2414},  {0x2415,0x2415,0x2415},
  {0x2416,0x2416,0x2416},  {0x2417,0x2417,0x2417},
  {0x2418,0x2418,0x2418},  {0x2419,0x2419,0x2419},
  {0x241A,0x241A,0x241A},  {0x241B,0x241B,0x241B},
  {0x241C,0x241C,0x241C},  {0x241D,0x241D,0x241D},
  {0x241E,0x241E,0x241E},  {0x241F,0x241F,0x241F},
  {0x2420,0x2420,0x2420},  {0x2421,0x2421,0x2421},
  {0x2422,0x2422,0x2422},  {0x2423,0x2423,0x2423},
  {0x2424,0x2424,0x2424},  {0x2425,0x2425,0x2425},
  {0x2426,0x2426,0x2426},  {0x2427,0x2427,0x2427},
  {0x2428,0x2428,0x2428},  {0x2429,0x2429,0x2429},
  {0x242A,0x242A,0x242A},  {0x242B,0x242B,0x242B},
  {0x242C,0x242C,0x242C},  {0x242D,0x242D,0x242D},
  {0x242E,0x242E,0x242E},  {0x242F,0x242F,0x242F},
  {0x2430,0x2430,0x2430},  {0x2431,0x2431,0x2431},
  {0x2432,0x2432,0x2432},  {0x2433,0x2433,0x2433},
  {0x2434,0x2434,0x2434},  {0x2435,0x2435,0x2435},
  {0x2436,0x2436,0x2436},  {0x2437,0x2437,0x2437},
  {0x2438,0x2438,0x2438},  {0x2439,0x2439,0x2439},
  {0x243A,0x243A,0x243A},  {0x243B,0x243B,0x243B},
  {0x243C,0x243C,0x243C},  {0x243D,0x243D,0x243D},
  {0x243E,0x243E,0x243E},  {0x243F,0x243F,0x243F},
  {0x2440,0x2440,0x2440},  {0x2441,0x2441,0x2441},
  {0x2442,0x2442,0x2442},  {0x2443,0x2443,0x2443},
  {0x2444,0x2444,0x2444},  {0x2445,0x2445,0x2445},
  {0x2446,0x2446,0x2446},  {0x2447,0x2447,0x2447},
  {0x2448,0x2448,0x2448},  {0x2449,0x2449,0x2449},
  {0x244A,0x244A,0x244A},  {0x244B,0x244B,0x244B},
  {0x244C,0x244C,0x244C},  {0x244D,0x244D,0x244D},
  {0x244E,0x244E,0x244E},  {0x244F,0x244F,0x244F},
  {0x2450,0x2450,0x2450},  {0x2451,0x2451,0x2451},
  {0x2452,0x2452,0x2452},  {0x2453,0x2453,0x2453},
  {0x2454,0x2454,0x2454},  {0x2455,0x2455,0x2455},
  {0x2456,0x2456,0x2456},  {0x2457,0x2457,0x2457},
  {0x2458,0x2458,0x2458},  {0x2459,0x2459,0x2459},
  {0x245A,0x245A,0x245A},  {0x245B,0x245B,0x245B},
  {0x245C,0x245C,0x245C},  {0x245D,0x245D,0x245D},
  {0x245E,0x245E,0x245E},  {0x245F,0x245F,0x245F},
  {0x2460,0x2460,0x2460},  {0x2461,0x2461,0x2461},
  {0x2462,0x2462,0x2462},  {0x2463,0x2463,0x2463},
  {0x2464,0x2464,0x2464},  {0x2465,0x2465,0x2465},
  {0x2466,0x2466,0x2466},  {0x2467,0x2467,0x2467},
  {0x2468,0x2468,0x2468},  {0x2469,0x2469,0x2469},
  {0x246A,0x246A,0x246A},  {0x246B,0x246B,0x246B},
  {0x246C,0x246C,0x246C},  {0x246D,0x246D,0x246D},
  {0x246E,0x246E,0x246E},  {0x246F,0x246F,0x246F},
  {0x2470,0x2470,0x2470},  {0x2471,0x2471,0x2471},
  {0x2472,0x2472,0x2472},  {0x2473,0x2473,0x2473},
  {0x2474,0x2474,0x2474},  {0x2475,0x2475,0x2475},
  {0x2476,0x2476,0x2476},  {0x2477,0x2477,0x2477},
  {0x2478,0x2478,0x2478},  {0x2479,0x2479,0x2479},
  {0x247A,0x247A,0x247A},  {0x247B,0x247B,0x247B},
  {0x247C,0x247C,0x247C},  {0x247D,0x247D,0x247D},
  {0x247E,0x247E,0x247E},  {0x247F,0x247F,0x247F},
  {0x2480,0x2480,0x2480},  {0x2481,0x2481,0x2481},
  {0x2482,0x2482,0x2482},  {0x2483,0x2483,0x2483},
  {0x2484,0x2484,0x2484},  {0x2485,0x2485,0x2485},
  {0x2486,0x2486,0x2486},  {0x2487,0x2487,0x2487},
  {0x2488,0x2488,0x2488},  {0x2489,0x2489,0x2489},
  {0x248A,0x248A,0x248A},  {0x248B,0x248B,0x248B},
  {0x248C,0x248C,0x248C},  {0x248D,0x248D,0x248D},
  {0x248E,0x248E,0x248E},  {0x248F,0x248F,0x248F},
  {0x2490,0x2490,0x2490},  {0x2491,0x2491,0x2491},
  {0x2492,0x2492,0x2492},  {0x2493,0x2493,0x2493},
  {0x2494,0x2494,0x2494},  {0x2495,0x2495,0x2495},
  {0x2496,0x2496,0x2496},  {0x2497,0x2497,0x2497},
  {0x2498,0x2498,0x2498},  {0x2499,0x2499,0x2499},
  {0x249A,0x249A,0x249A},  {0x249B,0x249B,0x249B},
  {0x249C,0x249C,0x249C},  {0x249D,0x249D,0x249D},
  {0x249E,0x249E,0x249E},  {0x249F,0x249F,0x249F},
  {0x24A0,0x24A0,0x24A0},  {0x24A1,0x24A1,0x24A1},
  {0x24A2,0x24A2,0x24A2},  {0x24A3,0x24A3,0x24A3},
  {0x24A4,0x24A4,0x24A4},  {0x24A5,0x24A5,0x24A5},
  {0x24A6,0x24A6,0x24A6},  {0x24A7,0x24A7,0x24A7},
  {0x24A8,0x24A8,0x24A8},  {0x24A9,0x24A9,0x24A9},
  {0x24AA,0x24AA,0x24AA},  {0x24AB,0x24AB,0x24AB},
  {0x24AC,0x24AC,0x24AC},  {0x24AD,0x24AD,0x24AD},
  {0x24AE,0x24AE,0x24AE},  {0x24AF,0x24AF,0x24AF},
  {0x24B0,0x24B0,0x24B0},  {0x24B1,0x24B1,0x24B1},
  {0x24B2,0x24B2,0x24B2},  {0x24B3,0x24B3,0x24B3},
  {0x24B4,0x24B4,0x24B4},  {0x24B5,0x24B5,0x24B5},
  {0x24B6,0x24D0,0x24B6},  {0x24B7,0x24D1,0x24B7},
  {0x24B8,0x24D2,0x24B8},  {0x24B9,0x24D3,0x24B9},
  {0x24BA,0x24D4,0x24BA},  {0x24BB,0x24D5,0x24BB},
  {0x24BC,0x24D6,0x24BC},  {0x24BD,0x24D7,0x24BD},
  {0x24BE,0x24D8,0x24BE},  {0x24BF,0x24D9,0x24BF},
  {0x24C0,0x24DA,0x24C0},  {0x24C1,0x24DB,0x24C1},
  {0x24C2,0x24DC,0x24C2},  {0x24C3,0x24DD,0x24C3},
  {0x24C4,0x24DE,0x24C4},  {0x24C5,0x24DF,0x24C5},
  {0x24C6,0x24E0,0x24C6},  {0x24C7,0x24E1,0x24C7},
  {0x24C8,0x24E2,0x24C8},  {0x24C9,0x24E3,0x24C9},
  {0x24CA,0x24E4,0x24CA},  {0x24CB,0x24E5,0x24CB},
  {0x24CC,0x24E6,0x24CC},  {0x24CD,0x24E7,0x24CD},
  {0x24CE,0x24E8,0x24CE},  {0x24CF,0x24E9,0x24CF},
  {0x24B6,0x24D0,0x24B6},  {0x24B7,0x24D1,0x24B7},
  {0x24B8,0x24D2,0x24B8},  {0x24B9,0x24D3,0x24B9},
  {0x24BA,0x24D4,0x24BA},  {0x24BB,0x24D5,0x24BB},
  {0x24BC,0x24D6,0x24BC},  {0x24BD,0x24D7,0x24BD},
  {0x24BE,0x24D8,0x24BE},  {0x24BF,0x24D9,0x24BF},
  {0x24C0,0x24DA,0x24C0},  {0x24C1,0x24DB,0x24C1},
  {0x24C2,0x24DC,0x24C2},  {0x24C3,0x24DD,0x24C3},
  {0x24C4,0x24DE,0x24C4},  {0x24C5,0x24DF,0x24C5},
  {0x24C6,0x24E0,0x24C6},  {0x24C7,0x24E1,0x24C7},
  {0x24C8,0x24E2,0x24C8},  {0x24C9,0x24E3,0x24C9},
  {0x24CA,0x24E4,0x24CA},  {0x24CB,0x24E5,0x24CB},
  {0x24CC,0x24E6,0x24CC},  {0x24CD,0x24E7,0x24CD},
  {0x24CE,0x24E8,0x24CE},  {0x24CF,0x24E9,0x24CF},
  {0x24EA,0x24EA,0x24EA},  {0x24EB,0x24EB,0x24EB},
  {0x24EC,0x24EC,0x24EC},  {0x24ED,0x24ED,0x24ED},
  {0x24EE,0x24EE,0x24EE},  {0x24EF,0x24EF,0x24EF},
  {0x24F0,0x24F0,0x24F0},  {0x24F1,0x24F1,0x24F1},
  {0x24F2,0x24F2,0x24F2},  {0x24F3,0x24F3,0x24F3},
  {0x24F4,0x24F4,0x24F4},  {0x24F5,0x24F5,0x24F5},
  {0x24F6,0x24F6,0x24F6},  {0x24F7,0x24F7,0x24F7},
  {0x24F8,0x24F8,0x24F8},  {0x24F9,0x24F9,0x24F9},
  {0x24FA,0x24FA,0x24FA},  {0x24FB,0x24FB,0x24FB},
  {0x24FC,0x24FC,0x24FC},  {0x24FD,0x24FD,0x24FD},
  {0x24FE,0x24FE,0x24FE},  {0x24FF,0x24FF,0x24FF}
};

static MY_UNICASE_INFO planeFF[]={
  {0xFF00,0xFF00,0xFF00},  {0xFF01,0xFF01,0xFF01},
  {0xFF02,0xFF02,0xFF02},  {0xFF03,0xFF03,0xFF03},
  {0xFF04,0xFF04,0xFF04},  {0xFF05,0xFF05,0xFF05},
  {0xFF06,0xFF06,0xFF06},  {0xFF07,0xFF07,0xFF07},
  {0xFF08,0xFF08,0xFF08},  {0xFF09,0xFF09,0xFF09},
  {0xFF0A,0xFF0A,0xFF0A},  {0xFF0B,0xFF0B,0xFF0B},
  {0xFF0C,0xFF0C,0xFF0C},  {0xFF0D,0xFF0D,0xFF0D},
  {0xFF0E,0xFF0E,0xFF0E},  {0xFF0F,0xFF0F,0xFF0F},
  {0xFF10,0xFF10,0xFF10},  {0xFF11,0xFF11,0xFF11},
  {0xFF12,0xFF12,0xFF12},  {0xFF13,0xFF13,0xFF13},
  {0xFF14,0xFF14,0xFF14},  {0xFF15,0xFF15,0xFF15},
  {0xFF16,0xFF16,0xFF16},  {0xFF17,0xFF17,0xFF17},
  {0xFF18,0xFF18,0xFF18},  {0xFF19,0xFF19,0xFF19},
  {0xFF1A,0xFF1A,0xFF1A},  {0xFF1B,0xFF1B,0xFF1B},
  {0xFF1C,0xFF1C,0xFF1C},  {0xFF1D,0xFF1D,0xFF1D},
  {0xFF1E,0xFF1E,0xFF1E},  {0xFF1F,0xFF1F,0xFF1F},
  {0xFF20,0xFF20,0xFF20},  {0xFF21,0xFF41,0xFF21},
  {0xFF22,0xFF42,0xFF22},  {0xFF23,0xFF43,0xFF23},
  {0xFF24,0xFF44,0xFF24},  {0xFF25,0xFF45,0xFF25},
  {0xFF26,0xFF46,0xFF26},  {0xFF27,0xFF47,0xFF27},
  {0xFF28,0xFF48,0xFF28},  {0xFF29,0xFF49,0xFF29},
  {0xFF2A,0xFF4A,0xFF2A},  {0xFF2B,0xFF4B,0xFF2B},
  {0xFF2C,0xFF4C,0xFF2C},  {0xFF2D,0xFF4D,0xFF2D},
  {0xFF2E,0xFF4E,0xFF2E},  {0xFF2F,0xFF4F,0xFF2F},
  {0xFF30,0xFF50,0xFF30},  {0xFF31,0xFF51,0xFF31},
  {0xFF32,0xFF52,0xFF32},  {0xFF33,0xFF53,0xFF33},
  {0xFF34,0xFF54,0xFF34},  {0xFF35,0xFF55,0xFF35},
  {0xFF36,0xFF56,0xFF36},  {0xFF37,0xFF57,0xFF37},
  {0xFF38,0xFF58,0xFF38},  {0xFF39,0xFF59,0xFF39},
  {0xFF3A,0xFF5A,0xFF3A},  {0xFF3B,0xFF3B,0xFF3B},
  {0xFF3C,0xFF3C,0xFF3C},  {0xFF3D,0xFF3D,0xFF3D},
  {0xFF3E,0xFF3E,0xFF3E},  {0xFF3F,0xFF3F,0xFF3F},
  {0xFF40,0xFF40,0xFF40},  {0xFF21,0xFF41,0xFF21},
  {0xFF22,0xFF42,0xFF22},  {0xFF23,0xFF43,0xFF23},
  {0xFF24,0xFF44,0xFF24},  {0xFF25,0xFF45,0xFF25},
  {0xFF26,0xFF46,0xFF26},  {0xFF27,0xFF47,0xFF27},
  {0xFF28,0xFF48,0xFF28},  {0xFF29,0xFF49,0xFF29},
  {0xFF2A,0xFF4A,0xFF2A},  {0xFF2B,0xFF4B,0xFF2B},
  {0xFF2C,0xFF4C,0xFF2C},  {0xFF2D,0xFF4D,0xFF2D},
  {0xFF2E,0xFF4E,0xFF2E},  {0xFF2F,0xFF4F,0xFF2F},
  {0xFF30,0xFF50,0xFF30},  {0xFF31,0xFF51,0xFF31},
  {0xFF32,0xFF52,0xFF32},  {0xFF33,0xFF53,0xFF33},
  {0xFF34,0xFF54,0xFF34},  {0xFF35,0xFF55,0xFF35},
  {0xFF36,0xFF56,0xFF36},  {0xFF37,0xFF57,0xFF37},
  {0xFF38,0xFF58,0xFF38},  {0xFF39,0xFF59,0xFF39},
  {0xFF3A,0xFF5A,0xFF3A},  {0xFF5B,0xFF5B,0xFF5B},
  {0xFF5C,0xFF5C,0xFF5C},  {0xFF5D,0xFF5D,0xFF5D},
  {0xFF5E,0xFF5E,0xFF5E},  {0xFF5F,0xFF5F,0xFF5F},
  {0xFF60,0xFF60,0xFF60},  {0xFF61,0xFF61,0xFF61},
  {0xFF62,0xFF62,0xFF62},  {0xFF63,0xFF63,0xFF63},
  {0xFF64,0xFF64,0xFF64},  {0xFF65,0xFF65,0xFF65},
  {0xFF66,0xFF66,0xFF66},  {0xFF67,0xFF67,0xFF67},
  {0xFF68,0xFF68,0xFF68},  {0xFF69,0xFF69,0xFF69},
  {0xFF6A,0xFF6A,0xFF6A},  {0xFF6B,0xFF6B,0xFF6B},
  {0xFF6C,0xFF6C,0xFF6C},  {0xFF6D,0xFF6D,0xFF6D},
  {0xFF6E,0xFF6E,0xFF6E},  {0xFF6F,0xFF6F,0xFF6F},
  {0xFF70,0xFF70,0xFF70},  {0xFF71,0xFF71,0xFF71},
  {0xFF72,0xFF72,0xFF72},  {0xFF73,0xFF73,0xFF73},
  {0xFF74,0xFF74,0xFF74},  {0xFF75,0xFF75,0xFF75},
  {0xFF76,0xFF76,0xFF76},  {0xFF77,0xFF77,0xFF77},
  {0xFF78,0xFF78,0xFF78},  {0xFF79,0xFF79,0xFF79},
  {0xFF7A,0xFF7A,0xFF7A},  {0xFF7B,0xFF7B,0xFF7B},
  {0xFF7C,0xFF7C,0xFF7C},  {0xFF7D,0xFF7D,0xFF7D},
  {0xFF7E,0xFF7E,0xFF7E},  {0xFF7F,0xFF7F,0xFF7F},
  {0xFF80,0xFF80,0xFF80},  {0xFF81,0xFF81,0xFF81},
  {0xFF82,0xFF82,0xFF82},  {0xFF83,0xFF83,0xFF83},
  {0xFF84,0xFF84,0xFF84},  {0xFF85,0xFF85,0xFF85},
  {0xFF86,0xFF86,0xFF86},  {0xFF87,0xFF87,0xFF87},
  {0xFF88,0xFF88,0xFF88},  {0xFF89,0xFF89,0xFF89},
  {0xFF8A,0xFF8A,0xFF8A},  {0xFF8B,0xFF8B,0xFF8B},
  {0xFF8C,0xFF8C,0xFF8C},  {0xFF8D,0xFF8D,0xFF8D},
  {0xFF8E,0xFF8E,0xFF8E},  {0xFF8F,0xFF8F,0xFF8F},
  {0xFF90,0xFF90,0xFF90},  {0xFF91,0xFF91,0xFF91},
  {0xFF92,0xFF92,0xFF92},  {0xFF93,0xFF93,0xFF93},
  {0xFF94,0xFF94,0xFF94},  {0xFF95,0xFF95,0xFF95},
  {0xFF96,0xFF96,0xFF96},  {0xFF97,0xFF97,0xFF97},
  {0xFF98,0xFF98,0xFF98},  {0xFF99,0xFF99,0xFF99},
  {0xFF9A,0xFF9A,0xFF9A},  {0xFF9B,0xFF9B,0xFF9B},
  {0xFF9C,0xFF9C,0xFF9C},  {0xFF9D,0xFF9D,0xFF9D},
  {0xFF9E,0xFF9E,0xFF9E},  {0xFF9F,0xFF9F,0xFF9F},
  {0xFFA0,0xFFA0,0xFFA0},  {0xFFA1,0xFFA1,0xFFA1},
  {0xFFA2,0xFFA2,0xFFA2},  {0xFFA3,0xFFA3,0xFFA3},
  {0xFFA4,0xFFA4,0xFFA4},  {0xFFA5,0xFFA5,0xFFA5},
  {0xFFA6,0xFFA6,0xFFA6},  {0xFFA7,0xFFA7,0xFFA7},
  {0xFFA8,0xFFA8,0xFFA8},  {0xFFA9,0xFFA9,0xFFA9},
  {0xFFAA,0xFFAA,0xFFAA},  {0xFFAB,0xFFAB,0xFFAB},
  {0xFFAC,0xFFAC,0xFFAC},  {0xFFAD,0xFFAD,0xFFAD},
  {0xFFAE,0xFFAE,0xFFAE},  {0xFFAF,0xFFAF,0xFFAF},
  {0xFFB0,0xFFB0,0xFFB0},  {0xFFB1,0xFFB1,0xFFB1},
  {0xFFB2,0xFFB2,0xFFB2},  {0xFFB3,0xFFB3,0xFFB3},
  {0xFFB4,0xFFB4,0xFFB4},  {0xFFB5,0xFFB5,0xFFB5},
  {0xFFB6,0xFFB6,0xFFB6},  {0xFFB7,0xFFB7,0xFFB7},
  {0xFFB8,0xFFB8,0xFFB8},  {0xFFB9,0xFFB9,0xFFB9},
  {0xFFBA,0xFFBA,0xFFBA},  {0xFFBB,0xFFBB,0xFFBB},
  {0xFFBC,0xFFBC,0xFFBC},  {0xFFBD,0xFFBD,0xFFBD},
  {0xFFBE,0xFFBE,0xFFBE},  {0xFFBF,0xFFBF,0xFFBF},
  {0xFFC0,0xFFC0,0xFFC0},  {0xFFC1,0xFFC1,0xFFC1},
  {0xFFC2,0xFFC2,0xFFC2},  {0xFFC3,0xFFC3,0xFFC3},
  {0xFFC4,0xFFC4,0xFFC4},  {0xFFC5,0xFFC5,0xFFC5},
  {0xFFC6,0xFFC6,0xFFC6},  {0xFFC7,0xFFC7,0xFFC7},
  {0xFFC8,0xFFC8,0xFFC8},  {0xFFC9,0xFFC9,0xFFC9},
  {0xFFCA,0xFFCA,0xFFCA},  {0xFFCB,0xFFCB,0xFFCB},
  {0xFFCC,0xFFCC,0xFFCC},  {0xFFCD,0xFFCD,0xFFCD},
  {0xFFCE,0xFFCE,0xFFCE},  {0xFFCF,0xFFCF,0xFFCF},
  {0xFFD0,0xFFD0,0xFFD0},  {0xFFD1,0xFFD1,0xFFD1},
  {0xFFD2,0xFFD2,0xFFD2},  {0xFFD3,0xFFD3,0xFFD3},
  {0xFFD4,0xFFD4,0xFFD4},  {0xFFD5,0xFFD5,0xFFD5},
  {0xFFD6,0xFFD6,0xFFD6},  {0xFFD7,0xFFD7,0xFFD7},
  {0xFFD8,0xFFD8,0xFFD8},  {0xFFD9,0xFFD9,0xFFD9},
  {0xFFDA,0xFFDA,0xFFDA},  {0xFFDB,0xFFDB,0xFFDB},
  {0xFFDC,0xFFDC,0xFFDC},  {0xFFDD,0xFFDD,0xFFDD},
  {0xFFDE,0xFFDE,0xFFDE},  {0xFFDF,0xFFDF,0xFFDF},
  {0xFFE0,0xFFE0,0xFFE0},  {0xFFE1,0xFFE1,0xFFE1},
  {0xFFE2,0xFFE2,0xFFE2},  {0xFFE3,0xFFE3,0xFFE3},
  {0xFFE4,0xFFE4,0xFFE4},  {0xFFE5,0xFFE5,0xFFE5},
  {0xFFE6,0xFFE6,0xFFE6},  {0xFFE7,0xFFE7,0xFFE7},
  {0xFFE8,0xFFE8,0xFFE8},  {0xFFE9,0xFFE9,0xFFE9},
  {0xFFEA,0xFFEA,0xFFEA},  {0xFFEB,0xFFEB,0xFFEB},
  {0xFFEC,0xFFEC,0xFFEC},  {0xFFED,0xFFED,0xFFED},
  {0xFFEE,0xFFEE,0xFFEE},  {0xFFEF,0xFFEF,0xFFEF},
  {0xFFF0,0xFFF0,0xFFF0},  {0xFFF1,0xFFF1,0xFFF1},
  {0xFFF2,0xFFF2,0xFFF2},  {0xFFF3,0xFFF3,0xFFF3},
  {0xFFF4,0xFFF4,0xFFF4},  {0xFFF5,0xFFF5,0xFFF5},
  {0xFFF6,0xFFF6,0xFFF6},  {0xFFF7,0xFFF7,0xFFF7},
  {0xFFF8,0xFFF8,0xFFF8},  {0xFFF9,0xFFF9,0xFFF9},
  {0xFFFA,0xFFFA,0xFFFA},  {0xFFFB,0xFFFB,0xFFFB},
  {0xFFFC,0xFFFC,0xFFFC},  {0xFFFD,0xFFFD,0xFFFD},
  {0xFFFE,0xFFFE,0xFFFE},  {0xFFFF,0xFFFF,0xFFFF}
};

MY_UNICASE_INFO *my_unicase_default[256]={
 plane00, plane01, plane02, plane03, plane04, plane05,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL, plane1E, plane1F,
    NULL, plane21,    NULL,    NULL, plane24,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL, planeFF

};


/*
  Turkish lower/upper mapping:
  1. LOWER(0x0049 LATIN CAPITAL LETTER I) ->
           0x0131 LATIN SMALL   LETTER DOTLESS I
  2. UPPER(0x0069 LATIN SMALL   LETTER I) ->
           0x0130 LATIN CAPITAL LETTER I WITH DOT ABOVE
*/

static MY_UNICASE_INFO turk00[]=
{
  {0x0000,0x0000,0x0000},  {0x0001,0x0001,0x0001},
  {0x0002,0x0002,0x0002},  {0x0003,0x0003,0x0003},
  {0x0004,0x0004,0x0004},  {0x0005,0x0005,0x0005},
  {0x0006,0x0006,0x0006},  {0x0007,0x0007,0x0007},
  {0x0008,0x0008,0x0008},  {0x0009,0x0009,0x0009},
  {0x000A,0x000A,0x000A},  {0x000B,0x000B,0x000B},
  {0x000C,0x000C,0x000C},  {0x000D,0x000D,0x000D},
  {0x000E,0x000E,0x000E},  {0x000F,0x000F,0x000F},
  {0x0010,0x0010,0x0010},  {0x0011,0x0011,0x0011},
  {0x0012,0x0012,0x0012},  {0x0013,0x0013,0x0013},
  {0x0014,0x0014,0x0014},  {0x0015,0x0015,0x0015},
  {0x0016,0x0016,0x0016},  {0x0017,0x0017,0x0017},
  {0x0018,0x0018,0x0018},  {0x0019,0x0019,0x0019},
  {0x001A,0x001A,0x001A},  {0x001B,0x001B,0x001B},
  {0x001C,0x001C,0x001C},  {0x001D,0x001D,0x001D},
  {0x001E,0x001E,0x001E},  {0x001F,0x001F,0x001F},
  {0x0020,0x0020,0x0020},  {0x0021,0x0021,0x0021},
  {0x0022,0x0022,0x0022},  {0x0023,0x0023,0x0023},
  {0x0024,0x0024,0x0024},  {0x0025,0x0025,0x0025},
  {0x0026,0x0026,0x0026},  {0x0027,0x0027,0x0027},
  {0x0028,0x0028,0x0028},  {0x0029,0x0029,0x0029},
  {0x002A,0x002A,0x002A},  {0x002B,0x002B,0x002B},
  {0x002C,0x002C,0x002C},  {0x002D,0x002D,0x002D},
  {0x002E,0x002E,0x002E},  {0x002F,0x002F,0x002F},
  {0x0030,0x0030,0x0030},  {0x0031,0x0031,0x0031},
  {0x0032,0x0032,0x0032},  {0x0033,0x0033,0x0033},
  {0x0034,0x0034,0x0034},  {0x0035,0x0035,0x0035},
  {0x0036,0x0036,0x0036},  {0x0037,0x0037,0x0037},
  {0x0038,0x0038,0x0038},  {0x0039,0x0039,0x0039},
  {0x003A,0x003A,0x003A},  {0x003B,0x003B,0x003B},
  {0x003C,0x003C,0x003C},  {0x003D,0x003D,0x003D},
  {0x003E,0x003E,0x003E},  {0x003F,0x003F,0x003F},
  {0x0040,0x0040,0x0040},  {0x0041,0x0061,0x0041},
  {0x0042,0x0062,0x0042},  {0x0043,0x0063,0x0043},
  {0x0044,0x0064,0x0044},  {0x0045,0x0065,0x0045},
  {0x0046,0x0066,0x0046},  {0x0047,0x0067,0x0047},
  {0x0048,0x0068,0x0048},  {0x0049,0x0131,0x0049},
  {0x004A,0x006A,0x004A},  {0x004B,0x006B,0x004B},
  {0x004C,0x006C,0x004C},  {0x004D,0x006D,0x004D},
  {0x004E,0x006E,0x004E},  {0x004F,0x006F,0x004F},
  {0x0050,0x0070,0x0050},  {0x0051,0x0071,0x0051},
  {0x0052,0x0072,0x0052},  {0x0053,0x0073,0x0053},
  {0x0054,0x0074,0x0054},  {0x0055,0x0075,0x0055},
  {0x0056,0x0076,0x0056},  {0x0057,0x0077,0x0057},
  {0x0058,0x0078,0x0058},  {0x0059,0x0079,0x0059},
  {0x005A,0x007A,0x005A},  {0x005B,0x005B,0x005B},
  {0x005C,0x005C,0x005C},  {0x005D,0x005D,0x005D},
  {0x005E,0x005E,0x005E},  {0x005F,0x005F,0x005F},
  {0x0060,0x0060,0x0060},  {0x0041,0x0061,0x0041},
  {0x0042,0x0062,0x0042},  {0x0043,0x0063,0x0043},
  {0x0044,0x0064,0x0044},  {0x0045,0x0065,0x0045},
  {0x0046,0x0066,0x0046},  {0x0047,0x0067,0x0047},
  {0x0048,0x0068,0x0048},  {0x0130,0x0069,0x0049},
  {0x004A,0x006A,0x004A},  {0x004B,0x006B,0x004B},
  {0x004C,0x006C,0x004C},  {0x004D,0x006D,0x004D},
  {0x004E,0x006E,0x004E},  {0x004F,0x006F,0x004F},
  {0x0050,0x0070,0x0050},  {0x0051,0x0071,0x0051},
  {0x0052,0x0072,0x0052},  {0x0053,0x0073,0x0053},
  {0x0054,0x0074,0x0054},  {0x0055,0x0075,0x0055},
  {0x0056,0x0076,0x0056},  {0x0057,0x0077,0x0057},
  {0x0058,0x0078,0x0058},  {0x0059,0x0079,0x0059},
  {0x005A,0x007A,0x005A},  {0x007B,0x007B,0x007B},
  {0x007C,0x007C,0x007C},  {0x007D,0x007D,0x007D},
  {0x007E,0x007E,0x007E},  {0x007F,0x007F,0x007F},
  {0x0080,0x0080,0x0080},  {0x0081,0x0081,0x0081},
  {0x0082,0x0082,0x0082},  {0x0083,0x0083,0x0083},
  {0x0084,0x0084,0x0084},  {0x0085,0x0085,0x0085},
  {0x0086,0x0086,0x0086},  {0x0087,0x0087,0x0087},
  {0x0088,0x0088,0x0088},  {0x0089,0x0089,0x0089},
  {0x008A,0x008A,0x008A},  {0x008B,0x008B,0x008B},
  {0x008C,0x008C,0x008C},  {0x008D,0x008D,0x008D},
  {0x008E,0x008E,0x008E},  {0x008F,0x008F,0x008F},
  {0x0090,0x0090,0x0090},  {0x0091,0x0091,0x0091},
  {0x0092,0x0092,0x0092},  {0x0093,0x0093,0x0093},
  {0x0094,0x0094,0x0094},  {0x0095,0x0095,0x0095},
  {0x0096,0x0096,0x0096},  {0x0097,0x0097,0x0097},
  {0x0098,0x0098,0x0098},  {0x0099,0x0099,0x0099},
  {0x009A,0x009A,0x009A},  {0x009B,0x009B,0x009B},
  {0x009C,0x009C,0x009C},  {0x009D,0x009D,0x009D},
  {0x009E,0x009E,0x009E},  {0x009F,0x009F,0x009F},
  {0x00A0,0x00A0,0x00A0},  {0x00A1,0x00A1,0x00A1},
  {0x00A2,0x00A2,0x00A2},  {0x00A3,0x00A3,0x00A3},
  {0x00A4,0x00A4,0x00A4},  {0x00A5,0x00A5,0x00A5},
  {0x00A6,0x00A6,0x00A6},  {0x00A7,0x00A7,0x00A7},
  {0x00A8,0x00A8,0x00A8},  {0x00A9,0x00A9,0x00A9},
  {0x00AA,0x00AA,0x00AA},  {0x00AB,0x00AB,0x00AB},
  {0x00AC,0x00AC,0x00AC},  {0x00AD,0x00AD,0x00AD},
  {0x00AE,0x00AE,0x00AE},  {0x00AF,0x00AF,0x00AF},
  {0x00B0,0x00B0,0x00B0},  {0x00B1,0x00B1,0x00B1},
  {0x00B2,0x00B2,0x00B2},  {0x00B3,0x00B3,0x00B3},
  {0x00B4,0x00B4,0x00B4},  {0x039C,0x00B5,0x039C},
  {0x00B6,0x00B6,0x00B6},  {0x00B7,0x00B7,0x00B7},
  {0x00B8,0x00B8,0x00B8},  {0x00B9,0x00B9,0x00B9},
  {0x00BA,0x00BA,0x00BA},  {0x00BB,0x00BB,0x00BB},
  {0x00BC,0x00BC,0x00BC},  {0x00BD,0x00BD,0x00BD},
  {0x00BE,0x00BE,0x00BE},  {0x00BF,0x00BF,0x00BF},
  {0x00C0,0x00E0,0x0041},  {0x00C1,0x00E1,0x0041},
  {0x00C2,0x00E2,0x0041},  {0x00C3,0x00E3,0x0041},
  {0x00C4,0x00E4,0x0041},  {0x00C5,0x00E5,0x0041},
  {0x00C6,0x00E6,0x00C6},  {0x00C7,0x00E7,0x0043},
  {0x00C8,0x00E8,0x0045},  {0x00C9,0x00E9,0x0045},
  {0x00CA,0x00EA,0x0045},  {0x00CB,0x00EB,0x0045},
  {0x00CC,0x00EC,0x0049},  {0x00CD,0x00ED,0x0049},
  {0x00CE,0x00EE,0x0049},  {0x00CF,0x00EF,0x0049},
  {0x00D0,0x00F0,0x00D0},  {0x00D1,0x00F1,0x004E},
  {0x00D2,0x00F2,0x004F},  {0x00D3,0x00F3,0x004F},
  {0x00D4,0x00F4,0x004F},  {0x00D5,0x00F5,0x004F},
  {0x00D6,0x00F6,0x004F},  {0x00D7,0x00D7,0x00D7},
  {0x00D8,0x00F8,0x00D8},  {0x00D9,0x00F9,0x0055},
  {0x00DA,0x00FA,0x0055},  {0x00DB,0x00FB,0x0055},
  {0x00DC,0x00FC,0x0055},  {0x00DD,0x00FD,0x0059},
  {0x00DE,0x00FE,0x00DE},  {0x00DF,0x00DF,0x00DF},
  {0x00C0,0x00E0,0x0041},  {0x00C1,0x00E1,0x0041},
  {0x00C2,0x00E2,0x0041},  {0x00C3,0x00E3,0x0041},
  {0x00C4,0x00E4,0x0041},  {0x00C5,0x00E5,0x0041},
  {0x00C6,0x00E6,0x00C6},  {0x00C7,0x00E7,0x0043},
  {0x00C8,0x00E8,0x0045},  {0x00C9,0x00E9,0x0045},
  {0x00CA,0x00EA,0x0045},  {0x00CB,0x00EB,0x0045},
  {0x00CC,0x00EC,0x0049},  {0x00CD,0x00ED,0x0049},
  {0x00CE,0x00EE,0x0049},  {0x00CF,0x00EF,0x0049},
  {0x00D0,0x00F0,0x00D0},  {0x00D1,0x00F1,0x004E},
  {0x00D2,0x00F2,0x004F},  {0x00D3,0x00F3,0x004F},
  {0x00D4,0x00F4,0x004F},  {0x00D5,0x00F5,0x004F},
  {0x00D6,0x00F6,0x004F},  {0x00F7,0x00F7,0x00F7},
  {0x00D8,0x00F8,0x00D8},  {0x00D9,0x00F9,0x0055},
  {0x00DA,0x00FA,0x0055},  {0x00DB,0x00FB,0x0055},
  {0x00DC,0x00FC,0x0055},  {0x00DD,0x00FD,0x0059},
  {0x00DE,0x00FE,0x00DE},  {0x0178,0x00FF,0x0059}
};



MY_UNICASE_INFO *my_unicase_turkish[256]=
{
  turk00, plane01, plane02, plane03, plane04, plane05,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL, plane1E, plane1F,
    NULL, plane21,    NULL,    NULL, plane24,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL, planeFF
};



/**
  Compare string against string with wildcard
  This function is used for utf8mb3, utf8mb4, ucs2, utf16, utf32

  @param cs Character set.
  @str      String.
  @str_end  End of string.
  @wildstr  Wildcard pattern.
  @wildend  End of wildcard pattern.
  @escape   Escape characters, typically \\.
  @w_one    "One character", typically _.
  @w_many   "Many characters", typically %.

  @return Comparison result.
    @retval  0 if matched.
    @retval -1 if not matched with wildcard.
    @retval  1 if matched with wildcard.
*/

int my_wildcmp_unicode(const CHARSET_INFO * const cs,
		       const char *str,const char *str_end,
		       const char *wildstr,const char *wildend,
		       int escape, int w_one, int w_many,
		       MY_UNICASE_INFO **weights)
{
  int result= -1;			/* Not found, using wildcards */
  my_wc_t s_wc=0, w_wc=0;
  int scan, plane;
  my_charset_conv_mb_wc mb_wc;
  mb_wc= cs->cset->mb_wc;

  while (wildstr != wildend)
  {
    while (1)
    {
      bool escaped= 0;
      if ((scan= mb_wc(cs, &w_wc, (const unsigned char*)wildstr,
                       (const unsigned char*)wildend)) <= 0)
        return 1;

      if (w_wc == (my_wc_t)w_many)
      {
        result= 1;				/* Found an anchor char */
        break;
      }

      wildstr+= scan;
      if (w_wc ==  (my_wc_t)escape && wildstr < wildend)
      {
        if ((scan= mb_wc(cs, &w_wc, (const unsigned char*)wildstr,
                         (const unsigned char*)wildend)) <= 0)
          return 1;
        wildstr+= scan;
        escaped= 1;
      }

      if ((scan= mb_wc(cs, &s_wc, (const unsigned char*)str,
                       (const unsigned char*)str_end)) <= 0)
        return 1;
      str+= scan;

      if (!escaped && w_wc == (my_wc_t)w_one)
      {
        result= 1;				/* Found an anchor char */
      }
      else
      {
        if (weights)
        {
          if (s_wc < 0x10000)
          {
            plane=(s_wc>>8) & 0xFF;
            s_wc = weights[plane] ? weights[plane][s_wc & 0xFF].sort : s_wc;
          }
          if (w_wc < 0x10000)
          {
            plane=(w_wc>>8) & 0xFF;
            w_wc = weights[plane] ? weights[plane][w_wc & 0xFF].sort : w_wc;
          }
        }
        if (s_wc != w_wc)
          return 1;				/* No match */
      }
      if (wildstr == wildend)
	return (str != str_end);		/* Match if both are at end */
    }


    if (w_wc == (my_wc_t)w_many)
    {						/* Found w_many */

      /* Remove any '%' and '_' from the wild search string */
      for (; wildstr != wildend ;)
      {
        if ((scan= mb_wc(cs, &w_wc, (const unsigned char*)wildstr,
                         (const unsigned char*)wildend)) <= 0)
          return 1;

	if (w_wc == (my_wc_t)w_many)
	{
	  wildstr+= scan;
	  continue;
	}

	if (w_wc == (my_wc_t)w_one)
	{
	  wildstr+= scan;
          if ((scan= mb_wc(cs, &s_wc, (const unsigned char*)str,
                           (const unsigned char*)str_end)) <=0)
            return 1;
          str+= scan;
	  continue;
	}
	break;					/* Not a wild character */
      }

      if (wildstr == wildend)
	return 0;				/* Ok if w_many is last */

      if (str == str_end)
	return -1;

      if ((scan= mb_wc(cs, &w_wc, (const unsigned char*)wildstr,
                       (const unsigned char*)wildend)) <=0)
        return 1;
      wildstr+= scan;

      if (w_wc ==  (my_wc_t)escape)
      {
        if (wildstr < wildend)
        {
          if ((scan= mb_wc(cs, &w_wc, (const unsigned char*)wildstr,
                           (const unsigned char*)wildend)) <=0)
            return 1;
          wildstr+= scan;
        }
      }

      while (1)
      {
        /* Skip until the first character from wildstr is found */
        while (str != str_end)
        {
          if ((scan= mb_wc(cs, &s_wc, (const unsigned char*)str,
                           (const unsigned char*)str_end)) <=0)
            return 1;
          if (weights)
          {
            plane=(s_wc>>8) & 0xFF;
            s_wc = weights[plane] ? weights[plane][s_wc & 0xFF].sort : s_wc;
            plane=(w_wc>>8) & 0xFF;
            w_wc = weights[plane] ? weights[plane][w_wc & 0xFF].sort : w_wc;
          }

          if (s_wc == w_wc)
            break;
          str+= scan;
        }
        if (str == str_end)
          return -1;

        str+= scan;
        result= my_wildcmp_unicode(cs, str, str_end, wildstr, wildend,
                                   escape, w_one, w_many,
                                   weights);
        if (result <= 0)
          return result;
      }
    }
  }
  return (str != str_end ? 1 : 0);
}


int make_escape_code(const CHARSET_INFO * const cs, const char *escape)
{
  my_charset_conv_mb_wc mb_wc= cs->cset->mb_wc;
  my_wc_t escape_wc;
  int rc= mb_wc(cs, &escape_wc,
                (const unsigned char*) escape,
                (const unsigned char*) escape + strlen(escape));
  return (int)(rc > 0 ? escape_wc : '\\');
}

/*
  We consider bytes with code more than 127 as a letter.
  This garantees that word boundaries work fine with regular
  expressions. Note, there is no need to mark byte 255  as a
  letter, it is illegal byte in UTF8.
*/
static unsigned char ctype_utf8mb4[]=
{
    0,
   32, 32, 32, 32, 32, 32, 32, 32, 32, 40, 40, 40, 40, 40, 32, 32,
   32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
   72, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  132,132,132,132,132,132,132,132,132,132, 16, 16, 16, 16, 16, 16,
   16,129,129,129,129,129,129,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 16, 16, 16, 16,
   16,130,130,130,130,130,130,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, 16, 16, 16, 16, 32,
    3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
    3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
    3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
    3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
    3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
    3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
    3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
    3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0
};


static unsigned char to_lower_utf8mb4[]=
{
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
   16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
   32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
   48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
   64, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,
  112,113,114,115,116,117,118,119,120,121,122, 91, 92, 93, 94, 95,
   96, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,
  112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
  128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
  144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
  160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
  176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
  192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
  208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
  224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
  240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255
};


static unsigned char to_upper_utf8mb4[]=
{
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
   16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
   32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
   48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
   64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
   80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
   96, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
   80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90,123,124,125,126,127,
  128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
  144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
  160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
  176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
  192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
  208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
  224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
  240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255
};


static inline int
bincmp_utf8mb4(const unsigned char *s, const unsigned char *se,
               const unsigned char *t, const unsigned char *te)
{
  int slen= (int) (se - s), tlen= (int) (te - t);
  int len= min(slen, tlen);
  int cmp= memcmp(s, t, len);
  return cmp ? cmp : slen - tlen;
}


int
my_mb_wc_utf8mb4(const CHARSET_INFO * const,
                 my_wc_t * pwc, const unsigned char *s, const unsigned char *e)
{
  unsigned char c;

  if (s >= e)
    return MY_CS_TOOSMALL;

  c= s[0];
  if (c < 0x80)
  {
    *pwc= c;
    return 1;
  }
  else if (c < 0xc2)
    return MY_CS_ILSEQ;
  else if (c < 0xe0)
  {
    if (s + 2 > e) /* We need 2 characters */
      return MY_CS_TOOSMALL2;

    if (!((s[1] ^ 0x80) < 0x40))
      return MY_CS_ILSEQ;

    *pwc= ((my_wc_t) (c & 0x1f) << 6) | (my_wc_t) (s[1] ^ 0x80);
    return 2;
  }
  else if (c < 0xf0)
  {
    if (s + 3 > e) /* We need 3 characters */
      return MY_CS_TOOSMALL3;

    if (!((s[1] ^ 0x80) < 0x40 && (s[2] ^ 0x80) < 0x40 &&
          (c >= 0xe1 || s[1] >= 0xa0)))
      return MY_CS_ILSEQ;

    *pwc= ((my_wc_t) (c & 0x0f) << 12)   |
          ((my_wc_t) (s[1] ^ 0x80) << 6) |
           (my_wc_t) (s[2] ^ 0x80);
    return 3;
  }
  else if (c < 0xf8)
  {
    if (s + 4 > e) /* We need 4 characters */
      return MY_CS_TOOSMALL4;

    if (!((s[1] ^ 0x80) < 0x40 &&
          (s[2] ^ 0x80) < 0x40 &&
          (s[3] ^ 0x80) < 0x40 &&
          (c >= 0xf1 || s[1] >= 0x90)))
      return MY_CS_ILSEQ;
    *pwc = ((my_wc_t) (c & 0x07) << 18)    |
           ((my_wc_t) (s[1] ^ 0x80) << 12) |
           ((my_wc_t) (s[2] ^ 0x80) << 6)  |
            (my_wc_t) (s[3] ^ 0x80);
    return 4;
  }
  return MY_CS_ILSEQ;
}


/*
  The same as above, but without range check
  for example, for a null-terminated string
*/
static int
my_mb_wc_utf8mb4_no_range(const CHARSET_INFO * const,
                          my_wc_t *pwc, const unsigned char *s)
{
  unsigned char c;

  c= s[0];
  if (c < 0x80)
  {
    *pwc = c;
    return 1;
  }

  if (c < 0xc2)
    return MY_CS_ILSEQ;

  if (c < 0xe0)
  {
    if (!((s[1] ^ 0x80) < 0x40))
      return MY_CS_ILSEQ;

    *pwc = ((my_wc_t) (c & 0x1f) << 6) | (my_wc_t) (s[1] ^ 0x80);
    return 2;
  }

  if (c < 0xf0)
  {
    if (!((s[1] ^ 0x80) < 0x40 &&
          (s[2] ^ 0x80) < 0x40 &&
          (c >= 0xe1 || s[1] >= 0xa0)))
      return MY_CS_ILSEQ;
    *pwc= ((my_wc_t) (c & 0x0f) << 12)   |
          ((my_wc_t) (s[1] ^ 0x80) << 6) |
           (my_wc_t) (s[2] ^ 0x80);

    return 3;
  }
  else if (c < 0xf8)
  {
    if (!((s[1] ^ 0x80) < 0x40 &&
          (s[2] ^ 0x80) < 0x40 &&
          (s[3] ^ 0x80) < 0x40 &&
          (c >= 0xf1 || s[1] >= 0x90)))
      return MY_CS_ILSEQ;
    *pwc = ((my_wc_t) (c & 0x07) << 18)    |
           ((my_wc_t) (s[1] ^ 0x80) << 12) |
           ((my_wc_t) (s[2] ^ 0x80) << 6)  |
            (my_wc_t) (s[3] ^ 0x80);
    return 4;
  }
  return MY_CS_ILSEQ;
}


int
my_wc_mb_utf8mb4(const CHARSET_INFO * const,
                 my_wc_t wc, unsigned char *r, unsigned char *e)
{
  int count;

  if (r >= e)
    return MY_CS_TOOSMALL;

  if (wc < 0x80)
    count= 1;
  else if (wc < 0x800)
    count= 2;
  else if (wc < 0x10000)
    count= 3;
  else if (wc < 0x200000)
    count= 4;
  else return MY_CS_ILUNI;

  if (r + count > e)
    return my_cs_toosmalln(count);

  switch (count) {
    /* Fall through all cases!!! */
    case 4: r[3] = (unsigned char) (0x80 | (wc & 0x3f)); wc = wc >> 6; wc |= 0x10000;
    case 3: r[2] = (unsigned char) (0x80 | (wc & 0x3f)); wc = wc >> 6; wc |= 0x800;
    case 2: r[1] = (unsigned char) (0x80 | (wc & 0x3f)); wc = wc >> 6; wc |= 0xc0;
    case 1: r[0] = (unsigned char) wc;
  }
  return count;
}


/*
  The same as above, but without range check.
*/
static int
my_wc_mb_utf8mb4_no_range(const CHARSET_INFO * const,
                          my_wc_t wc, unsigned char *r)
{
  int count;

  if (wc < 0x80)
    count= 1;
  else if (wc < 0x800)
    count= 2;
  else if (wc < 0x10000)
    count= 3;
  else if (wc < 0x200000)
    count= 4;
  else
    return MY_CS_ILUNI;

  switch (count)
  {
    /* Fall through all cases!!! */
    case 4: r[3]= (unsigned char) (0x80 | (wc & 0x3f)); wc= wc >> 6; wc |= 0x10000;
    case 3: r[2]= (unsigned char) (0x80 | (wc & 0x3f)); wc= wc >> 6; wc |= 0x800;
    case 2: r[1]= (unsigned char) (0x80 | (wc & 0x3f)); wc= wc >> 6; wc |= 0xc0;
    case 1: r[0]= (unsigned char) wc;
  }
  return count;
}


#define REPLACEMENT_CHAR 0xFFFD;


static inline void
my_tolower_utf8mb4(MY_UNICASE_INFO **uni_plane, my_wc_t *wc)
{
  int page= *wc >> 8;
  if (page < 256 && uni_plane[page])
    *wc= uni_plane[page][*wc & 0xFF].tolower;
}


static inline void
my_toupper_utf8mb4(MY_UNICASE_INFO **uni_plane, my_wc_t *wc)
{
  int page= *wc >> 8;
  if (page < 256 && uni_plane[page])
    *wc= uni_plane[page][*wc & 0xFF].toupper;
}


static inline void
my_tosort_utf8mb4(MY_UNICASE_INFO **uni_plane, my_wc_t *wc)
{
  int page= *wc >> 8;
  if (page < 256)
  {
    if (uni_plane[page])
      *wc= uni_plane[page][*wc & 0xFF].sort;
  }
  else
  {
    *wc= REPLACEMENT_CHAR;
  }
}


size_t
my_caseup_utf8mb4(const CHARSET_INFO * const cs, char *src, size_t srclen,
                  char *dst, size_t dstlen)
{
  my_wc_t wc;
  int srcres, dstres;
  char *srcend= src + srclen, *dstend= dst + dstlen, *dst0= dst;
  MY_UNICASE_INFO **uni_plane= cs->caseinfo;
  assert(src != dst || cs->caseup_multiply == 1);

  while ((src < srcend) &&
         (srcres= my_mb_wc_utf8mb4(cs, &wc,
                                   (unsigned char *) src, (unsigned char*) srcend)) > 0)
  {
    my_toupper_utf8mb4(uni_plane, &wc);
    if ((dstres= my_wc_mb_utf8mb4(cs, wc, (unsigned char*) dst, (unsigned char*) dstend)) <= 0)
      break;
    src+= srcres;
    dst+= dstres;
  }
  return (size_t) (dst - dst0);
}


static inline void
my_hash_add(uint32_t *n1, uint32_t *n2, uint32_t ch)
{
  n1[0]^= (((n1[0] & 63) + n2[0]) * (ch)) + (n1[0] << 8);
  n2[0]+= 3;
}


void my_hash_sort_utf8mb4(const CHARSET_INFO * const cs,
                          const unsigned char *s, size_t slen,
                          uint32_t *n1, uint32_t *n2)
{
  my_wc_t wc;
  int res;
  const unsigned char *e= s + slen;
  MY_UNICASE_INFO **uni_plane= cs->caseinfo;

  /*
    Remove end space. We do this to be able to compare
    'A ' and 'A' as identical
  */
  while (e > s && e[-1] == ' ')
    e--;

  while ((res= my_mb_wc_utf8mb4(cs, &wc, (const unsigned char*) s, (const unsigned char*) e)) > 0)
  {
    my_tosort_utf8mb4(uni_plane, &wc);
    my_hash_add(n1, n2, (uint32_t) (wc & 0xFF));
    my_hash_add(n1, n2, (uint32_t) (wc >> 8)  & 0xFF);
    if (wc > 0xFFFF)
    {
       /*
        Put the highest byte only if it is non-zero,
        to make hash functions for utf8mb3 and utf8mb4
        compatible for BMP characters.
        This is useful to keep order of records in
        test results, e.g. for "SHOW GRANTS".
      */
      my_hash_add(n1, n2, (uint32_t) (wc >> 16) & 0xFF);
    }
    s+= res;
  }
}


size_t
my_caseup_str_utf8mb4(const CHARSET_INFO * const cs, char *src)
{
  my_wc_t wc;
  int srcres, dstres;
  char *dst= src, *dst0= src;
  MY_UNICASE_INFO **uni_plane= cs->caseinfo;
  assert(cs->caseup_multiply == 1);

  while (*src &&
         (srcres= my_mb_wc_utf8mb4_no_range(cs, &wc, (unsigned char *) src)) > 0)
  {
    my_toupper_utf8mb4(uni_plane, &wc);
    if ((dstres= my_wc_mb_utf8mb4_no_range(cs, wc, (unsigned char*) dst)) <= 0)
      break;
    src+= srcres;
    dst+= dstres;
  }
  *dst= '\0';
  return (size_t) (dst - dst0);
}


size_t
my_casedn_utf8mb4(const CHARSET_INFO * const cs,
                  char *src, size_t srclen,
                  char *dst, size_t dstlen)
{
  my_wc_t wc;
  int srcres, dstres;
  char *srcend= src + srclen, *dstend= dst + dstlen, *dst0= dst;
  MY_UNICASE_INFO **uni_plane= cs->caseinfo;
  assert(src != dst || cs->casedn_multiply == 1);

  while ((src < srcend) &&
         (srcres= my_mb_wc_utf8mb4(cs, &wc,
                                   (unsigned char*) src, (unsigned char*) srcend)) > 0)
  {
    my_tolower_utf8mb4(uni_plane, &wc);
    if ((dstres= my_wc_mb_utf8mb4(cs, wc, (unsigned char*) dst, (unsigned char*) dstend)) <= 0)
      break;
    src+= srcres;
    dst+= dstres;
  }
  return (size_t) (dst - dst0);
}


size_t
my_casedn_str_utf8mb4(const CHARSET_INFO * const cs, char *src)
{
  my_wc_t wc;
  int srcres, dstres;
  char *dst= src, *dst0= src;
  MY_UNICASE_INFO **uni_plane= cs->caseinfo;
  assert(cs->casedn_multiply == 1);

  while (*src &&
         (srcres= my_mb_wc_utf8mb4_no_range(cs, &wc, (unsigned char *) src)) > 0)
  {
    my_tolower_utf8mb4(uni_plane, &wc);
    if ((dstres= my_wc_mb_utf8mb4_no_range(cs, wc, (unsigned char*) dst)) <= 0)
      break;
    src+= srcres;
    dst+= dstres;
  }

  /*
   In rare cases lower string can be shorter than
   the original string, for example:

   "U+0130 LATIN CAPITAL LETTER I WITH DOT ABOVE"
   (which is 0xC4B0 in utf8, i.e. two bytes)

   is converted into

   "U+0069 LATIN SMALL LETTER I"
   (which is 0x69 in utf8, i.e. one byte)

   So, we need to put '\0' terminator after converting.
  */

  *dst= '\0';
  return (size_t) (dst - dst0);
}


int
my_strnncoll_utf8mb4(const CHARSET_INFO * const cs,
                     const unsigned char *s, size_t slen,
                     const unsigned char *t, size_t tlen,
                     bool t_is_prefix)
{
  my_wc_t s_wc=0;
  my_wc_t t_wc=0;
  const unsigned char *se= s + slen;
  const unsigned char *te= t + tlen;
  MY_UNICASE_INFO **uni_plane= cs->caseinfo;

  while ( s < se && t < te )
  {
    int s_res= my_mb_wc_utf8mb4(cs, &s_wc, s, se);
    int t_res= my_mb_wc_utf8mb4(cs, &t_wc, t, te);

    if ( s_res <= 0 || t_res <= 0 )
    {
      /* Incorrect string, compare bytewise */
      return bincmp_utf8mb4(s, se, t, te);
    }

    my_tosort_utf8mb4(uni_plane, &s_wc);
    my_tosort_utf8mb4(uni_plane, &t_wc);

    if ( s_wc != t_wc )
    {
      return s_wc > t_wc ? 1 : -1;
    }

    s+= s_res;
    t+= t_res;
  }
  return (int) (t_is_prefix ? (t - te) : ((se - s) - (te - t)));
}


/**
  Compare strings, discarding end space

  If one string is shorter as the other, then we space extend the other
  so that the strings have equal length.

  This will ensure that the following things hold:

    "a"  == "a "
    "a\0" < "a"
    "a\0" < "a "

  @param  cs        Character set pinter.
  @param  a         First string to compare.
  @param  a_length  Length of 'a'.
  @param  b         Second string to compare.
  @param  b_length  Length of 'b'.
  @param  diff_if_only_endspace_difference
                    Set to 1 if the strings should be regarded as different
                    if they only difference in end space

  @return Comparison result.
    @retval Negative number, if a less than b.
    @retval 0, if a is equal to b
    @retval Positive number, if a > b
*/

int
my_strnncollsp_utf8mb4(const CHARSET_INFO * const cs,
                       const unsigned char *s, size_t slen,
                       const unsigned char *t, size_t tlen,
                       bool diff_if_only_endspace_difference)
{
  int res;
  my_wc_t s_wc=0;
  my_wc_t t_wc=0;
  const unsigned char *se= s + slen, *te= t + tlen;
  MY_UNICASE_INFO **uni_plane= cs->caseinfo;

#ifndef VARCHAR_WITH_DIFF_ENDSPACE_ARE_DIFFERENT_FOR_UNIQUE
  diff_if_only_endspace_difference= false;
#endif

  while ( s < se && t < te )
  {
    int s_res= my_mb_wc_utf8mb4(cs, &s_wc, s, se);
    int t_res= my_mb_wc_utf8mb4(cs, &t_wc, t, te);

    if ( s_res <= 0 || t_res <= 0 )
    {
      /* Incorrect string, compare bytewise */
      return bincmp_utf8mb4(s, se, t, te);
    }

    my_tosort_utf8mb4(uni_plane, &s_wc);
    my_tosort_utf8mb4(uni_plane, &t_wc);

    if ( s_wc != t_wc )
    {
      return s_wc > t_wc ? 1 : -1;
    }

    s+=s_res;
    t+=t_res;
  }

  slen= (size_t) (se-s);
  tlen= (size_t) (te-t);
  res= 0;

  if (slen != tlen)
  {
    int swap= 1;
    if (diff_if_only_endspace_difference)
      res= 1;                                   /* Assume 'a' is bigger */
    if (slen < tlen)
    {
      slen= tlen;
      s= t;
      se= te;
      swap= -1;
      res= -res;
    }
    /*
      This following loop uses the fact that in UTF-8
      all multibyte characters are greater than space,
      and all multibyte head characters are greater than
      space. It means if we meet a character greater
      than space, it always means that the longer string
      is greater. So we can reuse the same loop from the
      8bit version, without having to process full multibute
      sequences.
    */
    for ( ; s < se; s++)
    {
      if (*s != ' ')
	return (*s < ' ') ? -swap : swap;
    }
  }
  return res;
}


/**
  Compare 0-terminated UTF8 strings.

  @param  cs                  character set handler
  @param  s                   First 0-terminated string to compare
  @param  t                   Second 0-terminated string to compare

  @return Comparison result.
    @retval negative number if s < t
    @retval positive number if s > t
    @retval 0 is the strings are equal
*/

int my_strcasecmp_utf8mb4(const CHARSET_INFO * const cs,
                          const char *s, const char *t)
{
  MY_UNICASE_INFO **uni_plane= cs->caseinfo;
  while (s[0] && t[0])
  {
    my_wc_t s_wc,t_wc;

    if ((unsigned char) s[0] < 128)
    {
      /*
        s[0] is between 0 and 127.
        It represents a single byte character.
        Convert it into weight according to collation.
      */
      s_wc= plane00[(unsigned char) s[0]].tolower;
      s++;
    }
    else
    {
      int res= my_mb_wc_utf8mb4_no_range(cs, &s_wc, (const unsigned char*) s);

      /*
         In the case of wrong multibyte sequence we will
         call strcmp() for byte-to-byte comparison.
      */
      if (res <= 0)
        return strcmp(s, t);
      s+= res;

      my_tolower_utf8mb4(uni_plane, &s_wc);
    }


    /* Do the same for the second string */

    if ((unsigned char) t[0] < 128)
    {
      /* Convert single byte character into weight */
      t_wc= plane00[(unsigned char) t[0]].tolower;
      t++;
    }
    else
    {
      int res= my_mb_wc_utf8mb4_no_range(cs, &t_wc, (const unsigned char*) t);
      if (res <= 0)
        return strcmp(s, t);
      t+= res;

      my_tolower_utf8mb4(uni_plane, &t_wc);
    }

    /* Now we have two weights, let's compare them */
    if ( s_wc != t_wc )
      return  ((int) s_wc) - ((int) t_wc);
  }
  return ((int) (unsigned char) s[0]) - ((int) (unsigned char) t[0]);
}


int
my_wildcmp_utf8mb4(const CHARSET_INFO * const cs,
                   const char *str, const char *strend,
                   const char *wildstr, const char *wildend,
                   int escape, int w_one, int w_many)
{
  return my_wildcmp_unicode(cs, str, strend, wildstr, wildend,
                            escape, w_one, w_many, cs->caseinfo);
}


size_t
my_strnxfrmlen_utf8mb4(const CHARSET_INFO * const, size_t len)
{
  /* TODO: fix when working on WL "Unicode new version" */
  return (len * 2 + 2) / 4;
}


size_t
my_strnxfrm_utf8mb4(const CHARSET_INFO * const cs,
                    unsigned char *dst, size_t dstlen, uint32_t nweights,
                    const unsigned char *src, size_t srclen, uint32_t flags)
{
  my_wc_t wc;
  int res;
  unsigned char *dst0= dst;
  unsigned char *de= dst + dstlen;
  unsigned char *de_beg= de - 1;
  const unsigned char *se = src + srclen;
  MY_UNICASE_INFO **uni_plane= (cs->state & MY_CS_BINSORT) ?
                                NULL : cs->caseinfo;

  for (; dst < de_beg && nweights; nweights--)
  {
    if ((res= my_mb_wc_utf8mb4(cs,&wc, src, se)) <= 0)
      break;
    src+=res;

    if (uni_plane)
      my_tosort_utf8mb4(uni_plane, &wc);

    *dst++= (unsigned char)(wc >> 8);
    *dst++= (unsigned char)(wc & 0xFF);

  }

  if (dst < de && nweights && (flags & MY_STRXFRM_PAD_WITH_SPACE))
  {
    /* Fill the tail with keys for space character */
    for (; dst < de_beg && nweights; nweights--)
    {
      *dst++= 0x00;
      *dst++= 0x20;
    }

    if (dst < de)  /* Clear the last byte, if "dstlen" was an odd number */
      *dst++= 0x00;
  }
  my_strxfrm_desc_and_reverse(dst0, dst, flags, 0);
  return dst - dst0;
}


unsigned int my_ismbchar_utf8mb4(const CHARSET_INFO * const cs,
                                 const char *b, const char *e)
{
  my_wc_t wc;
  int res= my_mb_wc_utf8mb4(cs,&wc, (const unsigned char*)b, (const unsigned char*)e);
  return (res > 1) ? res : 0;
}


unsigned int my_mbcharlen_utf8mb4(const CHARSET_INFO * const, uint32_t c)
{
  if (c < 0x80)
    return 1;
  if (c < 0xc2)
    return 0; /* Illegal mb head */
  if (c < 0xe0)
    return 2;
  if (c < 0xf0)
    return 3;
  if (c < 0xf8)
    return 4;
  return 0; /* Illegal mb head */;
}


static MY_COLLATION_HANDLER my_collation_utf8mb4_general_ci_handler=
{
  NULL,               /* init */
  my_strnncoll_utf8mb4,
  my_strnncollsp_utf8mb4,
  my_strnxfrm_utf8mb4,
  my_strnxfrmlen_utf8mb4,
  my_like_range_mb,
  my_wildcmp_utf8mb4,
  my_strcasecmp_utf8mb4,
  my_instr_mb,
  my_hash_sort_utf8mb4,
  my_propagate_complex
};


static MY_COLLATION_HANDLER my_collation_utf8mb4_bin_handler =
{
    NULL,		/* init */
    my_strnncoll_mb_bin,
    my_strnncollsp_mb_bin,
    my_strnxfrm_utf8mb4,
    my_strnxfrmlen_utf8mb4,
    my_like_range_mb,
    my_wildcmp_mb_bin,
    my_strcasecmp_mb_bin,
    my_instr_mb,
    my_hash_sort_mb_bin,
    my_propagate_simple
};


MY_CHARSET_HANDLER my_charset_utf8mb4_handler=
{
  NULL,               /* init */
  my_ismbchar_utf8mb4,
  my_mbcharlen_utf8mb4,
  my_numchars_mb,
  my_charpos_mb,
  my_well_formed_len_mb,
  my_lengthsp_8bit,
  my_numcells_mb,
  my_mb_wc_utf8mb4,
  my_wc_mb_utf8mb4,
  my_mb_ctype_mb,
  my_caseup_str_utf8mb4,
  my_casedn_str_utf8mb4,
  my_caseup_utf8mb4,
  my_casedn_utf8mb4,
  my_snprintf_8bit,
  my_long10_to_str_8bit,
  my_int64_t10_to_str_8bit,
  my_fill_8bit,
  my_strntol_8bit,
  my_strntoul_8bit,
  my_strntoll_8bit,
  my_strntoull_8bit,
  my_strntod_8bit,
  my_strtoll10_8bit,
  my_strntoull10rnd_8bit,
  my_scan_8bit
};



DRIZZLED_API CHARSET_INFO my_charset_utf8mb4_general_ci=
{
  45,0,0,              /* number       */
  MY_CS_COMPILED|MY_CS_PRIMARY|MY_CS_STRNXFRM|MY_CS_UNICODE,  /* state  */
  MY_UTF8MB4,         /* cs name      */
  MY_UTF8MB4_GENERAL_CI,/* name       */
  "UTF-8 Unicode",    /* comment      */
  NULL,               /* tailoring    */
  ctype_utf8mb4,      /* ctype        */
  to_lower_utf8mb4,   /* to_lower     */
  to_upper_utf8mb4,   /* to_upper     */
  to_upper_utf8mb4,   /* sort_order   */
  NULL,               /* contractions */
  NULL,               /* sort_order_big*/
  NULL,               /* tab_to_uni   */
  NULL,               /* tab_from_uni */
  my_unicase_default, /* caseinfo     */
  NULL,               /* state_map    */
  NULL,               /* ident_map    */
  1,                  /* strxfrm_multiply */
  1,                  /* caseup_multiply  */
  1,                  /* casedn_multiply  */
  1,                  /* mbminlen     */
  4,                  /* mbmaxlen     */
  0,                  /* min_sort_char */
  0xFFFF,             /* max_sort_char */
  ' ',                /* pad char      */
  0,                  /* escape_with_backslash_is_dangerous */
  1,                  /* levels_for_compare */
  1,                  /* levels_for_order   */
  &my_charset_utf8mb4_handler,
  &my_collation_utf8mb4_general_ci_handler
};


DRIZZLED_API CHARSET_INFO my_charset_utf8mb4_bin=
{
  46,0,0,             /* number       */
  MY_CS_COMPILED|MY_CS_BINSORT|MY_CS_UNICODE, /* state  */
  MY_UTF8MB4,         /* cs name      */
  MY_UTF8MB4_BIN,     /* name         */
  "UTF-8 Unicode",    /* comment      */
  NULL,               /* tailoring    */
  ctype_utf8mb4,      /* ctype        */
  to_lower_utf8mb4,   /* to_lower     */
  to_upper_utf8mb4,   /* to_upper     */
  NULL,               /* sort_order   */
  NULL,               /* contractions */
  NULL,               /* sort_order_big*/
  NULL,               /* tab_to_uni   */
  NULL,               /* tab_from_uni */
  my_unicase_default, /* caseinfo     */
  NULL,               /* state_map    */
  NULL,               /* ident_map    */
  1,                  /* strxfrm_multiply */
  1,                  /* caseup_multiply  */
  1,                  /* casedn_multiply  */
  1,                  /* mbminlen     */
  4,                  /* mbmaxlen     */
  0,                  /* min_sort_char */
  0xFFFF,             /* max_sort_char */
  ' ',                /* pad char      */
  0,                  /* escape_with_backslash_is_dangerous */
  1,                  /* levels_for_compare */
  1,                  /* levels_for_order   */
  &my_charset_utf8mb4_handler,
  &my_collation_utf8mb4_bin_handler
};



static inline int bincmp(const unsigned char *s, const unsigned char *se,
                         const unsigned char *t, const unsigned char *te)
{
  int slen= (int) (se-s), tlen= (int) (te-t);
  int len= min(slen,tlen);
  int cmp= memcmp(s,t,len);
  return cmp ? cmp : slen-tlen;
}


/*
  File system encoding components:

Code range Pattern            Number   Used Unused  Blocks
-----------------------------------------------------------------------------
00C0..017F [.][0..4][g..z] 5*20= 100   97     3  Latin1 Supplement + Ext A
0370..03FF [.][5..9][g..z] 5*20= 100   88    12  Greek + Coptic
0400..052F [.][g..z][0..6] 20*7= 140  140   137  Cyrillic
0530..058F [.][g..z][7..8] 20*2=  40   38     2  Armenian
2160..217F [.][g..z][9]    20*1=  20   16     4  Number Forms
0180..02AF [.][g..z][a..k] 28*11=220  203    17  Latin Ext B + IPA
1E00..0EFF [.][g..z][l..r] 20*7= 140  136     4  Latin Additional Extended
1F00..1FFF [.][g..z][s..z] 20*8= 160  144    16  Greek Extended
....  .... [.][a..f][g..z] 6*20= 120    0   120  RESERVED
24B6..24E9 [.][@][a..z]           26   26     0  Enclosed Alphanumerics
FF21..FF5A [.][a..z][@]           26   26     0  Full Width forms

All other characters are encoded using five bytes:

[.][0..9a..z][0..9a..z][0..9a..z][0..9a..z]

*/

} /* namespace drizzled */

#ifdef MY_TEST_UTF8
#include <stdio.h>

static void test_mb(CHARSET_INFO *cs, unsigned char *s)
{
  while(*s)
  {
    if (my_ismbhead_utf8(cs,*s))
    {
      uint32_t len=my_mbcharlen_utf8(cs,*s);
      while(len--)
      {
        printf("%c",*s);
        s++;
      }
      printf("\n");
    }
    else
    {
      printf("%c\n",*s);
      s++;
    }
  }
}

int main()
{
  char str[1024]=" utf8 test проба ПЕРА по-РУССКИ";
  CHARSET_INFO *cs;

  test_mb(cs,(unsigned char*)str);

  printf("orig      :'%s'\n",str);

  my_caseup_utf8(cs,str,15);
  printf("caseup    :'%s'\n",str);

  my_caseup_str_utf8(cs,str);
  printf("caseup_str:'%s'\n",str);

  my_casedn_utf8(cs,str,15);
  printf("casedn    :'%s'\n",str);

  my_casedn_str_utf8(cs,str);
  printf("casedn_str:'%s'\n",str);

  return 0;
}

#endif
