# Ear Candy - Pulseaduio sound managment tool
# Copyright (C) 2009  Jason Taylor
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from PluginBase import PluginBaseObject

import dbus

class BansheeControlPlugin(PluginBaseObject):

    def __init__(self, core, path):
        PluginBaseObject(core, path) 
        self.bus = dbus.SessionBus()
        return

    def get_client_name(self):
        return "Banshee"

    def get_plugin_name(self):
        return "Banshee pause control (DBUS)"

    # Is application playing
    def is_playing(self):
        banshee = self.__get_application()
        if banshee:        
            return not banshee.GetCurrentState() == "paused"
        return False

    # Set application paused status
    def set_pause(self, status):
        banshee = self.__get_application()
        if banshee:
            if status:
                banshee.Pause()
            else:
                banshee.Play()
            return True
        return False

    def __get_application(self):
        return self.bus.get_object("org.bansheeproject.Banshee", "/org/bansheeproject/Banshee/PlayerEngine")


def register_plugin( core, path ):
    return BansheeControlPlugin( core, path )
