# Ear Candy - Pulseaduio sound managment tool
# Copyright (C) 2008 Jason Taylor
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os
from Freedesktop import DesktopParser

class DesktopFiles():

    def __init__(self):
        return

    def read_all(self):

        # http://bazaar.launchpad.net/~do-core/do/0.8/annotate/head%3A/Do.Platform.Linux/src/Do.Universe/ApplicationItemSource.cs
        self.paths = ["~/.local/share/applications","~/.local/share/applications/wine", \
                        "~/.local/share/applications/wine/Programs", "/usr/share/applications", \
                        "/usr/share/applications/kde", "/usr/share/applications/kde4", \
                        "/usr/share/gdm/applications", "/usr/local/share/applications" ]

        applications = []

        for path in self.paths:
            path = os.path.expanduser(path)
            if os.path.exists(path):
                for file in os.listdir(path):
                    if file.endswith(".desktop"):
                        d = DesktopParser(os.path.join(path, file))
                        if d.get("Type") == "Application":
                            applications.append( d )

        return applications

if __name__ == '__main__':

    df = DesktopFiles()
    df.read_all()
