#############################################################
##                                                         ##
## Copyright (c) 2003-2011 by The University of Queensland ##
## Earth Systems Science Computational Centre (ESSCC)      ##
## http://www.uq.edu.au/esscc                              ##
##                                                         ##
## Primary Business: Brisbane, Queensland, Australia       ##
## Licensed under the Open Software License version 3.0    ##
## http://www.opensource.org/licenses/osl-3.0.php          ##
##                                                         ##
#############################################################

from esys.lsm.vis import core
from Cylinder     import Cylinder, Disk

class CylinderExtractor(core.CylinderExtractor):
    def __init__(
        self,
        radiusMap   = lambda dataRecord: dataRecord.getRadius(),
        endPt1Map   = lambda dataRecord: dataRecord.getEndPt1(),
        endPt2Map   = lambda dataRecord: dataRecord.getEndPt2(),
        modifierMap = lambda dataRecord: None,
        radiusScale = 1.0
    ):
        core.CylinderExtractor.__init__(
            self,
            radiusMap,
            endPt1Map,
            endPt2Map,
            modifierMap,
            radiusScale
        )

    def addActor(self, record, addTo):
        """
        Adds the cylinder-actor associated with the data in
        C{record} to C{addTo}.
        """
        glyph = \
            Cylinder(
                endPt1=self.getEndPt1(record),
                endPt2=self.getEndPt2(record),
                radius=self.getRadius(record)
            )
        glyph.apply(self.getModifier(record))
        glyph.addActor(addTo)

class DiskExtractor(core.DiskExtractor):
    def __init__(
        self,
        radiusMap    = lambda dataRecord: dataRecord.getRadius(),
        centerMap    = lambda dataRecord: dataRecord.getCenter(),
        heightMap    = lambda dataRecord: 0.001,
        directionMap = lambda dataRecord: None,
        modifierMap  = lambda dataRecord: None,
        radiusScale = 1.0
    ):
        core.DiskExtractor.__init__(
            self,
            radiusMap,
            centerMap,
            heightMap,
            directionMap,
            modifierMap,
            radiusScale
        )

    def addActor(self, record, addTo):
        """
        Adds the disk-actor associated with the data in C{record}
        to C{addTo}.
        """
        glyph = \
            Disk(
                center    = self.getCenter(record),
                radius    = self.getRadius(record),
                height    = self.getHeight(record),
                direction = self.getDirection(record)
            )
        glyph.apply(self.getModifier(record))
        glyph.addActor(addTo)
