#! /bin/bash
#
#  Check if dependencies are installed before build.
#
#  Note: 
#  The following programs are not needed to build fotoxx
#  but they are required at run time.

dlist="xdg-open  xdg-desktop-menu  exiftool  ufraw-batch"

error=0
for dname in $dlist
do
   which $dname >/dev/null
   if [ $? -ne 0 ]; then error=1; fi
done
if [ $error -eq 0 ]; then exit 0; fi

for dname in $dlist
do
   which $dname >/dev/null
   if [ $? -ne 0 ]
      then echo " missing:  $dname"
      else echo "   found:  $dname"
   fi
done

echo ""
echo "The following programs are required for Fotoxx"
echo "(package names depend on your flavor of Linux)."
echo "   xdg-utils            LSB standard Linux utilities"
echo "   exiftool             EXIF/IPTC image data utility"
echo "   ufraw-batch          convert camera RAW files"
echo "Please install missing dependencies."
echo ""
exit 1


