/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.parser.EndPosParser;
import com.sun.tools.javac.parser.Keywords;
import com.sun.tools.javac.parser.Lexer;
import com.sun.tools.javac.parser.Token;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private static final int infixPrecedenceLevels = 10;
    private Lexer S;
    protected TreeMaker F;
    private Log log;
    private Keywords keywords;
    private Source source;
    private Name.Table names;
    boolean allowGenerics;
    boolean allowVarargs;
    boolean allowAsserts;
    boolean allowEnums;
    boolean allowForeach;
    boolean allowStaticImport;
    boolean allowAnnotations;
    boolean keepDocComments;
    static final int EXPR = 1;
    static final int TYPE = 2;
    static final int NOPARAMS = 4;
    static final int TYPEARG = 8;
    private int mode = 0;
    private int lastmode = 0;
    private JCTree.JCErroneous errorTree;
    private int errorPos = -1;
    Map<JCTree, String> docComments;
    private int errorEndPos = -1;
    ListBuffer<JCTree.JCExpression[]> odStackSupply = new ListBuffer();
    ListBuffer<Token[]> opStackSupply = new ListBuffer();

    protected Parser(Factory factory, Lexer lexer, boolean bl) {
        this.S = lexer;
        lexer.nextToken();
        this.F = factory.F;
        this.log = factory.log;
        this.names = factory.names;
        this.keywords = factory.keywords;
        this.source = factory.source;
        Options options = factory.options;
        this.allowGenerics = this.source.allowGenerics();
        this.allowVarargs = this.source.allowVarargs();
        this.allowAsserts = this.source.allowAsserts();
        this.allowEnums = this.source.allowEnums();
        this.allowForeach = this.source.allowForeach();
        this.allowStaticImport = this.source.allowStaticImport();
        this.allowAnnotations = this.source.allowAnnotations();
        this.keepDocComments = bl;
        if (bl) {
            this.docComments = new HashMap<JCTree, String>();
        }
        this.errorTree = this.F.Erroneous();
    }

    private void skip(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        while (true) {
            switch (this.S.token()) {
                case SEMI: {
                    this.S.nextToken();
                    return;
                }
                case PUBLIC: 
                case FINAL: 
                case ABSTRACT: 
                case MONKEYS_AT: 
                case EOF: 
                case CLASS: 
                case INTERFACE: 
                case ENUM: {
                    return;
                }
                case IMPORT: {
                    if (!bl) break;
                    return;
                }
                case LBRACE: 
                case RBRACE: 
                case PRIVATE: 
                case PROTECTED: 
                case STATIC: 
                case TRANSIENT: 
                case NATIVE: 
                case VOLATILE: 
                case SYNCHRONIZED: 
                case STRICTFP: 
                case LT: 
                case BYTE: 
                case SHORT: 
                case CHAR: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case VOID: {
                    if (!bl2) break;
                    return;
                }
                case IDENTIFIER: {
                    if (!bl3) break;
                    return;
                }
                case CASE: 
                case DEFAULT: 
                case IF: 
                case FOR: 
                case WHILE: 
                case DO: 
                case TRY: 
                case SWITCH: 
                case RETURN: 
                case THROW: 
                case BREAK: 
                case CONTINUE: 
                case ELSE: 
                case FINALLY: 
                case CATCH: {
                    if (!bl4) break;
                    return;
                }
            }
            this.S.nextToken();
        }
    }

    private JCTree.JCErroneous syntaxError(int n, String string, Object ... objectArray) {
        return this.syntaxError(n, null, string, objectArray);
    }

    private JCTree.JCErroneous syntaxError(int n, List<JCTree> list, String string, Object ... objectArray) {
        this.setErrorEndPos(n);
        this.reportSyntaxError(n, string, objectArray);
        return this.toP(this.F.at(n).Erroneous(list));
    }

    private void reportSyntaxError(int n, String string, Object ... objectArray) {
        if (n > this.S.errPos() || n == -1) {
            if (this.S.token() == Token.EOF) {
                this.log.error(n, "premature.eof", new Object[0]);
            } else {
                this.log.error(n, string, objectArray);
            }
        }
        this.S.errPos(n);
        if (this.S.pos() == this.errorPos) {
            this.S.nextToken();
        }
        this.errorPos = this.S.pos();
    }

    private JCTree.JCErroneous syntaxError(String string) {
        return this.syntaxError(this.S.pos(), string, new Object[0]);
    }

    private JCTree.JCErroneous syntaxError(String string, String string2) {
        return this.syntaxError(this.S.pos(), string, string2);
    }

    public void accept(Token token) {
        if (this.S.token() == token) {
            this.S.nextToken();
        } else {
            this.setErrorEndPos(this.S.pos());
            this.reportSyntaxError(this.S.prevEndPos(), "expected", this.keywords.token2string(token));
        }
    }

    JCTree.JCExpression illegal(int n) {
        this.setErrorEndPos(this.S.pos());
        if ((this.mode & 1) != 0) {
            return this.syntaxError(n, "illegal.start.of.expr", new Object[0]);
        }
        return this.syntaxError(n, "illegal.start.of.type", new Object[0]);
    }

    JCTree.JCExpression illegal() {
        return this.illegal(this.S.pos());
    }

    void checkNoMods(long l) {
        if (l != 0L) {
            long l2 = l & -l;
            this.log.error(this.S.pos(), "mod.not.allowed.here", Flags.toString(l2).trim());
        }
    }

    void attach(JCTree jCTree, String string) {
        if (this.keepDocComments && string != null) {
            this.docComments.put(jCTree, string);
        }
    }

    private void setErrorEndPos(int n) {
        if (n > this.errorEndPos) {
            this.errorEndPos = n;
        }
    }

    protected int getErrorEndPos() {
        return this.errorEndPos;
    }

    protected void storeEnd(JCTree jCTree, int n) {
    }

    protected <T extends JCTree> T to(T t) {
        return t;
    }

    protected <T extends JCTree> T toP(T t) {
        return t;
    }

    public int getStartPos(JCTree jCTree) {
        return TreeInfo.getStartPos(jCTree);
    }

    public int getEndPos(JCTree jCTree) {
        return -1;
    }

    Name ident() {
        if (this.S.token() == Token.IDENTIFIER) {
            Name name = this.S.name();
            this.S.nextToken();
            return name;
        }
        if (this.S.token() == Token.ASSERT) {
            if (this.allowAsserts) {
                this.log.error(this.S.pos(), "assert.as.identifier", new Object[0]);
                this.S.nextToken();
                return this.names.error;
            }
            this.log.warning(this.S.pos(), "assert.as.identifier", new Object[0]);
            Name name = this.S.name();
            this.S.nextToken();
            return name;
        }
        if (this.S.token() == Token.ENUM) {
            if (this.allowEnums) {
                this.log.error(this.S.pos(), "enum.as.identifier", new Object[0]);
                this.S.nextToken();
                return this.names.error;
            }
            this.log.warning(this.S.pos(), "enum.as.identifier", new Object[0]);
            Name name = this.S.name();
            this.S.nextToken();
            return name;
        }
        this.accept(Token.IDENTIFIER);
        return this.names.error;
    }

    public JCTree.JCExpression qualident() {
        JCTree.JCExpression jCExpression = this.toP(this.F.at(this.S.pos()).Ident(this.ident()));
        while (this.S.token() == Token.DOT) {
            int n = this.S.pos();
            this.S.nextToken();
            jCExpression = this.toP(this.F.at(n).Select(jCExpression, this.ident()));
        }
        return jCExpression;
    }

    JCTree.JCExpression literal(Name name) {
        int n = this.S.pos();
        JCTree.JCExpression jCExpression = this.errorTree;
        switch (this.S.token()) {
            case INTLITERAL: {
                try {
                    jCExpression = this.F.at(n).Literal(4, Convert.string2int(this.strval(name), this.S.radix()));
                }
                catch (NumberFormatException numberFormatException) {
                    this.log.error(this.S.pos(), "int.number.too.large", this.strval(name));
                }
                break;
            }
            case LONGLITERAL: {
                try {
                    jCExpression = this.F.at(n).Literal(5, new Long(Convert.string2long(this.strval(name), this.S.radix())));
                }
                catch (NumberFormatException numberFormatException) {
                    this.log.error(this.S.pos(), "int.number.too.large", this.strval(name));
                }
                break;
            }
            case FLOATLITERAL: {
                Float f;
                String string = this.S.radix() == 16 ? "0x" + this.S.stringVal() : this.S.stringVal();
                try {
                    f = Float.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    f = Float.valueOf(Float.NaN);
                }
                if (f.floatValue() == 0.0f && !this.isZero(string)) {
                    this.log.error(this.S.pos(), "fp.number.too.small", new Object[0]);
                    break;
                }
                if (f.floatValue() == Float.POSITIVE_INFINITY) {
                    this.log.error(this.S.pos(), "fp.number.too.large", new Object[0]);
                    break;
                }
                jCExpression = this.F.at(n).Literal(6, f);
                break;
            }
            case DOUBLELITERAL: {
                Double d;
                String string = this.S.radix() == 16 ? "0x" + this.S.stringVal() : this.S.stringVal();
                try {
                    d = Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    d = Double.NaN;
                }
                if (d == 0.0 && !this.isZero(string)) {
                    this.log.error(this.S.pos(), "fp.number.too.small", new Object[0]);
                    break;
                }
                if (d == Double.POSITIVE_INFINITY) {
                    this.log.error(this.S.pos(), "fp.number.too.large", new Object[0]);
                    break;
                }
                jCExpression = this.F.at(n).Literal(7, d);
                break;
            }
            case CHARLITERAL: {
                jCExpression = this.F.at(n).Literal(2, this.S.stringVal().charAt(0) + '\u0000');
                break;
            }
            case STRINGLITERAL: {
                jCExpression = this.F.at(n).Literal(10, this.S.stringVal());
                break;
            }
            case TRUE: 
            case FALSE: {
                jCExpression = this.F.at(n).Literal(8, this.S.token() == Token.TRUE ? 1 : 0);
                break;
            }
            case NULL: {
                jCExpression = this.F.at(n).Literal(17, null);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (jCExpression == this.errorTree) {
            jCExpression = this.F.at(n).Erroneous();
        }
        this.storeEnd(jCExpression, this.S.endPos());
        this.S.nextToken();
        return jCExpression;
    }

    boolean isZero(String string) {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length > 1 && Character.toLowerCase(cArray[1]) == 'x' ? 16 : 10;
        int n3 = n = n2 == 16 ? 2 : 0;
        while (n < cArray.length && (cArray[n] == '0' || cArray[n] == '.')) {
            ++n;
        }
        return n >= cArray.length || Character.digit(cArray[n], n2) <= 0;
    }

    String strval(Name name) {
        String string = this.S.stringVal();
        return name.len == 0 ? string : name + string;
    }

    public JCTree.JCExpression expression() {
        return this.term(1);
    }

    public JCTree.JCExpression type() {
        return this.term(2);
    }

    JCTree.JCExpression term(int n) {
        int n2 = this.mode;
        this.mode = n;
        JCTree.JCExpression jCExpression = this.term();
        this.lastmode = this.mode;
        this.mode = n2;
        return jCExpression;
    }

    JCTree.JCExpression term() {
        JCTree.JCExpression jCExpression = this.term1();
        if ((this.mode & 1) != 0 && this.S.token() == Token.EQ || Token.PLUSEQ.compareTo(this.S.token()) <= 0 && this.S.token().compareTo(Token.GTGTGTEQ) <= 0) {
            return this.termRest(jCExpression);
        }
        return jCExpression;
    }

    JCTree.JCExpression termRest(JCTree.JCExpression jCExpression) {
        switch (this.S.token()) {
            case EQ: {
                int n = this.S.pos();
                this.S.nextToken();
                this.mode = 1;
                JCTree.JCExpression jCExpression2 = this.term();
                return this.toP(this.F.at(n).Assign(jCExpression, jCExpression2));
            }
            case PLUSEQ: 
            case SUBEQ: 
            case STAREQ: 
            case SLASHEQ: 
            case PERCENTEQ: 
            case AMPEQ: 
            case BAREQ: 
            case CARETEQ: 
            case LTLTEQ: 
            case GTGTEQ: 
            case GTGTGTEQ: {
                int n = this.S.pos();
                Token token = this.S.token();
                this.S.nextToken();
                this.mode = 1;
                JCTree.JCExpression jCExpression3 = this.term();
                return this.F.at(n).Assignop(Parser.optag(token), jCExpression, jCExpression3);
            }
        }
        return jCExpression;
    }

    JCTree.JCExpression term1() {
        JCTree.JCExpression jCExpression = this.term2();
        if ((this.mode & 1) != 0 && this.S.token() == Token.QUES) {
            this.mode = 1;
            return this.term1Rest(jCExpression);
        }
        return jCExpression;
    }

    JCTree.JCExpression term1Rest(JCTree.JCExpression jCExpression) {
        if (this.S.token() == Token.QUES) {
            int n = this.S.pos();
            this.S.nextToken();
            JCTree.JCExpression jCExpression2 = this.term();
            this.accept(Token.COLON);
            JCTree.JCExpression jCExpression3 = this.term1();
            return this.F.at(n).Conditional(jCExpression, jCExpression2, jCExpression3);
        }
        return jCExpression;
    }

    JCTree.JCExpression term2() {
        JCTree.JCExpression jCExpression = this.term3();
        if ((this.mode & 1) != 0 && Parser.prec(this.S.token()) >= 4) {
            this.mode = 1;
            return this.term2Rest(jCExpression, 4);
        }
        return jCExpression;
    }

    JCTree.JCExpression term2Rest(JCTree.JCExpression jCExpression, int n) {
        StringBuffer stringBuffer;
        List list = this.odStackSupply.elems;
        JCTree.JCExpression[] jCExpressionArray = this.newOdStack();
        List list2 = this.opStackSupply.elems;
        Token[] tokenArray = this.newOpStack();
        int n2 = 0;
        jCExpressionArray[0] = jCExpression;
        int n3 = this.S.pos();
        Token token = Token.ERROR;
        while (Parser.prec(this.S.token()) >= n) {
            tokenArray[n2] = token;
            token = this.S.token();
            int n4 = this.S.pos();
            this.S.nextToken();
            JCTree.JCExpression jCExpression2 = jCExpressionArray[++n2] = token == Token.INSTANCEOF ? this.type() : this.term3();
            while (n2 > 0 && Parser.prec(token) >= Parser.prec(this.S.token())) {
                jCExpressionArray[n2 - 1] = this.makeOp(n4, token, jCExpressionArray[n2 - 1], jCExpressionArray[n2]);
                token = tokenArray[--n2];
            }
        }
        assert (n2 == 0);
        jCExpression = jCExpressionArray[0];
        if (jCExpression.getTag() == 69 && (stringBuffer = this.foldStrings(jCExpression)) != null) {
            jCExpression = this.toP(this.F.at(n3).Literal(10, stringBuffer.toString()));
        }
        this.odStackSupply.elems = list;
        this.opStackSupply.elems = list2;
        return jCExpression;
    }

    private JCTree.JCExpression makeOp(int n, Token token, JCTree.JCExpression jCExpression, JCTree.JCExpression jCExpression2) {
        if (token == Token.INSTANCEOF) {
            return this.F.at(n).TypeTest(jCExpression, jCExpression2);
        }
        return this.F.at(n).Binary(Parser.optag(token), jCExpression, jCExpression2);
    }

    protected StringBuffer foldStrings(JCTree jCTree) {
        List<String> list = List.nil();
        while (true) {
            Object object;
            JCTree.JCExpression jCExpression;
            if (jCTree.getTag() == 36) {
                jCExpression = (JCTree.JCLiteral)jCTree;
                if (jCExpression.typetag != 10) break;
                object = new StringBuffer((String)jCExpression.value);
                while (list.nonEmpty()) {
                    ((StringBuffer)object).append((String)list.head);
                    list = list.tail;
                }
                return object;
            }
            if (jCTree.getTag() != 69) break;
            jCExpression = (JCTree.JCBinary)jCTree;
            if (((JCTree.JCBinary)jCExpression).rhs.getTag() != 36) break;
            object = (JCTree.JCLiteral)((JCTree.JCBinary)jCExpression).rhs;
            if (((JCTree.JCLiteral)object).typetag != 10) break;
            list = list.prepend((String)((JCTree.JCLiteral)object).value);
            jCTree = ((JCTree.JCBinary)jCExpression).lhs;
        }
        return null;
    }

    private JCTree.JCExpression[] newOdStack() {
        if (this.odStackSupply.elems == this.odStackSupply.last) {
            this.odStackSupply.append(new JCTree.JCExpression[11]);
        }
        JCTree.JCExpression[] jCExpressionArray = (JCTree.JCExpression[])this.odStackSupply.elems.head;
        this.odStackSupply.elems = this.odStackSupply.elems.tail;
        return jCExpressionArray;
    }

    private Token[] newOpStack() {
        if (this.opStackSupply.elems == this.opStackSupply.last) {
            this.opStackSupply.append(new Token[11]);
        }
        Token[] tokenArray = (Token[])this.opStackSupply.elems.head;
        this.opStackSupply.elems = this.opStackSupply.elems.tail;
        return tokenArray;
    }

    protected JCTree.JCExpression term3() {
        int n;
        JCTree.JCExpression jCExpression;
        int n2 = this.S.pos();
        List<JCTree.JCExpression> list = this.typeArgumentsOpt(1);
        switch (this.S.token()) {
            case QUES: {
                if ((this.mode & 2) != 0 && (this.mode & 0xC) == 8) {
                    this.mode = 2;
                    return this.typeArgument();
                }
                return this.illegal();
            }
            case BANG: 
            case TILDE: 
            case PLUSPLUS: 
            case SUBSUB: 
            case PLUS: 
            case SUB: {
                if (list == null && (this.mode & 1) != 0) {
                    Token token = this.S.token();
                    this.S.nextToken();
                    this.mode = 1;
                    if (token == Token.SUB && (this.S.token() == Token.INTLITERAL || this.S.token() == Token.LONGLITERAL) && this.S.radix() == 10) {
                        this.mode = 1;
                        jCExpression = this.literal(this.names.hyphen);
                        break;
                    }
                    JCTree.JCExpression jCExpression2 = this.term3();
                    return this.F.at(n2).Unary(Parser.unoptag(token), jCExpression2);
                }
                return this.illegal();
            }
            case LPAREN: {
                if (list == null && (this.mode & 1) != 0) {
                    this.S.nextToken();
                    this.mode = 7;
                    jCExpression = this.term3();
                    if ((this.mode & 2) != 0 && this.S.token() == Token.LT) {
                        int n3 = 62;
                        n = this.S.pos();
                        this.S.nextToken();
                        this.mode &= 3;
                        this.mode |= 8;
                        JCTree.JCExpression jCExpression3 = this.term3();
                        if ((this.mode & 2) != 0 && (this.S.token() == Token.COMMA || this.S.token() == Token.GT)) {
                            this.mode = 2;
                            ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
                            listBuffer.append(jCExpression3);
                            while (this.S.token() == Token.COMMA) {
                                this.S.nextToken();
                                listBuffer.append(this.typeArgument());
                            }
                            this.accept(Token.GT);
                            jCExpression = this.F.at(n).TypeApply(jCExpression, listBuffer.toList());
                            this.checkGenerics();
                            jCExpression = this.bracketsOpt(this.toP(jCExpression));
                        } else if ((this.mode & 1) != 0) {
                            this.mode = 1;
                            jCExpression = this.F.at(n).Binary(n3, jCExpression, this.term2Rest(jCExpression3, 11));
                            jCExpression = this.termRest(this.term1Rest(this.term2Rest(jCExpression, 4)));
                        } else {
                            this.accept(Token.GT);
                        }
                    } else {
                        jCExpression = this.termRest(this.term1Rest(this.term2Rest(jCExpression, 4)));
                    }
                    this.accept(Token.RPAREN);
                    this.lastmode = this.mode;
                    this.mode = 1;
                    if ((this.lastmode & 1) == 0) {
                        JCTree.JCExpression jCExpression4 = this.term3();
                        return this.F.at(n2).TypeCast(jCExpression, jCExpression4);
                    }
                    if ((this.lastmode & 2) != 0) {
                        switch (this.S.token()) {
                            case ENUM: 
                            case BYTE: 
                            case SHORT: 
                            case CHAR: 
                            case INT: 
                            case LONG: 
                            case FLOAT: 
                            case DOUBLE: 
                            case BOOLEAN: 
                            case VOID: 
                            case IDENTIFIER: 
                            case INTLITERAL: 
                            case LONGLITERAL: 
                            case FLOATLITERAL: 
                            case DOUBLELITERAL: 
                            case CHARLITERAL: 
                            case STRINGLITERAL: 
                            case TRUE: 
                            case FALSE: 
                            case NULL: 
                            case BANG: 
                            case TILDE: 
                            case LPAREN: 
                            case THIS: 
                            case SUPER: 
                            case NEW: 
                            case ASSERT: {
                                JCTree.JCExpression jCExpression5 = this.term3();
                                return this.F.at(n2).TypeCast(jCExpression, jCExpression5);
                            }
                        }
                    }
                } else {
                    return this.illegal();
                }
                jCExpression = this.toP(this.F.at(n2).Parens(jCExpression));
                break;
            }
            case THIS: {
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    jCExpression = this.to(this.F.at(n2).Ident(this.names._this));
                    this.S.nextToken();
                    jCExpression = list == null ? this.argumentsOpt(null, jCExpression) : this.arguments(list, jCExpression);
                    list = null;
                    break;
                }
                return this.illegal();
            }
            case SUPER: {
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    jCExpression = this.to(this.superSuffix(list, this.F.at(n2).Ident(this.names._super)));
                    list = null;
                    break;
                }
                return this.illegal();
            }
            case INTLITERAL: 
            case LONGLITERAL: 
            case FLOATLITERAL: 
            case DOUBLELITERAL: 
            case CHARLITERAL: 
            case STRINGLITERAL: 
            case TRUE: 
            case FALSE: 
            case NULL: {
                if (list == null && (this.mode & 1) != 0) {
                    this.mode = 1;
                    jCExpression = this.literal(this.names.empty);
                    break;
                }
                return this.illegal();
            }
            case NEW: {
                if (list != null) {
                    return this.illegal();
                }
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    this.S.nextToken();
                    if (this.S.token() == Token.LT) {
                        list = this.typeArguments();
                    }
                    jCExpression = this.creator(n2, list);
                    list = null;
                    break;
                }
                return this.illegal();
            }
            case ENUM: 
            case IDENTIFIER: 
            case ASSERT: {
                if (list != null) {
                    return this.illegal();
                }
                jCExpression = this.toP(this.F.at(this.S.pos()).Ident(this.ident()));
                block27: while (true) {
                    n2 = this.S.pos();
                    switch (this.S.token()) {
                        case LBRACKET: {
                            this.S.nextToken();
                            if (this.S.token() == Token.RBRACKET) {
                                this.S.nextToken();
                                jCExpression = this.bracketsOpt(jCExpression);
                                jCExpression = this.toP(this.F.at(n2).TypeArray(jCExpression));
                                jCExpression = this.bracketsSuffix(jCExpression);
                                break block27;
                            }
                            if ((this.mode & 1) != 0) {
                                this.mode = 1;
                                JCTree.JCExpression jCExpression6 = this.term();
                                jCExpression = this.to(this.F.at(n2).Indexed(jCExpression, jCExpression6));
                            }
                            this.accept(Token.RBRACKET);
                            break block27;
                        }
                        case LPAREN: {
                            if ((this.mode & 1) == 0) break block27;
                            this.mode = 1;
                            jCExpression = this.arguments(list, jCExpression);
                            list = null;
                            break block27;
                        }
                        case DOT: {
                            this.S.nextToken();
                            list = this.typeArgumentsOpt(1);
                            if ((this.mode & 1) != 0) {
                                switch (this.S.token()) {
                                    case CLASS: {
                                        if (list != null) {
                                            return this.illegal();
                                        }
                                        this.mode = 1;
                                        jCExpression = this.to(this.F.at(n2).Select(jCExpression, this.names._class));
                                        this.S.nextToken();
                                        break block27;
                                    }
                                    case THIS: {
                                        if (list != null) {
                                            return this.illegal();
                                        }
                                        this.mode = 1;
                                        jCExpression = this.to(this.F.at(n2).Select(jCExpression, this.names._this));
                                        this.S.nextToken();
                                        break block27;
                                    }
                                    case SUPER: {
                                        this.mode = 1;
                                        jCExpression = this.to(this.F.at(n2).Select(jCExpression, this.names._super));
                                        jCExpression = this.superSuffix(list, jCExpression);
                                        list = null;
                                        break block27;
                                    }
                                    case NEW: {
                                        if (list != null) {
                                            return this.illegal();
                                        }
                                        this.mode = 1;
                                        int n4 = this.S.pos();
                                        this.S.nextToken();
                                        if (this.S.token() == Token.LT) {
                                            list = this.typeArguments();
                                        }
                                        jCExpression = this.innerCreator(n4, list, jCExpression);
                                        list = null;
                                        break block27;
                                    }
                                }
                            }
                            jCExpression = this.toP(this.F.at(n2).Select(jCExpression, this.ident()));
                            continue block27;
                        }
                    }
                    break;
                }
                if (list != null) {
                    this.illegal();
                }
                jCExpression = this.typeArgumentsOpt(jCExpression);
                break;
            }
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                if (list != null) {
                    this.illegal();
                }
                jCExpression = this.bracketsSuffix(this.bracketsOpt(this.basicType()));
                break;
            }
            case VOID: {
                if (list != null) {
                    this.illegal();
                }
                if ((this.mode & 1) != 0) {
                    this.S.nextToken();
                    if (this.S.token() == Token.DOT) {
                        JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree = this.toP(this.F.at(n2).TypeIdent(9));
                        jCExpression = this.bracketsSuffix(jCPrimitiveTypeTree);
                        break;
                    }
                    return this.illegal(n2);
                }
                return this.illegal();
            }
            default: {
                return this.illegal();
            }
        }
        if (list != null) {
            this.illegal();
        }
        while (true) {
            int n5 = this.S.pos();
            if (this.S.token() == Token.LBRACKET) {
                this.S.nextToken();
                if ((this.mode & 2) != 0) {
                    n = this.mode;
                    this.mode = 2;
                    if (this.S.token() == Token.RBRACKET) {
                        this.S.nextToken();
                        jCExpression = this.bracketsOpt(jCExpression);
                        jCExpression = this.toP(this.F.at(n5).TypeArray(jCExpression));
                        return jCExpression;
                    }
                    this.mode = n;
                }
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    JCTree.JCExpression jCExpression7 = this.term();
                    jCExpression = this.to(this.F.at(n5).Indexed(jCExpression, jCExpression7));
                }
                this.accept(Token.RBRACKET);
                continue;
            }
            if (this.S.token() != Token.DOT) break;
            this.S.nextToken();
            list = this.typeArgumentsOpt(1);
            if (this.S.token() == Token.SUPER && (this.mode & 1) != 0) {
                this.mode = 1;
                jCExpression = this.to(this.F.at(n5).Select(jCExpression, this.names._super));
                this.S.nextToken();
                jCExpression = this.arguments(list, jCExpression);
                list = null;
                continue;
            }
            if (this.S.token() == Token.NEW && (this.mode & 1) != 0) {
                if (list != null) {
                    return this.illegal();
                }
                this.mode = 1;
                n = this.S.pos();
                this.S.nextToken();
                if (this.S.token() == Token.LT) {
                    list = this.typeArguments();
                }
                jCExpression = this.innerCreator(n, list, jCExpression);
                list = null;
                continue;
            }
            jCExpression = this.toP(this.F.at(n5).Select(jCExpression, this.ident()));
            jCExpression = this.argumentsOpt(list, this.typeArgumentsOpt(jCExpression));
            list = null;
        }
        while ((this.S.token() == Token.PLUSPLUS || this.S.token() == Token.SUBSUB) && (this.mode & 1) != 0) {
            this.mode = 1;
            jCExpression = this.to(this.F.at(this.S.pos()).Unary(this.S.token() == Token.PLUSPLUS ? 52 : 53, jCExpression));
            this.S.nextToken();
        }
        return this.toP(jCExpression);
    }

    JCTree.JCExpression superSuffix(List<JCTree.JCExpression> list, JCTree.JCExpression jCExpression) {
        this.S.nextToken();
        if (this.S.token() == Token.LPAREN || list != null) {
            jCExpression = this.arguments(list, jCExpression);
        } else {
            int n = this.S.pos();
            this.accept(Token.DOT);
            list = this.S.token() == Token.LT ? this.typeArguments() : null;
            jCExpression = this.toP(this.F.at(n).Select(jCExpression, this.ident()));
            jCExpression = this.argumentsOpt(list, jCExpression);
        }
        return jCExpression;
    }

    JCTree.JCPrimitiveTypeTree basicType() {
        JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree = this.to(this.F.at(this.S.pos()).TypeIdent(Parser.typetag(this.S.token())));
        this.S.nextToken();
        return jCPrimitiveTypeTree;
    }

    JCTree.JCExpression argumentsOpt(List<JCTree.JCExpression> list, JCTree.JCExpression jCExpression) {
        if ((this.mode & 1) != 0 && this.S.token() == Token.LPAREN || list != null) {
            this.mode = 1;
            return this.arguments(list, jCExpression);
        }
        return jCExpression;
    }

    List<JCTree.JCExpression> arguments() {
        ListBuffer listBuffer = ListBuffer.lb();
        if (this.S.token() == Token.LPAREN) {
            this.S.nextToken();
            if (this.S.token() != Token.RPAREN) {
                listBuffer.append(this.expression());
                while (this.S.token() == Token.COMMA) {
                    this.S.nextToken();
                    listBuffer.append(this.expression());
                }
            }
            this.accept(Token.RPAREN);
        } else {
            this.syntaxError(this.S.pos(), "expected", this.keywords.token2string(Token.LPAREN));
        }
        return listBuffer.toList();
    }

    JCTree.JCMethodInvocation arguments(List<JCTree.JCExpression> list, JCTree.JCExpression jCExpression) {
        int n = this.S.pos();
        List<JCTree.JCExpression> list2 = this.arguments();
        return this.toP(this.F.at(n).Apply(list, jCExpression, list2));
    }

    JCTree.JCExpression typeArgumentsOpt(JCTree.JCExpression jCExpression) {
        if (this.S.token() == Token.LT && (this.mode & 2) != 0 && (this.mode & 4) == 0) {
            this.mode = 2;
            this.checkGenerics();
            return this.typeArguments(jCExpression);
        }
        return jCExpression;
    }

    List<JCTree.JCExpression> typeArgumentsOpt() {
        return this.typeArgumentsOpt(2);
    }

    List<JCTree.JCExpression> typeArgumentsOpt(int n) {
        if (this.S.token() == Token.LT) {
            this.checkGenerics();
            if ((this.mode & n) == 0 || (this.mode & 4) != 0) {
                this.illegal();
            }
            this.mode = n;
            return this.typeArguments();
        }
        return null;
    }

    List<JCTree.JCExpression> typeArguments() {
        ListBuffer listBuffer = ListBuffer.lb();
        if (this.S.token() == Token.LT) {
            this.S.nextToken();
            listBuffer.append((this.mode & 1) == 0 ? this.typeArgument() : this.type());
            while (this.S.token() == Token.COMMA) {
                this.S.nextToken();
                listBuffer.append((this.mode & 1) == 0 ? this.typeArgument() : this.type());
            }
            switch (this.S.token()) {
                case GTGTGTEQ: {
                    this.S.token(Token.GTGTEQ);
                    break;
                }
                case GTGTEQ: {
                    this.S.token(Token.GTEQ);
                    break;
                }
                case GTEQ: {
                    this.S.token(Token.EQ);
                    break;
                }
                case GTGTGT: {
                    this.S.token(Token.GTGT);
                    break;
                }
                case GTGT: {
                    this.S.token(Token.GT);
                    break;
                }
                default: {
                    this.accept(Token.GT);
                    break;
                }
            }
        } else {
            this.syntaxError(this.S.pos(), "expected", this.keywords.token2string(Token.LT));
        }
        return listBuffer.toList();
    }

    JCTree.JCExpression typeArgument() {
        if (this.S.token() != Token.QUES) {
            return this.type();
        }
        int n = this.S.pos();
        this.S.nextToken();
        if (this.S.token() == Token.EXTENDS) {
            JCTree.TypeBoundKind typeBoundKind = this.to(this.F.at(this.S.pos()).TypeBoundKind(BoundKind.EXTENDS));
            this.S.nextToken();
            return this.F.at(n).Wildcard(typeBoundKind, this.type());
        }
        if (this.S.token() == Token.SUPER) {
            JCTree.TypeBoundKind typeBoundKind = this.to(this.F.at(this.S.pos()).TypeBoundKind(BoundKind.SUPER));
            this.S.nextToken();
            return this.F.at(n).Wildcard(typeBoundKind, this.type());
        }
        if (this.S.token() == Token.IDENTIFIER) {
            this.reportSyntaxError(this.S.prevEndPos(), "expected3", this.keywords.token2string(Token.GT), this.keywords.token2string(Token.EXTENDS), this.keywords.token2string(Token.SUPER));
            JCTree.TypeBoundKind typeBoundKind = this.F.at(-1).TypeBoundKind(BoundKind.UNBOUND);
            JCTree.JCExpression jCExpression = this.toP(this.F.at(n).Wildcard(typeBoundKind, null));
            JCTree.JCIdent jCIdent = this.toP(this.F.at(this.S.pos()).Ident(this.ident()));
            return this.F.at(n).Erroneous(List.of(jCExpression, jCIdent));
        }
        JCTree.TypeBoundKind typeBoundKind = this.F.at(-1).TypeBoundKind(BoundKind.UNBOUND);
        return this.toP(this.F.at(n).Wildcard(typeBoundKind, null));
    }

    JCTree.JCTypeApply typeArguments(JCTree.JCExpression jCExpression) {
        int n = this.S.pos();
        List<JCTree.JCExpression> list = this.typeArguments();
        return this.toP(this.F.at(n).TypeApply(jCExpression, list));
    }

    private JCTree.JCExpression bracketsOpt(JCTree.JCExpression jCExpression) {
        if (this.S.token() == Token.LBRACKET) {
            int n = this.S.pos();
            this.S.nextToken();
            jCExpression = this.bracketsOptCont(jCExpression, n);
            this.F.at(n);
        }
        return jCExpression;
    }

    private JCTree.JCArrayTypeTree bracketsOptCont(JCTree.JCExpression jCExpression, int n) {
        this.accept(Token.RBRACKET);
        jCExpression = this.bracketsOpt(jCExpression);
        return this.toP(this.F.at(n).TypeArray(jCExpression));
    }

    JCTree.JCExpression bracketsSuffix(JCTree.JCExpression jCExpression) {
        if ((this.mode & 1) != 0 && this.S.token() == Token.DOT) {
            this.mode = 1;
            int n = this.S.pos();
            this.S.nextToken();
            this.accept(Token.CLASS);
            if (this.S.pos() == this.errorEndPos) {
                Name name = null;
                if (this.S.token() == Token.IDENTIFIER) {
                    name = this.S.name();
                    this.S.nextToken();
                } else {
                    name = this.names.error;
                }
                jCExpression = this.F.at(n).Erroneous(List.of(this.toP(this.F.at(n).Select(jCExpression, name))));
            } else {
                jCExpression = this.toP(this.F.at(n).Select(jCExpression, this.names._class));
            }
        } else if ((this.mode & 2) != 0) {
            this.mode = 2;
        } else {
            this.syntaxError(this.S.pos(), "dot.class.expected", new Object[0]);
        }
        return jCExpression;
    }

    JCTree.JCExpression creator(int n, List<JCTree.JCExpression> list) {
        switch (this.S.token()) {
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                if (list != null) break;
                return this.arrayCreatorRest(n, this.basicType());
            }
        }
        JCTree.JCExpression jCExpression = this.qualident();
        int n2 = this.mode;
        this.mode = 2;
        if (this.S.token() == Token.LT) {
            this.checkGenerics();
            jCExpression = this.typeArguments(jCExpression);
        }
        while (this.S.token() == Token.DOT) {
            int n3 = this.S.pos();
            this.S.nextToken();
            jCExpression = this.toP(this.F.at(n3).Select(jCExpression, this.ident()));
            if (this.S.token() != Token.LT) continue;
            this.checkGenerics();
            jCExpression = this.typeArguments(jCExpression);
        }
        this.mode = n2;
        if (this.S.token() == Token.LBRACKET) {
            JCTree.JCExpression jCExpression2 = this.arrayCreatorRest(n, jCExpression);
            if (list != null) {
                int n4 = n;
                if (!list.isEmpty() && ((JCTree.JCExpression)list.head).pos != -1) {
                    n4 = ((JCTree.JCExpression)list.head).pos;
                }
                this.setErrorEndPos(this.S.prevEndPos());
                this.reportSyntaxError(n4, "cannot.create.array.with.type.arguments", new Object[0]);
                return this.toP(this.F.at(n).Erroneous(list.prepend(jCExpression2)));
            }
            return jCExpression2;
        }
        if (this.S.token() == Token.LPAREN) {
            return this.classCreatorRest(n, null, list, jCExpression);
        }
        this.reportSyntaxError(this.S.pos(), "expected2", this.keywords.token2string(Token.LPAREN), this.keywords.token2string(Token.LBRACKET));
        jCExpression = this.toP(this.F.at(n).NewClass(null, list, jCExpression, List.<JCTree.JCExpression>nil(), null));
        return this.toP(this.F.at(n).Erroneous(List.of(jCExpression)));
    }

    JCTree.JCExpression innerCreator(int n, List<JCTree.JCExpression> list, JCTree.JCExpression jCExpression) {
        JCTree.JCExpression jCExpression2 = this.toP(this.F.at(this.S.pos()).Ident(this.ident()));
        if (this.S.token() == Token.LT) {
            this.checkGenerics();
            jCExpression2 = this.typeArguments(jCExpression2);
        }
        return this.classCreatorRest(n, jCExpression, list, jCExpression2);
    }

    JCTree.JCExpression arrayCreatorRest(int n, JCTree.JCExpression jCExpression) {
        this.accept(Token.LBRACKET);
        if (this.S.token() == Token.RBRACKET) {
            this.accept(Token.RBRACKET);
            jCExpression = this.bracketsOpt(jCExpression);
            if (this.S.token() == Token.LBRACE) {
                return this.arrayInitializer(n, jCExpression);
            }
            return this.syntaxError(this.S.pos(), "array.dimension.missing", new Object[0]);
        }
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        listBuffer.append(this.expression());
        this.accept(Token.RBRACKET);
        while (this.S.token() == Token.LBRACKET) {
            int n2 = this.S.pos();
            this.S.nextToken();
            if (this.S.token() == Token.RBRACKET) {
                jCExpression = this.bracketsOptCont(jCExpression, n2);
                continue;
            }
            listBuffer.append(this.expression());
            this.accept(Token.RBRACKET);
        }
        return this.toP(this.F.at(n).NewArray(jCExpression, listBuffer.toList(), null));
    }

    JCTree.JCExpression classCreatorRest(int n, JCTree.JCExpression jCExpression, List<JCTree.JCExpression> list, JCTree.JCExpression jCExpression2) {
        List<JCTree.JCExpression> list2 = this.arguments();
        JCTree.JCClassDecl jCClassDecl = null;
        if (this.S.token() == Token.LBRACE) {
            int n2 = this.S.pos();
            List<JCTree> list3 = this.classOrInterfaceBody(this.names.empty, false);
            JCTree.JCModifiers jCModifiers = this.F.at(-1).Modifiers(0L);
            jCClassDecl = this.toP(this.F.at(n2).AnonymousClassDef(jCModifiers, list3));
        }
        return this.toP(this.F.at(n).NewClass(jCExpression, list, jCExpression2, list2, jCClassDecl));
    }

    JCTree.JCExpression arrayInitializer(int n, JCTree.JCExpression jCExpression) {
        this.accept(Token.LBRACE);
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        if (this.S.token() == Token.COMMA) {
            this.S.nextToken();
        } else if (this.S.token() != Token.RBRACE) {
            listBuffer.append(this.variableInitializer());
            while (this.S.token() == Token.COMMA) {
                this.S.nextToken();
                if (this.S.token() == Token.RBRACE) break;
                listBuffer.append(this.variableInitializer());
            }
        }
        this.accept(Token.RBRACE);
        return this.toP(this.F.at(n).NewArray(jCExpression, List.<JCTree.JCExpression>nil(), listBuffer.toList()));
    }

    public JCTree.JCExpression variableInitializer() {
        return this.S.token() == Token.LBRACE ? this.arrayInitializer(this.S.pos(), null) : this.expression();
    }

    JCTree.JCExpression parExpression() {
        this.accept(Token.LPAREN);
        JCTree.JCExpression jCExpression = this.expression();
        this.accept(Token.RPAREN);
        return jCExpression;
    }

    JCTree.JCBlock block(int n, long l) {
        this.accept(Token.LBRACE);
        List<JCTree.JCStatement> list = this.blockStatements();
        JCTree.JCBlock jCBlock = this.F.at(n).Block(l, list);
        while (this.S.token() == Token.CASE || this.S.token() == Token.DEFAULT) {
            this.syntaxError("orphaned", this.keywords.token2string(this.S.token()));
            this.switchBlockStatementGroups();
        }
        jCBlock.endpos = this.S.pos();
        this.accept(Token.RBRACE);
        return this.toP(jCBlock);
    }

    public JCTree.JCBlock block() {
        return this.block(this.S.pos(), 0L);
    }

    List<JCTree.JCStatement> blockStatements() {
        int n = -1;
        ListBuffer<JCTree.JCStatement> listBuffer = new ListBuffer<JCTree.JCStatement>();
        while (true) {
            int n2 = this.S.pos();
            switch (this.S.token()) {
                case EOF: 
                case RBRACE: 
                case CASE: 
                case DEFAULT: {
                    return listBuffer.toList();
                }
                case SEMI: 
                case LBRACE: 
                case SYNCHRONIZED: 
                case IF: 
                case FOR: 
                case WHILE: 
                case DO: 
                case TRY: 
                case SWITCH: 
                case RETURN: 
                case THROW: 
                case BREAK: 
                case CONTINUE: 
                case ELSE: 
                case FINALLY: 
                case CATCH: {
                    listBuffer.append(this.statement());
                    break;
                }
                case FINAL: 
                case MONKEYS_AT: {
                    CharSequence charSequence = this.S.docComment();
                    JCTree jCTree = this.modifiersOpt();
                    if (this.S.token() == Token.INTERFACE || this.S.token() == Token.CLASS || this.allowEnums && this.S.token() == Token.ENUM) {
                        listBuffer.append(this.classOrInterfaceOrEnumDeclaration((JCTree.JCModifiers)jCTree, (String)charSequence));
                        break;
                    }
                    JCTree jCTree2 = this.type();
                    listBuffer.appendList(this.variableDeclarators((JCTree.JCModifiers)jCTree, (JCTree.JCExpression)jCTree2, (ListBuffer)new ListBuffer()));
                    this.storeEnd((JCTree)listBuffer.elems.last(), this.S.endPos());
                    this.accept(Token.SEMI);
                    break;
                }
                case ABSTRACT: 
                case STRICTFP: {
                    CharSequence charSequence = this.S.docComment();
                    JCTree jCTree = this.modifiersOpt();
                    listBuffer.append(this.classOrInterfaceOrEnumDeclaration((JCTree.JCModifiers)jCTree, (String)charSequence));
                    break;
                }
                case CLASS: 
                case INTERFACE: {
                    listBuffer.append(this.classOrInterfaceOrEnumDeclaration(this.modifiersOpt(), this.S.docComment()));
                    break;
                }
                case ENUM: 
                case ASSERT: {
                    if (this.allowEnums && this.S.token() == Token.ENUM) {
                        this.log.error(this.S.pos(), "local.enum", new Object[0]);
                        listBuffer.append(this.classOrInterfaceOrEnumDeclaration(this.modifiersOpt(), this.S.docComment()));
                        break;
                    }
                    if (this.allowAsserts && this.S.token() == Token.ASSERT) {
                        listBuffer.append(this.statement());
                        break;
                    }
                }
                default: {
                    JCTree jCTree2;
                    CharSequence charSequence = this.S.name();
                    JCTree jCTree = this.term(3);
                    if (this.S.token() == Token.COLON && jCTree.getTag() == 35) {
                        this.S.nextToken();
                        jCTree2 = this.statement();
                        listBuffer.append(this.F.at(n2).Labelled((Name)charSequence, (JCTree.JCStatement)jCTree2));
                        break;
                    }
                    if ((this.lastmode & 2) != 0 && (this.S.token() == Token.IDENTIFIER || this.S.token() == Token.ASSERT || this.S.token() == Token.ENUM)) {
                        n2 = this.S.pos();
                        jCTree2 = this.F.at(-1).Modifiers(0L);
                        this.F.at(n2);
                        listBuffer.appendList(this.variableDeclarators((JCTree.JCModifiers)jCTree2, (JCTree.JCExpression)jCTree, new ListBuffer()));
                        this.storeEnd((JCTree)listBuffer.elems.last(), this.S.endPos());
                        this.accept(Token.SEMI);
                        break;
                    }
                    listBuffer.append(this.to(this.F.at(n2).Exec(this.checkExprStat((JCTree.JCExpression)jCTree))));
                    this.accept(Token.SEMI);
                }
            }
            if (this.S.pos() == n) {
                return listBuffer.toList();
            }
            if (this.S.pos() <= this.errorEndPos) {
                this.skip(false, true, true, true);
                n = this.S.pos();
            }
            this.S.resetDeprecatedFlag();
        }
    }

    public JCTree.JCStatement statement() {
        int n = this.S.pos();
        switch (this.S.token()) {
            case LBRACE: {
                return this.block();
            }
            case IF: {
                this.S.nextToken();
                JCTree.JCExpression jCExpression = this.parExpression();
                JCTree.JCStatement jCStatement = this.statement();
                JCTree.JCStatement jCStatement2 = null;
                if (this.S.token() == Token.ELSE) {
                    this.S.nextToken();
                    jCStatement2 = this.statement();
                }
                return this.F.at(n).If(jCExpression, jCStatement, jCStatement2);
            }
            case FOR: {
                List<Object> list;
                this.S.nextToken();
                this.accept(Token.LPAREN);
                List<Object> list2 = list = this.S.token() == Token.SEMI ? List.nil() : this.forInit();
                if (list.length() == 1 && ((JCTree.JCStatement)list.head).getTag() == 5 && ((JCTree.JCVariableDecl)list.head).init == null && this.S.token() == Token.COLON) {
                    this.checkForeach();
                    JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)list.head;
                    this.accept(Token.COLON);
                    JCTree.JCExpression jCExpression = this.expression();
                    this.accept(Token.RPAREN);
                    JCTree.JCStatement jCStatement = this.statement();
                    return this.F.at(n).ForeachLoop(jCVariableDecl, jCExpression, jCStatement);
                }
                this.accept(Token.SEMI);
                JCTree.JCExpression jCExpression = this.S.token() == Token.SEMI ? null : this.expression();
                this.accept(Token.SEMI);
                List<JCTree.JCExpressionStatement> list3 = this.S.token() == Token.RPAREN ? List.nil() : this.forUpdate();
                this.accept(Token.RPAREN);
                JCTree.JCStatement jCStatement = this.statement();
                return this.F.at(n).ForLoop(list, jCExpression, list3, jCStatement);
            }
            case WHILE: {
                this.S.nextToken();
                JCTree.JCExpression jCExpression = this.parExpression();
                JCTree.JCStatement jCStatement = this.statement();
                return this.F.at(n).WhileLoop(jCExpression, jCStatement);
            }
            case DO: {
                this.S.nextToken();
                JCTree.JCStatement jCStatement = this.statement();
                this.accept(Token.WHILE);
                JCTree.JCExpression jCExpression = this.parExpression();
                JCTree.JCDoWhileLoop jCDoWhileLoop = this.to(this.F.at(n).DoLoop(jCStatement, jCExpression));
                this.accept(Token.SEMI);
                return jCDoWhileLoop;
            }
            case TRY: {
                this.S.nextToken();
                JCTree.JCBlock jCBlock = this.block();
                ListBuffer<JCTree.JCCatch> listBuffer = new ListBuffer<JCTree.JCCatch>();
                JCTree.JCBlock jCBlock2 = null;
                if (this.S.token() == Token.CATCH || this.S.token() == Token.FINALLY) {
                    while (this.S.token() == Token.CATCH) {
                        listBuffer.append(this.catchClause());
                    }
                    if (this.S.token() == Token.FINALLY) {
                        this.S.nextToken();
                        jCBlock2 = this.block();
                    }
                } else {
                    this.log.error(n, "try.without.catch.or.finally", new Object[0]);
                }
                return this.F.at(n).Try(jCBlock, listBuffer.toList(), jCBlock2);
            }
            case SWITCH: {
                this.S.nextToken();
                JCTree.JCExpression jCExpression = this.parExpression();
                this.accept(Token.LBRACE);
                List<JCTree.JCCase> list = this.switchBlockStatementGroups();
                JCTree.JCSwitch jCSwitch = this.to(this.F.at(n).Switch(jCExpression, list));
                this.accept(Token.RBRACE);
                return jCSwitch;
            }
            case SYNCHRONIZED: {
                this.S.nextToken();
                JCTree.JCExpression jCExpression = this.parExpression();
                JCTree.JCBlock jCBlock = this.block();
                return this.F.at(n).Synchronized(jCExpression, jCBlock);
            }
            case RETURN: {
                this.S.nextToken();
                JCTree.JCExpression jCExpression = this.S.token() == Token.SEMI ? null : this.expression();
                JCTree.JCReturn jCReturn = this.to(this.F.at(n).Return(jCExpression));
                this.accept(Token.SEMI);
                return jCReturn;
            }
            case THROW: {
                this.S.nextToken();
                JCTree.JCExpression jCExpression = this.expression();
                JCTree.JCThrow jCThrow = this.to(this.F.at(n).Throw(jCExpression));
                this.accept(Token.SEMI);
                return jCThrow;
            }
            case BREAK: {
                this.S.nextToken();
                Name name = this.S.token() == Token.IDENTIFIER || this.S.token() == Token.ASSERT || this.S.token() == Token.ENUM ? this.ident() : null;
                JCTree.JCBreak jCBreak = this.to(this.F.at(n).Break(name));
                this.accept(Token.SEMI);
                return jCBreak;
            }
            case CONTINUE: {
                this.S.nextToken();
                Name name = this.S.token() == Token.IDENTIFIER || this.S.token() == Token.ASSERT || this.S.token() == Token.ENUM ? this.ident() : null;
                JCTree.JCContinue jCContinue = this.to(this.F.at(n).Continue(name));
                this.accept(Token.SEMI);
                return jCContinue;
            }
            case SEMI: {
                this.S.nextToken();
                return this.toP(this.F.at(n).Skip());
            }
            case ELSE: {
                return this.toP(this.F.Exec(this.syntaxError("else.without.if")));
            }
            case FINALLY: {
                return this.toP(this.F.Exec(this.syntaxError("finally.without.try")));
            }
            case CATCH: {
                return this.toP(this.F.Exec(this.syntaxError("catch.without.try")));
            }
            case ASSERT: {
                if (!this.allowAsserts || this.S.token() != Token.ASSERT) break;
                this.S.nextToken();
                JCTree.JCExpression jCExpression = this.expression();
                JCTree.JCExpression jCExpression2 = null;
                if (this.S.token() == Token.COLON) {
                    this.S.nextToken();
                    jCExpression2 = this.expression();
                }
                JCTree.JCAssert jCAssert = this.to(this.F.at(n).Assert(jCExpression, jCExpression2));
                this.accept(Token.SEMI);
                return jCAssert;
            }
        }
        Name name = this.S.name();
        JCTree.JCExpression jCExpression = this.expression();
        if (this.S.token() == Token.COLON && jCExpression.getTag() == 35) {
            this.S.nextToken();
            JCTree.JCStatement jCStatement = this.statement();
            return this.F.at(n).Labelled(name, jCStatement);
        }
        JCTree.JCExpressionStatement jCExpressionStatement = this.to(this.F.at(n).Exec(this.checkExprStat(jCExpression)));
        this.accept(Token.SEMI);
        return jCExpressionStatement;
    }

    JCTree.JCCatch catchClause() {
        int n = this.S.pos();
        this.accept(Token.CATCH);
        this.accept(Token.LPAREN);
        JCTree.JCVariableDecl jCVariableDecl = this.variableDeclaratorId(this.optFinal(0x200000000L), this.qualident());
        this.accept(Token.RPAREN);
        JCTree.JCBlock jCBlock = this.block();
        return this.F.at(n).Catch(jCVariableDecl, jCBlock);
    }

    List<JCTree.JCCase> switchBlockStatementGroups() {
        ListBuffer<Object> listBuffer = new ListBuffer<Object>();
        block5: while (true) {
            int n = this.S.pos();
            switch (this.S.token()) {
                case CASE: {
                    this.S.nextToken();
                    Object object = this.expression();
                    this.accept(Token.COLON);
                    Object object2 = this.blockStatements();
                    JCTree.JCCase jCCase = this.F.at(n).Case((JCTree.JCExpression)object, (List<JCTree.JCStatement>)object2);
                    if (((List)object2).isEmpty()) {
                        this.storeEnd(jCCase, this.S.prevEndPos());
                    }
                    listBuffer.append(jCCase);
                    continue block5;
                }
                case DEFAULT: {
                    this.S.nextToken();
                    this.accept(Token.COLON);
                    Object object = this.blockStatements();
                    Object object2 = this.F.at(n).Case(null, (List<JCTree.JCStatement>)object);
                    if (((List)object).isEmpty()) {
                        this.storeEnd((JCTree)object2, this.S.prevEndPos());
                    }
                    listBuffer.append(object2);
                    continue block5;
                }
                case EOF: 
                case RBRACE: {
                    return listBuffer.toList();
                }
            }
            this.S.nextToken();
            this.syntaxError(n, "expected3", this.keywords.token2string(Token.CASE), this.keywords.token2string(Token.DEFAULT), this.keywords.token2string(Token.RBRACE));
        }
    }

    <T extends ListBuffer<? super JCTree.JCExpressionStatement>> T moreStatementExpressions(int n, JCTree.JCExpression jCExpression, T t) {
        t.append((JCTree.JCExpressionStatement)this.toP(this.F.at(n).Exec(this.checkExprStat(jCExpression))));
        while (this.S.token() == Token.COMMA) {
            this.S.nextToken();
            n = this.S.pos();
            JCTree.JCExpression jCExpression2 = this.expression();
            t.append((JCTree.JCExpressionStatement)this.toP(this.F.at(n).Exec(this.checkExprStat(jCExpression2))));
        }
        return t;
    }

    List<JCTree.JCStatement> forInit() {
        ListBuffer listBuffer = ListBuffer.lb();
        int n = this.S.pos();
        if (this.S.token() == Token.FINAL || this.S.token() == Token.MONKEYS_AT) {
            return this.variableDeclarators(this.optFinal(0L), this.type(), listBuffer).toList();
        }
        JCTree.JCExpression jCExpression = this.term(3);
        if ((this.lastmode & 2) != 0 && (this.S.token() == Token.IDENTIFIER || this.S.token() == Token.ASSERT || this.S.token() == Token.ENUM)) {
            return this.variableDeclarators(this.modifiersOpt(), jCExpression, listBuffer).toList();
        }
        return this.moreStatementExpressions(n, jCExpression, listBuffer).toList();
    }

    List<JCTree.JCExpressionStatement> forUpdate() {
        return this.moreStatementExpressions(this.S.pos(), this.expression(), new ListBuffer()).toList();
    }

    List<JCTree.JCAnnotation> annotationsOpt() {
        if (this.S.token() != Token.MONKEYS_AT) {
            return List.nil();
        }
        ListBuffer<JCTree.JCAnnotation> listBuffer = new ListBuffer<JCTree.JCAnnotation>();
        while (this.S.token() == Token.MONKEYS_AT) {
            int n = this.S.pos();
            this.S.nextToken();
            listBuffer.append(this.annotation(n));
        }
        return listBuffer.toList();
    }

    JCTree.JCModifiers modifiersOpt() {
        return this.modifiersOpt(null);
    }

    JCTree.JCModifiers modifiersOpt(JCTree.JCModifiers jCModifiers) {
        long l;
        long l2 = l = jCModifiers == null ? 0L : jCModifiers.flags;
        if (this.S.deprecatedFlag()) {
            l |= 0x20000L;
            this.S.resetDeprecatedFlag();
        }
        ListBuffer<JCTree.JCAnnotation> listBuffer = new ListBuffer<JCTree.JCAnnotation>();
        if (jCModifiers != null) {
            listBuffer.appendList(jCModifiers.annotations);
        }
        int n = this.S.pos();
        int n2 = -1;
        block18: while (true) {
            long l3;
            switch (this.S.token()) {
                case PRIVATE: {
                    l3 = 2L;
                    break;
                }
                case PROTECTED: {
                    l3 = 4L;
                    break;
                }
                case PUBLIC: {
                    l3 = 1L;
                    break;
                }
                case STATIC: {
                    l3 = 8L;
                    break;
                }
                case TRANSIENT: {
                    l3 = 128L;
                    break;
                }
                case FINAL: {
                    l3 = 16L;
                    break;
                }
                case ABSTRACT: {
                    l3 = 1024L;
                    break;
                }
                case NATIVE: {
                    l3 = 256L;
                    break;
                }
                case VOLATILE: {
                    l3 = 64L;
                    break;
                }
                case SYNCHRONIZED: {
                    l3 = 32L;
                    break;
                }
                case STRICTFP: {
                    l3 = 2048L;
                    break;
                }
                case MONKEYS_AT: {
                    l3 = 8192L;
                    break;
                }
                default: {
                    break block18;
                }
            }
            if ((l & l3) != 0L) {
                this.log.error(this.S.pos(), "repeated.modifier", new Object[0]);
            }
            n2 = this.S.pos();
            this.S.nextToken();
            if (l3 == 8192L) {
                this.checkAnnotations();
                if (this.S.token() != Token.INTERFACE) {
                    JCTree.JCAnnotation jCAnnotation = this.annotation(n2);
                    if (l == 0L && listBuffer.isEmpty()) {
                        n = jCAnnotation.pos;
                    }
                    listBuffer.append(jCAnnotation);
                    n2 = jCAnnotation.pos;
                    l3 = 0L;
                }
            }
            l |= l3;
        }
        switch (this.S.token()) {
            case ENUM: {
                l |= 0x4000L;
                break;
            }
            case INTERFACE: {
                l |= 0x200L;
                break;
            }
        }
        if (l == 0L && listBuffer.isEmpty()) {
            n = -1;
        }
        JCTree.JCModifiers jCModifiers2 = this.F.at(n).Modifiers(l, listBuffer.toList());
        if (n != -1) {
            this.storeEnd(jCModifiers2, this.S.prevEndPos());
        }
        return jCModifiers2;
    }

    JCTree.JCAnnotation annotation(int n) {
        this.checkAnnotations();
        JCTree.JCExpression jCExpression = this.qualident();
        List<JCTree.JCExpression> list = this.annotationFieldValuesOpt();
        JCTree.JCAnnotation jCAnnotation = this.F.at(n).Annotation(jCExpression, list);
        this.storeEnd(jCAnnotation, this.S.prevEndPos());
        return jCAnnotation;
    }

    List<JCTree.JCExpression> annotationFieldValuesOpt() {
        return this.S.token() == Token.LPAREN ? this.annotationFieldValues() : List.nil();
    }

    List<JCTree.JCExpression> annotationFieldValues() {
        this.accept(Token.LPAREN);
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        if (this.S.token() != Token.RPAREN) {
            listBuffer.append(this.annotationFieldValue());
            while (this.S.token() == Token.COMMA) {
                this.S.nextToken();
                listBuffer.append(this.annotationFieldValue());
            }
        }
        this.accept(Token.RPAREN);
        return listBuffer.toList();
    }

    JCTree.JCExpression annotationFieldValue() {
        if (this.S.token() == Token.IDENTIFIER) {
            this.mode = 1;
            JCTree.JCExpression jCExpression = this.term1();
            if (jCExpression.getTag() == 35 && this.S.token() == Token.EQ) {
                int n = this.S.pos();
                this.accept(Token.EQ);
                return this.toP(this.F.at(n).Assign(jCExpression, this.annotationValue()));
            }
            return jCExpression;
        }
        return this.annotationValue();
    }

    JCTree.JCExpression annotationValue() {
        switch (this.S.token()) {
            case MONKEYS_AT: {
                int n = this.S.pos();
                this.S.nextToken();
                return this.annotation(n);
            }
            case LBRACE: {
                int n = this.S.pos();
                this.accept(Token.LBRACE);
                ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
                if (this.S.token() != Token.RBRACE) {
                    listBuffer.append(this.annotationValue());
                    while (this.S.token() == Token.COMMA) {
                        this.S.nextToken();
                        if (this.S.token() == Token.RBRACE) break;
                        listBuffer.append(this.annotationValue());
                    }
                }
                this.accept(Token.RBRACE);
                return this.toP(this.F.at(n).NewArray(null, List.<JCTree.JCExpression>nil(), listBuffer.toList()));
            }
        }
        this.mode = 1;
        return this.term1();
    }

    public <T extends ListBuffer<? super JCTree.JCVariableDecl>> T variableDeclarators(JCTree.JCModifiers jCModifiers, JCTree.JCExpression jCExpression, T t) {
        return this.variableDeclaratorsRest(this.S.pos(), jCModifiers, jCExpression, this.ident(), false, null, t);
    }

    <T extends ListBuffer<? super JCTree.JCVariableDecl>> T variableDeclaratorsRest(int n, JCTree.JCModifiers jCModifiers, JCTree.JCExpression jCExpression, Name name, boolean bl, String string, T t) {
        t.append((JCTree.JCVariableDecl)this.variableDeclaratorRest(n, jCModifiers, jCExpression, name, bl, string));
        while (this.S.token() == Token.COMMA) {
            this.storeEnd((JCTree)t.elems.last(), this.S.endPos());
            this.S.nextToken();
            t.append((JCTree.JCVariableDecl)this.variableDeclarator(jCModifiers, jCExpression, bl, string));
        }
        return t;
    }

    JCTree.JCVariableDecl variableDeclarator(JCTree.JCModifiers jCModifiers, JCTree.JCExpression jCExpression, boolean bl, String string) {
        return this.variableDeclaratorRest(this.S.pos(), jCModifiers, jCExpression, this.ident(), bl, string);
    }

    JCTree.JCVariableDecl variableDeclaratorRest(int n, JCTree.JCModifiers jCModifiers, JCTree.JCExpression jCExpression, Name name, boolean bl, String string) {
        jCExpression = this.bracketsOpt(jCExpression);
        JCTree.JCExpression jCExpression2 = null;
        if (this.S.token() == Token.EQ) {
            this.S.nextToken();
            jCExpression2 = this.variableInitializer();
        } else if (bl) {
            this.syntaxError(this.S.pos(), "expected", this.keywords.token2string(Token.EQ));
        }
        JCTree.JCVariableDecl jCVariableDecl = this.toP(this.F.at(n).VarDef(jCModifiers, name, jCExpression, jCExpression2));
        this.attach(jCVariableDecl, string);
        return jCVariableDecl;
    }

    JCTree.JCVariableDecl variableDeclaratorId(JCTree.JCModifiers jCModifiers, JCTree.JCExpression jCExpression) {
        int n = this.S.pos();
        Name name = this.ident();
        if ((jCModifiers.flags & 0x400000000L) == 0L) {
            jCExpression = this.bracketsOpt(jCExpression);
        }
        return this.toP(this.F.at(n).VarDef(jCModifiers, name, jCExpression, null));
    }

    public JCTree.JCCompilationUnit compilationUnit() {
        JCTree jCTree;
        int n = this.S.pos();
        JCTree.JCExpression jCExpression = null;
        String string = this.S.docComment();
        JCTree.JCModifiers jCModifiers = null;
        List<JCTree.JCAnnotation> list = List.nil();
        if (this.S.token() == Token.MONKEYS_AT) {
            jCModifiers = this.modifiersOpt();
        }
        if (this.S.token() == Token.PACKAGE) {
            if (jCModifiers != null) {
                this.checkNoMods(jCModifiers.flags);
                list = jCModifiers.annotations;
                jCModifiers = null;
            }
            this.S.nextToken();
            jCExpression = this.qualident();
            this.accept(Token.SEMI);
        }
        ListBuffer<JCTree> listBuffer = new ListBuffer<JCTree>();
        boolean bl = true;
        while (this.S.token() != Token.EOF) {
            if (this.S.pos() <= this.errorEndPos) {
                this.skip(bl, false, false, false);
                if (this.S.token() == Token.EOF) break;
            }
            if (bl && jCModifiers == null && this.S.token() == Token.IMPORT) {
                listBuffer.append(this.importDeclaration());
                continue;
            }
            jCTree = this.typeDeclaration(jCModifiers);
            if (jCTree instanceof JCTree.JCExpressionStatement) {
                jCTree = ((JCTree.JCExpressionStatement)jCTree).expr;
            }
            listBuffer.append(jCTree);
            if (jCTree instanceof JCTree.JCClassDecl) {
                bl = false;
            }
            jCModifiers = null;
        }
        jCTree = this.F.at(n).TopLevel(list, jCExpression, listBuffer.toList());
        this.attach(jCTree, string);
        if (listBuffer.elems.isEmpty()) {
            this.storeEnd(jCTree, this.S.prevEndPos());
        }
        if (this.keepDocComments) {
            jCTree.docComments = this.docComments;
        }
        return jCTree;
    }

    JCTree importDeclaration() {
        int n = this.S.pos();
        this.S.nextToken();
        boolean bl = false;
        if (this.S.token() == Token.STATIC) {
            this.checkStaticImports();
            bl = true;
            this.S.nextToken();
        }
        JCTree.JCExpression jCExpression = this.toP(this.F.at(this.S.pos()).Ident(this.ident()));
        do {
            int n2 = this.S.pos();
            this.accept(Token.DOT);
            if (this.S.token() == Token.STAR) {
                jCExpression = this.to(this.F.at(n2).Select(jCExpression, this.names.asterisk));
                this.S.nextToken();
                break;
            }
            jCExpression = this.toP(this.F.at(n2).Select(jCExpression, this.ident()));
        } while (this.S.token() == Token.DOT);
        this.accept(Token.SEMI);
        return this.toP(this.F.at(n).Import(jCExpression, bl));
    }

    JCTree typeDeclaration(JCTree.JCModifiers jCModifiers) {
        int n = this.S.pos();
        if (jCModifiers == null && this.S.token() == Token.SEMI) {
            this.S.nextToken();
            return this.toP(this.F.at(n).Skip());
        }
        String string = this.S.docComment();
        return this.classOrInterfaceOrEnumDeclaration(this.modifiersOpt(jCModifiers), string);
    }

    JCTree.JCStatement classOrInterfaceOrEnumDeclaration(JCTree.JCModifiers jCModifiers, String string) {
        List<JCTree> list;
        if (this.S.token() == Token.CLASS) {
            return this.classDeclaration(jCModifiers, string);
        }
        if (this.S.token() == Token.INTERFACE) {
            return this.interfaceDeclaration(jCModifiers, string);
        }
        if (this.allowEnums) {
            List<JCTree> list2;
            if (this.S.token() == Token.ENUM) {
                return this.enumDeclaration(jCModifiers, string);
            }
            int n = this.S.pos();
            if (this.S.token() == Token.IDENTIFIER) {
                list2 = List.of(jCModifiers, this.toP(this.F.at(n).Ident(this.ident())));
                this.setErrorEndPos(this.S.pos());
            } else {
                list2 = List.of(jCModifiers);
            }
            return this.toP(this.F.Exec(this.syntaxError(n, list2, "expected3", this.keywords.token2string(Token.CLASS), this.keywords.token2string(Token.INTERFACE), this.keywords.token2string(Token.ENUM))));
        }
        if (this.S.token() == Token.ENUM) {
            this.log.error(this.S.pos(), "enums.not.supported.in.source", this.source.name);
            this.allowEnums = true;
            return this.enumDeclaration(jCModifiers, string);
        }
        int n = this.S.pos();
        if (this.S.token() == Token.IDENTIFIER) {
            list = List.of(jCModifiers, this.toP(this.F.at(n).Ident(this.ident())));
            this.setErrorEndPos(this.S.pos());
        } else {
            list = List.of(jCModifiers);
        }
        return this.toP(this.F.Exec(this.syntaxError(n, list, "expected2", this.keywords.token2string(Token.CLASS), this.keywords.token2string(Token.INTERFACE))));
    }

    JCTree.JCClassDecl classDeclaration(JCTree.JCModifiers jCModifiers, String string) {
        int n = this.S.pos();
        this.accept(Token.CLASS);
        Name name = this.ident();
        List<JCTree.JCTypeParameter> list = this.typeParametersOpt();
        JCTree.JCExpression jCExpression = null;
        if (this.S.token() == Token.EXTENDS) {
            this.S.nextToken();
            jCExpression = this.type();
        }
        List<JCTree.JCExpression> list2 = List.nil();
        if (this.S.token() == Token.IMPLEMENTS) {
            this.S.nextToken();
            list2 = this.typeList();
        }
        List<JCTree> list3 = this.classOrInterfaceBody(name, false);
        JCTree.JCClassDecl jCClassDecl = this.toP(this.F.at(n).ClassDef(jCModifiers, name, list, jCExpression, list2, list3));
        this.attach(jCClassDecl, string);
        return jCClassDecl;
    }

    JCTree.JCClassDecl interfaceDeclaration(JCTree.JCModifiers jCModifiers, String string) {
        int n = this.S.pos();
        this.accept(Token.INTERFACE);
        Name name = this.ident();
        List<JCTree.JCTypeParameter> list = this.typeParametersOpt();
        List<JCTree.JCExpression> list2 = List.nil();
        if (this.S.token() == Token.EXTENDS) {
            this.S.nextToken();
            list2 = this.typeList();
        }
        List<JCTree> list3 = this.classOrInterfaceBody(name, true);
        JCTree.JCClassDecl jCClassDecl = this.toP(this.F.at(n).ClassDef(jCModifiers, name, list, null, list2, list3));
        this.attach(jCClassDecl, string);
        return jCClassDecl;
    }

    JCTree.JCClassDecl enumDeclaration(JCTree.JCModifiers jCModifiers, String string) {
        int n = this.S.pos();
        this.accept(Token.ENUM);
        Name name = this.ident();
        List<JCTree.JCExpression> list = List.nil();
        if (this.S.token() == Token.IMPLEMENTS) {
            this.S.nextToken();
            list = this.typeList();
        }
        List<JCTree> list2 = this.enumBody(name);
        JCTree.JCModifiers jCModifiers2 = this.F.at(jCModifiers.pos).Modifiers(jCModifiers.flags | 0x4000L, jCModifiers.annotations);
        JCTree.JCClassDecl jCClassDecl = this.toP(this.F.at(n).ClassDef(jCModifiers2, name, List.<JCTree.JCTypeParameter>nil(), null, list, list2));
        this.attach(jCClassDecl, string);
        return jCClassDecl;
    }

    List<JCTree> enumBody(Name name) {
        this.accept(Token.LBRACE);
        ListBuffer<JCTree> listBuffer = new ListBuffer<JCTree>();
        if (this.S.token() == Token.COMMA) {
            this.S.nextToken();
        } else if (this.S.token() != Token.RBRACE && this.S.token() != Token.SEMI) {
            listBuffer.append(this.enumeratorDeclaration(name));
            while (this.S.token() == Token.COMMA) {
                this.S.nextToken();
                if (this.S.token() == Token.RBRACE || this.S.token() == Token.SEMI) break;
                listBuffer.append(this.enumeratorDeclaration(name));
            }
            if (this.S.token() != Token.SEMI && this.S.token() != Token.RBRACE) {
                listBuffer.append(this.syntaxError(this.S.pos(), "expected3", this.keywords.token2string(Token.COMMA), this.keywords.token2string(Token.RBRACE), this.keywords.token2string(Token.SEMI)));
                this.S.nextToken();
            }
        }
        if (this.S.token() == Token.SEMI) {
            this.S.nextToken();
            while (this.S.token() != Token.RBRACE && this.S.token() != Token.EOF) {
                listBuffer.appendList(this.classOrInterfaceBodyDeclaration(name, false));
                if (this.S.pos() > this.errorEndPos) continue;
                this.skip(false, true, true, false);
            }
        }
        this.accept(Token.RBRACE);
        return listBuffer.toList();
    }

    JCTree enumeratorDeclaration(Name name) {
        Object object;
        JCTree jCTree;
        String string = this.S.docComment();
        int n = 16409;
        if (this.S.deprecatedFlag()) {
            n |= 0x20000;
            this.S.resetDeprecatedFlag();
        }
        int n2 = this.S.pos();
        List<JCTree.JCAnnotation> list = this.annotationsOpt();
        JCTree.JCModifiers jCModifiers = this.F.at(list.isEmpty() ? -1 : n2).Modifiers(n, list);
        List<JCTree.JCExpression> list2 = this.typeArgumentsOpt();
        int n3 = this.S.pos();
        Name name2 = this.ident();
        int n4 = this.S.pos();
        List<Object> list3 = this.S.token() == Token.LPAREN ? this.arguments() : List.nil();
        JCTree.JCClassDecl jCClassDecl = null;
        if (this.S.token() == Token.LBRACE) {
            jCTree = this.F.at(-1).Modifiers(16392L);
            object = this.classOrInterfaceBody(this.names.empty, false);
            jCClassDecl = this.toP(this.F.at(n3).AnonymousClassDef((JCTree.JCModifiers)jCTree, (List<JCTree>)object));
        }
        if (list3.isEmpty() && jCClassDecl == null) {
            n4 = -1;
        }
        jCTree = this.F.at(-1).Ident(name);
        object = this.F.at(n4).NewClass(null, list2, (JCTree.JCExpression)jCTree, list3, jCClassDecl);
        if (n4 != -1) {
            this.storeEnd((JCTree)object, this.S.prevEndPos());
        }
        jCTree = this.F.at(-1).Ident(name);
        JCTree.JCVariableDecl jCVariableDecl = this.toP(this.F.at(n2).VarDef(jCModifiers, name2, (JCTree.JCExpression)jCTree, (JCTree.JCExpression)object));
        this.attach(jCVariableDecl, string);
        return jCVariableDecl;
    }

    List<JCTree.JCExpression> typeList() {
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        listBuffer.append(this.type());
        while (this.S.token() == Token.COMMA) {
            this.S.nextToken();
            listBuffer.append(this.type());
        }
        return listBuffer.toList();
    }

    List<JCTree> classOrInterfaceBody(Name name, boolean bl) {
        this.accept(Token.LBRACE);
        if (this.S.pos() <= this.errorEndPos) {
            this.skip(false, true, false, false);
            if (this.S.token() == Token.LBRACE) {
                this.S.nextToken();
            }
        }
        ListBuffer<JCTree> listBuffer = new ListBuffer<JCTree>();
        while (this.S.token() != Token.RBRACE && this.S.token() != Token.EOF) {
            listBuffer.appendList(this.classOrInterfaceBodyDeclaration(name, bl));
            if (this.S.pos() > this.errorEndPos) continue;
            this.skip(false, true, true, false);
        }
        this.accept(Token.RBRACE);
        return listBuffer.toList();
    }

    List<JCTree> classOrInterfaceBodyDeclaration(Name name, boolean bl) {
        JCTree.JCExpression jCExpression;
        boolean bl2;
        if (this.S.token() == Token.SEMI) {
            this.S.nextToken();
            return List.of(this.F.at(-1).Block(0L, List.<JCTree.JCStatement>nil()));
        }
        String string = this.S.docComment();
        int n = this.S.pos();
        JCTree.JCModifiers jCModifiers = this.modifiersOpt();
        if (this.S.token() == Token.CLASS || this.S.token() == Token.INTERFACE || this.allowEnums && this.S.token() == Token.ENUM) {
            return List.of(this.classOrInterfaceOrEnumDeclaration(jCModifiers, string));
        }
        if (this.S.token() == Token.LBRACE && !bl && (jCModifiers.flags & 0xFFFL & 0xFFFFFFFFFFFFFFF7L) == 0L && jCModifiers.annotations.isEmpty()) {
            return List.of(this.block(n, jCModifiers.flags));
        }
        n = this.S.pos();
        List<JCTree.JCTypeParameter> list = this.typeParametersOpt();
        if (list.length() > 0 && jCModifiers.pos == -1) {
            jCModifiers.pos = n;
        }
        Token token = this.S.token();
        Name name2 = this.S.name();
        n = this.S.pos();
        boolean bl3 = bl2 = this.S.token() == Token.VOID;
        if (bl2) {
            jCExpression = this.to(this.F.at(n).TypeIdent(9));
            this.S.nextToken();
        } else {
            jCExpression = this.type();
        }
        if (this.S.token() == Token.LPAREN && !bl && jCExpression.getTag() == 35) {
            if (bl || name2 != name) {
                this.log.error(n, "invalid.meth.decl.ret.type.req", new Object[0]);
            }
            return List.of(this.methodDeclaratorRest(n, jCModifiers, null, this.names.init, list, bl, true, string));
        }
        n = this.S.pos();
        name2 = this.ident();
        if (this.S.token() == Token.LPAREN) {
            return List.of(this.methodDeclaratorRest(n, jCModifiers, jCExpression, name2, list, bl, bl2, string));
        }
        if (!bl2 && list.isEmpty()) {
            List<JCTree> list2 = this.variableDeclaratorsRest(n, jCModifiers, jCExpression, name2, bl, string, new ListBuffer()).toList();
            this.storeEnd((JCTree)list2.last(), this.S.endPos());
            this.accept(Token.SEMI);
            return list2;
        }
        n = this.S.pos();
        List<JCTree> list3 = bl2 ? List.of(this.toP(this.F.at(n).MethodDef(jCModifiers, name2, jCExpression, list, List.<JCTree.JCVariableDecl>nil(), List.<JCTree.JCExpression>nil(), null, null))) : null;
        return List.of(this.syntaxError(this.S.pos(), list3, "expected", this.keywords.token2string(Token.LPAREN)));
    }

    JCTree methodDeclaratorRest(int n, JCTree.JCModifiers jCModifiers, JCTree.JCExpression jCExpression, Name name, List<JCTree.JCTypeParameter> list, boolean bl, boolean bl2, String string) {
        JCTree.JCExpression jCExpression2;
        List<JCTree.JCVariableDecl> list2 = this.formalParameters();
        if (!bl2) {
            jCExpression = this.bracketsOpt(jCExpression);
        }
        List<JCTree.JCExpression> list3 = List.nil();
        if (this.S.token() == Token.THROWS) {
            this.S.nextToken();
            list3 = this.qualidentList();
        }
        JCTree.JCBlock jCBlock = null;
        if (this.S.token() == Token.LBRACE) {
            jCBlock = this.block();
            jCExpression2 = null;
        } else {
            if (this.S.token() == Token.DEFAULT) {
                this.accept(Token.DEFAULT);
                jCExpression2 = this.annotationValue();
            } else {
                jCExpression2 = null;
            }
            this.accept(Token.SEMI);
            if (this.S.pos() <= this.errorEndPos) {
                this.skip(false, true, false, false);
                if (this.S.token() == Token.LBRACE) {
                    jCBlock = this.block();
                }
            }
        }
        JCTree.JCMethodDecl jCMethodDecl = this.toP(this.F.at(n).MethodDef(jCModifiers, name, jCExpression, list, list2, list3, jCBlock, jCExpression2));
        this.attach(jCMethodDecl, string);
        return jCMethodDecl;
    }

    List<JCTree.JCExpression> qualidentList() {
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        listBuffer.append(this.qualident());
        while (this.S.token() == Token.COMMA) {
            this.S.nextToken();
            listBuffer.append(this.qualident());
        }
        return listBuffer.toList();
    }

    List<JCTree.JCTypeParameter> typeParametersOpt() {
        if (this.S.token() == Token.LT) {
            this.checkGenerics();
            ListBuffer<JCTree.JCTypeParameter> listBuffer = new ListBuffer<JCTree.JCTypeParameter>();
            this.S.nextToken();
            listBuffer.append(this.typeParameter());
            while (this.S.token() == Token.COMMA) {
                this.S.nextToken();
                listBuffer.append(this.typeParameter());
            }
            this.accept(Token.GT);
            return listBuffer.toList();
        }
        return List.nil();
    }

    JCTree.JCTypeParameter typeParameter() {
        int n = this.S.pos();
        Name name = this.ident();
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        if (this.S.token() == Token.EXTENDS) {
            this.S.nextToken();
            listBuffer.append(this.type());
            while (this.S.token() == Token.AMP) {
                this.S.nextToken();
                listBuffer.append(this.type());
            }
        }
        return this.toP(this.F.at(n).TypeParameter(name, listBuffer.toList()));
    }

    List<JCTree.JCVariableDecl> formalParameters() {
        ListBuffer<JCTree.JCVariableDecl> listBuffer = new ListBuffer<JCTree.JCVariableDecl>();
        JCTree.JCVariableDecl jCVariableDecl = null;
        this.accept(Token.LPAREN);
        if (this.S.token() != Token.RPAREN) {
            jCVariableDecl = this.formalParameter();
            listBuffer.append(jCVariableDecl);
            while ((jCVariableDecl.mods.flags & 0x400000000L) == 0L && this.S.token() == Token.COMMA) {
                this.S.nextToken();
                jCVariableDecl = this.formalParameter();
                listBuffer.append(jCVariableDecl);
            }
        }
        this.accept(Token.RPAREN);
        return listBuffer.toList();
    }

    JCTree.JCModifiers optFinal(long l) {
        JCTree.JCModifiers jCModifiers = this.modifiersOpt();
        this.checkNoMods(jCModifiers.flags & 0xFFFFFFFFFFFDFFEFL);
        jCModifiers.flags |= l;
        return jCModifiers;
    }

    JCTree.JCVariableDecl formalParameter() {
        JCTree.JCModifiers jCModifiers = this.optFinal(0x200000000L);
        JCTree.JCExpression jCExpression = this.type();
        if (this.S.token() == Token.ELLIPSIS) {
            this.checkVarargs();
            jCModifiers.flags |= 0x400000000L;
            jCExpression = this.to(this.F.at(this.S.pos()).TypeArray(jCExpression));
            this.S.nextToken();
        }
        return this.variableDeclaratorId(jCModifiers, jCExpression);
    }

    protected JCTree.JCExpression checkExprStat(JCTree.JCExpression jCExpression) {
        switch (jCExpression.getTag()) {
            case 26: 
            case 27: 
            case 30: 
            case 45: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return jCExpression;
            }
        }
        this.log.error(jCExpression.pos, "not.stmt", new Object[0]);
        return this.F.at(jCExpression.pos).Erroneous(List.of(jCExpression));
    }

    static int prec(Token token) {
        int n = Parser.optag(token);
        return n >= 0 ? TreeInfo.opPrec(n) : -1;
    }

    static int optag(Token token) {
        switch (token) {
            case BARBAR: {
                return 55;
            }
            case AMPAMP: {
                return 56;
            }
            case BAR: {
                return 57;
            }
            case BAREQ: {
                return 74;
            }
            case CARET: {
                return 58;
            }
            case CARETEQ: {
                return 75;
            }
            case AMP: {
                return 59;
            }
            case AMPEQ: {
                return 76;
            }
            case EQEQ: {
                return 60;
            }
            case BANGEQ: {
                return 61;
            }
            case LT: {
                return 62;
            }
            case GT: {
                return 63;
            }
            case LTEQ: {
                return 64;
            }
            case GTEQ: {
                return 65;
            }
            case LTLT: {
                return 66;
            }
            case LTLTEQ: {
                return 83;
            }
            case GTGT: {
                return 67;
            }
            case GTGTEQ: {
                return 84;
            }
            case GTGTGT: {
                return 68;
            }
            case GTGTGTEQ: {
                return 85;
            }
            case PLUS: {
                return 69;
            }
            case PLUSEQ: {
                return 86;
            }
            case SUB: {
                return 70;
            }
            case SUBEQ: {
                return 87;
            }
            case STAR: {
                return 71;
            }
            case STAREQ: {
                return 88;
            }
            case SLASH: {
                return 72;
            }
            case SLASHEQ: {
                return 89;
            }
            case PERCENT: {
                return 73;
            }
            case PERCENTEQ: {
                return 90;
            }
            case INSTANCEOF: {
                return 32;
            }
        }
        return -1;
    }

    static int unoptag(Token token) {
        switch (token) {
            case PLUS: {
                return 46;
            }
            case SUB: {
                return 47;
            }
            case BANG: {
                return 48;
            }
            case TILDE: {
                return 49;
            }
            case PLUSPLUS: {
                return 50;
            }
            case SUBSUB: {
                return 51;
            }
        }
        return -1;
    }

    static int typetag(Token token) {
        switch (token) {
            case BYTE: {
                return 1;
            }
            case CHAR: {
                return 2;
            }
            case SHORT: {
                return 3;
            }
            case INT: {
                return 4;
            }
            case LONG: {
                return 5;
            }
            case FLOAT: {
                return 6;
            }
            case DOUBLE: {
                return 7;
            }
            case BOOLEAN: {
                return 8;
            }
        }
        return -1;
    }

    void checkGenerics() {
        if (!this.allowGenerics) {
            this.log.error(this.S.pos(), "generics.not.supported.in.source", this.source.name);
            this.allowGenerics = true;
        }
    }

    void checkVarargs() {
        if (!this.allowVarargs) {
            this.log.error(this.S.pos(), "varargs.not.supported.in.source", this.source.name);
            this.allowVarargs = true;
        }
    }

    void checkForeach() {
        if (!this.allowForeach) {
            this.log.error(this.S.pos(), "foreach.not.supported.in.source", this.source.name);
            this.allowForeach = true;
        }
    }

    void checkStaticImports() {
        if (!this.allowStaticImport) {
            this.log.error(this.S.pos(), "static.import.not.supported.in.source", this.source.name);
            this.allowStaticImport = true;
        }
    }

    void checkAnnotations() {
        if (!this.allowAnnotations) {
            this.log.error(this.S.pos(), "annotations.not.supported.in.source", this.source.name);
            this.allowAnnotations = true;
        }
    }

    public static class Factory {
        protected static final Context.Key<Factory> parserFactoryKey = new Context.Key();
        final TreeMaker F;
        final Log log;
        final Keywords keywords;
        final Source source;
        final Name.Table names;
        final Options options;

        public static Factory instance(Context context) {
            Factory factory = context.get(parserFactoryKey);
            if (factory == null) {
                factory = new Factory(context);
            }
            return factory;
        }

        protected Factory(Context context) {
            context.put(parserFactoryKey, this);
            this.F = TreeMaker.instance(context);
            this.log = Log.instance(context);
            this.names = Name.Table.instance(context);
            this.keywords = Keywords.instance(context);
            this.source = Source.instance(context);
            this.options = Options.instance(context);
        }

        public Parser newParser(Lexer lexer, boolean bl, boolean bl2) {
            if (!bl2) {
                return new Parser(this, lexer, bl);
            }
            return new EndPosParser(this, lexer, bl);
        }
    }
}

