/*
 * Decompiled with CFR 0.152.
 */
package logformat.clog2TOdrawable;

import base.drawable.Category;
import base.drawable.Kind;
import base.drawable.Primitive;
import base.drawable.Topology;
import base.drawable.YCoordMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import logformat.clog2TOdrawable.InputLog;

public class Print {
    public static final void main(String[] stringArray) {
        Kind kind;
        if (stringArray.length != 1) {
            System.err.println("It needs the filename to be the only command line arguemnt");
            System.exit(0);
        }
        String string = stringArray[0];
        ArrayList<Category> arrayList = new ArrayList<Category>();
        HashMap<Topology, Category> hashMap = new HashMap<Topology, Category>();
        ArrayList<YCoordMap> arrayList2 = new ArrayList<YCoordMap>();
        long l = 0L;
        Date date = new Date();
        InputLog inputLog = new InputLog(string);
        Date date2 = new Date();
        while ((kind = inputLog.peekNextKind()) != Kind.EOF) {
            Category category;
            if (kind == Kind.TOPOLOGY) {
                Topology topology = inputLog.getNextTopology();
                category = Category.getShadowCategory(topology);
                arrayList.add(category);
                hashMap.put(topology, category);
            }
            if (kind == Kind.YCOORDMAP) {
                arrayList2.add(inputLog.getNextYCoordMap());
            }
            if (kind == Kind.CATEGORY) {
                category = inputLog.getNextCategory();
                arrayList.add(category);
            }
            if (kind != Kind.PRIMITIVE) continue;
            Primitive primitive = inputLog.getNextPrimitive();
            System.out.println(++l + ", " + primitive);
        }
        inputLog.close();
        Date date3 = new Date();
        System.out.println("\n\t Shadow Category Definitions : ");
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
        System.out.println("\n\t Primitive Category Definitions : ");
        for (Category category : arrayList) {
            System.out.println(category.toString());
        }
        System.out.println("\n\t YCoordMap Definitions : ");
        for (YCoordMap yCoordMap : arrayList2) {
            System.out.println(yCoordMap.toString());
        }
        System.out.println("\n");
        System.out.println("Number of Primitives = " + l);
        System.out.println("Number of Unmatched Events = " + inputLog.getNumberOfUnMatchedEvents());
        System.out.println("Total ByteSize of the logfile = " + inputLog.getTotalBytesRead());
        System.out.println("timeElapsed between 1 & 2 = " + (date2.getTime() - date.getTime()) + " msec");
        System.out.println("timeElapsed between 2 & 3 = " + (date3.getTime() - date2.getTime()) + " msec");
    }
}

