#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <errno.h>
#include <gtk/gtk.h>

#ifndef USE_OSX
#include <linux/limits.h>
#endif

#define MAX_PATH NAME_MAX + PATH_MAX

#include "mplinux.h"
#include "mp3util.h"
#include "ini/ini.h"

GList* PlayList = NULL;

// need this to support another generic mp3 list, not tied to playlist
// should have done this at design time
void pl_MegaHack(int i) {
    static GList* templist;
    GList* tmp;

    if (i) {
        templist = PlayList;
        PlayList = NULL;
    } else {
            while (PlayList)
                pl_Remove(PlayList->data);

        PlayList = templist;
    }
}

GList* pl_GetPlayList() {
    return PlayList;
}

gint EntriesAllocated = 0;

gchar* path_cat(gchar* ret,gchar* p1,char* p2) {
     if (strlen(p1) + strlen(p2) > MAX_PATH - 1)
	  return NULL;
     strncpy(ret,p1,MAX_PATH);
     if (p1[strlen(p1) -1] != '/')
	  strcat(ret,"/");
     strncat(ret,p2,MAX_PATH - (strlen(p1) +1));

     return ret;
}

gchar* strip_path(gchar* filename) {
     gchar* c;

     c = filename + strlen(filename);
     while (c != filename) {
          c--;
          if (*c == '/' || *c == '\\') {
               c++;
               break;
          }
     }
     return c;
}

gchar* strip_dotmp3(gchar* filename) {
     static gchar ret[NAME_MAX +1];
     gchar* c;
     
     strncpy(ret,filename,NAME_MAX);
     c = ret + strlen(ret);
     while (c != ret) {
          c--;
          if (strncasecmp(c,".mp3",3) == 0) {
               *c = '\0';
               break;
          }
     }
     return ret;
}

gint pl_listcomp(PlayListEntry* entry1,PlayListEntry* entry2) {
     GString* s1; GString* s2;

     s1 = entry1->name;
     s2 = entry2->name;

     return strcmp(s1->str,s2->str);
}


PlayListEntry* pl_New(gchar* name,gchar* ID3name,gint filesize) {
     PlayListEntry* new;
	 gsize bytes_read;
	 gsize bytes_written;
	 
     new = g_malloc(sizeof(PlayListEntry));
     
     new->name = g_string_new(name);
     new->ID3name = g_string_new(ID3name);
     new->filesize = filesize;
#ifdef NLS	 
	 new->ID3name_utf8 = g_string_new(convert_if_needed(ID3name));
#else
 	 new->ID3name_utf8 = g_string_new(ID3name);
#endif

     PlayList = g_list_insert_sorted(PlayList,new,(GCompareFunc)pl_listcomp);
     return new;
}

void pl_Remove(PlayListEntry* remove) {
     g_string_free(remove->name,TRUE);
     g_string_free(remove->ID3name,TRUE);
	 g_string_free(remove->ID3name_utf8,TRUE);
     PlayList = g_list_remove(PlayList,remove);
     g_free(remove);
}


struct mp3_info* pl_GetMp3Info(gchar* filename) {
     
     if (!mp3_valid(filename)) 
	  return NULL;
	  
     return mp3_get_info();
}

void replace_substring(GString* g_str, gchar* find, gchar* rep) {
    char* str;
    char* c;
    int pos;
    int len;
    
    len = strlen(find);
    str = g_str->str;

    while (c = strstr(str,find)) {
        pos = c - str;
        g_string_erase(g_str,pos,len);
        g_string_insert(g_str,pos,rep);
        str = g_str->str;
    }
    
}

PlayListEntry* pl_AddFile(gchar* filename) {
     struct mp3_info* info = NULL;
     gchar temp[81];
     gchar* c;
     GString* custom;
     PlayListEntry* entry;

/*
     if (!mp3_valid(filename)) 
	  return NULL;
*/
	if (!mp3_get_tag(filename))
		return NULL;

     info = mp3_get_info();
     if (info->hastag) {
         c = cfg_Read("options","use custom titles","0");
         if (atoi(c)) {
             custom = g_string_sized_new(40);
             g_string_append(custom,cfg_Read("options","title format","%p - %t"));
             replace_substring(custom,"%p",info->artist);
             replace_substring(custom,"%t",info->title);
             replace_substring(custom,"%f",strip_dotmp3(strip_path(filename)));
             replace_substring(custom,"%c",info->comment);
             replace_substring(custom,"%a",info->album);
             entry = pl_New(filename,custom->str,info->filesize);
             g_string_free(custom,TRUE);
             return entry;
         } else {
             if ( (c = strchr(strip_path(filename),'-')) ) {
                    if (strlen(c) - 6 > strlen(info->title)) 
                        snprintf(temp,81,"%s %s",info->artist,strip_dotmp3(c));
                    else 
                        snprintf(temp,81,"%s - %s",info->artist,info->title);                    
             }
             else {
                 snprintf(temp,81,"%s - %s",info->artist,info->title);
             }
             return pl_New(filename,strip_dotmp3(temp),info->filesize);
         }
     }
     else 
	  return pl_New(filename,strip_dotmp3(strip_path(filename)),info->filesize);
} 


static gint AddDirectoryCancel = 0;

void pl_AddDirectoryCancel(gboolean a) {
     if (a == TRUE)
	  AddDirectoryCancel = 1;
     else
	  AddDirectoryCancel = 0;
}


//returned list must be freed
GList* pl_AddDirectory(gchar* dirname) {
     GDir* gdir;
     gchar* c;
     GList* ret = NULL;
     PlayListEntry* p;
     gchar file_path[NAME_MAX + PATH_MAX];
     
     gdir = g_dir_open(dirname,0,NULL);
     if (!gdir)
	  return NULL;
  
     while ( ( (c = (gchar*)g_dir_read_name(gdir)) != NULL) && (!AddDirectoryCancel) ) {
	  path_cat(file_path,dirname,c);
	  if (g_file_test(file_path,G_FILE_TEST_IS_DIR)) {
	       GList* more = NULL;
	       more = pl_AddDirectory(file_path);
	       ret = g_list_concat(ret,more);
	       continue;
	  }

	  if (strlen(c) < 5)
	       continue;
	  if (c[strlen(c) -1] != '3')
	       continue;
	  if (! ( (c[strlen(c) - 2] == 'p') || (c[strlen(c) - 2] == 'P') ) )
	       continue;
	  if (! ( (c[strlen(c) - 3] == 'm') || (c[strlen(c) - 3] == 'M') ) )
	       continue;

	  p = pl_AddFile(file_path);
	  if (p)
	       ret = g_list_append(ret,p);
	  
     } 

     if (AddDirectoryCancel)
	  if (ret) {
	       GList* tmp;
	       for(tmp = ret;tmp;tmp = g_list_next(tmp)) 
		    pl_Remove(tmp->data);
	       g_list_free(ret);
	       ret = NULL;
	  }
	       
     g_dir_close(gdir);
     return ret;
}

gboolean pl_StringOk(guchar* string) {
     int i;

     for(i=0;i<strlen(string);i++) 
	  if (string[i] > 127)
	       return FALSE;

     return TRUE;
     
}

gint loadlist_file_size = 1;
gint loadlist_file_position = 0;

float pl_LoadListProgress() {

	return (float) loadlist_file_position / (float) loadlist_file_size;
}


GList* pl_LoadList(gchar* filename) {
     FILE* fp;
     GList* list = NULL;
     guchar buffer[256];
     PlayListEntry* p;
	 int len;
	 
     fp = fopen(filename,"r");
     if (!fp) return NULL;

	fseek(fp,0,SEEK_END);
	loadlist_file_size = ftell(fp);
	fseek(fp,0,SEEK_SET);
	loadlist_file_position = 0;
	
     while (fgets(buffer,256,fp)) {
	  if (( len = strlen(buffer) ) < 1) break;
	  //if (pl_StringOk(buffer) == FALSE) {fclose(fp);return NULL;}

	  if (buffer[len -1] == '\n') {
	       buffer[len -1]  = '\0';
	  		len = strlen(buffer);
	  }
	  
	  if (buffer[0] == '#') continue;
	  if (buffer[0] == ';') continue;

	
	  if (buffer[len -1] != '3')
	       continue;
	  if (! ( (buffer[len - 2] == 'p') || (buffer[len - 2] == 'P') ) )
	       continue;
	  if (! ( (buffer[len - 3] == 'm') || (buffer[len - 3] == 'M') ) )
	       continue;

	  p = pl_AddFile(buffer);
	  if (p)
		  list = g_list_append(list,p);
	  loadlist_file_position = ftell(fp);
     }

     fclose(fp);

     return list;
}

int pl_SaveList(GList* list,gchar* filename) {
     FILE* fp;
     GList* i;
     PlayListEntry* p;

     fp = fopen(filename,"w");
     if (!fp) return 0;

     for(i=list;i;i = g_list_next(i)) {
	  p = i->data;
	  fwrite(p->name->str,1,strlen(p->name->str),fp);
	  fwrite("\n",1,1,fp);
     }
     fclose(fp);
     return 1;
}

void  pl_RemoveBigger(gint big) {
     GList* i;

     for(i=PlayList;i; )
	  if ( ( ((PlayListEntry*)i->data)->filesize > big) 
	  ||  (((PlayListEntry*)i->data)->filesize == 0)   ) {
	       pl_Remove(i->data);
	       i = PlayList;
	  } else 
	       i = g_list_next(i);
}

guint  pl_ListSize() {
     GList* i;
     guint size = 0;

     for(i=PlayList;i;i = g_list_next(i) )
	  size = size + ((PlayListEntry*)i->data)->filesize;

     return size;
}


GList* pl_RandomizeList(guint freemem) {
     gint len;
     PlayListEntry* p;
     gint random_index;
     GRand* g;

     len = g_list_length(PlayList);
     if (len < 2)
	  return PlayList;
     pl_RemoveBigger(freemem);
     len = g_list_length(PlayList);
     if (len < 2)
	  return PlayList;

     g =  g_rand_new();

     while (pl_ListSize() > freemem) {
	  random_index = g_rand_int_range(g,0,len);
	  p = g_list_nth_data(PlayList,random_index);
	  pl_Remove(p);
	  len--;
	  if (len == 1)
	       break;
     }
     
     return PlayList;
}

static gint ini_fd = -1;
static GString* cfg_filename;

int cfg_Init() {
     gint fd;
     gint ret = CFG_OK;
     gchar fullpath[PATH_MAX + NAME_MAX];

     strncpy(fullpath,getenv("HOME"),PATH_MAX);
     strncat(fullpath,CFG_DIR,sizeof(CFG_DIR));
     

     fd = mkdir(fullpath, S_IRWXU);
     if (fd < 0) 
	  if (errno != EEXIST) 
	       return 0;

     strncat(fullpath,CFG_FILE,sizeof(CFG_FILE));
     ini_fd = ini_ReadFile(fullpath);
     if (ini_fd < 0) {
	  ini_fd = ini_NewFile();
	  if (ini_fd < 0) return 0; 
	  ret = CFG_NEW;
     }

     cfg_filename = g_string_new(fullpath);
     strncpy(fullpath,getenv("HOME"),PATH_MAX);
     strncat(fullpath,CFG_DIR,sizeof(CFG_DIR));
     strncat(fullpath,CFG_PLAY_LIST,sizeof(CFG_PLAY_LIST));
     cfg_Write("paths","default playlist",fullpath);
     return ret;
}

void cfg_Write(gchar* sec,gchar* name,gchar* value) {
     if (ini_fd < 0) return;
     ini_WriteString(ini_fd,sec,name,value);
}

char* cfg_Read(gchar* sec,gchar*name,gchar* fallback) {
     gchar* ret;

     if (ini_fd < 0) return NULL;
     ret = ini_ReadValue(ini_fd,sec,name);
     if (ret == NULL) {
	  cfg_Write(sec,name,fallback);
	  return fallback;
     }
     return ret;
}

char* cfg_ReadSection(gchar* sec) {
     gchar* name;
     gchar* value;

     if (ini_fd < 0) return NULL;
     value = ini_ReadKeysValues(ini_fd,sec,&name);
     if (value < (gchar*)1)
	  return 0;
     return value;
}		      

void cfg_Save() {
     if (ini_fd < 0) return;
	  
     ini_Save(ini_fd,cfg_filename->str);
}


#ifdef NLS
// if not a valid utf-8 string try to convert from current locale charset to utf-8 
//  fallback to iso8859-1 charset  
gchar* convert_if_needed(gchar* text) {
	gint bytes_read;
	gint bytes_written;
	gchar* conv_text;
	GError*	gerror = NULL;
	static gchar* free_text = NULL;
	
	if (g_utf8_validate(text,-1,NULL))
		return text;

	conv_text = g_locale_to_utf8(text,-1,&bytes_read,&bytes_written,NULL);
	if (conv_text != NULL)
		return conv_text;

	if (free_text) 
		g_free(free_text);

	free_text =  g_convert(text,strlen(text),"UTF-8","ISO-8859-1",&bytes_read,&bytes_written,&gerror);
	if (!free_text) {
		g_print("%s\bn",gerror->message);
		// if we still cant convert return original string, will likely produce an error message
		return text;
	}

	return free_text;
}


#endif

