/*
** libSlashFX test. Needs SDL. Tested only in Linux.
*/

#include <stdlib.h>
#include <stdio.h>
#include <SDL/SDL.h>
#include <slashfx.h>
#ifdef WIN32
#undef main
#endif

short		*wave;
int		waveLen;
int		pos = 0;
int		canExit = 0;

static void callMeBack(void *userdata, Uint8 *stream, int len)
{
	short		*buff = (short*)stream;
	int		i;
	len /= 2;
	
	for (i=0;i<len;i++)
	{
		if (pos >= waveLen)
			buff[i] = 0;
		else
			buff[i] = wave[pos++];
	}
	
	if (pos >= waveLen)
	{
		canExit = 1;
		SDL_PauseAudio(1);
	}
}

static void startPlayback(void)
{
	SDL_AudioSpec	spec;
	
	memset(&spec, 0, sizeof(spec));
	spec.freq = 22050;
	spec.channels = 1;
	spec.format = AUDIO_S16;
	spec.samples = 1024;
	spec.callback = callMeBack;
	if (SDL_OpenAudio(&spec, NULL) < 0)
	{
		printf("Error: %s\n", SDL_GetError());
		exit(1);
	}
	SDL_PauseAudio(0);
}

int main(int argc, char *argv[])
{
	char	*filename = NULL;
	int	i;
	
	for (i=0;i<argc;i++)
		if (!strcmp(argv[i], "-i"))
		{
			filename = argv[++i];
		}
		
	if (!filename)
	{
		printf("Use: test -i filename.ssfx\n");
		return 0;
	}

	if (!ssfxLoadEffectFromFile(filename, &wave, &waveLen))
	{
		printf("Cannot load effect file.\n");
		return 1;
	}
	
	startPlayback();

	while (!canExit);
	
	free(wave);

	return 0;
}
