# -*- coding: utf-8 -*-
# vim:set noet ts=4:
#
# scim-python
#
# Copyright (c) 2007-2008 Huang Peng <shawn.p.huang@gmail.com>
#
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this program; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place, Suite 330,
# Boston, MA  02111-1307  USA
#
# $Id: $
#
import scim
import gtk 

from gettext import dgettext
_ = lambda (a) : dgettext ("scim-python", a)
N_ = lambda (a) : a

class EnglishSetupUI (gtk.VBox):
	__options__ = [
		("/IMEngine/Python/EnglishWriter/AlwaysShowCandidates", bool, False, 
			N_("Always show candidates window"), N_("Always show candidates, even if the spelling is right.")),
		("/IMEngine/Python/EnglishWriter/CommitSpace", bool, True, 
			N_("Commit a space with preedit string"), N_("Commit preedit string or a candidates with a space.")),
	]
	def __init__ (self):
		gtk.VBox.__init__ (self)
		self._values = {}
		self._create_ui (EnglishSetupUI.__options__)

		self.show_all ()

	def _create_ui (self, options):
		tooltips = gtk.Tooltips ()
		for opt in options:
			widget = None
			if opt[1] == bool:
				widget = gtk.CheckButton (_(opt[3]))
				tooltips.set_tip (widget, _(opt[4]))
				widget.get_value = widget.get_active
				widget.set_value = widget.set_active
				widget.set_value (opt[2])
				self._values[opt[0]] = (widget, opt[2])
			if widget:
				self.pack_start (widget, False, False)

	def get_name (self):
		return _("English Writer")
	
	def save_config (self, config):
		for key, v in self._values.items ():
			new_value = v[0].get_value ()
			config.write (key, new_value)
			self._values[key] = (v[0], new_value)

	def load_config (self, config):
		for key, v in self._values.items ():
			new_value = config.read (key, v[1])
			v[0].set_value (new_value)
			self._values[key] = (v[0], new_value)

	def query_changed (self):
		for k, v in self._values.items ():
			if v[1] != v[0].get_value ():
				return True
		return False

	def _toggled_cb (self, widget, id):
		if id == 0:
			widget.get_active ()
