dnl Copyright (C) 2006, 2007 Greger Viken Teigre
dnl This file is part of ser, a free SIP server.
dnl ser is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version
dnl  
dnl ser is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
dnl
dnl -------------------------------------
dnl local.m4 - Site-wide or server-specific configurations
dnl
dnl 
dnl local.m4 should either be found in local/common/ (if you only have one server to manage)
dnl or one in each local/serverA/, local/serverB/ etc
dnl local.m4 can also be copied to local/yourservername/. It will then will override the global configuration for
dnl all servers in local/common/. 
dnl
dnl local,m4 relies on config.m4, which ALWAYS must reside in local/default/ or in local/servername.
dnl config.m4 is generated by the configure script with your servername as parameter (default is default).
dnl
dnl ***************************************
dnl ******** Local directory paths ********
dnl ***************************************
define(`SER_ETC_DIR',`SER_INSTALL_PREFIX/etc/ser')dnl
define(`SER_LIB_DIR',`SER_INSTALL_PREFIX/lib/ser/modules')dnl
define(`SER_FIFO_PATH',`/tmp/ser_fifo')dnl
define(`SER_SOCK_PATH',`/tmp/ser_ctl')dnl
define(`SER_XMLRPC',`tcp:127.0.0.1:2049')dnl
dnl
dnl *********************************************
dnl ******** Local configs for directives *******
dnl *********************************************
dnl The debug=x directice, controls the amount of logging from SER internals
dnl <=2 is recommended for a production system. >=5 will give LOTS of logging
define(`DEBUG_LEVEL',`3')dnl
dnl Debug level for memory operations
define(`MEM_DEBUG_LEVEL',`10')dnl
dnl Debug level for memory statistics
define(`MEM_STAT_DEBUG_LEVEL',`10')dnl
dnl Disable core dumping (not good for production systems)
define(`DISABLE_CORE_DUMPS',`yes')dnl
dnl Should we fork? [yes|no] Recommended: yes
dnl If no is defined, only one process will be used and the system will slow down A LOT!
dnl (and especially if the DEBUG_LEVEL is high)
dnl Also, only UDP will be listened to on the interface.
define(`DEBUG_FORK',`yes')dnl
dnl Whether to log to stderror (instead of syslog), use only in no-fork mode (above)
define(`DEBUG_LOG_STDERROR',`no')dnl
dnl The number of children to fork per port and protocol
define(`NR_OF_CHILDREN',`4')dnl
dnl Turn DNS lookup on?`
define(`SER_DNS_ON',`no')dnl
dnl Turn DNS reverse lookup on?
define(`SER_REVERSE_DNS_ON',`no')dnl
dnl Is this host multi-homed and need to route SIP messages on more than one adapter?
dnl NOTE! Leaving default modparam("rr", "enable_double_rr", 1) is recommended if you set this to yes!
define(`MULTIHOMED',`no')dnl
dnl
dnl *********************************************
dnl ******** Global (not module) configs  *******
dnl *********************************************
dnl This defines which failure route to use as default. You can implement your own (in your routes.m4)
dnl with a different name than default and replace the name here.
define(`ROUTE_FAILURE_ROUTE',`FAILURE_ROUTE')dnl
dnl This dial plan will be used as a filter when determining which INVITEs to send to $gw_ip
define(`PSTN_DIAL_PLAN',`sips?:\+?[0-9]{3,18}@.*')dnl
dnl When this define is defined, the specified attribute will be used to set Remote-Party-ID
define(`PSTN_ASSERTED_ID_ATTR',`$asserted_id')dnl
dnl
dnl **************************
dnl ******** MODULES  ********
dnl **************************
dnl
dnl *** rr
define(`ENABLE_FULL_RR',`1')dnl
define(`RR_COOKIE_SECRET',`ChangeThisIfYouStoreSecretStuffInCookie')dnl
dnl *** mysql
define(`USE_MYSQL_DB',`yes')dnl
dnl *** nathelper
define(`NATHELPER_NATPING_INTVL',`30')dnl
define(`NATHELPER_PING_METHOD',`OPTIONS')dnl
define(`NATHELPER_PING_NATED_ONLY',`1')dnl
define(`NATHELPER_RTPPROXY_SOCK',`udp:127.0.0.1:22222')dnl
dnl The UAC tests (nat_uac_test function) used for new dialog messages
define(`NATHELPER_UAC_TESTS_NEWDIALOG',`19')dnl
dnl *** xmlrpc
dnl This define will occur in the setting if(... && (XMLRPC_SRC_CHECK)) { ... do XMLRPC }
dnl The default will only allow calls from localhost
define(`XMLRPC_SRC_CHECK',`src_ip==127.0.0.1')dnl
dnl *** auth
dnl Which database table to authenticate against
define(`REGISTER_CREDENTIALS_TABLE',`credentials')dnl
define(`AUTH_CREDENTIALS_TABLE',`credentials')dnl
dnl Should we force that the authentication user is the same as the user being registered?
define(`REGISTER_CHECK_TO_EQUALS_AUTH',`defined')dnl
dnl Should we force that the authentication user and From is the same user? (and not "register on behalf of")
define(`REGISTER_CHECK_FROM_EQUALS_AUTH',`defined')dnl
dnl Should we force that the authentication user and the From is the same user? (to prevent identity spoofing)
define(`AUTH_CHECK_FROM_EQUALS_AUTH',`defined')dnl
dnl *** options
dnl Include reply to OPTIONS message
define(`OPTIONS_REPLY_TO_LOCAL',`defined')dnl
dnl
dnl ====================================================================
dnl **** DON'T CHANGE BELOW HERE UNLESS YOU KNOW WHAT YOU ARE DOING ****
dnl ====================================================================
dnl
dnl ***************************
dnl ******** LOG SYSTEM *******
dnl ***************************
dnl Global flags for the gflags module
dnl Make sure that these flags are not defined elsewhere
define(`GFLAG_NOTICE',`29')dnl
define(`GFLAG_INFO',`30')dnl
define(`GFLAG_DEBUG',`31')dnl
dnl Log to the given syslog facility
define(`SYSLOG_FACILITY',`LOG_LOCAL0')dnl
dnl Log level to be used for NOTICE level messages
define(`LOG_NOTICE',`2')dnl
define(`XLOG_NOTICE',`L_NOTICE')dnl
dnl Log level to be used for INFO level messages
define(`LOG_INFO',`2')dnl
define(`XLOG_INFO',`L_NOTICE')dnl
dnl Log level to be used for DEBUG level messages
define(`LOG_DEBUG',`2')dnl
define(`XLOG_DEBUG',`L_NOTICE')dnl
dnl **********************
dnl ******** FLAGS *******
dnl **********************
dnl
dnl If you use own flags, make sure that you don't overlap values.
dnl accounting flag
define(`DEF_FLAG_ACC',`1')dnl
dnl Flag set when script has been in failure route
define(`DEF_FLAG_FAILUREROUTE',`2')dnl
dnl Flag set if NAT is detected for UAC (caller)
define(`DEF_FLAG_NAT_UAC',`6')dnl
dnl NAT flag loaded from database for UAS (callee)
define(`DEF_FLAG_NAT_UAS',`7')dnl
