/* sqlheavy-0.1.vapi generated by valac 0.12.1, do not modify. */

[CCode (cprefix = "SQLHeavy", lower_case_cprefix = "sql_heavy_")]
namespace SQLHeavy {
	[CCode (cprefix = "SQLHeavyCommonFunction", lower_case_cprefix = "sql_heavy_common_function_")]
	namespace CommonFunction {
		[CCode (cheader_filename = "SQLHeavy.h")]
		public static GLib.Value? compress (SQLHeavy.UserFunction.Context ctx, GLib.ValueArray args) throws SQLHeavy.Error;
		[CCode (cheader_filename = "SQLHeavy.h")]
		public static GLib.Value? decompress (SQLHeavy.UserFunction.Context ctx, GLib.ValueArray args) throws SQLHeavy.Error;
		[CCode (cheader_filename = "SQLHeavy.h")]
		public static GLib.Value? md5 (SQLHeavy.UserFunction.Context ctx, GLib.ValueArray args) throws SQLHeavy.Error;
		[CCode (cheader_filename = "SQLHeavy.h")]
		public static GLib.Value? regex (SQLHeavy.UserFunction.Context ctx, GLib.ValueArray args) throws SQLHeavy.Error;
		[CCode (cheader_filename = "SQLHeavy.h")]
		public static GLib.Value? sha1 (SQLHeavy.UserFunction.Context ctx, GLib.ValueArray args) throws SQLHeavy.Error;
		[CCode (cheader_filename = "SQLHeavy.h")]
		public static GLib.Value? sha256 (SQLHeavy.UserFunction.Context ctx, GLib.ValueArray args) throws SQLHeavy.Error;
	}
	[CCode (cprefix = "SQLHeavyUserFunction", lower_case_cprefix = "sql_heavy_user_function_")]
	namespace UserFunction {
		[CCode (ref_function = "sql_heavy_user_function_context_ref", unref_function = "sql_heavy_user_function_context_unref", cheader_filename = "SQLHeavy.h")]
		public class Context {
			public unowned GLib.Value? get_user_data (string key);
			public void set_user_data (string key, GLib.Value value);
		}
		[CCode (cheader_filename = "SQLHeavy.h")]
		public delegate void FinalizeFunc (SQLHeavy.UserFunction.Context ctx);
		[CCode (cheader_filename = "SQLHeavy.h")]
		public delegate GLib.Value? UserFunc (SQLHeavy.UserFunction.Context ctx, GLib.ValueArray args) throws SQLHeavy.Error;
	}
	[CCode (cprefix = "SQLHeavyVersion", lower_case_cprefix = "sql_heavy_version_")]
	namespace Version {
		[CCode (cheader_filename = "SQLHeavy.h")]
		public const string API;
		[CCode (cheader_filename = "SQLHeavy.h")]
		public const int MAJOR;
		[CCode (cheader_filename = "SQLHeavy.h")]
		public const int MICRO;
		[CCode (cheader_filename = "SQLHeavy.h")]
		public const int MINOR;
		[CCode (cheader_filename = "SQLHeavy.h")]
		public const string STRING;
		[CCode (cheader_filename = "SQLHeavy.h")]
		public static int library ();
		[CCode (cheader_filename = "SQLHeavy.h")]
		public static int sqlite_library ();
	}
	[CCode (cheader_filename = "SQLHeavy.h")]
	public class Backup : GLib.Object {
		public Backup (SQLHeavy.Database source, SQLHeavy.Database destination) throws SQLHeavy.Error;
		public void execute () throws SQLHeavy.Error;
		public async void execute_async (GLib.Cancellable? cancellable = null) throws SQLHeavy.Error;
		public bool step () throws SQLHeavy.Error;
		public Backup.with_db_names (SQLHeavy.Database source, string? source_name, SQLHeavy.Database destination, string? destination_name) throws SQLHeavy.Error;
		public SQLHeavy.Database destination_db { get; construct; }
		public string? destination_db_name { get; construct; }
		public int remaining_pages { get; }
		public SQLHeavy.Database source_db { get; construct; }
		public string? source_db_name { get; construct; }
		public int total_pages { get; }
		public signal void stepped ();
	}
	[CCode (cheader_filename = "SQLHeavy.h")]
	public class Database : GLib.Object, SQLHeavy.Queryable, GLib.Initable {
		public Database (string? filename = null, SQLHeavy.FileMode mode = SQLHeavy.FileMode.READ | SQLHeavy.FileMode.WRITE | SQLHeavy.FileMode.CREATE) throws SQLHeavy.Error;
		public void backup (string destination) throws SQLHeavy.Error;
		public async void backup_async (string destination) throws SQLHeavy.Error;
		public static int compare (SQLHeavy.Database? a, SQLHeavy.Database? b);
		public SQLHeavy.Table get_table (string table) throws SQLHeavy.Error;
		public GLib.HashTable<string,SQLHeavy.Table> get_tables () throws SQLHeavy.Error;
		public void incremental_vacuum (int pages) throws SQLHeavy.Error;
		public virtual bool init (GLib.Cancellable? cancellable = null) throws SQLHeavy.Error;
		public void interrupt ();
		public void register_aggregate_function (string name, int argc, owned SQLHeavy.UserFunction.UserFunc func, owned SQLHeavy.UserFunction.FinalizeFunc final);
		public void register_common_functions ();
		public void register_scalar_function (string name, int argc, owned SQLHeavy.UserFunction.UserFunc func);
		public void unregister_function (string name);
		public void wal_checkpoint (string? database = null) throws SQLHeavy.Error;
		public SQLHeavy.AutoVacuum auto_vacuum { get; set; }
		public int cache_size { get; set; }
		public bool case_sensitive_like { get; set; }
		public bool count_changes { get; set; }
		public int default_cache_size { get; set; }
		public bool empty_result_callbacks { get; set; }
		public bool enable_profiling { get; set; }
		public SQLHeavy.Encoding encoding { get; set; }
		public string filename { get; construct; }
		public bool foreign_keys { get; set; }
		public int free_list_count { get; }
		public bool full_column_names { get; set; }
		public bool full_fsync { get; set; }
		public SQLHeavy.JournalMode journal_mode { get; set; }
		public int journal_size_limit { get; set; }
		public int64 last_insert_id { get; }
		public bool legacy_file_format { get; set; }
		public SQLHeavy.LockingMode locking_mode { get; set; }
		public int lookaside_used { get; }
		public int max_page_count { get; set; }
		public SQLHeavy.FileMode mode { get; construct; }
		public int page_count { get; set; }
		public int page_size { get; set; }
		public bool parser_trace { get; set; }
		public SQLHeavy.ProfilingDatabase? profiling_data { get; set; }
		public bool read_uncommitted { get; set; }
		public bool recursive_triggers { get; set; }
		public bool reverse_unordered_selects { get; set; }
		public int schema_version { get; set; }
		public bool secure_delete { get; set; }
		public bool short_column_names { get; set; }
		public SQLHeavy.SynchronousMode synchronous { get; set; }
		public SQLHeavy.TempStoreMode temp_store { get; set; }
		public string temp_store_directory { owned get; set; }
		public int user_version { get; set; }
		public bool vdbe_listing { get; set; }
		public bool vdbe_trace { get; set; }
		public int wal_auto_checkpoint { get; set; }
		public signal void sql_executed (string sql);
		public virtual signal void wal_committed (string db_name, int pages);
	}
	[CCode (cheader_filename = "SQLHeavy.h")]
	public class ProfilingDatabase : SQLHeavy.VersionedDatabase {
		public ProfilingDatabase (string? filename = null) throws SQLHeavy.Error;
	}
	[CCode (cheader_filename = "SQLHeavy.h")]
	public class Query : GLib.Object, GLib.Initable {
		public Query (SQLHeavy.Queryable queryable, string sql) throws SQLHeavy.Error;
		public void bind (int parameter, GLib.Value? value) throws SQLHeavy.Error;
		public void bind_blob (int field, uint8[] value) throws SQLHeavy.Error;
		public void bind_byte_array (int field, GLib.ByteArray value) throws SQLHeavy.Error;
		public void bind_double (int field, double value) throws SQLHeavy.Error;
		public void bind_int (int field, int value) throws SQLHeavy.Error;
		public void bind_int64 (int field, int64 value) throws SQLHeavy.Error;
		public void bind_null (int field) throws SQLHeavy.Error;
		public void bind_string (int field, string? value) throws SQLHeavy.Error;
		public void clear ();
		public SQLHeavy.QueryResult execute (string? first_parameter = null, ...) throws SQLHeavy.Error;
		public async SQLHeavy.QueryResult execute_async (GLib.Cancellable? cancellable = null) throws SQLHeavy.Error;
		public int64 execute_insert (string? first_parameter = null, ...) throws SQLHeavy.Error;
		public async int64 execute_insert_async (GLib.Cancellable? cancellable = null) throws SQLHeavy.Error;
		public Query.full (SQLHeavy.Queryable queryable, string sql, int sql_max_len = -1, out unowned string? tail = null) throws SQLHeavy.Error;
		public GLib.GenericArray<GLib.GenericArray<GLib.Value?>> get_table () throws SQLHeavy.Error;
		public virtual bool init (GLib.Cancellable? cancellable = null) throws SQLHeavy.Error;
		public int parameter_index (string parameter) throws SQLHeavy.Error;
		public unowned string parameter_name (int parameter) throws SQLHeavy.Error;
		public void print_table (GLib.FileStream? fd = null) throws SQLHeavy.Error;
		public new void @set (string name, GLib.Value? value) throws SQLHeavy.Error;
		public void set_blob (string field, uint8[] value) throws SQLHeavy.Error;
		public void set_byte_array (string field, GLib.ByteArray value) throws SQLHeavy.Error;
		public void set_double (string field, double value) throws SQLHeavy.Error;
		public void set_int (string field, int value) throws SQLHeavy.Error;
		public void set_int64 (string field, int64 value) throws SQLHeavy.Error;
		public void set_null (string field) throws SQLHeavy.Error;
		public void set_string (string field, string? value) throws SQLHeavy.Error;
		public bool auto_clear { get; set; }
		public int parameter_count { get; private set; }
		public SQLHeavy.Queryable queryable { get; private set; }
		public string sql { get; construct; }
		public int sql_length { private get; construct; }
	}
	[CCode (cheader_filename = "SQLHeavy.h")]
	public class QueryResult : GLib.Object, SQLHeavy.Record, SQLHeavy.RecordSet {
		public QueryResult (SQLHeavy.Query query) throws SQLHeavy.Error;
		public void complete () throws SQLHeavy.Error;
		public async void complete_async (GLib.Cancellable? cancellable = null) throws SQLHeavy.Error;
		public string field_origin_name (int field) throws SQLHeavy.Error;
		public SQLHeavy.Table field_origin_table (int field) throws SQLHeavy.Error;
		public string field_origin_table_name (int field) throws SQLHeavy.Error;
		public async bool next_async (GLib.Cancellable? cancellable = null) throws SQLHeavy.Error;
		public SQLHeavy.ValueArray bindings { get; construct; }
		public double execution_time { get; }
		public bool finished { get; private set; }
		public int full_scan_steps { get; }
		public SQLHeavy.Query query { get; construct; }
		public int sort_operations { get; }
		public signal void received_row ();
	}
	[CCode (cheader_filename = "SQLHeavy.h")]
	public class Row : GLib.Object, SQLHeavy.Record, SQLHeavy.MutableRecord {
		public Row (SQLHeavy.Table table, int64 id = 0);
		public static int compare (SQLHeavy.Row? a, SQLHeavy.Row? b);
		public bool auto_save { get; set; }
		public bool enable_cache { get; set construct; }
		public int64 id { get; construct; }
		public SQLHeavy.Table table { get; construct; }
		public signal void changed ();
		public signal void deleted ();
		public signal void field_changed (int field);
	}
	[CCode (cheader_filename = "SQLHeavy.h")]
	public class Table : GLib.Object {
		public Table (SQLHeavy.Queryable queryable, string name) throws SQLHeavy.Error;
		public static int compare (SQLHeavy.Table? a, SQLHeavy.Table? b);
		public string field_affinity (int field) throws SQLHeavy.Error;
		public GLib.Type field_affinity_type (int field) throws SQLHeavy.Error;
		public int field_index (string name) throws SQLHeavy.Error;
		public string field_name (int field) throws SQLHeavy.Error;
		public string foreign_key_from (int foreign_key) throws SQLHeavy.Error;
		public int foreign_key_index (string foreign_key) throws SQLHeavy.Error;
		public SQLHeavy.Table foreign_key_table (int foreign_key) throws SQLHeavy.Error;
		public string foreign_key_table_name (int foreign_key) throws SQLHeavy.Error;
		public string foreign_key_to (int foreign_key) throws SQLHeavy.Error;
		public new SQLHeavy.Row @get (int64 id) throws SQLHeavy.Error;
		public SQLHeavy.TableCursor iterator ();
		public void register_notify_triggers () throws SQLHeavy.Error;
		public int field_count { get; }
		public int foreign_key_count { get; }
		public string name { get; construct; }
		public SQLHeavy.Queryable queryable { get; construct; }
		public signal void row_deleted (int64 row_id);
		public signal void row_inserted (int64 row_id);
		public virtual signal void row_modified (int64 row_id);
	}
	[CCode (cheader_filename = "SQLHeavy.h")]
	public class TableCursor : GLib.Object, SQLHeavy.RecordSet, SQLHeavy.Cursor {
		public TableCursor (SQLHeavy.Table table);
		public int field_count { get; }
		public int64 offset { get; private set; }
		public string sort_column { get; set; }
		public SQLHeavy.SortOrder sort_order { get; set construct; }
		public SQLHeavy.Table table { get; construct; }
	}
	[CCode (cheader_filename = "SQLHeavy.h")]
	public class Transaction : GLib.Object, SQLHeavy.Queryable {
		public Transaction (SQLHeavy.Queryable parent) throws SQLHeavy.Error;
		public void commit () throws SQLHeavy.Error;
		public async void commit_async () throws SQLHeavy.Error;
		public void rollback () throws SQLHeavy.Error;
		public async void rollback_async () throws SQLHeavy.Error;
		public SQLHeavy.Queryable? parent { get; construct; }
		public SQLHeavy.TransactionStatus status { get; private set; }
		public signal void resolved (SQLHeavy.TransactionStatus status);
	}
	[CCode (cheader_filename = "SQLHeavy.h")]
	public class ValueArray : GLib.Object {
		public ValueArray (int length = 0);
		public void append (GLib.Value? value);
		public void clear ();
		public SQLHeavy.ValueArray copy ();
		public new unowned GLib.Value? @get (int index);
		public void insert (int index, GLib.Value? value);
		public void insert_padding (int index, int members);
		public void prepend (GLib.Value? value);
		public void remove (int index);
		public new void @set (int index, GLib.Value? value);
		public void set_byte_array (int index, GLib.ByteArray value);
		public void set_double (int index, double value);
		public void set_int (int index, int value);
		public void set_int64 (int index, int64 value);
		public void set_null (int index);
		public void set_string (int index, string value);
		public int length { get; }
		public SQLHeavy.ValueArray? source { get; set construct; }
		public signal void position_changed (int old_index, int new_index);
		public signal void value_changed (int index);
	}
	[CCode (cheader_filename = "SQLHeavy.h")]
	public class VersionedDatabase : SQLHeavy.Database {
		public VersionedDatabase (string? file, string directory) throws SQLHeavy.Error;
		public string schema { get; construct; }
	}
	[CCode (cheader_filename = "SQLHeavy.h")]
	public interface Cursor : SQLHeavy.RecordSet {
		public void first () throws SQLHeavy.Error;
		public abstract SQLHeavy.Record @get () throws SQLHeavy.Error;
		public void last () throws SQLHeavy.Error;
		public abstract bool move_to (int64 offset) throws SQLHeavy.Error;
		public abstract bool previous () throws SQLHeavy.Error;
	}
	[CCode (cheader_filename = "SQLHeavy.h")]
	public interface MutableRecord : SQLHeavy.Record {
		public abstract void @delete () throws SQLHeavy.Error;
		public abstract void put (int field, GLib.Value value) throws SQLHeavy.Error;
		public virtual void put_blob (int field, uint8[] value) throws SQLHeavy.Error;
		public virtual void put_double (int field, double value) throws SQLHeavy.Error;
		public virtual void put_int (int field, int value) throws SQLHeavy.Error;
		public virtual void put_int64 (int field, int64 value) throws SQLHeavy.Error;
		public virtual void put_null (int field) throws SQLHeavy.Error;
		public virtual void put_string (int field, string? value) throws SQLHeavy.Error;
		public virtual void put_time_t (int field, time_t value) throws SQLHeavy.Error;
		public abstract void save () throws SQLHeavy.Error;
		public virtual void @set (string field, GLib.Value value) throws SQLHeavy.Error;
		public virtual void set_blob (string field, uint8[] value) throws SQLHeavy.Error;
		public virtual void set_double (string field, double value) throws SQLHeavy.Error;
		public virtual void set_int (string field, int value) throws SQLHeavy.Error;
		public virtual void set_int64 (string field, int64 value) throws SQLHeavy.Error;
		public virtual void set_null (string field) throws SQLHeavy.Error;
		public virtual void set_string (string field, string? value) throws SQLHeavy.Error;
		public virtual void set_time_t (string field, time_t value) throws SQLHeavy.Error;
	}
	[CCode (cheader_filename = "SQLHeavy.h")]
	public interface Queryable : GLib.Object {
		public virtual SQLHeavy.Transaction begin_transaction () throws SQLHeavy.Error;
		public SQLHeavy.QueryResult execute (string sql, ...) throws SQLHeavy.Error;
		public int64 execute_insert (string sql, ...) throws SQLHeavy.Error;
		public abstract void @lock ();
		public virtual SQLHeavy.Query prepare (string sql) throws SQLHeavy.Error;
		public virtual void print_table (string sql, GLib.FileStream? fd = null) throws SQLHeavy.Error;
		public abstract void queue (SQLHeavy.Query query) throws SQLHeavy.Error;
		public void run (string sql, ...) throws SQLHeavy.Error;
		public virtual void run_script (string filename) throws SQLHeavy.Error;
		public abstract void unlock ();
		public abstract SQLHeavy.Database database { owned get; }
		public signal void query_executed (SQLHeavy.Query query);
	}
	[CCode (cheader_filename = "SQLHeavy.h")]
	public interface Record : GLib.Object {
		public abstract GLib.Value fetch (int field = 0) throws SQLHeavy.Error;
		public virtual uint8[] fetch_blob (int field = 0) throws SQLHeavy.Error;
		public virtual double fetch_double (int field = 0) throws SQLHeavy.Error;
		public abstract SQLHeavy.Row fetch_foreign_row (int field = 0) throws SQLHeavy.Error;
		public virtual int fetch_int (int field = 0) throws SQLHeavy.Error;
		public virtual int64 fetch_int64 (int field = 0) throws SQLHeavy.Error;
		public virtual GLib.ValueArray fetch_row () throws SQLHeavy.Error;
		public virtual string? fetch_string (int field = 0) throws SQLHeavy.Error;
		public virtual time_t fetch_time_t (int field = 0) throws SQLHeavy.Error;
		public virtual GLib.Value fetch_with_type (GLib.Type requested_type, int field = 0) throws SQLHeavy.Error;
		public abstract int field_index (string field) throws SQLHeavy.Error;
		public abstract string field_name (int field = 0) throws SQLHeavy.Error;
		public virtual string[] field_names ();
		public abstract GLib.Type field_type (int field = 0) throws SQLHeavy.Error;
		public virtual GLib.Value? @get (string field) throws SQLHeavy.Error;
		public virtual uint8[] get_blob (string field) throws SQLHeavy.Error;
		public virtual double get_double (string field) throws SQLHeavy.Error;
		public virtual SQLHeavy.Row get_foreign_row (string field) throws SQLHeavy.Error;
		public virtual int get_int (string field) throws SQLHeavy.Error;
		public virtual int64 get_int64 (string field) throws SQLHeavy.Error;
		public virtual string? get_string (string field) throws SQLHeavy.Error;
		public virtual time_t get_time_t (string field) throws SQLHeavy.Error;
		public abstract int field_count { get; }
	}
	[CCode (cheader_filename = "SQLHeavy.h")]
	public interface RecordSet {
		public abstract bool next () throws SQLHeavy.Error;
	}
	[CCode (cprefix = "SQL_HEAVY_AUTO_VACUUM_", cheader_filename = "SQLHeavy.h")]
	public enum AutoVacuum {
		NONE,
		FULL,
		INCREMENTAL
	}
	[CCode (cprefix = "SQL_HEAVY_ENCODING_", cheader_filename = "SQLHeavy.h")]
	public enum Encoding {
		UTF_8,
		UTF_16,
		UTF_16LE,
		UTF_16BE;
		public static SQLHeavy.Encoding from_string (string? encoding);
		public unowned string to_string ();
	}
	[CCode (cprefix = "SQL_HEAVY_FILE_MODE_", cheader_filename = "SQLHeavy.h")]
	[Flags]
	public enum FileMode {
		READ,
		WRITE,
		CREATE
	}
	[CCode (cprefix = "SQL_HEAVY_JOURNAL_MODE_", cheader_filename = "SQLHeavy.h")]
	public enum JournalMode {
		DELETE,
		TRUNCATE,
		PERSIST,
		MEMORY,
		WAL,
		OFF;
		public static SQLHeavy.JournalMode from_string (string? journal_mode);
		public unowned string to_string ();
	}
	[CCode (cprefix = "SQL_HEAVY_LOCKING_MODE_", cheader_filename = "SQLHeavy.h")]
	public enum LockingMode {
		NORMAL,
		EXCLUSIVE;
		public static SQLHeavy.LockingMode from_string (string? locking_mode);
		public unowned string to_string ();
	}
	[CCode (cprefix = "SQL_HEAVY_SORT_ORDER_", cheader_filename = "SQLHeavy.h")]
	public enum SortOrder {
		ASCENDING,
		DESCENDING
	}
	[CCode (cprefix = "SQL_HEAVY_SYNCHRONOUS_MODE_", cheader_filename = "SQLHeavy.h")]
	public enum SynchronousMode {
		OFF,
		NORMAL,
		FULL;
		public static SQLHeavy.SynchronousMode from_string (string? synchronous_mode);
		public unowned string to_string ();
	}
	[CCode (cprefix = "SQL_HEAVY_TEMP_STORE_MODE_", cheader_filename = "SQLHeavy.h")]
	public enum TempStoreMode {
		DEFAULT,
		FILE,
		MEMORY;
		public static SQLHeavy.TempStoreMode from_string (string? temp_store_mode);
		public unowned string to_string ();
	}
	[CCode (cprefix = "SQL_HEAVY_TRANSACTION_STATUS_", cheader_filename = "SQLHeavy.h")]
	public enum TransactionStatus {
		UNRESOLVED,
		COMMITTED,
		ROLLED_BACK
	}
	[CCode (cprefix = "SQL_HEAVY_TRANSACTION_TYPE_", cheader_filename = "SQLHeavy.h")]
	public enum TransactionType {
		DEFERRED,
		IMMEDIATE,
		EXCLUSIVE;
		public unowned string to_string ();
	}
	[CCode (cprefix = "SQL_HEAVY_ERROR_", cheader_filename = "SQLHeavy.h")]
	public errordomain Error {
		UNKNOWN,
		ERROR,
		INTERNAL,
		ACCESS_DENIED,
		ABORTED,
		BUSY,
		LOCKED,
		NO_MEMORY,
		READ_ONLY,
		INTERRUPTED,
		IO,
		CORRUPT,
		NOT_FOUND,
		FULL,
		CAN_NOT_OPEN,
		PROTOCOL,
		EMPTY,
		SCHEMA,
		TOO_BIG,
		CONSTRAINT,
		MISMATCH,
		MISUSE,
		NOLFS,
		AUTH,
		FORMAT,
		RANGE,
		NOTADB,
		DATA_TYPE,
		THREAD,
		TRANSACTION,
		FEATURE_NOT_SUPPORTED,
		NO_SQL,
		MISSING_PARAMETER,
	}
	[CCode (cheader_filename = "SQLHeavy.h")]
	public static string escape_string (string str);
}
