/* sqlheavy-common-function.c generated by valac 0.12.1, the Vala compiler
 * generated from sqlheavy-common-function.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include "SQLHeavy.h"
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <gio/gio.h>

#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))



static GValue* _g_value_dup (GValue* self);
static void _vala_GValue_free (GValue* self);
const gchar* sql_heavy_sqlite_errstr (gint ec);
GValue* sql_heavy_common_function_checksum (GChecksumType cs, SQLHeavyUserFunctionContext* ctx, GValueArray* args, GError** error);
GValue* sql_heavy_common_function_convert_blob (GConverter* converter, SQLHeavyUserFunctionContext* ctx, GValueArray* args, GError** error);
static guint8* _vala_array_dup1 (guint8* self, int length);


/**
     * Implementation of a REGEXP function using GRegex
     *
     * SQLite includes special support for a function named REGEXP,
     * which is left unimplemented by SQLite. This function provides a
     * basic implementation based on the regex support in GLib.
     *
     * @return whether or not the expression matched
     * @param ctx execution context
     * @param args arguments to the function
     */
static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static gpointer _g_regex_ref0 (gpointer self) {
	return self ? g_regex_ref (self) : NULL;
}


GValue* sql_heavy_common_function_regex (SQLHeavyUserFunctionContext* ctx, GValueArray* args, GError** error) {
	GValue* result = NULL;
	GRegex* regex;
	GValue* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* str_expr;
	GValue* _tmp2_ = NULL;
	GValue* _tmp3_;
	GValue* gv_expr;
	GValue* _tmp10_ = NULL;
	GValue* _tmp11_;
	GValue* arg;
	gboolean _tmp13_;
	const gchar* _tmp16_ = NULL;
	gboolean _tmp17_;
	GValue* _tmp18_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (ctx != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	regex = NULL;
	_tmp0_ = g_value_array_get_nth (args, (guint) 0);
	_tmp1_ = g_value_get_string (_tmp0_);
	str_expr = _tmp1_;
	_tmp2_ = sql_heavy_user_function_context_get_user_data (ctx, str_expr);
	_tmp3_ = __g_value_dup0 (_tmp2_);
	gv_expr = _tmp3_;
	if (gv_expr == NULL) {
		GRegex* _tmp4_ = NULL;
		GRegex* _tmp5_;
		GValue _tmp7_ = {0};
		_tmp4_ = g_regex_new (str_expr, G_REGEX_OPTIMIZE | G_REGEX_DOLLAR_ENDONLY, 0, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			__vala_GValue_free0 (gv_expr);
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (regex);
		regex = _tmp5_;
		goto __finally1;
		__catch1_g_regex_error:
		{
			GError * e;
			GError* _tmp6_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp6_ = g_error_new (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_ERROR, "Unable to compile regular expression: %s", e->message);
			_inner_error_ = _tmp6_;
			_g_error_free0 (e);
			goto __finally1;
		}
		__finally1:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				__vala_GValue_free0 (gv_expr);
				_g_regex_unref0 (regex);
				return NULL;
			} else {
				__vala_GValue_free0 (gv_expr);
				_g_regex_unref0 (regex);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		g_value_init (&_tmp7_, G_TYPE_REGEX);
		g_value_set_boxed (&_tmp7_, (GRegex*) regex);
		sql_heavy_user_function_context_set_user_data (ctx, str_expr, &_tmp7_);
		G_IS_VALUE (&_tmp7_) ? (g_value_unset (&_tmp7_), NULL) : NULL;
	} else {
		void* _tmp8_ = NULL;
		GRegex* _tmp9_;
		_tmp8_ = g_value_get_boxed (gv_expr);
		_tmp9_ = _g_regex_ref0 ((GRegex*) _tmp8_);
		_g_regex_unref0 (regex);
		regex = _tmp9_;
	}
	_tmp10_ = g_value_array_get_nth (args, (guint) 1);
	_tmp11_ = __g_value_dup0 (_tmp10_);
	arg = _tmp11_;
	if (arg == NULL) {
		GValue* _tmp12_ = NULL;
		_tmp12_ = g_new0 (GValue, 1);
		g_value_init (_tmp12_, G_TYPE_BOOLEAN);
		g_value_set_boolean (_tmp12_, FALSE);
		result = _tmp12_;
		__vala_GValue_free0 (arg);
		__vala_GValue_free0 (gv_expr);
		_g_regex_unref0 (regex);
		return result;
	}
	_tmp13_ = G_VALUE_HOLDS (arg, G_TYPE_STRING);
	if (!_tmp13_) {
		const gchar* _tmp14_ = NULL;
		GError* _tmp15_ = NULL;
		_tmp14_ = sql_heavy_sqlite_errstr (SQLITE_MISMATCH);
		_tmp15_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_MISMATCH, _tmp14_);
		_inner_error_ = _tmp15_;
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			__vala_GValue_free0 (arg);
			__vala_GValue_free0 (gv_expr);
			_g_regex_unref0 (regex);
			return NULL;
		} else {
			__vala_GValue_free0 (arg);
			__vala_GValue_free0 (gv_expr);
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp16_ = g_value_get_string (arg);
	_tmp17_ = g_regex_match (regex, _tmp16_, 0, NULL);
	_tmp18_ = g_new0 (GValue, 1);
	g_value_init (_tmp18_, G_TYPE_BOOLEAN);
	g_value_set_boolean (_tmp18_, _tmp17_);
	result = _tmp18_;
	__vala_GValue_free0 (arg);
	__vala_GValue_free0 (gv_expr);
	_g_regex_unref0 (regex);
	return result;
}


GValue* sql_heavy_common_function_checksum (GChecksumType cs, SQLHeavyUserFunctionContext* ctx, GValueArray* args, GError** error) {
	GValue* result = NULL;
	GValue* _tmp0_ = NULL;
	GValue* _tmp1_;
	GValue* arg;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (ctx != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = g_value_array_get_nth (args, (guint) 0);
	_tmp1_ = __g_value_dup0 (_tmp0_);
	arg = _tmp1_;
	_tmp2_ = G_VALUE_HOLDS (arg, G_TYPE_STRING);
	if (_tmp2_) {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		GValue* _tmp5_ = NULL;
		_tmp3_ = g_value_get_string (arg);
		_tmp4_ = g_compute_checksum_for_string (cs, _tmp3_, (gsize) (-1));
		_tmp5_ = g_new0 (GValue, 1);
		g_value_init (_tmp5_, G_TYPE_STRING);
		g_value_take_string (_tmp5_, _tmp4_);
		result = _tmp5_;
		__vala_GValue_free0 (arg);
		return result;
	} else {
		gboolean _tmp6_;
		_tmp6_ = G_VALUE_HOLDS (arg, G_TYPE_BYTE_ARRAY);
		if (_tmp6_) {
			void* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			GValue* _tmp9_ = NULL;
			_tmp7_ = g_value_get_boxed (arg);
			_tmp8_ = g_compute_checksum_for_data (cs, ((GByteArray*) _tmp7_)->data, (gint) ((GByteArray*) _tmp7_)->len);
			_tmp9_ = g_new0 (GValue, 1);
			g_value_init (_tmp9_, G_TYPE_STRING);
			g_value_take_string (_tmp9_, _tmp8_);
			result = _tmp9_;
			__vala_GValue_free0 (arg);
			return result;
		} else {
			const gchar* _tmp10_ = NULL;
			GError* _tmp11_ = NULL;
			_tmp10_ = sql_heavy_sqlite_errstr (SQLITE_MISMATCH);
			_tmp11_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_MISMATCH, _tmp10_);
			_inner_error_ = _tmp11_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				__vala_GValue_free0 (arg);
				return NULL;
			} else {
				__vala_GValue_free0 (arg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	__vala_GValue_free0 (arg);
}


/**
     * Implementation of a MD5 function using GChecksum
     *
     * @return whether or not the expression matched
     * @param ctx execution context
     * @param args arguments to the function
     * @see sha1
     * @see sha256
     */
GValue* sql_heavy_common_function_md5 (SQLHeavyUserFunctionContext* ctx, GValueArray* args, GError** error) {
	GValue* result = NULL;
	GValue* _tmp0_ = NULL;
	GValue* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (ctx != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = sql_heavy_common_function_checksum (G_CHECKSUM_MD5, ctx, args, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp1_;
	return result;
}


/**
     * Implementation of a SHA-1 function using GChecksum
     *
     * @return whether or not the expression matched
     * @param ctx execution context
     * @param args arguments to the function
     * @see sha256
     * @see md5
     */
GValue* sql_heavy_common_function_sha1 (SQLHeavyUserFunctionContext* ctx, GValueArray* args, GError** error) {
	GValue* result = NULL;
	GValue* _tmp0_ = NULL;
	GValue* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (ctx != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = sql_heavy_common_function_checksum (G_CHECKSUM_SHA1, ctx, args, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp1_;
	return result;
}


/**
     * Implementation of a SHA-256 function using GChecksum
     *
     * @return whether or not the expression matched
     * @param ctx execution context
     * @param args arguments to the function
     * @see sha1
     * @see md5
     */
GValue* sql_heavy_common_function_sha256 (SQLHeavyUserFunctionContext* ctx, GValueArray* args, GError** error) {
	GValue* result = NULL;
	GValue* _tmp0_ = NULL;
	GValue* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (ctx != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = sql_heavy_common_function_checksum (G_CHECKSUM_SHA256, ctx, args, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp1_;
	return result;
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = g_new0 (gchar, _tmp0_ + 1);
	_result_ = _tmp1_;
	_result__length1 = _tmp0_ + 1;
	__result__size_ = _tmp0_ + 1;
	_result__length1--;
	_tmp2_ = strlen (self);
	memcpy (_result_, self, (gsize) _tmp2_);
	_tmp3_ = _result_;
	if (result_length1) {
		*result_length1 = _result__length1;
	}
	result = _tmp3_;
	return result;
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


GValue* sql_heavy_common_function_convert_blob (GConverter* converter, SQLHeavyUserFunctionContext* ctx, GValueArray* args, GError** error) {
	GValue* result = NULL;
	GValue _tmp0_;
	GValue _tmp1_ = {0};
	GValue arg;
	guint8* in_data = NULL;
	gint in_data_length1 = 0;
	gint _in_data_size_ = 0;
	gboolean _tmp2_;
	GByteArray* _tmp12_ = NULL;
	GByteArray* res;
	gsize bytes_read = 0UL;
	gsize bytes_written = 0UL;
	guint8* _tmp13_ = NULL;
	guint8* outbuf;
	gint outbuf_length1;
	gint _outbuf_size_;
	gint in_offset;
	GValue* _tmp21_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (converter != NULL, NULL);
	g_return_val_if_fail (ctx != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	if (G_IS_VALUE (&args->values[0])) {
		g_value_init (&_tmp1_, G_VALUE_TYPE (&args->values[0]));
		g_value_copy (&args->values[0], &_tmp1_);
	} else {
		_tmp1_ = args->values[0];
	}
	_tmp0_ = _tmp1_;
	arg = _tmp0_;
	_tmp2_ = G_VALUE_HOLDS (&arg, G_TYPE_STRING);
	if (_tmp2_) {
		const gchar* _tmp3_ = NULL;
		gint _tmp4_;
		gchar* _tmp5_ = NULL;
		_tmp3_ = g_value_get_string (&arg);
		_tmp5_ = string_to_utf8 (_tmp3_, &_tmp4_);
		in_data = (g_free (in_data), NULL);
		in_data = (guint8*) _tmp5_;
		in_data_length1 = _tmp4_;
		_in_data_size_ = _tmp4_;
	} else {
		gboolean _tmp6_;
		_tmp6_ = G_VALUE_HOLDS (&arg, G_TYPE_BYTE_ARRAY);
		if (_tmp6_) {
			void* _tmp7_ = NULL;
			guint8* _tmp8_;
			guint8* _tmp9_;
			_tmp7_ = g_value_get_boxed (&arg);
			_tmp8_ = (_tmp9_ = ((GByteArray*) _tmp7_)->data, (_tmp9_ == NULL) ? ((gpointer) _tmp9_) : _vala_array_dup1 (_tmp9_, (gint) ((GByteArray*) _tmp7_)->len));
			in_data = (g_free (in_data), NULL);
			in_data = _tmp8_;
			in_data_length1 = (gint) ((GByteArray*) _tmp7_)->len;
			_in_data_size_ = (gint) ((GByteArray*) _tmp7_)->len;
		} else {
			const gchar* _tmp10_ = NULL;
			GError* _tmp11_ = NULL;
			_tmp10_ = sql_heavy_sqlite_errstr (SQLITE_MISMATCH);
			_tmp11_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_MISMATCH, _tmp10_);
			_inner_error_ = _tmp11_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				in_data = (g_free (in_data), NULL);
				G_IS_VALUE (&arg) ? (g_value_unset (&arg), NULL) : NULL;
				return NULL;
			} else {
				in_data = (g_free (in_data), NULL);
				G_IS_VALUE (&arg) ? (g_value_unset (&arg), NULL) : NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp12_ = g_byte_array_new ();
	res = _tmp12_;
	_tmp13_ = g_new0 (guint8, 4096);
	outbuf = _tmp13_;
	outbuf_length1 = 4096;
	_outbuf_size_ = 4096;
	in_offset = 0;
	while (TRUE) {
		gint _tmp14_;
		gint end;
		GConverterFlags _tmp15_ = 0;
		gsize _tmp16_;
		gsize _tmp17_;
		GConverterResult _tmp18_;
		GConverterResult cr;
		gboolean _tmp19_ = FALSE;
		_tmp14_ = MIN (in_offset + 256, in_data_length1);
		end = _tmp14_;
		if (end >= in_data_length1) {
			_tmp15_ = G_CONVERTER_INPUT_AT_END;
		} else {
			_tmp15_ = G_CONVERTER_NO_FLAGS;
		}
		_tmp18_ = g_converter_convert (converter, in_data + in_offset, (gsize) (end - in_offset), outbuf, (gsize) outbuf_length1, _tmp15_, &_tmp16_, &_tmp17_, &_inner_error_);
		bytes_read = _tmp16_;
		bytes_written = _tmp17_;
		cr = _tmp18_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		if (cr == G_CONVERTER_CONVERTED) {
			_tmp19_ = TRUE;
		} else {
			_tmp19_ = cr == G_CONVERTER_FINISHED;
		}
		if (_tmp19_) {
			guint8* data;
			gint data_length1;
			gint _data_size_;
			data = outbuf;
			data_length1 = outbuf_length1;
			_data_size_ = outbuf_length1;
			data_length1 = (gint) bytes_written;
			g_byte_array_append (res, data, data_length1);
			if (cr == G_CONVERTER_FINISHED) {
				break;
			} else {
				in_offset = in_offset + ((gint) bytes_read);
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			if (g_error_matches (e, G_IO_ERROR, G_IO_ERROR_PARTIAL_INPUT)) {
				gint _tmp20_;
				_tmp20_ = outbuf_length1 + 4096;
				outbuf = g_renew (guint8, outbuf, outbuf_length1 + 4096);
				(_tmp20_ > outbuf_length1) ? memset (outbuf + outbuf_length1, 0, sizeof (guint8) * (_tmp20_ - outbuf_length1)) : NULL;
				outbuf_length1 = _tmp20_;
				_outbuf_size_ = _tmp20_;
			}
			g_error ("sqlheavy-common-function.vala:138: %s", e->message);
			_g_error_free0 (e);
		}
		__finally2:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				outbuf = (g_free (outbuf), NULL);
				_g_byte_array_unref0 (res);
				in_data = (g_free (in_data), NULL);
				G_IS_VALUE (&arg) ? (g_value_unset (&arg), NULL) : NULL;
				return NULL;
			} else {
				outbuf = (g_free (outbuf), NULL);
				_g_byte_array_unref0 (res);
				in_data = (g_free (in_data), NULL);
				G_IS_VALUE (&arg) ? (g_value_unset (&arg), NULL) : NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	g_free (outbuf);
	_tmp21_ = g_new0 (GValue, 1);
	g_value_init (_tmp21_, G_TYPE_BYTE_ARRAY);
	g_value_take_boxed (_tmp21_, res);
	result = _tmp21_;
	outbuf = (g_free (outbuf), NULL);
	in_data = (g_free (in_data), NULL);
	G_IS_VALUE (&arg) ? (g_value_unset (&arg), NULL) : NULL;
	return result;
}


/**
     * Implementation of a ZLib COMPRESS function
     *
     * @return whether or not the expression matched
     * @param ctx execution context
     * @param args arguments to the function
     * @see decompress
     */
GValue* sql_heavy_common_function_compress (SQLHeavyUserFunctionContext* ctx, GValueArray* args, GError** error) {
	GValue* result = NULL;
	GZlibCompressor* _tmp0_ = NULL;
	GZlibCompressor* _tmp1_;
	GValue* _tmp2_ = NULL;
	GValue* _tmp3_;
	GValue* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (ctx != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = g_zlib_compressor_new (G_ZLIB_COMPRESSOR_FORMAT_RAW, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = sql_heavy_common_function_convert_blob ((GConverter*) _tmp1_, ctx, args, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp4_;
	return result;
}


/**
     * Implementation of a ZLib DECOMPRESS function
     *
     * @return whether or not the expression matched
     * @param ctx execution context
     * @param args arguments to the function
     * @see compress
     */
GValue* sql_heavy_common_function_decompress (SQLHeavyUserFunctionContext* ctx, GValueArray* args, GError** error) {
	GValue* result = NULL;
	GZlibDecompressor* _tmp0_ = NULL;
	GZlibDecompressor* _tmp1_;
	GValue* _tmp2_ = NULL;
	GValue* _tmp3_;
	GValue* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (ctx != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = g_zlib_decompressor_new (G_ZLIB_COMPRESSOR_FORMAT_RAW);
	_tmp1_ = _tmp0_;
	_tmp2_ = sql_heavy_common_function_convert_blob ((GConverter*) _tmp1_, ctx, args, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp4_;
	return result;
}



