# $Id: roster_delimiter.tcl 1237 2007-09-21 17:27:08Z sergei $
#
# Nested roster groups server-side delimiter storing (XEP-0083).
#

###############################################################################

namespace eval delimiter {}

###############################################################################
#
# Retrieving nested groups delimiter
#

proc delimiter::request {connid fallback args} {
    debugmsg plugins "delimiter::request $connid $fallback $args"
    
    set command ""
    foreach {key val} $args {
	switch -- $key {
	    -command { set command $val }
	}
    }

    private::retrieve [list [jlib::wrapper:createtag roster \
				 -vars [list xmlns $::NS(delimiter)]]] \
	-command [list [namespace current]::request_result \
		       $connid $fallback $command] \
	-connection $connid
}

proc delimiter::request_result {connid fallback command res child} {
    debugmsg plugins "delimiter::request_result $connid $res"

    set delimiter $fallback

    if {$res == "OK"} {
	foreach ch $child {
	    jlib::wrapper:splitxml $ch tag1 vars1 isempty1 cdata1 children1

	    if {[jlib::wrapper:getattr $vars1 xmlns] == $NS(delimiter)} {
		set delimiter $cdata1
	    }
	}
    }

    if {$command != ""} {
	eval $command [list $connid $delimiter]
    }
}

###############################################################################
#
# Storing nested groups delimiter
#

proc delimiter::store {connid delimiter args} {
    debugmsg plugins "delimiter::store $connid $delimiter $args"

    set command ""
    foreach {key val} $args {
	switch -- $key {
	    -command { set command $val }
	}
    }

    private::store [list [jlib::wrapper:createtag roster \
			      -vars [list xmlns $::NS(delimiter)] \
			      -chdata $delimiter]] \
	-command [list [namespace current]::store_result $connid $command] \
	-connection $connid
    
}

proc delimiter::store_result {connid command res child} {
    debugmsg plugins "delimiter::store_result $connid $res"
    
    if {$command != ""} {
	eval $command [list $res $child]
    }
}

