# Copyright (C) 2008-2012 eBox Technologies S.L.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License, version 2, as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package EBox::CGI::UsersAndGroups::AddGroup;

use strict;
use warnings;

use base 'EBox::CGI::ClientBase';

use EBox::Global;
use EBox::UsersAndGroups;
use EBox::Gettext;


sub new
{
    my $class = shift;
    my $self = $class->SUPER::new('title' => 'Users and Groups', @_);
    bless($self, $class);
    $self->{errorchain} = 'UsersAndGroups/Groups';
    return $self;
}


sub _process($)
{
    my $self = shift;
    my $usersandgroups = EBox::Global->modInstance('users');

    my @args = ();

    $self->_requireParam('groupname', __('group name'));

    my $group = $self->param('groupname');
    my $comment = $self->param('comment');

    $usersandgroups->addGroup($group, $comment);

    # FIXME Is there a better way to pass parameters to redirect/chain
    # cgi's
    if ($self->param('addAndEdit')) {
        $self->{redirect} = "UsersAndGroups/Group?group=$group";
    } else {
        $self->{redirect} = "UsersAndGroups/Groups";
    }
}

1;
